/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn;

import com.trilead.ssh2.auth.AgentProxy;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNSSHPrivateKeyUtil {
    private static final String TRILEAD_AGENT_PROXY_CLASS = "com.jcraft.jsch.agentproxy.TrileadAgentProxy";
    private static final String CONNECTOR_FACTORY_CLASS = "com.jcraft.jsch.agentproxy.ConnectorFactory";
    private static final String CONNECTOR_CLASS = "com.jcraft.jsch.agentproxy.Connector";

    public static AgentProxy createOptionalSSHAgentProxy() {
        try {
            Class<?> clazz = Class.forName(CONNECTOR_CLASS);
            Method method = Class.forName(CONNECTOR_FACTORY_CLASS).getMethod("getDefault", new Class[0]);
            Method method2 = Class.forName(CONNECTOR_FACTORY_CLASS).getMethod("createConnector", new Class[0]);
            Object object = method.invoke(null, new Object[0]);
            Object object2 = method2.invoke(object, new Object[0]);
            Class<?> clazz2 = Class.forName(TRILEAD_AGENT_PROXY_CLASS);
            return (AgentProxy)clazz2.getConstructor(clazz).newInstance(object2);
        }
        catch (Throwable throwable) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "Failed to load TrileadAgentProxy");
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, throwable);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] readPrivateKey(File file) {
        if (!(file != null && file.exists() && file.isFile() && file.canRead())) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "Can not read private key from '" + file + "'");
            return null;
        }
        BufferedReader bufferedReader = null;
        StringWriter stringWriter = new StringWriter();
        try {
            int n2;
            bufferedReader = new BufferedReader(new FileReader(file));
            while ((n2 = ((Reader)bufferedReader).read()) >= 0) {
                stringWriter.write(n2);
            }
        }
        catch (IOException iOException) {
            char[] cArray;
            try {
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, iOException);
                cArray = null;
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(bufferedReader);
                throw throwable;
            }
            SVNFileUtil.closeFile(bufferedReader);
            return cArray;
        }
        SVNFileUtil.closeFile(bufferedReader);
        return stringWriter.toString().toCharArray();
    }

    public static boolean isValidPrivateKey(char[] cArray, String string) {
        return SVNSSHPrivateKeyUtil.isValidPrivateKey(cArray, string != null ? string.toCharArray() : null);
    }

    public static boolean isValidPrivateKey(char[] cArray, char[] cArray2) {
        try {
            byte[] byArray = new String(cArray).getBytes(Charset.defaultCharset());
            String string = cArray2 != null ? new String(cArray2) : null;
            Iterable iterable = SecurityUtils.loadKeyPairIdentities(null, () -> "byte array", new ByteArrayInputStream(byArray), FilePasswordProvider.of(string));
            return iterable.iterator().hasNext();
        }
        catch (Exception exception) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, exception);
            return false;
        }
    }
}

