/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn;

import com.trilead.ssh2.auth.AgentProxy;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.auth.BasicAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNSSHHostVerifier;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSHAuthentication;
import org.tmatesoft.svn.core.auth.SVNUserNameAuthentication;
import org.tmatesoft.svn.core.internal.io.svn.ISVNConnector;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryImpl;
import org.tmatesoft.svn.core.internal.io.svn.SVNSSHPrivateKeyUtil;
import org.tmatesoft.svn.core.internal.io.svn.StreamLogger;
import org.tmatesoft.svn.core.internal.io.svn.ssh.SessionPoolFactory;
import org.tmatesoft.svn.core.internal.io.svn.ssh.SshAuthenticationException;
import org.tmatesoft.svn.core.internal.io.svn.ssh.SshSession;
import org.tmatesoft.svn.core.internal.io.svn.ssh.SshSessionPool;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNSSHConnector
implements ISVNConnector {
    private static final String SVNSERVE_COMMAND = "svnserve -t";
    private static final String SVNSERVE_COMMAND_WITH_USER_NAME = "svnserve -t --tunnel-user ";
    private static final boolean ourIsUseSessionPing = Boolean.getBoolean("svnkit.ssh2.ping");
    private static SshSessionPool ourSessionPool = SessionPoolFactory.create();
    private SshSession mySession;
    private InputStream myInputStream;
    private OutputStream myOutputStream;
    private boolean myIsUseSessionPing;
    private StreamLogger stderrConsumer;

    public SVNSSHConnector() {
        this(true, true);
    }

    public SVNSSHConnector(boolean bl2, boolean bl3) {
        this.myIsUseSessionPing = bl3;
    }

    @Override
    public void open(SVNRepositoryImpl sVNRepositoryImpl) {
        ISVNAuthenticationManager iSVNAuthenticationManager = sVNRepositoryImpl.getAuthenticationManager();
        if (iSVNAuthenticationManager == null) {
            SVNErrorManager.authenticationFailed("Authentication required for ''{0}''", sVNRepositoryImpl.getLocation());
            return;
        }
        String string = sVNRepositoryImpl.getLocation().getProtocol() + "://" + sVNRepositoryImpl.getLocation().getHost();
        if (sVNRepositoryImpl.getLocation().hasPort()) {
            string = string + ":" + sVNRepositoryImpl.getLocation().getPort();
        }
        if (sVNRepositoryImpl.getLocation().getUserInfo() != null && !"".equals(sVNRepositoryImpl.getLocation().getUserInfo())) {
            string = sVNRepositoryImpl.getLocation().getUserInfo() + "@" + string;
        }
        int n2 = 1;
        while (true) {
            Object object;
            Object object2;
            SVNSSHAuthentication sVNSSHAuthentication = (SVNSSHAuthentication)iSVNAuthenticationManager.getFirstAuthentication("svn.ssh", string, sVNRepositoryImpl.getLocation());
            SshSession sshSession = null;
            while (sVNSSHAuthentication != null) {
                try {
                    int n3;
                    int n4;
                    char[] cArray;
                    char[] cArray2;
                    char[] cArray3;
                    int n5;
                    object2 = (ISVNSSHHostVerifier)((Object)(iSVNAuthenticationManager instanceof ISVNSSHHostVerifier ? iSVNAuthenticationManager : null));
                    object = sVNRepositoryImpl.getLocation().getHost();
                    int n6 = n5 = sVNRepositoryImpl.getLocation().hasPort() ? sVNRepositoryImpl.getLocation().getPort() : sVNSSHAuthentication.getPortNumber();
                    if (n5 < 0) {
                        n5 = 22;
                    }
                    String string2 = sVNSSHAuthentication.getUserName();
                    char[] cArray4 = cArray3 = sVNSSHAuthentication.getPrivateKey() != null ? sVNSSHAuthentication.getPrivateKey() : null;
                    if (cArray3 == null && sVNSSHAuthentication.getPrivateKeyFile() != null) {
                        cArray3 = SVNSSHPrivateKeyUtil.readPrivateKey(sVNSSHAuthentication.getPrivateKeyFile());
                    }
                    if ((cArray2 = sVNSSHAuthentication.getPassphraseValue()) != null && cArray2.length == 0) {
                        cArray2 = null;
                    }
                    if ((cArray = sVNSSHAuthentication.getPasswordValue()) != null && cArray.length == 0) {
                        cArray = null;
                    }
                    AgentProxy agentProxy = sVNSSHAuthentication.getAgentProxy();
                    if (cArray3 != null && !SVNSSHPrivateKeyUtil.isValidPrivateKey(cArray3, sVNSSHAuthentication.getPassphraseValue())) {
                        if (cArray == null) {
                            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "File ''{0}'' is not valid OpenSSH DSA or RSA private key file", (Object)sVNSSHAuthentication.getPrivateKeyFile());
                            SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
                        }
                        cArray3 = null;
                    }
                    if ((sshSession = ourSessionPool.openSession((String)object, n5, string2, cArray3, cArray2, cArray, agentProxy, (ISVNSSHHostVerifier)object2, n4 = iSVNAuthenticationManager.getConnectTimeout(sVNRepositoryImpl), n3 = iSVNAuthenticationManager.getReadTimeout(sVNRepositoryImpl))) == null) {
                        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_SVN_CONNECTION_CLOSED, "Cannot connect to ''{0}''", (Object)sVNRepositoryImpl.getLocation().setPath("", false));
                        SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
                    }
                    BasicAuthenticationManager.acknowledgeAuthentication(true, "svn.ssh", string, null, sVNSSHAuthentication, sVNRepositoryImpl.getLocation(), iSVNAuthenticationManager);
                    break;
                }
                catch (SVNAuthenticationException sVNAuthenticationException) {
                    SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, sVNAuthenticationException);
                    BasicAuthenticationManager.acknowledgeAuthentication(false, "svn.ssh", string, sVNAuthenticationException.getErrorMessage(), sVNSSHAuthentication, sVNRepositoryImpl.getLocation(), iSVNAuthenticationManager);
                    sVNSSHAuthentication = (SVNSSHAuthentication)iSVNAuthenticationManager.getNextAuthentication("svn.ssh", string, sVNRepositoryImpl.getLocation());
                    sshSession = null;
                }
                catch (SshAuthenticationException sshAuthenticationException) {
                    SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, sshAuthenticationException);
                    object = SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, sshAuthenticationException.getMessage());
                    BasicAuthenticationManager.acknowledgeAuthentication(false, "svn.ssh", string, (SVNErrorMessage)object, sVNSSHAuthentication, sVNRepositoryImpl.getLocation(), iSVNAuthenticationManager);
                    sVNSSHAuthentication = (SVNSSHAuthentication)iSVNAuthenticationManager.getNextAuthentication("svn.ssh", string, sVNRepositoryImpl.getLocation());
                    sshSession = null;
                }
                catch (IOException iOException) {
                    sshSession = null;
                    object = SVNErrorMessage.create(SVNErrorCode.RA_SVN_CONNECTION_CLOSED, iOException);
                    SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.NETWORK);
                }
            }
            if (sVNSSHAuthentication == null) {
                SVNErrorManager.cancel("authentication cancelled", SVNLogType.NETWORK);
            } else if (sshSession == null) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_CONNECTION_CLOSED, "Can not establish connection to ''{0}''", (Object)string), SVNLogType.NETWORK);
            }
            try {
                this.mySession = sshSession;
                object2 = iSVNAuthenticationManager.getFirstAuthentication("svn.username", string, sVNRepositoryImpl.getLocation());
                if (object2 == null) {
                    SVNErrorManager.cancel("authentication cancelled", SVNLogType.NETWORK);
                }
                if ((object = ((SVNAuthentication)object2).getUserName()) == null || "".equals(((String)object).trim())) {
                    object = sVNSSHAuthentication.getUserName();
                }
                if (((SVNAuthentication)object2).getUserName() == null || ((SVNAuthentication)object2).getUserName().equals(sVNSSHAuthentication.getUserName()) || "".equals(((SVNAuthentication)object2).getUserName())) {
                    sVNRepositoryImpl.setExternalUserName("");
                } else {
                    sVNRepositoryImpl.setExternalUserName(((SVNAuthentication)object2).getUserName());
                }
                object2 = new SVNUserNameAuthentication((String)object, ((SVNAuthentication)object2).isStorageAllowed(), sVNRepositoryImpl.getLocation(), false);
                BasicAuthenticationManager.acknowledgeAuthentication(true, "svn.username", string, null, (SVNAuthentication)object2, sVNRepositoryImpl.getLocation(), iSVNAuthenticationManager);
                if ("".equals(sVNRepositoryImpl.getExternalUserName())) {
                    this.mySession.execCommand(SVNSERVE_COMMAND);
                } else {
                    this.mySession.execCommand("svnserve -t --tunnel-user \"" + sVNRepositoryImpl.getExternalUserName() + "\"");
                }
                this.myOutputStream = this.mySession.getIn();
                this.myOutputStream = new BufferedOutputStream(this.myOutputStream, 16384);
                this.myInputStream = this.mySession.getOut();
                this.myInputStream = new BufferedInputStream(this.myInputStream, 16384);
                this.stderrConsumer = StreamLogger.consume(this.mySession.getErr());
                return;
            }
            catch (SocketTimeoutException socketTimeoutException) {
                object = SVNErrorMessage.create(SVNErrorCode.RA_SVN_IO_ERROR, "timed out waiting for server", null, 0, socketTimeoutException);
                SVNErrorManager.error((SVNErrorMessage)object, socketTimeoutException, SVNLogType.NETWORK);
                continue;
            }
            catch (UnknownHostException unknownHostException) {
                object = SVNErrorMessage.create(SVNErrorCode.RA_SVN_IO_ERROR, "Unknown host " + unknownHostException.getMessage(), null, 0, unknownHostException);
                SVNErrorManager.error((SVNErrorMessage)object, unknownHostException, SVNLogType.NETWORK);
                continue;
            }
            catch (ConnectException connectException) {
                object = SVNErrorMessage.create(SVNErrorCode.RA_SVN_IO_ERROR, "connection refused by the server", null, 0, connectException);
                SVNErrorManager.error((SVNErrorMessage)object, connectException, SVNLogType.NETWORK);
                continue;
            }
            catch (IOException iOException) {
                if (--n2 >= 0) {
                    this.mySession.close();
                    continue;
                }
                sVNRepositoryImpl.getDebugLog().logFine(SVNLogType.NETWORK, iOException);
                this.close(sVNRepositoryImpl);
                object = SVNErrorMessage.create(SVNErrorCode.RA_SVN_CONNECTION_CLOSED, "Cannot connect to ''{0}'': {1}", sVNRepositoryImpl.getLocation().setPath("", false), iOException.getMessage());
                SVNErrorManager.error((SVNErrorMessage)object, iOException, SVNLogType.NETWORK);
                continue;
            }
            break;
        }
    }

    @Override
    public void close(SVNRepositoryImpl sVNRepositoryImpl) {
        if (this.stderrConsumer != null) {
            this.stderrConsumer.close();
            this.stderrConsumer = null;
        }
        SVNFileUtil.closeFile(this.myOutputStream);
        SVNFileUtil.closeFile(this.myInputStream);
        if (this.mySession != null && this.mySession != null) {
            this.mySession.close();
            this.mySession = null;
        }
        this.mySession = null;
        this.myOutputStream = null;
        this.myInputStream = null;
    }

    @Override
    public InputStream getInputStream() {
        return this.myInputStream;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.myOutputStream;
    }

    @Override
    public boolean isConnected(SVNRepositoryImpl sVNRepositoryImpl) {
        return this.mySession != null && !this.isStale();
    }

    @Override
    public boolean isStale() {
        if (this.mySession == null) {
            return true;
        }
        if (!ourIsUseSessionPing) {
            return false;
        }
        if (!this.myIsUseSessionPing) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "SKIPPING CHANNEL PING, IT HAS BEEN DISABLED");
            return false;
        }
        try {
            this.mySession.ping();
        }
        catch (IOException iOException) {
            return true;
        }
        return false;
    }

    public static void shutdown() {
        ourSessionPool.shutdown();
    }

    @Override
    public void handleExceptionOnOpen(SVNRepositoryImpl sVNRepositoryImpl, SVNException sVNException) {
        throw sVNException;
    }

    public static void recreateSessionPoolForTest() {
        ourSessionPool.shutdown();
        ourSessionPool = SessionPoolFactory.create();
    }
}

