/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNMergeInfo;
import org.tmatesoft.svn.core.SVNMergeInfoInheritance;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaReader;
import org.tmatesoft.svn.core.internal.io.svn.ISVNConnector;
import org.tmatesoft.svn.core.internal.io.svn.SVNCommitEditor;
import org.tmatesoft.svn.core.internal.io.svn.SVNConnection;
import org.tmatesoft.svn.core.internal.io.svn.SVNEditModeReader;
import org.tmatesoft.svn.core.internal.io.svn.SVNItem;
import org.tmatesoft.svn.core.internal.io.svn.SVNReader;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryImpl$1;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryImpl$2;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryImpl$3;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNMergeInfoUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNDepthFilterEditor;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNFileRevisionHandler;
import org.tmatesoft.svn.core.io.ISVNInheritedPropertiesHandler;
import org.tmatesoft.svn.core.io.ISVNLocationEntryHandler;
import org.tmatesoft.svn.core.io.ISVNLocationSegmentHandler;
import org.tmatesoft.svn.core.io.ISVNLockHandler;
import org.tmatesoft.svn.core.io.ISVNReplayHandler;
import org.tmatesoft.svn.core.io.ISVNReporter;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.ISVNSession;
import org.tmatesoft.svn.core.io.ISVNWorkspaceMediator;
import org.tmatesoft.svn.core.io.SVNCapability;
import org.tmatesoft.svn.core.io.SVNFileRevision;
import org.tmatesoft.svn.core.io.SVNLocationEntry;
import org.tmatesoft.svn.core.io.SVNLocationSegment;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.util.SVNLogType;
import org.tmatesoft.svn.util.Version;

public class SVNRepositoryImpl
extends SVNRepository
implements ISVNReporter {
    private static final String DIRENT_KIND = "kind";
    private static final String DIRENT_SIZE = "size";
    private static final String DIRENT_HAS_PROPS = "has-props";
    private static final String DIRENT_CREATED_REV = "created-rev";
    private static final String DIRENT_TIME = "time";
    private static final String DIRENT_LAST_AUTHOR = "last-author";
    private SVNConnection myConnection;
    private String myRealm;
    private String myExternalUserName;

    protected SVNRepositoryImpl(SVNURL sVNURL, ISVNSession iSVNSession) {
        super(sVNURL, iSVNSession);
    }

    @Override
    public void testConnection() {
        try {
            this.openConnection();
        }
        catch (SVNException sVNException) {
            this.closeSession();
            throw sVNException;
        }
        finally {
            this.closeConnection();
        }
    }

    @Override
    public void setLocation(SVNURL sVNURL, boolean bl2) {
        if (sVNURL == null) {
            return;
        }
        if (!sVNURL.getProtocol().equals(this.myLocation.getProtocol())) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_NOT_IMPLEMENTED, "SVNRepository URL could not be changed from ''{0}'' to ''{1}''; create new SVNRepository instance instead", this.myLocation, sVNURL);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
        }
        if (this.myConnection == null) {
            bl2 = true;
        }
        if (bl2) {
            this.closeSession();
            this.myLocation = sVNURL;
            this.myRealm = null;
            this.myRepositoryRoot = null;
            this.myRepositoryUUID = null;
            return;
        }
        try {
            this.openConnection();
            if (this.reparent(sVNURL)) {
                this.myLocation = sVNURL;
                return;
            }
            this.setLocation(sVNURL, true);
        }
        catch (SVNException sVNException) {
            this.closeSession();
            throw sVNException;
        }
        finally {
            this.closeConnection();
        }
    }

    private boolean reparent(SVNURL sVNURL) {
        block4: {
            if (this.myConnection != null) {
                if (this.getLocation().equals(sVNURL)) {
                    return true;
                }
                try {
                    Object[] objectArray = new Object[]{"reparent", sVNURL.toString()};
                    this.write("(w(s))", objectArray);
                    this.authenticate();
                    this.read("", null, false);
                    String string = sVNURL.toString();
                    String string2 = this.myRepositoryRoot.toString();
                    return string.startsWith(string2) && (string.length() == string2.length() || string.length() > string2.length() && string.charAt(string2.length()) == '/');
                }
                catch (SVNException sVNException) {
                    if (!(sVNException instanceof SVNCancelException) && !(sVNException instanceof SVNAuthenticationException)) break block4;
                    throw sVNException;
                }
            }
        }
        return false;
    }

    @Override
    public long getLatestRevision() {
        Object[] objectArray = new Object[]{"get-latest-rev"};
        List list = null;
        try {
            this.openConnection();
            this.write("(w())", objectArray);
            this.authenticate();
            list = this.read("r", null, false);
        }
        catch (SVNException sVNException) {
            this.closeSession();
            throw sVNException;
        }
        finally {
            this.closeConnection();
        }
        return SVNReader.getLong(list, 0);
    }

    @Override
    public long getDatedRevision(Date date) {
        if (date == null) {
            date = new Date(System.currentTimeMillis());
        }
        Object[] objectArray = new Object[]{"get-dated-rev", date};
        List list = null;
        try {
            this.openConnection();
            this.write("(w(s))", objectArray);
            this.authenticate();
            list = this.read("r", null, false);
        }
        catch (SVNException sVNException) {
            this.closeSession();
            throw sVNException;
        }
        finally {
            this.closeConnection();
        }
        return SVNReader.getLong(list, 0);
    }

    @Override
    public SVNProperties getRevisionProperties(long l2, SVNProperties sVNProperties) {
        SVNRepositoryImpl.assertValidRevision(l2);
        if (sVNProperties == null) {
            sVNProperties = new SVNProperties();
        }
        Object[] objectArray = new Object[]{"rev-proplist", SVNRepositoryImpl.getRevisionObject(l2)};
        try {
            this.openConnection();
            this.write("(w(n))", objectArray);
            this.authenticate();
            List list = this.read("l", null, false);
            sVNProperties = SVNReader.getProperties(list, 0, sVNProperties);
        }
        catch (SVNException sVNException) {
            this.closeSession();
            throw sVNException;
        }
        finally {
            this.closeConnection();
        }
        return sVNProperties;
    }

    @Override
    public SVNPropertyValue getRevisionPropertyValue(long l2, String string) {
        SVNRepositoryImpl.assertValidRevision(l2);
        Object[] objectArray = new Object[]{"rev-prop", SVNRepositoryImpl.getRevisionObject(l2), string};
        List list = null;
        try {
            this.openConnection();
            this.write("(w(ns))", objectArray);
            this.authenticate();
            list = this.read("(?b)", null, false);
        }
        catch (SVNException sVNException) {
            this.closeSession();
            throw sVNException;
        }
        finally {
            this.closeConnection();
        }
        byte[] byArray = SVNReader.getBytes(list, 0);
        return byArray == null ? null : SVNPropertyValue.create(string, byArray);
    }

    @Override
    public SVNNodeKind checkPath(String string, long l2) {
        try {
            this.openConnection();
            string = this.getLocationRelativePath(string);
            Object[] objectArray = new Object[]{"check-path", string, SVNRepositoryImpl.getRevisionObject(l2)};
            this.write("(w(s(n)))", objectArray);
            this.authenticate();
            List list = this.read("w", null, false);
            SVNNodeKind sVNNodeKind = SVNNodeKind.parseKind(SVNReader.getString(list, 0));
            return sVNNodeKind;
        }
        catch (SVNException sVNException) {
            this.closeSession();
            throw sVNException;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int getLocationsImpl(String string, long l2, long[] lArray, ISVNLocationEntryHandler iSVNLocationEntryHandler) {
        int n2;
        SVNRepositoryImpl.assertValidRevision(l2);
        for (n2 = 0; n2 < lArray.length; ++n2) {
            SVNRepositoryImpl.assertValidRevision(lArray[n2]);
        }
        n2 = 0;
        try {
            SVNItem sVNItem;
            this.openConnection();
            string = this.getLocationRelativePath(string);
            Object[] objectArray = new Object[]{"get-locations", string, SVNRepositoryImpl.getRevisionObject(l2), lArray};
            this.write("(w(sn(*n)))", objectArray);
            this.authenticate();
            while ((sVNItem = this.readItem(false)).getKind() != 0 || !"done".equals(sVNItem.getWord())) {
                Object object;
                if (sVNItem.getKind() != 2) {
                    object = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Location entry not a list");
                    SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.NETWORK);
                    continue;
                }
                object = SVNReader.parseTuple("rs", sVNItem.getItems(), null);
                ++n2;
                if (iSVNLocationEntryHandler == null) continue;
                long l3 = SVNReader.getLong((List)object, 0);
                String string2 = SVNReader.getString((List)object, 1);
                if (string2 == null) continue;
                string2 = SVNRepositoryImpl.ensureAbsolutePath(string2);
                iSVNLocationEntryHandler.handleLocationEntry(new SVNLocationEntry(l3, string2));
            }
            this.read("", null, false);
        }
        catch (SVNException sVNException) {
            this.closeSession();
            this.handleUnsupportedCommand(sVNException, "'get-locations' not implemented");
        }
        finally {
            this.closeConnection();
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long getLocationSegmentsImpl(String string, long l2, long l3, long l4, ISVNLocationSegmentHandler iSVNLocationSegmentHandler) {
        long l5 = 0L;
        try {
            this.openConnection();
            string = this.getLocationRelativePath(string);
            Object[] objectArray = new Object[]{"get-location-segments", string, SVNRepositoryImpl.getRevisionObject(l2), SVNRepositoryImpl.getRevisionObject(l3), SVNRepositoryImpl.getRevisionObject(l4)};
            this.write("(w(s(n)(n)(n)))", objectArray);
            this.authenticate();
            boolean bl2 = false;
            while (!bl2) {
                Object object;
                SVNItem sVNItem = this.readItem(false);
                if (sVNItem.getKind() == 0 && "done".equals(sVNItem.getWord())) {
                    bl2 = true;
                    continue;
                }
                if (sVNItem.getKind() != 2) {
                    object = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Location segment entry not a list");
                    SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.NETWORK);
                    continue;
                }
                object = SVNReader.parseTuple("rr(?s)", sVNItem.getItems(), null);
                long l6 = SVNReader.getLong((List)object, 0);
                long l7 = SVNReader.getLong((List)object, 1);
                String string2 = SVNReader.getString((List)object, 2);
                if (SVNRepository.isInvalidRevision(l6) || SVNRepository.isInvalidRevision(l7)) {
                    SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Expected valid revision range");
                    SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
                }
                if (string2 != null) {
                    string2 = SVNRepositoryImpl.ensureAbsolutePath(string2);
                }
                if (iSVNLocationSegmentHandler != null) {
                    iSVNLocationSegmentHandler.handleLocationSegment(new SVNLocationSegment(l6, l7, string2));
                }
                l5 += l7 - l6 + 1L;
            }
            this.read("", null, false);
        }
        catch (SVNException sVNException) {
            this.closeSession();
            this.handleUnsupportedCommand(sVNException, "'get-location-segments' not implemented");
        }
        finally {
            this.closeConnection();
        }
        return l5;
    }

    @Override
    public long getFile(String string, long l2, SVNProperties sVNProperties, OutputStream outputStream) {
        Long l3 = l2 > 0L ? Long.valueOf(l2) : null;
        try {
            Object object;
            this.openConnection();
            Object[] objectArray = new Object[]{"get-file", this.getLocationRelativePath(string), l3, sVNProperties != null, outputStream != null};
            this.write("(w(s(n)ww))", objectArray);
            this.authenticate();
            List list = this.read("(?s)rl", null, false);
            MessageDigest messageDigest = null;
            try {
                messageDigest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                object = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "MD5 implementation not found: {0}", (Object)noSuchAlgorithmException.getMessage());
                SVNErrorManager.error((SVNErrorMessage)object, noSuchAlgorithmException, SVNLogType.NETWORK);
            }
            String string2 = SVNReader.getString(list, 0);
            if (sVNProperties != null) {
                sVNProperties = SVNReader.getProperties(list, 2, sVNProperties);
                sVNProperties.put("svn:entry:revision", SVNReader.getString(list, 1));
                sVNProperties.put("svn:entry:checksum", string2);
            }
            if (outputStream != null) {
                SVNErrorMessage sVNErrorMessage;
                while (true) {
                    if (((SVNItem)(object = this.readItem(false))).getKind() != 1) {
                        sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Non-string as part of file contents");
                        SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
                    }
                    if (((SVNItem)object).getBytes().length == 0) break;
                    if (string2 != null) {
                        messageDigest.update(((SVNItem)object).getBytes());
                    }
                    try {
                        outputStream.write(((SVNItem)object).getBytes());
                    }
                    catch (IOException iOException) {
                        SVNErrorMessage sVNErrorMessage2 = SVNErrorMessage.create(SVNErrorCode.RA_SVN_IO_ERROR, iOException.getMessage());
                        SVNErrorManager.error(sVNErrorMessage2, SVNLogType.NETWORK);
                    }
                }
                this.read("", null, false);
                if (string2 != null && !string2.equals(object = SVNFileUtil.toHexDigest(messageDigest))) {
                    sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CHECKSUM_MISMATCH, "Checksum mismatch for ''{0}''\nexpected checksum: ''{1}''\nactual checksum: ''{2}''", string, string2, object);
                    SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
                }
            }
            long l4 = SVNReader.getLong(list, 1);
            return l4;
        }
        catch (SVNException sVNException) {
            this.closeSession();
            throw sVNException;
        }
        finally {
            this.closeConnection();
        }
    }

    @Override
    public long getDir(String string, long l2, SVNProperties sVNProperties, ISVNDirEntryHandler iSVNDirEntryHandler) {
        return this.getDir(string, l2, sVNProperties, -1, iSVNDirEntryHandler);
    }

    @Override
    public long getDir(String string, long l2, SVNProperties sVNProperties, int n2, ISVNDirEntryHandler iSVNDirEntryHandler) {
        Long l3 = SVNRepositoryImpl.getRevisionObject(l2);
        try {
            this.openConnection();
            String string2 = this.getFullPath(string);
            SVNURL sVNURL = this.getLocation().setPath(string2, false);
            string = this.getLocationRelativePath(string);
            LinkedList<String> linkedList = new LinkedList<String>();
            if ((n2 & 1) != 0) {
                linkedList.add(DIRENT_KIND);
            }
            if ((n2 & 2) != 0) {
                linkedList.add(DIRENT_SIZE);
            }
            if ((n2 & 4) != 0) {
                linkedList.add(DIRENT_HAS_PROPS);
            }
            if ((n2 & 8) != 0) {
                linkedList.add(DIRENT_CREATED_REV);
            }
            if ((n2 & 0x10) != 0) {
                linkedList.add(DIRENT_TIME);
            }
            if ((n2 & 0x20) != 0) {
                linkedList.add(DIRENT_LAST_AUTHOR);
            }
            Object[] objectArray = new Object[]{"get-dir", string, l3, sVNProperties != null, iSVNDirEntryHandler != null, linkedList.size() > 0 ? linkedList.toArray(new String[linkedList.size()]) : null};
            this.write("(w(s(n)ww(*w)))", objectArray);
            this.authenticate();
            List list = this.read("rll", null, false);
            long l4 = l2 = list.get(0) != null ? SVNReader.getLong(list, 0) : l2;
            if (sVNProperties != null) {
                SVNReader.getProperties(list, 1, sVNProperties);
            }
            if (iSVNDirEntryHandler != null) {
                SVNURL sVNURL2 = this.getRepositoryRoot(false);
                List list2 = (List)list.get(2);
                for (SVNItem sVNItem : list2) {
                    Object object;
                    if (sVNItem.getKind() != 2) {
                        object = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Dirlist element not a list");
                        SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.NETWORK);
                    }
                    object = SVNReader.parseTuple("swnsr(?s)(?s)", sVNItem.getItems(), null);
                    String string3 = SVNReader.getString((List)object, 0);
                    SVNNodeKind sVNNodeKind = SVNNodeKind.parseKind(SVNReader.getString((List)object, 1));
                    long l5 = SVNReader.getLong((List)object, 2);
                    boolean bl2 = SVNReader.getBoolean((List)object, 3);
                    long l6 = SVNReader.getLong((List)object, 4);
                    SVNDate sVNDate = SVNDate.parseDate(SVNReader.getString((List)object, 5));
                    String string4 = SVNReader.getString((List)object, 6);
                    iSVNDirEntryHandler.handleDirEntry(new SVNDirEntry(sVNURL.appendPath(string3, false), sVNURL2, "".equals(string3) ? SVNPathUtil.tail(sVNURL.getPath()) : string3, sVNNodeKind, l5, bl2, l6, sVNDate, string4));
                }
            }
        }
        catch (SVNException sVNException) {
            this.closeSession();
            throw sVNException;
        }
        finally {
            this.closeConnection();
        }
        return l2;
    }

    @Override
    public SVNDirEntry getDir(String string, long l2, boolean bl2, Collection collection) {
        Long l3 = SVNRepositoryImpl.getRevisionObject(l2);
        SVNDirEntry sVNDirEntry = null;
        try {
            Object object;
            Iterator iterator;
            Object object2;
            this.openConnection();
            SVNURL sVNURL = this.getLocation().setPath(this.getFullPath(string), false);
            SVNURL sVNURL2 = this.getRepositoryRoot(false);
            SVNRepositoryImpl$1 sVNRepositoryImpl$1 = new SVNRepositoryImpl$1(this, collection, sVNURL, sVNURL2);
            string = this.getLocationRelativePath(string);
            Object[] objectArray = new Object[]{"stat", string, SVNRepositoryImpl.getRevisionObject(l2)};
            this.write("(w(s(n)))", objectArray);
            this.authenticate();
            List list = this.read("(?l)", null, false);
            list = (List)list.get(0);
            if (list != null) {
                object2 = SVNReader.parseTuple("wnsr(?s)(?s)", list, null);
                iterator = SVNNodeKind.parseKind(SVNReader.getString((List)object2, 0));
                long l4 = SVNReader.getLong((List)object2, 1);
                boolean bl3 = SVNReader.getBoolean((List)object2, 2);
                long l5 = SVNReader.getLong((List)object2, 3);
                SVNDate sVNDate = SVNDate.parseDate(SVNReader.getString((List)object2, 4));
                String string2 = SVNReader.getString((List)object2, 5);
                sVNDirEntry = new SVNDirEntry(sVNURL, sVNURL2, "", (SVNNodeKind)((Object)iterator), l4, bl3, l5, sVNDate, string2);
            }
            objectArray = new Object[]{"get-dir", string, l3, Boolean.FALSE, Boolean.TRUE};
            this.write("(w(s(n)ww))", objectArray);
            this.authenticate();
            list = this.read("rll", null, false);
            long l6 = l2 = list.get(0) != null ? SVNReader.getLong(list, 0) : l2;
            if (sVNRepositoryImpl$1 != null) {
                object2 = (List)list.get(2);
                iterator = object2.iterator();
                while (iterator.hasNext()) {
                    SVNItem sVNItem = (SVNItem)iterator.next();
                    if (sVNItem.getKind() != 2) {
                        object = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Dirlist element not a list");
                        SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.NETWORK);
                    }
                    object = SVNReader.parseTuple("swnsr(?s)(?s)", sVNItem.getItems(), null);
                    String string3 = SVNReader.getString((List)object, 0);
                    SVNNodeKind sVNNodeKind = SVNNodeKind.parseKind(SVNReader.getString((List)object, 1));
                    long l7 = SVNReader.getLong((List)object, 2);
                    boolean bl4 = SVNReader.getBoolean((List)object, 3);
                    long l8 = SVNReader.getLong((List)object, 4);
                    SVNDate sVNDate = SVNDate.parseDate(SVNReader.getString((List)object, 5));
                    String string4 = SVNReader.getString((List)object, 6);
                    sVNRepositoryImpl$1.handleDirEntry(new SVNDirEntry(sVNURL.appendPath(string3, false), sVNURL2, string3, sVNNodeKind, l7, bl4, l8, sVNDate, string4));
                }
            }
            if (bl2 && collection != null) {
                object2 = new SVNHashMap();
                for (SVNDirEntry sVNDirEntry2 : collection) {
                    object = SVNRepositoryImpl.getRevisionObject(sVNDirEntry2.getRevision());
                    if (object2.containsKey(object)) {
                        sVNDirEntry2.setCommitMessage((String)object2.get(object));
                        continue;
                    }
                    objectArray = new Object[]{"rev-prop", object, "svn:log"};
                    this.write("(w(ns))", objectArray);
                    this.authenticate();
                    list = this.read("(?s)", null, false);
                    String string5 = SVNReader.getString(list, 0);
                    object2.put(object, string5);
                    sVNDirEntry2.setCommitMessage(string5);
                }
            }
        }
        catch (SVNException sVNException) {
            this.closeSession();
            throw sVNException;
        }
        finally {
            this.closeConnection();
        }
        return sVNDirEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int getFileRevisionsImpl(String string, long l2, long l3, boolean bl2, ISVNFileRevisionHandler iSVNFileRevisionHandler) {
        Long l4 = SVNRepositoryImpl.getRevisionObject(l2);
        Long l5 = SVNRepositoryImpl.getRevisionObject(l3);
        SVNDeltaReader sVNDeltaReader = new SVNDeltaReader();
        if (!(l2 <= l3 && SVNRevision.isValidRevisionNumber(l2) || this.hasCapability(SVNCapability.GET_FILE_REVS_REVERSED))) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_NOT_IMPLEMENTED), SVNLogType.NETWORK);
        }
        try {
            Object object;
            this.openConnection();
            Object[] objectArray = new Object[]{"get-file-revs", this.getLocationRelativePath(string), l4, l5, Boolean.toString(bl2)};
            this.write("(w(s(n)(n)w))", objectArray);
            this.authenticate();
            boolean bl3 = false;
            int n2 = 0;
            while (((SVNItem)(object = this.readItem(false))).getKind() != 0 || !"done".equals(((SVNItem)object).getWord())) {
                boolean bl4;
                SVNItem sVNItem;
                Serializable serializable;
                Object object2;
                Object object3;
                bl3 = true;
                if (((SVNItem)object).getKind() != 2) {
                    object3 = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Revision entry not a list");
                    SVNErrorManager.error((SVNErrorMessage)object3, SVNLogType.NETWORK);
                }
                object3 = SVNReader.parseTuple("srll?s", ((SVNItem)object).getItems(), null);
                String string2 = null;
                SVNFileRevision sVNFileRevision = null;
                if (iSVNFileRevisionHandler != null) {
                    string2 = SVNReader.getString((List)object3, 0);
                    long l6 = SVNReader.getLong((List)object3, 1);
                    object2 = SVNReader.getProperties((List)object3, 2, null);
                    serializable = SVNReader.getPropertyDiffs((List)object3, 3, null);
                    boolean bl5 = SVNReader.getBoolean((List)object3, 4);
                    if (string2 != null) {
                        sVNFileRevision = new SVNFileRevision(string2, l6, (SVNProperties)object2, (SVNProperties)serializable, bl5);
                    }
                }
                if ((sVNItem = this.readItem(false)).getKind() != 1) {
                    SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Text delta chunk not a string");
                    SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
                }
                boolean bl6 = bl4 = sVNItem.getBytes().length > 0;
                if (iSVNFileRevisionHandler != null && sVNFileRevision != null) {
                    iSVNFileRevisionHandler.openRevision(sVNFileRevision);
                }
                if (bl4) {
                    if (iSVNFileRevisionHandler != null) {
                        iSVNFileRevisionHandler.applyTextDelta(string2 == null ? string : string2, null);
                    }
                    while ((object2 = (Object)sVNItem.getBytes()) != null && ((Object)object2).length != 0) {
                        sVNDeltaReader.nextWindow((byte[])object2, 0, ((Object)object2).length, string2 == null ? string : string2, iSVNFileRevisionHandler);
                        sVNItem = this.readItem(false);
                        if (sVNItem.getKind() == 1) continue;
                        serializable = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Text delta chunk not a string");
                        SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.NETWORK);
                    }
                    sVNDeltaReader.reset(string2 == null ? string : string2, iSVNFileRevisionHandler);
                    if (iSVNFileRevisionHandler != null) {
                        iSVNFileRevisionHandler.textDeltaEnd(string2 == null ? string : string2);
                    }
                }
                if (iSVNFileRevisionHandler == null) continue;
                iSVNFileRevisionHandler.closeRevision(string2 == null ? string : string2);
                ++n2;
            }
            this.read("", null, false);
            if (!bl3) {
                object = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "The get-file-revs command didn't return any revisions");
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.NETWORK);
            }
            int n3 = n2;
            return n3;
        }
        catch (SVNException sVNException) {
            this.closeSession();
            this.handleUnsupportedCommand(sVNException, "'get-file-revs' not implemented");
        }
        finally {
            this.closeConnection();
        }
        return -1;
    }

    @Override
    protected long logImpl(String[] stringArray, long l2, long l3, boolean bl2, boolean bl3, long l4, boolean bl4, String[] stringArray2, ISVNLogEntryHandler iSVNLogEntryHandler) {
        long l5 = 0L;
        int n2 = 0;
        long l6 = -1L;
        if (SVNRepositoryImpl.isInvalidRevision(l2)) {
            l2 = l6 = this.getLatestRevision();
        }
        if (SVNRepositoryImpl.isInvalidRevision(l3)) {
            l3 = l6 != -1L ? l6 : this.getLatestRevision();
        }
        try {
            Object[] objectArray;
            Object object;
            Object object2;
            this.openConnection();
            String[] stringArray3 = this.getRepositoryPaths(stringArray);
            if (stringArray3 == null || stringArray3.length == 0) {
                stringArray3 = new String[]{""};
            }
            if (stringArray3.length == 1 && "/".equals(stringArray3[0])) {
                stringArray3[0] = "";
            }
            boolean bl5 = false;
            if (stringArray2 != null && stringArray2.length > 0) {
                object2 = new Object[]{"log", stringArray3, SVNRepositoryImpl.getRevisionObject(l2), SVNRepositoryImpl.getRevisionObject(l3), bl2, bl3, l4 > 0L ? l4 : 0L, bl4, "revprops", stringArray2};
                for (int i2 = 0; i2 < stringArray2.length; ++i2) {
                    object = stringArray2[i2];
                    if ("svn:author".equals(object) || "svn:date".equals(object) || "svn:log".equals(object)) continue;
                    bl5 = true;
                    break;
                }
                objectArray = object2;
                this.write("(w((*s)(n)(n)wwnww(*s)))", objectArray);
            } else {
                objectArray = new Object[]{"log", stringArray3, SVNRepositoryImpl.getRevisionObject(l2), SVNRepositoryImpl.getRevisionObject(l3), bl2, bl3, l4 > 0L ? l4 : 0L, bl4, "all-revprops"};
                this.write("(w((*s)(n)(n)wwnww()))", objectArray);
            }
            this.authenticate();
            while (((SVNItem)(object2 = this.readItem(false))).getKind() != 0 || !"done".equals(((SVNItem)object2).getWord())) {
                String string;
                Object object3;
                Object object4;
                if (((SVNItem)object2).getKind() != 2) {
                    SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Log entry not a list");
                    SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
                }
                List list = SVNReader.parseTuple("lr(?s)(?s)(?s)?ssnl?s", ((SVNItem)object2).getItems(), null);
                object = (List)list.get(0);
                SVNHashMap sVNHashMap = new SVNHashMap();
                if (object != null && object.size() > 0) {
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        SVNItem sVNItem = (SVNItem)iterator.next();
                        if (sVNItem.getKind() != 2) {
                            object4 = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Changed-path entry not a list");
                            SVNErrorManager.error((SVNErrorMessage)object4, SVNLogType.NETWORK);
                        }
                        object4 = SVNReader.parseTuple("sw(?sr)?(?s)", sVNItem.getItems(), null);
                        object3 = SVNReader.getString((List)object4, 0);
                        String string2 = SVNReader.getString((List)object4, 1);
                        String string3 = SVNReader.getString((List)object4, 2);
                        long l7 = SVNReader.getLong((List)object4, 3);
                        string = SVNReader.getString((List)object4, 4);
                        sVNHashMap.put(object3, new SVNLogEntryPath((String)object3, string2.charAt(0), string3, l7, string != null ? SVNNodeKind.parseKind(string) : SVNNodeKind.UNKNOWN));
                    }
                }
                if (n2 == 0) {
                    ++l5;
                }
                long l8 = 0L;
                object4 = null;
                object3 = new SVNProperties();
                boolean bl6 = false;
                boolean bl7 = false;
                if (iSVNLogEntryHandler != null && (l4 <= 0L || l5 <= l4 || n2 != 0)) {
                    l8 = SVNReader.getLong(list, 1);
                    String string4 = SVNReader.getString(list, 2);
                    Date date = SVNReader.getDate(list, 3);
                    if (date == SVNDate.NULL) {
                        date = null;
                    }
                    string = SVNReader.getString(list, 4);
                    bl6 = SVNReader.getBoolean(list, 5);
                    boolean bl8 = SVNReader.getBoolean(list, 6);
                    object4 = SVNReader.getProperties(list, 8, null);
                    if (bl8) {
                        l8 = -1L;
                    }
                    bl7 = SVNReader.getBoolean(list, 9);
                    if (bl5 && object4 == null) {
                        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_NOT_IMPLEMENTED, "Server does not support custom revprops via log");
                        SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
                    }
                    if (object4 != null) {
                        for (String string5 : ((SVNProperties)object4).nameSet()) {
                            ((SVNProperties)object3).put(string5, ((SVNProperties)object4).getSVNPropertyValue(string5));
                        }
                    }
                    if (stringArray2 == null || stringArray2.length == 0) {
                        if (string4 != null) {
                            ((SVNProperties)object3).put("svn:author", string4);
                        }
                        if (date != null) {
                            ((SVNProperties)object3).put("svn:date", SVNDate.formatDate(date));
                        }
                        if (string != null) {
                            ((SVNProperties)object3).put("svn:log", string);
                        }
                    } else {
                        for (int i3 = 0; i3 < stringArray2.length; ++i3) {
                            String string5;
                            string5 = stringArray2[i3];
                            if (string4 != null && "svn:author".equals(string5)) {
                                ((SVNProperties)object3).put("svn:author", string4);
                            }
                            if (date != null && "svn:date".equals(string5)) {
                                ((SVNProperties)object3).put("svn:date", SVNDate.formatDate(date));
                            }
                            if (string == null || !"svn:log".equals(string5)) continue;
                            ((SVNProperties)object3).put("svn:log", string);
                        }
                    }
                }
                if (iSVNLogEntryHandler == null || l4 > 0L && l5 > l4 && n2 == 0) continue;
                SVNLogEntry sVNLogEntry = new SVNLogEntry(sVNHashMap, l8, (SVNProperties)object3, bl6);
                sVNLogEntry.setSubtractiveMerge(bl7);
                iSVNLogEntryHandler.handleLogEntry(sVNLogEntry);
                if (sVNLogEntry.hasChildren()) {
                    ++n2;
                }
                if (sVNLogEntry.getRevision() >= 0L || --n2 >= 0) continue;
                n2 = 0;
            }
            this.read("", null, false);
            long l9 = l5;
            return l9;
        }
        catch (SVNException sVNException) {
            this.closeSession();
            throw sVNException;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replay(long l2, long l3, boolean bl2, ISVNEditor iSVNEditor) {
        Object[] objectArray = new Object[]{"replay", SVNRepositoryImpl.getRevisionObject(l3), SVNRepositoryImpl.getRevisionObject(l2), bl2};
        try {
            this.openConnection();
            this.write("(w(nnw))", objectArray);
            this.authenticate();
            SVNEditModeReader sVNEditModeReader = new SVNEditModeReader(this.myConnection, iSVNEditor, true);
            sVNEditModeReader.driveEditor();
            this.read("", null, false);
        }
        catch (SVNException sVNException) {
            this.closeSession();
            this.handleUnsupportedCommand(sVNException, "Server doesn't support the replay command");
        }
        finally {
            this.closeConnection();
        }
    }

    @Override
    public void setRevisionPropertyValue(long l2, String string, SVNPropertyValue sVNPropertyValue) {
        SVNRepositoryImpl.assertValidRevision(l2);
        byte[] byArray = SVNPropertyValue.getPropertyAsBytes(sVNPropertyValue);
        Object[] objectArray = new Object[]{"change-rev-prop", SVNRepositoryImpl.getRevisionObject(l2), string, byArray};
        try {
            this.openConnection();
            this.write("(w(nsb))", objectArray);
            this.authenticate();
            this.read("", null, false);
        }
        catch (SVNException sVNException) {
            this.closeSession();
            throw sVNException;
        }
        finally {
            this.closeConnection();
        }
    }

    @Override
    public ISVNEditor getCommitEditor(String string, Map map, boolean bl2, ISVNWorkspaceMediator iSVNWorkspaceMediator) {
        try {
            SVNProperties sVNProperties;
            this.openConnection();
            SVNProperties sVNProperties2 = sVNProperties = this.myConnection.hasCapability(SVNCapability.EPHEMERAL_PROPS.toString()) ? new SVNProperties() : null;
            if (sVNProperties != null) {
                sVNProperties.put("svn:txn-client-compat-version", Version.getSVNVersion());
                sVNProperties.put("svn:txn-user-agent", Version.getUserAgent());
                sVNProperties.put("svn:log", string);
            }
            if (map != null) {
                if (sVNProperties != null) {
                    this.write("(w(s(*l)w(*l)))", new Object[]{"commit", string, map, bl2, sVNProperties});
                } else {
                    this.write("(w(s(*l)w))", new Object[]{"commit", string, map, bl2});
                }
            } else if (sVNProperties != null) {
                this.write("(w(s(*l)w(*l)))", new Object[]{"commit", string, new HashMap(), false, sVNProperties});
            } else {
                this.write("(w(s))", new Object[]{"commit", string});
            }
            this.authenticate();
            this.read("", null, false);
            return new SVNCommitEditor(this, this.myConnection, new SVNRepositoryImpl$2(this));
        }
        catch (SVNException sVNException) {
            this.closeSession();
            this.closeConnection();
            throw sVNException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SVNLock getLock(String string) {
        try {
            this.openConnection();
            string = this.getLocationRelativePath(string);
            Object[] objectArray = new Object[]{"get-lock", string};
            this.write("(w(s))", objectArray);
            this.authenticate();
            List list = this.read("(?l)", null, false);
            list = (List)list.get(0);
            SVNLock sVNLock = SVNReader.getLock(list);
            return sVNLock;
        }
        catch (SVNException sVNException) {
            this.closeSession();
            this.handleUnsupportedCommand(sVNException, "Server doesn't support the get-lock command");
        }
        finally {
            this.closeConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SVNLock[] getLocks(String string) {
        try {
            this.openConnection();
            string = this.getLocationRelativePath(string);
            Object[] objectArray = new Object[]{"get-locks", string};
            this.write("(w(s))", objectArray);
            this.authenticate();
            List list = this.read("l", null, false);
            list = (List)list.get(0);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (SVNItem sVNItem : list) {
                Object object;
                if (sVNItem.getKind() != 2) {
                    object = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Lock element not a list");
                    SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.NETWORK);
                }
                if ((object = SVNReader.getLock(sVNItem.getItems())) == null) continue;
                arrayList.add(object);
            }
            SVNLock[] sVNLockArray = arrayList.toArray(new SVNLock[arrayList.size()]);
            return sVNLockArray;
        }
        catch (SVNException sVNException) {
            this.closeSession();
            this.handleUnsupportedCommand(sVNException, "Server doesn't support the get-lock command");
        }
        finally {
            this.closeConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lock(Map map, String string, boolean bl2, ISVNLockHandler iSVNLockHandler) {
        block20: {
            Object object;
            Object object2;
            boolean bl3;
            try {
                this.openConnection();
                Object[] objectArray = new Object[]{"lock-many", string, bl2};
                this.write("(w((s)w(", objectArray);
                objectArray = new Object[2];
                Iterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    objectArray[0] = this.getLocationRelativePath((String)iterator.next());
                    objectArray[1] = map.get(objectArray[0]);
                    this.write("(s(n))", objectArray);
                }
                this.write(")))", objectArray);
                try {
                    this.authenticate();
                }
                catch (SVNException sVNException) {
                    if (sVNException.getErrorMessage() != null && sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.RA_SVN_UNKNOWN_CMD) {
                        this.closeSession();
                        this.closeConnection();
                        this.openConnection();
                        this.lock12(map, string, bl2, iSVNLockHandler);
                        this.closeConnection();
                        return;
                    }
                    this.closeSession();
                    throw sVNException;
                }
                bl3 = false;
                object2 = map.keySet().iterator();
            }
            catch (SVNException sVNException) {
                this.closeSession();
                this.handleUnsupportedCommand(sVNException, "Server doesn't support the lock command");
                break block20;
            }
            finally {
                this.closeConnection();
            }
            while (object2.hasNext()) {
                Object object3;
                object = (String)object2.next();
                SVNLock sVNLock = null;
                SVNErrorMessage sVNErrorMessage = null;
                SVNItem sVNItem = this.readItem(false);
                if (sVNItem.getKind() == 0 && "done".equals(sVNItem.getWord())) {
                    bl3 = true;
                    break;
                }
                if (sVNItem.getKind() != 2) {
                    object3 = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Lock response not a list");
                    SVNErrorManager.error((SVNErrorMessage)object3, SVNLogType.NETWORK);
                }
                try {
                    object3 = SVNReader.parseTuple("wl", sVNItem.getItems(), null);
                    String string2 = SVNReader.getString((List)object3, 0);
                    List list = (List)object3.get(1);
                    if ("success".equals(string2)) {
                        sVNLock = SVNReader.getLock(list);
                        if (sVNLock == null) continue;
                        object = sVNLock.getPath();
                    } else if ("failure".equals(string2)) {
                        SVNReader.handleFailureStatus(list);
                    } else {
                        SVNErrorMessage sVNErrorMessage2 = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA);
                        SVNErrorManager.error(sVNErrorMessage2, SVNLogType.NETWORK);
                    }
                }
                catch (SVNException sVNException) {
                    object = this.getRepositoryPath((String)object);
                    sVNErrorMessage = sVNException.getErrorMessage();
                }
                if (iSVNLockHandler == null) continue;
                iSVNLockHandler.handleLock((String)object, sVNLock, sVNErrorMessage);
            }
            if (!(bl3 || ((SVNItem)(object2 = this.readItem(false))).getKind() == 0 && "done".equals(((SVNItem)object2).getWord()))) {
                object = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Didn't receive end marker for lock responses");
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.NETWORK);
            }
            this.read("", null, false);
        }
    }

    private void lock12(Map map, String string, boolean bl2, ISVNLockHandler iSVNLockHandler) {
        for (String string2 : map.keySet()) {
            List list;
            SVNErrorMessage sVNErrorMessage;
            block4: {
                Long l2 = (Long)map.get(string2);
                string2 = this.getLocationRelativePath(string2);
                Object[] objectArray = new Object[]{"lock", string2, string, bl2, l2};
                this.write("(w(s(s)w(n)))", objectArray);
                this.authenticate();
                sVNErrorMessage = null;
                list = null;
                try {
                    list = this.read("l", null, false);
                    list = (List)list.get(0);
                }
                catch (SVNException sVNException) {
                    SVNErrorCode sVNErrorCode;
                    if (sVNException.getErrorMessage() != null && ((sVNErrorCode = sVNException.getErrorMessage().getErrorCode()) == SVNErrorCode.FS_PATH_ALREADY_LOCKED || sVNErrorCode == SVNErrorCode.FS_OUT_OF_DATE)) {
                        sVNErrorMessage = sVNException.getErrorMessage();
                    }
                    if (sVNErrorMessage != null) break block4;
                    throw sVNException;
                }
            }
            if (iSVNLockHandler == null) continue;
            SVNLock sVNLock = list == null ? null : SVNReader.getLock(list);
            string2 = sVNLock != null ? sVNLock.getPath() : this.getRepositoryPath(string2);
            iSVNLockHandler.handleLock(string2, sVNLock, sVNErrorMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock(Map map, boolean bl2, ISVNLockHandler iSVNLockHandler) {
        block20: {
            Object object;
            Object object2;
            boolean bl3;
            try {
                this.openConnection();
                Object[] objectArray = new Object[]{"unlock-many", bl2};
                this.write("(w(w(", objectArray);
                objectArray = new Object[2];
                Iterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    objectArray[0] = iterator.next();
                    objectArray[1] = map.get(objectArray[0]);
                    this.write("(s(s))", objectArray);
                }
                this.write(")))", objectArray);
                try {
                    this.authenticate();
                }
                catch (SVNException sVNException) {
                    if (sVNException.getErrorMessage() != null && sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.RA_SVN_UNKNOWN_CMD) {
                        this.closeSession();
                        this.closeConnection();
                        this.openConnection();
                        this.unlock12(map, bl2, iSVNLockHandler);
                        this.closeConnection();
                        return;
                    }
                    throw sVNException;
                }
                bl3 = false;
                object2 = map.keySet().iterator();
            }
            catch (SVNException sVNException) {
                this.closeSession();
                this.handleUnsupportedCommand(sVNException, "Server doesn't support the unlock command");
                break block20;
            }
            finally {
                this.closeConnection();
            }
            while (object2.hasNext()) {
                object = (String)object2.next();
                String string = (String)map.get(object);
                SVNErrorMessage sVNErrorMessage = null;
                try {
                    Object object3;
                    SVNItem sVNItem = this.readItem(false);
                    if (sVNItem.getKind() == 0 && "done".equals(sVNItem.getWord())) {
                        bl3 = true;
                        break;
                    }
                    if (sVNItem.getKind() != 2) {
                        object3 = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Unlock response not a list");
                        SVNErrorManager.error((SVNErrorMessage)object3, SVNLogType.NETWORK);
                    }
                    object3 = SVNReader.parseTuple("wl", sVNItem.getItems(), null);
                    String string2 = SVNReader.getString((List)object3, 0);
                    List list = (List)object3.get(1);
                    if ("success".equals(string2)) {
                        object3 = SVNReader.parseTuple("s", list, null);
                        object = SVNReader.getString((List)object3, 0);
                    } else if ("failure".equals(string2)) {
                        SVNReader.handleFailureStatus(list);
                    } else {
                        SVNErrorMessage sVNErrorMessage2 = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA);
                        SVNErrorManager.error(sVNErrorMessage2, SVNLogType.NETWORK);
                    }
                }
                catch (SVNException sVNException) {
                    sVNErrorMessage = sVNException.getErrorMessage();
                }
                object = this.getRepositoryPath((String)object);
                if (iSVNLockHandler == null) continue;
                iSVNLockHandler.handleUnlock((String)object, new SVNLock((String)object, string, null, null, null, null), sVNErrorMessage);
            }
            if (!(bl3 || ((SVNItem)(object2 = this.readItem(false))).getKind() == 0 && "done".equals(((SVNItem)object2).getWord()))) {
                object = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Didn't receive end marker for unlock responses");
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.NETWORK);
            }
            this.read("", null, false);
        }
    }

    private void unlock12(Map map, boolean bl2, ISVNLockHandler iSVNLockHandler) {
        for (String string : map.keySet()) {
            SVNLock sVNLock;
            Object object;
            Object[] objectArray;
            String string2 = (String)map.get(string);
            string = this.getLocationRelativePath(string);
            if (string2 == null) {
                objectArray = new Object[]{"get-lock", string};
                this.write("(w(s))", objectArray);
                this.authenticate();
                object = this.read("l", null, false);
                object = (List)object.get(0);
                sVNLock = SVNReader.getLock((Collection)object);
                if (sVNLock == null) {
                    sVNLock = new SVNLock(string, "", null, null, null, null);
                    SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_NOT_LOCKED, "No lock on path ''{0}''", (Object)string);
                    if (iSVNLockHandler == null) continue;
                    iSVNLockHandler.handleUnlock(string, sVNLock, sVNErrorMessage);
                    continue;
                }
                string2 = sVNLock.getID();
            }
            objectArray = new Object[]{"unlock", string, string2, bl2};
            this.write("(w(s(s)w))", objectArray);
            this.authenticate();
            object = null;
            try {
                this.read("", null, false);
            }
            catch (SVNException sVNException) {
                if (sVNException.getErrorMessage() != null && sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.RA_NOT_LOCKED) {
                    object = sVNException.getErrorMessage();
                    object = SVNErrorMessage.create(((SVNErrorMessage)object).getErrorCode(), ((SVNErrorMessage)object).getMessageTemplate(), (Object)string);
                }
                throw sVNException;
            }
            if (iSVNLockHandler == null) continue;
            string = this.getRepositoryPath(string);
            sVNLock = new SVNLock(string, string2, null, null, null, null);
            iSVNLockHandler.handleUnlock(string, sVNLock, (SVNErrorMessage)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SVNDirEntry info(String string, long l2) {
        try {
            SVNURL sVNURL;
            this.openConnection();
            String string2 = this.getFullPath(string);
            SVNURL sVNURL2 = this.getLocation().setPath(string2, false);
            string = this.getLocationRelativePath(string);
            Object[] objectArray = new Object[]{"stat", string, SVNRepositoryImpl.getRevisionObject(l2)};
            this.write("(w(s(n)))", objectArray);
            this.authenticate();
            Object object = null;
            List list = this.read("(?l)", null, false);
            if (list == null || list.isEmpty()) {
                SVNDirEntry sVNDirEntry = null;
                return sVNDirEntry;
            }
            if ((list = (List)list.get(0)) != null && !list.isEmpty()) {
                sVNURL = this.getRepositoryRoot(false);
                List list2 = SVNReader.parseTuple("wnsr(?s)(?s)", list, null);
                SVNNodeKind sVNNodeKind = SVNNodeKind.parseKind(SVNReader.getString(list2, 0));
                long l3 = SVNReader.getLong(list2, 1);
                boolean bl2 = SVNReader.getBoolean(list2, 2);
                long l4 = SVNReader.getLong(list2, 3);
                SVNDate sVNDate = SVNDate.parseDate(SVNReader.getString(list2, 4));
                String string3 = SVNReader.getString(list2, 5);
                object = new SVNDirEntry(sVNURL2, sVNURL, "".equals(string) ? SVNPathUtil.tail(this.getLocation().getPath()) : SVNPathUtil.tail(string), sVNNodeKind, l3, bl2, l4, sVNDate, string3);
            }
            sVNURL = object;
            return sVNURL;
        }
        catch (SVNException sVNException) {
            this.closeSession();
            this.handleUnsupportedCommand(sVNException, "'stat' not implemented");
        }
        finally {
            this.closeConnection();
        }
        return null;
    }

    void updateCredentials(String string, SVNURL sVNURL) {
        if (this.getRepositoryRoot(false) != null) {
            return;
        }
        this.setRepositoryCredentials(string, sVNURL);
    }

    protected void openConnection() {
        this.fireConnectionOpened();
        this.lock();
        if (this.myConnection != null && this.myConnection.isConnectionStale()) {
            this.closeSession();
        }
        if (this.myConnection != null) {
            if (this.reparent(this.getLocation())) {
                return;
            }
            this.closeSession();
        }
        ISVNConnector iSVNConnector = SVNRepositoryFactoryImpl.getConnectorFactory().createConnector(this);
        this.myConnection = new SVNConnection(iSVNConnector, this);
        try {
            this.myConnection.open(this);
            this.authenticate();
        }
        finally {
            if (this.myConnection != null) {
                this.myRealm = this.myConnection.getRealm();
            }
        }
    }

    protected void closeConnection() {
        if (!this.getOptions().keepConnection(this)) {
            this.closeSession();
        }
        this.unlock();
        this.fireConnectionClosed();
    }

    public String getRealm() {
        return this.myRealm;
    }

    void authenticate() {
        if (this.myConnection != null) {
            this.myConnection.authenticate(this);
        }
    }

    private void write(String string, Object[] objectArray) {
        if (this.myConnection == null) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_CONNECTION_CLOSED), SVNLogType.NETWORK);
        }
        this.myConnection.write(string, objectArray);
    }

    private List read(String string, List list, boolean bl2) {
        if (this.myConnection == null) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_CONNECTION_CLOSED), SVNLogType.NETWORK);
        }
        return this.myConnection.read(string, list, bl2);
    }

    private SVNItem readItem(boolean bl2) {
        if (this.myConnection == null) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_CONNECTION_CLOSED), SVNLogType.NETWORK);
        }
        return this.myConnection.readItem(bl2);
    }

    private List readTuple(String string, boolean bl2) {
        if (this.myConnection == null) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_CONNECTION_CLOSED), SVNLogType.NETWORK);
        }
        return this.myConnection.readTuple(string, bl2);
    }

    @Override
    public void setPath(String string, String string2, long l2, boolean bl2) {
        this.setPath(string, string2, l2, SVNDepth.INFINITY, bl2);
    }

    @Override
    public void deletePath(String string) {
        this.write("(w(s))", new Object[]{"delete-path", string});
    }

    @Override
    public void linkPath(SVNURL sVNURL, String string, String string2, long l2, boolean bl2) {
        this.linkPath(sVNURL, string, string2, l2, SVNDepth.INFINITY, bl2);
    }

    @Override
    public void finishReport() {
        this.write("(w())", new Object[]{"finish-report"});
    }

    @Override
    public void abortReport() {
        this.write("(w())", new Object[]{"abort-report"});
    }

    private String[] getRepositoryPaths(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return stringArray;
        }
        String[] stringArray2 = new String[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray2[i2] = this.getLocationRelativePath(stringArray[i2]);
        }
        return stringArray2;
    }

    public void setExternalUserName(String string) {
        this.myExternalUserName = string;
    }

    public String getExternalUserName() {
        return this.myExternalUserName;
    }

    @Override
    public void closeSession() {
        block6: {
            this.lock(true);
            try {
                if (this.myConnection == null) break block6;
                try {
                    this.myConnection.close();
                    this.myConnection = null;
                }
                catch (SVNException sVNException) {
                    this.myConnection = null;
                }
                catch (Throwable throwable) {
                    this.myConnection = null;
                    throw throwable;
                }
            }
            finally {
                this.unlock();
            }
        }
    }

    private void handleUnsupportedCommand(SVNException sVNException, String string) {
        if (sVNException.getErrorMessage() != null && sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.RA_SVN_UNKNOWN_CMD) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_NOT_IMPLEMENTED, string);
            SVNErrorManager.error(sVNErrorMessage, sVNException.getErrorMessage(), SVNLogType.NETWORK);
        }
        throw sVNException;
    }

    @Override
    public void linkPath(SVNURL sVNURL, String string, String string2, long l2, SVNDepth sVNDepth, boolean bl2) {
        SVNRepositoryImpl.assertValidRevision(l2);
        this.write("(w(ssnw(s)w))", new Object[]{"link-path", string, sVNURL.toString(), SVNRepositoryImpl.getRevisionObject(l2), bl2, string2, SVNDepth.asString(sVNDepth)});
    }

    @Override
    public void setPath(String string, String string2, long l2, SVNDepth sVNDepth, boolean bl2) {
        SVNRepositoryImpl.assertValidRevision(l2);
        this.write("(w(snw(s)w))", new Object[]{"set-path", string, SVNRepositoryImpl.getRevisionObject(l2), bl2, string2, SVNDepth.asString(sVNDepth)});
    }

    @Override
    public void diff(SVNURL sVNURL, long l2, long l3, String string, boolean bl2, SVNDepth sVNDepth, boolean bl3, ISVNReporterBaton iSVNReporterBaton, ISVNEditor iSVNEditor) {
        boolean bl4 = SVNRepositoryImpl.getRecurseFromDepth(sVNDepth);
        boolean bl5 = string != null;
        String string2 = string = string == null ? "" : string;
        if (sVNURL == null) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.BAD_URL, "URL can not be NULL"), SVNLogType.NETWORK);
        }
        iSVNEditor = this.getDepthFilterEditor(iSVNEditor, sVNDepth, bl5);
        Object[] objectArray = new Object[]{"diff", SVNRepositoryImpl.getRevisionObject(l2), string, bl4, bl2, sVNURL.toString(), bl3, SVNDepth.asString(sVNDepth)};
        try {
            this.openConnection();
            this.write("(w((n)swwsww))", objectArray);
            this.authenticate();
            iSVNReporterBaton.report(this);
            this.authenticate();
            SVNEditModeReader sVNEditModeReader = new SVNEditModeReader(this.myConnection, iSVNEditor, false);
            sVNEditModeReader.driveEditor();
            this.read("", null, false);
        }
        catch (SVNException sVNException) {
            this.closeSession();
            throw sVNException;
        }
        finally {
            this.closeConnection();
        }
    }

    @Override
    public void status(long l2, String string, SVNDepth sVNDepth, ISVNReporterBaton iSVNReporterBaton, ISVNEditor iSVNEditor) {
        boolean bl2 = SVNRepositoryImpl.getRecurseFromDepth(sVNDepth);
        boolean bl3 = string != null;
        string = string == null ? "" : string;
        iSVNEditor = this.getDepthFilterEditor(iSVNEditor, sVNDepth, bl3);
        Object[] objectArray = new Object[]{"status", string, bl2, SVNRepositoryImpl.getRevisionObject(l2), SVNDepth.asString(sVNDepth)};
        try {
            this.openConnection();
            this.write("(w(sw(n)w))", objectArray);
            this.authenticate();
            iSVNReporterBaton.report(this);
            this.authenticate();
            SVNEditModeReader sVNEditModeReader = new SVNEditModeReader(this.myConnection, iSVNEditor, false);
            sVNEditModeReader.driveEditor();
            this.read("", null, false);
        }
        catch (SVNException sVNException) {
            this.closeSession();
            throw sVNException;
        }
        finally {
            this.closeConnection();
        }
    }

    @Override
    public void update(SVNURL sVNURL, long l2, String string, SVNDepth sVNDepth, ISVNReporterBaton iSVNReporterBaton, ISVNEditor iSVNEditor) {
        boolean bl2 = SVNRepositoryImpl.getRecurseFromDepth(sVNDepth);
        boolean bl3 = string != null;
        String string2 = string = string == null ? "" : string;
        if (sVNURL == null) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.BAD_URL, "URL can not be NULL"), SVNLogType.NETWORK);
        }
        iSVNEditor = this.getDepthFilterEditor(iSVNEditor, sVNDepth, bl3);
        Object[] objectArray = new Object[]{"switch", SVNRepositoryImpl.getRevisionObject(l2), string, bl2, sVNURL.toString(), SVNDepth.asString(sVNDepth)};
        try {
            this.openConnection();
            this.write("(w((n)swsw))", objectArray);
            this.authenticate();
            iSVNReporterBaton.report(this);
            this.authenticate();
            SVNEditModeReader sVNEditModeReader = new SVNEditModeReader(this.myConnection, iSVNEditor, false);
            sVNEditModeReader.driveEditor();
            this.read("", null, false);
        }
        catch (SVNException sVNException) {
            this.closeSession();
            throw sVNException;
        }
        finally {
            this.closeConnection();
        }
    }

    @Override
    public void update(long l2, String string, SVNDepth sVNDepth, boolean bl2, ISVNReporterBaton iSVNReporterBaton, ISVNEditor iSVNEditor) {
        boolean bl3 = string != null;
        string = string == null ? "" : string;
        boolean bl4 = SVNRepositoryImpl.getRecurseFromDepth(sVNDepth);
        iSVNEditor = this.getDepthFilterEditor(iSVNEditor, sVNDepth, bl3);
        Object[] objectArray = new Object[]{"update", SVNRepositoryImpl.getRevisionObject(l2), string, bl4, SVNDepth.asString(sVNDepth), bl2};
        try {
            this.openConnection();
            this.write("(w((n)swww))", objectArray);
            this.authenticate();
            iSVNReporterBaton.report(this);
            this.authenticate();
            SVNEditModeReader sVNEditModeReader = new SVNEditModeReader(this.myConnection, iSVNEditor, false);
            sVNEditModeReader.driveEditor();
            this.read("", null, false);
        }
        catch (SVNException sVNException) {
            this.closeSession();
            throw sVNException;
        }
        finally {
            this.closeConnection();
        }
    }

    @Override
    protected Map getMergeInfoImpl(String[] stringArray, long l2, SVNMergeInfoInheritance sVNMergeInfoInheritance, boolean bl2) {
        try {
            this.openConnection();
            String[] stringArray2 = this.getRepositoryPaths(stringArray);
            if (stringArray2 == null || stringArray2.length == 0) {
                stringArray2 = new String[]{""};
            }
            Object[] objectArray = new Object[]{"get-mergeinfo", stringArray2, SVNRepositoryImpl.getRevisionObject(l2), sVNMergeInfoInheritance.toString(), bl2};
            this.write("(w((*s)(n)ww))", objectArray);
            this.authenticate();
            List list = this.read("l", null, false);
            list = (List)list.get(0);
            SVNHashMap sVNHashMap = new SVNHashMap();
            for (SVNItem sVNItem : list) {
                String string;
                Object object;
                if (sVNItem.getKind() != 2) {
                    object = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Merge info element is not a list");
                    SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.NETWORK);
                }
                string = (string = SVNReader.getString((List)(object = SVNReader.parseTuple("ss", sVNItem.getItems(), null)), 0)).startsWith("/") ? string.substring(1) : string;
                string = this.getRepositoryPath(string);
                String string2 = SVNReader.getString((List)object, 1);
                Map map = SVNMergeInfoUtil.parseMergeInfo(new StringBuffer(string2), null);
                SVNMergeInfo sVNMergeInfo = new SVNMergeInfo(string, map);
                sVNHashMap.put(string, sVNMergeInfo);
            }
            SVNHashMap sVNHashMap2 = sVNHashMap;
            return sVNHashMap2;
        }
        catch (SVNException sVNException) {
            this.closeSession();
            throw sVNException;
        }
        finally {
            this.closeConnection();
        }
    }

    @Override
    public boolean hasCapability(SVNCapability sVNCapability) {
        if (sVNCapability == null) {
            return false;
        }
        try {
            this.openConnection();
            String string = sVNCapability == SVNCapability.GET_FILE_REVS_REVERSED ? "file-revs-reverse" : sVNCapability.toString();
            boolean bl2 = this.myConnection.hasCapability(string);
            return bl2;
        }
        catch (SVNException sVNException) {
            this.closeSession();
            throw sVNException;
        }
        finally {
            this.closeConnection();
        }
    }

    @Override
    protected ISVNEditor getCommitEditorInternal(Map map, boolean bl2, SVNProperties serializable, ISVNWorkspaceMediator iSVNWorkspaceMediator) {
        try {
            Serializable serializable2;
            this.openConnection();
            String string = serializable.getStringValue("svn:log");
            if (serializable.size() > 1 && !this.myConnection.isCommitRevprops()) {
                serializable2 = SVNErrorMessage.create(SVNErrorCode.RA_NOT_IMPLEMENTED, "Server doesn't support setting arbitrary revision properties during commit");
                SVNErrorManager.error((SVNErrorMessage)serializable2, SVNLogType.NETWORK);
            }
            serializable2 = new SVNProperties();
            ((SVNProperties)serializable2).putAll((SVNProperties)serializable);
            if (this.myConnection.hasCapability(SVNCapability.EPHEMERAL_PROPS.toString())) {
                if (!((SVNProperties)serializable2).containsName("svn:txn-user-agent")) {
                    ((SVNProperties)serializable2).put("svn:txn-user-agent", Version.getUserAgent());
                }
                if (!((SVNProperties)serializable2).containsName("svn:txn-client-compat-version")) {
                    ((SVNProperties)serializable2).put("svn:txn-client-compat-version", Version.getSVNVersion());
                }
            } else {
                for (String string2 : new HashSet(((SVNProperties)serializable2).nameSet())) {
                    if (!string2.startsWith("svn:txn-")) continue;
                    ((SVNProperties)serializable2).remove(string2);
                }
            }
            serializable = serializable2;
            this.write("(w(s(*l)w(*l)))", new Object[]{"commit", string, map, bl2, serializable});
            this.authenticate();
            this.read("", null, false);
            return new SVNCommitEditor(this, this.myConnection, new SVNRepositoryImpl$3(this));
        }
        catch (SVNException sVNException) {
            this.closeConnection();
            this.closeSession();
            throw sVNException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void replayRangeImpl(long l2, long l3, long l4, boolean bl2, ISVNReplayHandler iSVNReplayHandler) {
        Object[] objectArray = new Object[]{"replay-range", SVNRepositoryImpl.getRevisionObject(l2), SVNRepositoryImpl.getRevisionObject(l3), SVNRepositoryImpl.getRevisionObject(l4), bl2};
        try {
            this.openConnection();
            this.write("(w(nnnw))", objectArray);
            this.authenticate();
            for (long i2 = l2; i2 <= l3; ++i2) {
                Serializable serializable;
                List list = this.readTuple("wl", false);
                String string = SVNReader.getString(list, 0);
                if (!"revprops".equals(string)) {
                    serializable = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Expected ''revprops'', found ''{0}''", (Object)string);
                    SVNErrorManager.error(serializable, SVNLogType.NETWORK);
                }
                serializable = SVNReader.getProperties(list, 1, null);
                ISVNEditor iSVNEditor = iSVNReplayHandler.handleStartRevision(i2, (SVNProperties)serializable);
                SVNEditModeReader sVNEditModeReader = new SVNEditModeReader(this.myConnection, iSVNEditor, true);
                sVNEditModeReader.driveEditor();
                iSVNReplayHandler.handleEndRevision(i2, (SVNProperties)serializable, iSVNEditor);
            }
            this.read("", null, false);
        }
        catch (SVNException sVNException) {
            this.closeSession();
            this.handleUnsupportedCommand(sVNException, "Server doesn't support the replay-range command");
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long getDeletedRevisionImpl(String string, long l2, long l3) {
        try {
            this.openConnection();
            string = this.getLocationRelativePath(string);
            Long l4 = SVNRepositoryImpl.getRevisionObject(l2);
            Long l5 = SVNRepositoryImpl.getRevisionObject(l3);
            Object[] objectArray = new Object[]{"get-deleted-rev", string, l4, l5};
            this.write("(w(snn))", objectArray);
            this.authenticate();
            List list = this.read("r", null, false);
            long l6 = SVNReader.getLong(list, 0);
            return l6;
        }
        catch (SVNException sVNException) {
            this.closeSession();
            this.handleUnsupportedCommand(sVNException, "'get-deleted-rev' not implemented");
        }
        finally {
            this.closeConnection();
        }
        return -1L;
    }

    private static boolean getRecurseFromDepth(SVNDepth sVNDepth) {
        return sVNDepth == null || sVNDepth == SVNDepth.UNKNOWN || sVNDepth.compareTo(SVNDepth.FILES) > 0;
    }

    private static String ensureAbsolutePath(String string) {
        if (string != null) {
            string = SVNPathUtil.canonicalizePath(string);
        }
        if (string != null && (string.length() == 0 || string.charAt(0) != '/')) {
            return "/" + string;
        }
        return string;
    }

    private ISVNEditor getDepthFilterEditor(ISVNEditor iSVNEditor, SVNDepth sVNDepth, boolean bl2) {
        if (sVNDepth != SVNDepth.FILES && sVNDepth != SVNDepth.INFINITY) {
            return SVNDepthFilterEditor.getDepthFilterEditor(sVNDepth, iSVNEditor, bl2);
        }
        return iSVNEditor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void getInheritedPropertiesImpl(String string, long l2, String string2, ISVNInheritedPropertiesHandler iSVNInheritedPropertiesHandler) {
        try {
            this.openConnection();
            string = this.getLocationRelativePath(string);
            this.write("(w(s(n)))", new Object[]{"get-iprops", string, l2});
            this.authenticate();
            List list = this.read("l", null, false);
            list = (List)list.get(0);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                SVNItem sVNItem = (SVNItem)list.get(i2);
                List list2 = SVNReader.parseTuple("sl", sVNItem.getItems(), null);
                String string3 = SVNReader.getString(list2, 0);
                if (!string3.startsWith("/")) {
                    string3 = "/" + string3;
                }
                List list3 = SVNReader.getList(list2, 1);
                SVNProperties sVNProperties = new SVNProperties();
                for (int i3 = 0; i3 < list3.size(); ++i3) {
                    SVNItem sVNItem2 = (SVNItem)list3.get(i3);
                    List list4 = SVNReader.parseTuple("sb", sVNItem2.getItems(), null);
                    String string4 = (String)list4.get(0);
                    sVNProperties.put(string4, SVNPropertyValue.create(string4, SVNReader.getBytes(list4, 1)));
                }
                if (sVNProperties.isEmpty() || iSVNInheritedPropertiesHandler == null) continue;
                if (string2 != null && sVNProperties.containsName(string2)) {
                    SVNProperties sVNProperties2 = new SVNProperties();
                    sVNProperties2.put(string2, sVNProperties.getSVNPropertyValue(string2));
                    iSVNInheritedPropertiesHandler.handleInheritedProperites(string3, sVNProperties2);
                    continue;
                }
                if (string2 != null) continue;
                iSVNInheritedPropertiesHandler.handleInheritedProperites(string3, sVNProperties);
            }
        }
        catch (SVNException sVNException) {
            this.closeSession();
            this.handleUnsupportedCommand(sVNException, "'get-iprops' not implemented");
        }
        finally {
            this.closeConnection();
        }
    }
}

