/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn;

import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.internal.io.svn.SVNItem;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNReader {
    private static final String DEAFAULT_ERROR_TEMPLATE = "nssn";
    private static final String DEFAULT_TEMPLATE = "wl";
    private static final String UTF8_CHARSET_STRING = "UTF-8";

    public static Date getDate(List list, int n2) {
        String string = SVNReader.getString(list, n2);
        return SVNDate.parseDate(string);
    }

    public static long getLong(List list, int n2) {
        if (list == null || n2 >= list.size()) {
            return -1L;
        }
        Object e2 = list.get(n2);
        if (e2 instanceof Long) {
            return (Long)e2;
        }
        return -1L;
    }

    public static boolean getBoolean(List list, int n2) {
        if (list == null || n2 >= list.size()) {
            return false;
        }
        Object e2 = list.get(n2);
        if (e2 instanceof String) {
            return Boolean.valueOf((String)e2);
        }
        return false;
    }

    public static List getList(List list, int n2) {
        if (list == null || n2 >= list.size()) {
            return Collections.EMPTY_LIST;
        }
        Object e2 = list.get(n2);
        if (e2 instanceof List) {
            List list2 = (List)e2;
            for (int i2 = 0; i2 < list2.size(); ++i2) {
                if (!(list2.get(i2) instanceof SVNItem)) continue;
                SVNItem sVNItem = (SVNItem)list2.get(i2);
                if (sVNItem.getKind() == 1) {
                    list2.set(i2, sVNItem.getBytes());
                    continue;
                }
                if (sVNItem.getKind() == 0) {
                    list2.set(i2, sVNItem.getWord());
                    continue;
                }
                if (sVNItem.getKind() != 3) continue;
                list2.set(i2, sVNItem.getNumber());
            }
            return list2;
        }
        return Collections.EMPTY_LIST;
    }

    public static SVNProperties getProperties(List list, int n2, SVNProperties sVNProperties) {
        SVNProperties sVNProperties2 = sVNProperties = sVNProperties == null ? new SVNProperties() : sVNProperties;
        if (list == null || n2 >= list.size()) {
            return sVNProperties;
        }
        if (!(list.get(n2) instanceof List)) {
            return sVNProperties;
        }
        List list2 = SVNReader.getItemList(list, n2);
        for (SVNItem sVNItem : list2) {
            Object object;
            if (sVNItem.getKind() != 2) {
                object = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Proplist element not a list");
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.NETWORK);
            }
            object = SVNReader.parseTuple("sb", sVNItem.getItems(), null);
            sVNProperties.put(SVNReader.getString((List)object, 0), SVNReader.getBytes((List)object, 1));
        }
        return sVNProperties;
    }

    public static SVNProperties getPropertyDiffs(List list, int n2, SVNProperties sVNProperties) {
        if (list == null || n2 >= list.size()) {
            return sVNProperties;
        }
        if (!(list.get(n2) instanceof List)) {
            return sVNProperties;
        }
        sVNProperties = sVNProperties == null ? new SVNProperties() : sVNProperties;
        list = SVNReader.getList(list, n2);
        for (SVNItem sVNItem : list) {
            Object object;
            if (sVNItem.getKind() != 2) {
                object = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Prop diffs element not a list");
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.NETWORK);
            }
            object = SVNReader.parseTuple("s(?b)", sVNItem.getItems(), null);
            sVNProperties.put(SVNReader.getString((List)object, 0), SVNReader.getBytes((List)object, 1));
        }
        return sVNProperties;
    }

    public static SVNLock getLock(Collection collection) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        List list = SVNReader.parseTuple("sss(?s)s(?s)", collection, null);
        if (list.isEmpty()) {
            return null;
        }
        String string = SVNPathUtil.canonicalizePath(SVNReader.getString(list, 0));
        String string2 = SVNReader.getString(list, 1);
        String string3 = SVNReader.getString(list, 2);
        String string4 = SVNReader.getString(list, 3);
        Date date = SVNReader.getDate(list, 4);
        Date date2 = null;
        if (list.size() >= 6 && list.get(5) != null) {
            date2 = SVNReader.getDate(list, 5);
        }
        return new SVNLock(string, string2, string3, string4, date, date2);
    }

    public static String getString(List list, int n2) {
        if (list == null || n2 >= list.size()) {
            return null;
        }
        Object e2 = list.get(n2);
        if (e2 instanceof byte[]) {
            try {
                return new String((byte[])e2, UTF8_CHARSET_STRING);
            }
            catch (IOException iOException) {
                return null;
            }
        }
        if (e2 instanceof String) {
            return (String)e2;
        }
        if (e2 instanceof Long) {
            return e2.toString();
        }
        return null;
    }

    public static byte[] getBytes(List list, int n2) {
        if (list == null || n2 >= list.size()) {
            return null;
        }
        Object e2 = list.get(n2);
        if (e2 instanceof byte[]) {
            return (byte[])e2;
        }
        if (e2 instanceof String) {
            try {
                return ((String)e2).getBytes(UTF8_CHARSET_STRING);
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return null;
    }

    private static List getItemList(List list, int n2) {
        if (list == null || n2 >= list.size()) {
            return Collections.EMPTY_LIST;
        }
        if (list.get(n2) instanceof List) {
            return (List)list.get(n2);
        }
        return Collections.EMPTY_LIST;
    }

    public static boolean hasValue(List list, int n2, Object object) {
        if (list == null || n2 >= list.size()) {
            return false;
        }
        if (list.get(n2) instanceof List) {
            for (Object e2 : (List)list.get(n2)) {
                if (!e2.equals(object)) continue;
                return true;
            }
        } else {
            if (list.get(n2) == null) {
                return object == null;
            }
            if (list.get(n2) instanceof byte[] && object instanceof String) {
                try {
                    list.set(n2, new String((byte[])list.get(n2), UTF8_CHARSET_STRING));
                }
                catch (IOException iOException) {
                    return false;
                }
            }
            return list.get(n2).equals(object);
        }
        return false;
    }

    public static SVNItem readItem(InputStream inputStream) {
        char c2 = SVNReader.skipWhiteSpace(inputStream);
        return SVNReader.readItem(inputStream, null, c2);
    }

    public static List parse(InputStream inputStream, String string, List list) {
        List list2 = SVNReader.readTuple(inputStream, DEFAULT_TEMPLATE);
        String string2 = SVNReader.getString(list2, 0);
        List list3 = SVNReader.getItemList(list2, 1);
        if ("success".equals(string2)) {
            return SVNReader.parseTuple(string, list3, list);
        }
        if ("failure".equals(string2)) {
            SVNReader.handleFailureStatus(list3);
        } else {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Unknown status ''{0}'' in command response", (Object)string2);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
        }
        return null;
    }

    public static void handleFailureStatus(List list) {
        SVNErrorMessage sVNErrorMessage;
        if (list.size() == 0) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Empty error list");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
        }
        SVNErrorMessage sVNErrorMessage2 = sVNErrorMessage = SVNReader.getErrorMessage((SVNItem)list.get(list.size() - 1));
        for (int i2 = list.size() - 2; i2 >= 0; --i2) {
            SVNItem sVNItem = (SVNItem)list.get(i2);
            SVNErrorMessage sVNErrorMessage3 = SVNReader.getErrorMessage(sVNItem);
            sVNErrorMessage2.setChildErrorMessage(sVNErrorMessage3);
            sVNErrorMessage2 = sVNErrorMessage3;
        }
        SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
    }

    private static SVNErrorMessage getErrorMessage(SVNItem sVNItem) {
        Object object;
        if (sVNItem.getKind() != 2) {
            object = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Malformed error list");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.NETWORK);
        }
        object = SVNReader.parseTuple(DEAFAULT_ERROR_TEMPLATE, sVNItem.getItems(), null);
        int n2 = ((Long)object.get(0)).intValue();
        SVNErrorCode sVNErrorCode = SVNErrorCode.getErrorCode(n2);
        String string = SVNReader.getString((List)object, 1);
        string = string == null ? "" : string;
        return SVNErrorMessage.create(sVNErrorCode, string);
    }

    public static List readTuple(InputStream inputStream, String string) {
        char c2 = SVNReader.skipWhiteSpace(inputStream);
        SVNItem sVNItem = SVNReader.readItem(inputStream, null, c2);
        if (sVNItem.getKind() != 2) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
        }
        return SVNReader.parseTuple(string, sVNItem.getItems(), null);
    }

    public static List parseTuple(String string, Collection collection, List list) {
        list = list == null ? new ArrayList() : list;
        SVNReader.parseTuple(string, 0, collection, list);
        return list;
    }

    private static int parseTuple(String string, int n2, Collection collection, List list) {
        Object object;
        list = list == null ? new ArrayList() : list;
        Object object2 = collection.iterator();
        while (object2.hasNext() && n2 < string.length()) {
            object = (SVNItem)object2.next();
            char c2 = string.charAt(n2);
            if (c2 == '?') {
                c2 = string.charAt(++n2);
            }
            if ((c2 == 'n' || c2 == 'r') && ((SVNItem)object).getKind() == 3) {
                list.add(((SVNItem)object).getNumber());
            } else if (c2 == 's' && ((SVNItem)object).getKind() == 1) {
                try {
                    list.add(new String(((SVNItem)object).getBytes(), UTF8_CHARSET_STRING));
                }
                catch (IOException iOException) {
                    list.add(((SVNItem)object).getBytes());
                }
            } else if (c2 == 's' && ((SVNItem)object).getKind() == 0) {
                list.add(((SVNItem)object).getWord());
            } else if (c2 == 'b' && ((SVNItem)object).getKind() == 1) {
                list.add(((SVNItem)object).getBytes());
            } else if (c2 == 'w' && ((SVNItem)object).getKind() == 0) {
                list.add(((SVNItem)object).getWord());
            } else if (c2 == 'l' && ((SVNItem)object).getKind() == 2) {
                list.add(((SVNItem)object).getItems());
            } else if (c2 == '(' && ((SVNItem)object).getKind() == 2) {
                ++n2;
                n2 = SVNReader.parseTuple(string, n2, ((SVNItem)object).getItems(), list);
            } else {
                if (c2 != ')') break;
                return ++n2;
            }
            ++n2;
        }
        if (n2 < string.length() && string.charAt(n2) == '?') {
            int n3 = 0;
            while (n2 < string.length()) {
                switch (string.charAt(n2)) {
                    case '?': {
                        break;
                    }
                    case 'n': 
                    case 'r': {
                        list.add(-1L);
                        break;
                    }
                    case 'b': 
                    case 's': 
                    case 'w': {
                        list.add(null);
                        break;
                    }
                    case 'l': {
                        list.add(Collections.EMPTY_LIST);
                        break;
                    }
                    case '(': {
                        ++n3;
                        break;
                    }
                    case ')': {
                        if (--n3 >= 0) break;
                        return n2;
                    }
                    default: {
                        object = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA);
                        SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.NETWORK);
                    }
                }
                ++n2;
            }
        }
        if (n2 == string.length() - 1 && string.charAt(n2) != ')') {
            object2 = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA);
            SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.NETWORK);
        }
        return n2;
    }

    private static SVNItem readItem(InputStream inputStream, SVNItem sVNItem, char c2) {
        if (sVNItem == null) {
            sVNItem = new SVNItem();
        }
        if (Character.isDigit(c2)) {
            Object object;
            long l2 = Character.digit(c2, 10);
            while (true) {
                long l3 = l2;
                c2 = SVNReader.readChar(inputStream);
                if (!Character.isDigit(c2)) break;
                if (l3 == (l2 = l2 * 10L + (long)Character.digit(c2, 10)) / 10L || l2 == -1L) continue;
                object = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Number is larger than maximum");
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.NETWORK);
            }
            if (c2 == ':') {
                object = new byte[(int)l2];
                try {
                    int n2;
                    for (int i2 = (int)l2; i2 > 0; i2 -= n2) {
                        n2 = inputStream.read((byte[])object, ((byte[])object).length - i2, i2);
                        if (n2 >= 0) continue;
                        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA);
                        SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
                    }
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    SVNDebugLog.getDefaultLog().logFinest(SVNLogType.NETWORK, socketTimeoutException);
                    SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_SVN_IO_ERROR, "time out reading data", null, 0, socketTimeoutException);
                    SVNErrorManager.error(sVNErrorMessage, socketTimeoutException, SVNLogType.NETWORK);
                }
                catch (IOException iOException) {
                    SVNDebugLog.getDefaultLog().logFinest(SVNLogType.NETWORK, iOException);
                    SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA);
                    SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
                }
                sVNItem.setKind(1);
                sVNItem.setLine((byte[])object);
                c2 = SVNReader.readChar(inputStream);
            } else {
                sVNItem.setKind(3);
                sVNItem.setNumber(l2);
            }
        } else if (Character.isLetter(c2)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(c2);
            while (Character.isLetterOrDigit(c2 = SVNReader.readChar(inputStream)) || c2 == '-') {
                stringBuffer.append(c2);
            }
            sVNItem.setKind(0);
            sVNItem.setWord(stringBuffer.toString());
        } else if (c2 == '(') {
            sVNItem.setKind(2);
            sVNItem.setItems(new ArrayList());
            while ((c2 = SVNReader.skipWhiteSpace(inputStream)) != ')') {
                SVNItem sVNItem2 = new SVNItem();
                sVNItem.getItems().add(sVNItem2);
                SVNReader.readItem(inputStream, sVNItem2, c2);
            }
            c2 = SVNReader.readChar(inputStream);
        }
        if (!Character.isWhitespace(c2)) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
        }
        return sVNItem;
    }

    private static char readChar(InputStream inputStream) {
        int n2 = 0;
        try {
            n2 = inputStream.read();
            if (n2 < 0) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            SVNDebugLog.getDefaultLog().logFinest(SVNLogType.NETWORK, socketTimeoutException);
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_SVN_IO_ERROR, "time out reading data", null, 0, socketTimeoutException);
            SVNErrorManager.error(sVNErrorMessage, socketTimeoutException, SVNLogType.NETWORK);
        }
        catch (IOException iOException) {
            SVNDebugLog.getDefaultLog().logFinest(SVNLogType.NETWORK, iOException);
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
        }
        return (char)(n2 & 0xFF);
    }

    private static char skipWhiteSpace(InputStream inputStream) {
        char c2;
        while (Character.isWhitespace(c2 = SVNReader.readChar(inputStream))) {
        }
        return c2;
    }
}

