/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.io.svn.ISVNConnector;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryImpl;
import org.tmatesoft.svn.core.internal.util.SVNSocketFactory;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNPlainConnector
implements ISVNConnector {
    private static final int DEFAULT_SVN_TIMEOUT = 0;
    private Socket mySocket;
    private OutputStream myOutputStream;
    private InputStream myInputStream;

    @Override
    public void open(SVNRepositoryImpl sVNRepositoryImpl) {
        if (this.mySocket != null) {
            return;
        }
        SVNURL sVNURL = sVNRepositoryImpl.getLocation();
        try {
            int n2 = sVNRepositoryImpl.getAuthenticationManager() != null ? sVNRepositoryImpl.getAuthenticationManager().getConnectTimeout(sVNRepositoryImpl) : 0;
            int n3 = sVNRepositoryImpl.getAuthenticationManager() != null ? sVNRepositoryImpl.getAuthenticationManager().getReadTimeout(sVNRepositoryImpl) : 0;
            this.mySocket = SVNSocketFactory.createPlainSocket(sVNURL.getHost(), sVNURL.getPort(), n2, n3, sVNRepositoryImpl.getCanceller());
        }
        catch (SocketTimeoutException socketTimeoutException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_SVN_IO_ERROR, "timed out waiting for server", null, 0, socketTimeoutException);
            SVNErrorManager.error(sVNErrorMessage, socketTimeoutException, SVNLogType.NETWORK);
        }
        catch (UnknownHostException unknownHostException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_SVN_IO_ERROR, "Unknown host " + unknownHostException.getMessage(), null, 0, unknownHostException);
            SVNErrorManager.error(sVNErrorMessage, unknownHostException, SVNLogType.NETWORK);
        }
        catch (ConnectException connectException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_SVN_IO_ERROR, "connection refused by the server", null, 0, connectException);
            SVNErrorManager.error(sVNErrorMessage, connectException, SVNLogType.NETWORK);
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_SVN_IO_ERROR, iOException.getLocalizedMessage());
            SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.NETWORK);
        }
    }

    @Override
    public void close(SVNRepositoryImpl sVNRepositoryImpl) {
        if (this.mySocket != null) {
            try {
                this.mySocket.shutdownInput();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.mySocket.shutdownOutput();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.mySocket.close();
            }
            catch (IOException iOException) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_IO_ERROR, iOException.getMessage(), (Object)iOException), SVNLogType.NETWORK);
            }
            finally {
                this.mySocket = null;
                this.myInputStream = null;
                this.myOutputStream = null;
            }
        }
    }

    @Override
    public boolean isStale() {
        try {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "checking whether connection is stale.");
            boolean bl2 = this.mySocket != null && SVNSocketFactory.isSocketStale(this.mySocket);
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "connection is stale: " + bl2);
            return bl2;
        }
        catch (IOException iOException) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "failure during stale check");
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, iOException);
            return true;
        }
    }

    @Override
    public boolean isConnected(SVNRepositoryImpl sVNRepositoryImpl) {
        return this.mySocket != null && this.mySocket.isConnected();
    }

    @Override
    public InputStream getInputStream() {
        if (this.myInputStream == null) {
            this.myInputStream = this.mySocket.getInputStream();
            this.myInputStream = new BufferedInputStream(this.myInputStream);
        }
        return this.myInputStream;
    }

    @Override
    public OutputStream getOutputStream() {
        if (this.myOutputStream == null) {
            this.myOutputStream = new BufferedOutputStream(this.mySocket.getOutputStream());
        }
        return this.myOutputStream;
    }

    public void free() {
    }

    public boolean occupy() {
        return true;
    }

    @Override
    public void handleExceptionOnOpen(SVNRepositoryImpl sVNRepositoryImpl, SVNException sVNException) {
        throw sVNException;
    }
}

