/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn;

import java.io.IOException;
import java.util.List;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.BasicAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.internal.io.svn.CramMD5;
import org.tmatesoft.svn.core.internal.io.svn.SVNAuthenticator;
import org.tmatesoft.svn.core.internal.io.svn.SVNConnection;
import org.tmatesoft.svn.core.internal.io.svn.SVNReader;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryImpl;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNPlainAuthenticator
extends SVNAuthenticator {
    public SVNPlainAuthenticator(SVNConnection sVNConnection) {
        super(sVNConnection);
    }

    @Override
    public SVNAuthentication authenticate(List list, String string, SVNRepositoryImpl sVNRepositoryImpl) {
        SVNAuthentication sVNAuthentication;
        SVNErrorMessage sVNErrorMessage;
        block25: {
            sVNErrorMessage = null;
            if (list == null || list.size() == 0) {
                return null;
            }
            ISVNAuthenticationManager iSVNAuthenticationManager = sVNRepositoryImpl.getAuthenticationManager();
            if (iSVNAuthenticationManager != null && iSVNAuthenticationManager.isAuthenticationForced() && list.contains("ANONYMOUS") && list.contains("CRAM-MD5")) {
                list.remove("ANONYMOUS");
            }
            SVNURL sVNURL = sVNRepositoryImpl.getLocation();
            sVNAuthentication = null;
            if (sVNRepositoryImpl.getExternalUserName() != null && list.contains("EXTERNAL")) {
                this.getConnection().write("(w(s))", new Object[]{"EXTERNAL", ""});
                sVNErrorMessage = this.readAuthResponse();
            } else if (list.contains("ANONYMOUS")) {
                this.getConnection().write("(w(s))", new Object[]{"ANONYMOUS", ""});
                sVNErrorMessage = this.readAuthResponse();
            } else {
                if (list.contains("CRAM-MD5")) {
                    block4: while (true) {
                        CramMD5 cramMD5 = new CramMD5();
                        if (sVNURL != null) {
                            string = "<" + sVNURL.getProtocol() + "://" + sVNURL.getHost() + ":" + sVNURL.getPort() + "> " + string;
                        }
                        try {
                            if (sVNAuthentication == null && iSVNAuthenticationManager != null) {
                                sVNAuthentication = (SVNPasswordAuthentication)iSVNAuthenticationManager.getFirstAuthentication("svn.simple", string, sVNURL);
                            } else if (iSVNAuthenticationManager != null) {
                                BasicAuthenticationManager.acknowledgeAuthentication(false, "svn.simple", string, sVNErrorMessage, sVNAuthentication, sVNURL, iSVNAuthenticationManager);
                                sVNAuthentication = (SVNPasswordAuthentication)iSVNAuthenticationManager.getNextAuthentication("svn.simple", string, sVNURL);
                            }
                        }
                        catch (SVNException sVNException) {
                            if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.CANCELLED) {
                                throw sVNException;
                            }
                            if (this.getLastError() != null) {
                                SVNErrorManager.error(this.getLastError(), SVNLogType.NETWORK);
                            }
                            throw sVNException;
                        }
                        if (sVNAuthentication == null) {
                            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CANCELLED, "Authentication cancelled");
                            this.setLastError(sVNErrorMessage);
                            break block25;
                        }
                        if (sVNAuthentication.getUserName() == null || ((SVNPasswordAuthentication)sVNAuthentication).getPasswordValue() == null) {
                            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "Can''t get password. Authentication is required for ''{0}''", (Object)string);
                            break block25;
                        }
                        this.getConnection().write("(w())", new Object[]{"CRAM-MD5"});
                        while (true) {
                            Object object;
                            cramMD5.setUserCredentials((SVNPasswordAuthentication)sVNAuthentication);
                            List list2 = this.getConnection().readTuple("w(?s)", true);
                            String string2 = SVNReader.getString(list2, 0);
                            if ("success".equals(string2)) {
                                BasicAuthenticationManager.acknowledgeAuthentication(true, "svn.simple", string, null, sVNAuthentication, sVNURL, iSVNAuthenticationManager);
                                return sVNAuthentication;
                            }
                            if ("failure".equals(string2)) {
                                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "Authentication error from server: {0}", (Object)SVNReader.getString(list2, 1));
                                object = SVNReader.getString(list2, 1);
                                if (object == null) continue block4;
                                this.setLastError(SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, (String)object));
                                continue block4;
                            }
                            if (!"step".equals(string2)) continue;
                            try {
                                object = cramMD5.buildChallengeResponse(SVNReader.getBytes(list2, 1));
                                this.getConnectionOutputStream().write((byte[])object);
                                this.getConnectionOutputStream().flush();
                            }
                            catch (IOException iOException) {
                                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_IO_ERROR, iOException.getMessage()), iOException, SVNLogType.NETWORK);
                            }
                        }
                        break;
                    }
                }
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "Cannot negotiate authentication mechanism"), SVNLogType.NETWORK);
            }
        }
        if (sVNErrorMessage != null) {
            if (this.getLastError() != null) {
                SVNErrorManager.error(this.getLastError(), SVNLogType.NETWORK);
            }
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
        }
        return sVNAuthentication;
    }

    protected SVNErrorMessage readAuthResponse() {
        List list = this.getConnection().readTuple("w(?s)", true);
        if ("success".equals(SVNReader.getString(list, 0))) {
            return null;
        }
        if ("failure".equals(SVNReader.getString(list, 0))) {
            return SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "Authentication error from server: {0}", (Object)SVNReader.getString(list, 1));
        }
        return SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "Unexpected server response to authentication");
    }
}

