/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn;

import java.io.UnsupportedEncodingException;
import java.util.Collection;

public class SVNItem {
    public static final int WORD = 0;
    public static final int BYTES = 1;
    public static final int LIST = 2;
    public static final int NUMBER = 3;
    private int myKind;
    private long myNumber = -1L;
    private String myWord;
    private byte[] myLine;
    private Collection myItems;

    public int getKind() {
        return this.myKind;
    }

    public void setKind(int n2) {
        this.myKind = n2;
    }

    public long getNumber() {
        return this.myNumber;
    }

    public void setNumber(long l2) {
        this.myNumber = l2;
    }

    public String getWord() {
        return this.myWord;
    }

    public void setWord(String string) {
        this.myWord = string;
    }

    public byte[] getBytes() {
        return this.myLine;
    }

    public void setLine(byte[] byArray) {
        this.myLine = byArray;
    }

    public Collection getItems() {
        return this.myItems;
    }

    public void setItems(Collection collection) {
        this.myItems = collection;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.myKind == 0) {
            stringBuffer.append("W").append(this.myWord);
        } else if (this.myKind == 1) {
            stringBuffer.append("S").append(this.myLine.length).append(":");
            try {
                stringBuffer.append(new String(this.myLine, "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                stringBuffer.append(this.myLine);
            }
            stringBuffer.append(" ");
        } else if (this.myKind == 3) {
            stringBuffer.append("N").append(this.myNumber);
        } else if (this.myKind == 2) {
            stringBuffer.append("L(");
            for (SVNItem sVNItem : this.myItems) {
                stringBuffer.append(sVNItem.toString());
                stringBuffer.append(" ");
            }
            stringBuffer.append(") ");
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof String) {
            if (this.myKind == 0) {
                return this.myWord.equals(object);
            }
            if (this.myKind == 1) {
                return this.myLine.equals(object);
            }
            return false;
        }
        if (object instanceof byte[]) {
            if (this.myKind == 0) {
                return this.myWord.getBytes().equals(object);
            }
            if (this.myKind == 1) {
                return this.myLine.equals(object);
            }
            return false;
        }
        if (object instanceof Long) {
            long l2 = (Long)object;
            return this.myKind == 3 && this.myNumber == l2;
        }
        if (object instanceof Integer) {
            long l3 = ((Integer)object).longValue();
            return this.myKind == 3 && this.myNumber == l3;
        }
        if (object instanceof Collection) {
            return this.myKind == 2 && this.myItems.equals(object);
        }
        return super.equals(object);
    }
}

