/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaReader;
import org.tmatesoft.svn.core.internal.io.svn.SVNConnection;
import org.tmatesoft.svn.core.internal.io.svn.SVNItem;
import org.tmatesoft.svn.core.internal.io.svn.SVNReader;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNEditModeReader {
    private static final Map COMMANDS_MAP = new SVNHashMap();
    private SVNConnection myConnection;
    private ISVNEditor myEditor;
    private SVNDeltaReader myDeltaReader;
    private String myFilePath;
    private boolean myDone;
    private boolean myAborted;
    private boolean myForReplay;
    private Map myTokens;

    public SVNEditModeReader(SVNConnection sVNConnection, ISVNEditor iSVNEditor, boolean bl2) {
        this.myConnection = sVNConnection;
        this.myEditor = iSVNEditor;
        this.myDeltaReader = new SVNDeltaReader();
        this.myDone = false;
        this.myAborted = false;
        this.myForReplay = bl2;
        this.myTokens = new SVNHashMap();
    }

    public boolean isAborted() {
        return this.myAborted;
    }

    private void storeToken(String string, boolean bl2) {
        this.myTokens.put(string, bl2);
    }

    private void lookupToken(String string, boolean bl2) {
        Boolean bl3 = (Boolean)this.myTokens.get(string);
        if (bl3 == null || bl3 != Boolean.valueOf(bl2)) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Invalid file or dir token during edit");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
        }
    }

    private void removeToken(String string) {
        this.myTokens.remove(string);
    }

    private void processCommand(String string, List list) {
        if ("target-rev".equals(string)) {
            this.myEditor.targetRevision(SVNReader.getLong(list, 0));
        } else if ("open-root".equals(string)) {
            this.myEditor.openRoot(SVNReader.getLong(list, 0));
            String string2 = SVNReader.getString(list, 1);
            this.storeToken(string2, false);
        } else if ("delete-entry".equals(string)) {
            this.lookupToken(SVNReader.getString(list, 2), false);
            String string3 = SVNPathUtil.canonicalizePath(SVNReader.getString(list, 0));
            this.myEditor.deleteEntry(string3, SVNReader.getLong(list, 1));
        } else if ("add-dir".equals(string)) {
            this.lookupToken(SVNReader.getString(list, 1), false);
            String string4 = SVNPathUtil.canonicalizePath(SVNReader.getString(list, 0));
            String string5 = SVNReader.getString(list, 3);
            if (string5 != null) {
                string5 = SVNPathUtil.canonicalizePath(string5);
            }
            this.myEditor.addDir(string4, string5, SVNReader.getLong(list, 4));
            this.storeToken(SVNReader.getString(list, 2), false);
        } else if ("open-dir".equals(string)) {
            this.lookupToken(SVNReader.getString(list, 1), false);
            String string6 = SVNPathUtil.canonicalizePath(SVNReader.getString(list, 0));
            this.myEditor.openDir(string6, SVNReader.getLong(list, 3));
            this.storeToken(SVNReader.getString(list, 2), false);
        } else if ("change-dir-prop".equals(string)) {
            this.lookupToken(SVNReader.getString(list, 0), false);
            byte[] byArray = SVNReader.getBytes(list, 2);
            String string7 = SVNReader.getString(list, 1);
            this.myEditor.changeDirProperty(string7, SVNPropertyValue.create(string7, byArray));
        } else if ("close-dir".equals(string)) {
            String string8 = SVNReader.getString(list, 0);
            this.lookupToken(string8, false);
            this.myEditor.closeDir();
            this.removeToken(string8);
        } else if ("add-file".equals(string)) {
            this.lookupToken(SVNReader.getString(list, 1), false);
            String string9 = SVNPathUtil.canonicalizePath(SVNReader.getString(list, 0));
            String string10 = SVNReader.getString(list, 3);
            if (string10 != null) {
                string10 = SVNPathUtil.canonicalizePath(string10);
            }
            this.storeToken(SVNReader.getString(list, 2), true);
            this.myEditor.addFile(string9, string10, SVNReader.getLong(list, 4));
            this.myFilePath = string9;
        } else if ("open-file".equals(string)) {
            this.lookupToken(SVNReader.getString(list, 1), false);
            String string11 = SVNPathUtil.canonicalizePath(SVNReader.getString(list, 0));
            this.storeToken(SVNReader.getString(list, 2), true);
            this.myEditor.openFile(SVNReader.getString(list, 0), SVNReader.getLong(list, 3));
            this.myFilePath = string11;
        } else if ("change-file-prop".equals(string)) {
            this.lookupToken(SVNReader.getString(list, 0), true);
            byte[] byArray = SVNReader.getBytes(list, 2);
            String string12 = SVNReader.getString(list, 1);
            this.myEditor.changeFileProperty(this.myFilePath, string12, SVNPropertyValue.create(string12, byArray));
        } else if ("close-file".equals(string)) {
            String string13 = SVNReader.getString(list, 0);
            this.lookupToken(string13, true);
            this.myEditor.closeFile(this.myFilePath, SVNReader.getString(list, 1));
            this.removeToken(string13);
        } else if ("apply-textdelta".equals(string)) {
            this.lookupToken(SVNReader.getString(list, 0), true);
            this.myEditor.applyTextDelta(this.myFilePath, SVNReader.getString(list, 1));
        } else if ("textdelta-chunk".equals(string)) {
            this.lookupToken(SVNReader.getString(list, 0), true);
            byte[] byArray = SVNReader.getBytes(list, 1);
            this.myDeltaReader.nextWindow(byArray, 0, byArray.length, this.myFilePath, this.myEditor);
        } else if ("textdelta-end".equals(string)) {
            this.lookupToken(SVNReader.getString(list, 0), true);
            this.myDeltaReader.reset(this.myFilePath, this.myEditor);
            this.myEditor.textDeltaEnd(this.myFilePath);
        } else if ("close-edit".equals(string)) {
            this.myEditor.closeEdit();
            this.myDone = true;
            this.myAborted = false;
            this.myConnection.write("(w())", new Object[]{"success"});
        } else if ("abort-edit".equals(string)) {
            this.myEditor.abortEdit();
            this.myDone = true;
            this.myAborted = true;
            this.myConnection.write("(w())", new Object[]{"success"});
        } else if ("failure".equals(string)) {
            this.myEditor.abortEdit();
            this.myDone = true;
            this.myAborted = true;
            ArrayList<SVNItem> arrayList = new ArrayList<SVNItem>();
            for (List list2 : list) {
                SVNItem sVNItem = new SVNItem();
                sVNItem.setKind(2);
                sVNItem.setItems(list2);
                arrayList.add(sVNItem);
            }
            SVNReader.handleFailureStatus(arrayList);
        } else if ("absent-dir".equals(string)) {
            this.lookupToken(SVNReader.getString(list, 1), false);
            this.myEditor.absentDir(SVNReader.getString(list, 0));
        } else if ("absent-file".equals(string)) {
            this.lookupToken(SVNReader.getString(list, 1), false);
            this.myEditor.absentFile(SVNReader.getString(list, 0));
        } else if ("finish-replay".equals(string)) {
            if (!this.myForReplay) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_SVN_UNKNOWN_CMD, "Command 'finish-replay' invalid outside of replays");
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
            }
            this.myDone = true;
            this.myAborted = false;
        }
    }

    public void driveEditor() {
        Object object;
        Object object2;
        while (!this.myDone) {
            Object object3;
            object2 = null;
            object = this.readTuple("wl", false);
            String string = SVNReader.getString((List)object, 0);
            String string2 = (String)COMMANDS_MAP.get(string);
            if (string2 == null) {
                object3 = SVNErrorMessage.create(SVNErrorCode.RA_SVN_UNKNOWN_CMD, "Unknown command ''{0}''", (Object)string);
                object2 = SVNErrorMessage.create(SVNErrorCode.RA_SVN_CMD_ERR);
                ((SVNErrorMessage)object2).setChildErrorMessage((SVNErrorMessage)object3);
            }
            if (string2 != null && object.get(1) instanceof Collection) {
                object3 = SVNReader.parseTuple(string2, (Collection)object.get(1), null);
                try {
                    this.processCommand(string, (List)object3);
                }
                catch (SVNException sVNException) {
                    object2 = sVNException.getErrorMessage();
                }
            }
            if (object2 == null) continue;
            if (((SVNErrorMessage)object2).getErrorCode() == SVNErrorCode.RA_SVN_CMD_ERR) {
                this.myAborted = true;
                if (!this.myDone) {
                    try {
                        this.myEditor.abortEdit();
                    }
                    catch (SVNException sVNException) {
                        // empty catch block
                    }
                }
                this.myConnection.writeError(((SVNErrorMessage)object2).getChildErrorMessage());
                break;
            }
            SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.NETWORK);
        }
        while (!this.myDone) {
            object2 = this.readTuple("wl", false);
            object = SVNReader.getString((List)object2, 0);
            this.myDone = "abort-edit".equals(object) || "success".equals(object);
        }
    }

    private List readTuple(String string, boolean bl2) {
        if (this.myConnection == null) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_CONNECTION_CLOSED), SVNLogType.NETWORK);
        }
        return this.myConnection.readTuple(string, bl2);
    }

    static {
        COMMANDS_MAP.put("target-rev", "r");
        COMMANDS_MAP.put("open-root", "(?r)s");
        COMMANDS_MAP.put("delete-entry", "s(?r)s");
        COMMANDS_MAP.put("add-dir", "sss(?sr)");
        COMMANDS_MAP.put("open-dir", "sss(?r)");
        COMMANDS_MAP.put("change-dir-prop", "ss(?b)");
        COMMANDS_MAP.put("close-dir", "s");
        COMMANDS_MAP.put("add-file", "sss(?sr)");
        COMMANDS_MAP.put("open-file", "sss(?r)");
        COMMANDS_MAP.put("apply-textdelta", "s(?s)");
        COMMANDS_MAP.put("textdelta-chunk", "sb");
        COMMANDS_MAP.put("textdelta-end", "s");
        COMMANDS_MAP.put("change-file-prop", "ss(?b)");
        COMMANDS_MAP.put("close-file", "s(?b)");
        COMMANDS_MAP.put("close-edit", "()");
        COMMANDS_MAP.put("abort-edit", "()");
        COMMANDS_MAP.put("finish-replay", "()");
        COMMANDS_MAP.put("absent-dir", "ss");
        COMMANDS_MAP.put("absent-file", "ss");
        COMMANDS_MAP.put("failure", "l");
    }
}

