/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.net.SocketTimeoutException;
import java.util.List;
import java.util.Set;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.BasicAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManagerExt;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaCompression;
import org.tmatesoft.svn.core.internal.io.svn.ISVNConnector;
import org.tmatesoft.svn.core.internal.io.svn.SVNAuthenticator;
import org.tmatesoft.svn.core.internal.io.svn.SVNConnection$1;
import org.tmatesoft.svn.core.internal.io.svn.SVNItem;
import org.tmatesoft.svn.core.internal.io.svn.SVNReader;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryImpl;
import org.tmatesoft.svn.core.internal.io.svn.SVNWriter;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.wc.SVNClassLoader;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNConnection {
    private final ISVNConnector myConnector;
    private String myRealm;
    private String myRoot;
    private OutputStream myOutputStream;
    private InputStream myInputStream;
    private SVNRepositoryImpl myRepository;
    private SVNDeltaCompression myDeltaCompression = SVNDeltaCompression.None;
    private boolean myIsCommitRevprops;
    private boolean myIsReopening = false;
    private boolean myIsCredentialsReceived = false;
    private InputStream myLoggingInputStream;
    private Set myCapabilities;
    private byte[] myHandshakeBuffer = new byte[8192];
    private SVNAuthenticator myEncryptor;
    private SVNAuthentication myAuthentication;
    private static final String EDIT_PIPELINE = "edit-pipeline";
    private static final String SVNDIFF1 = "svndiff1";
    private static final String ACCEPTS_SVNDIFF2 = "accepts-svndiff2";
    private static final String ABSENT_ENTRIES = "absent-entries";
    private static final String COMMIT_REVPROPS = "commit-revprops";
    private static final String MERGE_INFO = "mergeinfo";
    private static final String DEPTH = "depth";
    private static final String LOG_REVPROPS = "log-revprops";

    public SVNConnection(ISVNConnector iSVNConnector, SVNRepositoryImpl sVNRepositoryImpl) {
        this.myConnector = iSVNConnector;
        this.myRepository = sVNRepositoryImpl;
    }

    public void open(SVNRepositoryImpl sVNRepositoryImpl) {
        this.myIsReopening = true;
        try {
            this.myIsCredentialsReceived = false;
            this.myConnector.open(sVNRepositoryImpl);
            this.myRepository = sVNRepositoryImpl;
            try {
                this.handshake(sVNRepositoryImpl);
            }
            catch (SVNException sVNException) {
                this.myConnector.handleExceptionOnOpen(sVNRepositoryImpl, sVNException);
            }
        }
        finally {
            this.myIsReopening = false;
        }
    }

    public String getRealm() {
        return this.myRealm;
    }

    @Deprecated
    public boolean isSVNDiff1() {
        return this.myDeltaCompression == SVNDeltaCompression.Zlib;
    }

    public SVNDeltaCompression getDeltaCompression() {
        return this.myDeltaCompression;
    }

    public boolean isCommitRevprops() {
        return this.myIsCommitRevprops;
    }

    private InputStream skipLeadingGrabage(int n2) {
        SVNErrorMessage sVNErrorMessage;
        byte[] byArray = this.myHandshakeBuffer;
        int n3 = 0;
        try {
            n3 = this.getInputStream().read(byArray);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_SVN_IO_ERROR, "time out reading data", null, 0, socketTimeoutException);
            SVNErrorManager.error(sVNErrorMessage, socketTimeoutException, SVNLogType.NETWORK);
        }
        catch (IOException iOException) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Handshake failed: ''{0}''", (Object)iOException.getMessage());
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
        }
        if (n3 >= 0) {
            for (int i2 = 0; i2 < n3; ++i2) {
                if (byArray[i2] != 40 || byArray[i2 + 1] != 32) continue;
                return new SequenceInputStream(new ByteArrayInputStream(byArray, i2, n3 - i2), this.getInputStream());
            }
        }
        if (n3 >= 0 && n2 == 0) {
            return this.skipLeadingGrabage(n2 + 1);
        }
        if (n3 <= 0) {
            SVNErrorMessage sVNErrorMessage2 = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Handshake failed, data stream ended unexpectedly");
            SVNErrorManager.error(sVNErrorMessage2, SVNLogType.NETWORK);
        }
        SVNErrorMessage sVNErrorMessage3 = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Handshake failed, received: ''{0}''", (Object)new String(byArray, 0, n3));
        SVNErrorManager.error(sVNErrorMessage3, SVNLogType.NETWORK);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handshake(SVNRepositoryImpl sVNRepositoryImpl) {
        this.checkConnection();
        InputStream inputStream = this.skipLeadingGrabage(0);
        List list = null;
        try {
            list = SVNReader.parse(inputStream, "nnll", null);
        }
        finally {
            this.myRepository.getDebugLog().flushStream(this.myLoggingInputStream);
        }
        Long l2 = (Long)list.get(0);
        Long l3 = (Long)list.get(1);
        if (l2 > 2L) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_BAD_VERSION, "Server requires minimum version {0}", (Object)l2), SVNLogType.NETWORK);
        } else if (l3 < 2L) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_BAD_VERSION, "Server requires maximum version {0}", (Object)l3), SVNLogType.NETWORK);
        }
        List list2 = (List)list.get(3);
        this.addCapabilities(list2);
        if (!this.hasCapability(EDIT_PIPELINE)) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_BAD_VERSION, "Server does not support edit pipelining"), SVNLogType.NETWORK);
        }
        if (SVNReader.hasValue(list, 3, ACCEPTS_SVNDIFF2)) {
            this.myDeltaCompression = SVNDeltaCompression.LZ4;
        } else if (SVNReader.hasValue(list, 3, SVNDIFF1)) {
            this.myDeltaCompression = SVNDeltaCompression.Zlib;
        }
        this.myIsCommitRevprops = SVNReader.hasValue(list, 3, COMMIT_REVPROPS);
        this.write("(n(wwwwwww)s)", new Object[]{"2", EDIT_PIPELINE, SVNDIFF1, ACCEPTS_SVNDIFF2, ABSENT_ENTRIES, DEPTH, MERGE_INFO, LOG_REVPROPS, sVNRepositoryImpl.getLocation().toString()});
    }

    protected boolean hasCapability(String string) {
        if (this.myCapabilities != null) {
            return this.myCapabilities.contains(string);
        }
        return false;
    }

    public void authenticate(SVNRepositoryImpl sVNRepositoryImpl) {
        List list;
        ISVNAuthenticationManager iSVNAuthenticationManager = this.myRepository.getAuthenticationManager();
        try {
            list = this.read("ls", null, true);
        }
        catch (SVNException sVNException) {
            SVNErrorMessage sVNErrorMessage = sVNException.getErrorMessage();
            if (sVNErrorMessage != null && sVNErrorMessage.getErrorCode() == SVNErrorCode.RA_NOT_AUTHORIZED && iSVNAuthenticationManager != null && this.myAuthentication != null) {
                BasicAuthenticationManager.acknowledgeAuthentication(false, "svn.simple", this.myRealm, sVNErrorMessage, this.myAuthentication, sVNRepositoryImpl.getLocation(), iSVNAuthenticationManager);
            }
            throw sVNException;
        }
        List list2 = SVNReader.getList(list, 0);
        if (list2 == null || list2.size() == 0) {
            if (iSVNAuthenticationManager instanceof ISVNAuthenticationManagerExt) {
                ((ISVNAuthenticationManagerExt)iSVNAuthenticationManager).acknowledgeConnectionSuccessful(this.myRepository.getLocation(), "");
            }
            return;
        }
        this.myRealm = SVNReader.getString(list, 1);
        if (iSVNAuthenticationManager != null && iSVNAuthenticationManager.isAuthenticationForced() && list2.contains("ANONYMOUS") && (list2.contains("CRAM-MD5") || list2.contains("DIGEST-MD5"))) {
            list2.remove("ANONYMOUS");
        }
        SVNAuthenticator sVNAuthenticator = this.createSASLAuthenticator();
        this.myAuthentication = sVNAuthenticator.authenticate(list2, this.myRealm, sVNRepositoryImpl);
        this.receiveRepositoryCredentials(sVNRepositoryImpl);
        if (iSVNAuthenticationManager instanceof ISVNAuthenticationManagerExt) {
            ((ISVNAuthenticationManagerExt)iSVNAuthenticationManager).acknowledgeConnectionSuccessful(this.myRepository.getLocation(), "");
        }
    }

    private SVNAuthenticator createSASLAuthenticator() {
        return SVNClassLoader.getSASLAuthenticator(this);
    }

    private void addCapabilities(List list) {
        if (this.myCapabilities == null) {
            this.myCapabilities = new SVNHashSet();
        }
        if (list == null || list.isEmpty()) {
            return;
        }
        for (SVNItem sVNItem : list) {
            if (sVNItem.getKind() != 0) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Capability entry is not a word");
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
            }
            this.myCapabilities.add(sVNItem.getWord());
        }
    }

    private void receiveRepositoryCredentials(SVNRepositoryImpl sVNRepositoryImpl) {
        if (this.myIsCredentialsReceived) {
            return;
        }
        List list = this.read("s?s?l", null, true);
        this.myIsCredentialsReceived = true;
        if (list != null && list.size() >= 2 && list.get(0) != null && list.get(1) != null) {
            SVNURL sVNURL;
            SVNURL sVNURL2 = sVNURL = list.get(1) != null ? SVNURL.parseURIEncoded(SVNReader.getString(list, 1)) : null;
            if (sVNURL != null && sVNURL.toString().length() > sVNRepositoryImpl.getLocation().toString().length()) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Impossibly long repository root from server"), SVNLogType.NETWORK);
            }
            if (sVNRepositoryImpl != null && sVNRepositoryImpl.getRepositoryRoot(false) == null) {
                sVNRepositoryImpl.updateCredentials(SVNReader.getString(list, 0), sVNURL);
            }
            if (this.myRealm == null) {
                this.myRealm = SVNReader.getString(list, 0);
            }
            if (this.myRoot == null) {
                this.myRoot = SVNReader.getString(list, 1);
            }
            if (list.size() > 2 && list.get(2) instanceof List) {
                List list2 = (List)list.get(2);
                this.addCapabilities(list2);
            }
        }
    }

    public void setEncrypted(SVNAuthenticator sVNAuthenticator) {
        this.myEncryptor = sVNAuthenticator;
    }

    public boolean isEncrypted() {
        return this.myEncryptor != null;
    }

    public void close() {
        if (this.myEncryptor != null) {
            this.myEncryptor.dispose();
            this.myEncryptor = null;
        }
        this.myInputStream = null;
        this.myLoggingInputStream = null;
        this.myOutputStream = null;
        this.myConnector.close(this.myRepository);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List read(String string, List list, boolean bl2) {
        try {
            this.checkConnection();
            List list2 = SVNReader.parse(this.getInputStream(), string, list);
            return list2;
        }
        catch (SVNException sVNException) {
            this.handleIOError(sVNException, bl2);
            List list3 = null;
            return list3;
        }
        finally {
            this.myRepository.getDebugLog().flushStream(this.myLoggingInputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List readTuple(String string, boolean bl2) {
        try {
            this.checkConnection();
            List list = SVNReader.readTuple(this.getInputStream(), string);
            return list;
        }
        catch (SVNException sVNException) {
            this.handleIOError(sVNException, bl2);
            List list = null;
            return list;
        }
        finally {
            this.myRepository.getDebugLog().flushStream(this.myLoggingInputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNItem readItem(boolean bl2) {
        try {
            this.checkConnection();
            SVNItem sVNItem = SVNReader.readItem(this.getInputStream());
            return sVNItem;
        }
        catch (SVNException sVNException) {
            this.handleIOError(sVNException, bl2);
            SVNItem sVNItem = null;
            return sVNItem;
        }
        finally {
            this.myRepository.getDebugLog().flushStream(this.myLoggingInputStream);
        }
    }

    private void handleIOError(SVNException sVNException, boolean bl2) {
        if (bl2 && sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.RA_SVN_MALFORMED_DATA) {
            byte[] byArray = new byte[1024];
            try {
                this.getInputStream().read(byArray);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        throw sVNException;
    }

    public void writeError(SVNErrorMessage sVNErrorMessage) {
        Object[] objectArray = new Object[]{"failure"};
        this.write("(w(", objectArray);
        while (sVNErrorMessage != null) {
            String string = sVNErrorMessage.getMessage() == null ? "" : sVNErrorMessage.getMessage();
            objectArray = new Object[]{(long)sVNErrorMessage.getErrorCode().getCode(), string, "", 0};
            this.write("(nssn)", objectArray);
            sVNErrorMessage = sVNErrorMessage.getChildErrorMessage();
        }
        this.write(")", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String string, Object[] objectArray) {
        try {
            SVNWriter.write(this.getOutputStream(), string, objectArray);
        }
        finally {
            try {
                this.getOutputStream().flush();
            }
            catch (IOException iOException) {
            }
            catch (SVNException sVNException) {}
            this.myRepository.getDebugLog().flushStream(this.getOutputStream());
        }
    }

    public boolean isConnectionStale() {
        return this.myConnector.isStale();
    }

    private void checkConnection() {
        if (!this.myIsReopening && !this.myConnector.isConnected(this.myRepository)) {
            this.myIsReopening = true;
            try {
                this.close();
                this.open(this.myRepository);
            }
            finally {
                this.myIsReopening = false;
            }
        }
    }

    public OutputStream getDeltaStream(String string) {
        return new SVNConnection$1(this, string);
    }

    OutputStream getOutputStream() {
        if (this.myOutputStream == null) {
            try {
                this.myOutputStream = this.myRepository.getDebugLog().createLogStream(SVNLogType.NETWORK, this.myConnector.getOutputStream());
            }
            catch (IOException iOException) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_IO_ERROR, iOException.getMessage()), iOException, SVNLogType.NETWORK);
            }
        }
        return this.myOutputStream;
    }

    InputStream getInputStream() {
        if (this.myInputStream == null) {
            try {
                InputStream inputStream = this.myConnector.getInputStream();
                this.myLoggingInputStream = this.myInputStream = this.myRepository.getDebugLog().createLogStream(SVNLogType.NETWORK, inputStream);
            }
            catch (IOException iOException) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_IO_ERROR, iOException.getMessage()), iOException, SVNLogType.NETWORK);
            }
        }
        return this.myInputStream;
    }

    void setOutputStream(OutputStream outputStream) {
        if (this.myOutputStream != null) {
            this.myRepository.getDebugLog().flushStream(this.myOutputStream);
        }
        this.myOutputStream = outputStream;
    }

    void setInputStream(InputStream inputStream) {
        if (this.myLoggingInputStream != null) {
            this.myRepository.getDebugLog().flushStream(this.myLoggingInputStream);
        }
        this.myInputStream = inputStream;
        this.myLoggingInputStream = inputStream;
    }

    ISVNConnector getConnector() {
        return this.myConnector;
    }
}

