/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.io.svn.SVNCommitEditor$DirBaton;
import org.tmatesoft.svn.core.internal.io.svn.SVNCommitEditor$ISVNCommitCallback;
import org.tmatesoft.svn.core.internal.io.svn.SVNConnection;
import org.tmatesoft.svn.core.internal.io.svn.SVNReader;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryImpl;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.util.SVNLogType;

class SVNCommitEditor
implements ISVNEditor {
    private SVNConnection myConnection;
    private SVNRepositoryImpl myRepository;
    private SVNCommitEditor$ISVNCommitCallback myCloseCallback;
    private Stack myDirsStack;
    private int myNextToken;
    private Map myFilesToTokens;
    private int myDiffWindowCount = 0;
    private boolean myIsAborted;

    public SVNCommitEditor(SVNRepositoryImpl sVNRepositoryImpl, SVNConnection sVNConnection, SVNCommitEditor$ISVNCommitCallback sVNCommitEditor$ISVNCommitCallback) {
        this.myRepository = sVNRepositoryImpl;
        this.myConnection = sVNConnection;
        this.myCloseCallback = sVNCommitEditor$ISVNCommitCallback;
        this.myDirsStack = new Stack();
        this.myNextToken = 0;
    }

    @Override
    public void targetRevision(long l2) {
    }

    @Override
    public void absentDir(String string) {
    }

    @Override
    public void absentFile(String string) {
    }

    @Override
    public void openRoot(long l2) {
        SVNCommitEditor$DirBaton sVNCommitEditor$DirBaton = new SVNCommitEditor$DirBaton(this.myNextToken++);
        this.myConnection.write("(w((n)s))", new Object[]{"open-root", SVNCommitEditor.getRevisionObject(l2), sVNCommitEditor$DirBaton.getToken()});
        this.myDirsStack.push(sVNCommitEditor$DirBaton);
    }

    @Override
    public void deleteEntry(String string, long l2) {
        SVNCommitEditor$DirBaton sVNCommitEditor$DirBaton = (SVNCommitEditor$DirBaton)this.myDirsStack.peek();
        this.myConnection.write("(w(s(n)s))", new Object[]{"delete-entry", string, SVNCommitEditor.getRevisionObject(l2), sVNCommitEditor$DirBaton.getToken()});
    }

    @Override
    public void addDir(String string, String string2, long l2) {
        SVNCommitEditor$DirBaton sVNCommitEditor$DirBaton = (SVNCommitEditor$DirBaton)this.myDirsStack.peek();
        SVNCommitEditor$DirBaton sVNCommitEditor$DirBaton2 = new SVNCommitEditor$DirBaton(this.myNextToken++);
        if (string2 != null) {
            Object object;
            if (!SVNRevision.isValidRevisionNumber(l2)) {
                object = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Got source path but no source revision for ''{0}''", (Object)string);
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.NETWORK);
            }
            object = this.myRepository.getRepositoryRoot(false).toString();
            string2 = SVNPathUtil.append((String)object, SVNEncodingUtil.uriEncode(this.myRepository.getRepositoryPath(string2)));
            this.myConnection.write("(w(sss(sn)))", new Object[]{"add-dir", string, sVNCommitEditor$DirBaton.getToken(), sVNCommitEditor$DirBaton2.getToken(), string2, SVNCommitEditor.getRevisionObject(l2)});
        } else {
            this.myConnection.write("(w(sss()))", new Object[]{"add-dir", string, sVNCommitEditor$DirBaton.getToken(), sVNCommitEditor$DirBaton2.getToken()});
        }
        this.myDirsStack.push(sVNCommitEditor$DirBaton2);
    }

    @Override
    public void openDir(String string, long l2) {
        SVNCommitEditor$DirBaton sVNCommitEditor$DirBaton = (SVNCommitEditor$DirBaton)this.myDirsStack.peek();
        SVNCommitEditor$DirBaton sVNCommitEditor$DirBaton2 = new SVNCommitEditor$DirBaton(this.myNextToken++);
        this.myConnection.write("(w(sss(n)))", new Object[]{"open-dir", string, sVNCommitEditor$DirBaton.getToken(), sVNCommitEditor$DirBaton2.getToken(), SVNCommitEditor.getRevisionObject(l2)});
        this.myDirsStack.push(sVNCommitEditor$DirBaton2);
    }

    @Override
    public void changeDirProperty(String string, SVNPropertyValue sVNPropertyValue) {
        SVNCommitEditor$DirBaton sVNCommitEditor$DirBaton = (SVNCommitEditor$DirBaton)this.myDirsStack.peek();
        byte[] byArray = SVNPropertyValue.getPropertyAsBytes(sVNPropertyValue);
        this.myConnection.write("(w(ss(b)))", new Object[]{"change-dir-prop", sVNCommitEditor$DirBaton.getToken(), string, byArray});
    }

    @Override
    public void closeDir() {
        SVNCommitEditor$DirBaton sVNCommitEditor$DirBaton = (SVNCommitEditor$DirBaton)this.myDirsStack.pop();
        this.myConnection.write("(w(s))", new Object[]{"close-dir", sVNCommitEditor$DirBaton.getToken()});
    }

    @Override
    public void addFile(String string, String string2, long l2) {
        SVNCommitEditor$DirBaton sVNCommitEditor$DirBaton = (SVNCommitEditor$DirBaton)this.myDirsStack.peek();
        String string3 = "c" + this.myNextToken++;
        if (string2 != null) {
            String string4 = this.myRepository.getRepositoryRoot(false).toString();
            string2 = SVNPathUtil.append(string4, SVNEncodingUtil.uriEncode(this.myRepository.getRepositoryPath(string2)));
            this.myConnection.write("(w(sss(sn)))", new Object[]{"add-file", string, sVNCommitEditor$DirBaton.getToken(), string3, string2, SVNCommitEditor.getRevisionObject(l2)});
        } else {
            this.myConnection.write("(w(sss()))", new Object[]{"add-file", string, sVNCommitEditor$DirBaton.getToken(), string3});
        }
        if (this.myFilesToTokens == null) {
            this.myFilesToTokens = new SVNHashMap();
        }
        this.myFilesToTokens.put(string, string3);
    }

    @Override
    public void openFile(String string, long l2) {
        SVNCommitEditor$DirBaton sVNCommitEditor$DirBaton = (SVNCommitEditor$DirBaton)this.myDirsStack.peek();
        String string2 = "c" + this.myNextToken++;
        this.myConnection.write("(w(sss(n)))", new Object[]{"open-file", string, sVNCommitEditor$DirBaton.getToken(), string2, SVNCommitEditor.getRevisionObject(l2)});
        if (this.myFilesToTokens == null) {
            this.myFilesToTokens = new SVNHashMap();
        }
        this.myFilesToTokens.put(string, string2);
    }

    @Override
    public void applyTextDelta(String string, String string2) {
        String string3 = (String)this.myFilesToTokens.get(string);
        this.myDiffWindowCount = 0;
        this.myConnection.write("(w(s(s)))", new Object[]{"apply-textdelta", string3, string2});
    }

    @Override
    public OutputStream textDeltaChunk(String string, SVNDiffWindow sVNDiffWindow) {
        String string2 = (String)this.myFilesToTokens.get(string);
        try {
            sVNDiffWindow.writeTo(this.myConnection.getDeltaStream(string2), this.myDiffWindowCount == 0, this.myConnection.getDeltaCompression());
            ++this.myDiffWindowCount;
            return SVNFileUtil.DUMMY_OUT;
        }
        catch (IOException iOException) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_IO_ERROR, iOException.getMessage()), iOException, SVNLogType.NETWORK);
            return null;
        }
    }

    @Override
    public void textDeltaEnd(String string) {
        String string2 = (String)this.myFilesToTokens.get(string);
        this.myDiffWindowCount = 0;
        this.myConnection.write("(w(s))", new Object[]{"textdelta-end", string2});
    }

    @Override
    public void changeFileProperty(String string, String string2, SVNPropertyValue sVNPropertyValue) {
        String string3 = (String)this.myFilesToTokens.get(string);
        byte[] byArray = SVNPropertyValue.getPropertyAsBytes(sVNPropertyValue);
        this.myConnection.write("(w(ss(b)))", new Object[]{"change-file-prop", string3, string2, byArray});
    }

    @Override
    public void closeFile(String string, String string2) {
        String string3 = (String)this.myFilesToTokens.remove(string);
        this.myDiffWindowCount = 0;
        this.myConnection.write("(w(s(s)))", new Object[]{"close-file", string3, string2});
    }

    @Override
    public SVNCommitInfo closeEdit() {
        SVNException sVNException = null;
        try {
            this.myConnection.write("(w())", new Object[]{"close-edit"});
            this.myConnection.read("", null, true);
            this.myRepository.authenticate();
            List list = this.myConnection.readTuple("r(?s)(?s)?(?s)", true);
            long l2 = SVNReader.getLong(list, 0);
            Date date = SVNReader.getDate(list, 1);
            String string = SVNReader.getString(list, 2);
            String string2 = SVNReader.getString(list, 3);
            SVNErrorMessage sVNErrorMessage = string2 == null || string2.length() == 0 ? null : SVNErrorMessage.create(SVNErrorCode.REPOS_POST_COMMIT_HOOK_FAILED, string2, 1);
            SVNCommitInfo sVNCommitInfo = new SVNCommitInfo(l2, string, date, sVNErrorMessage);
            return sVNCommitInfo;
        }
        catch (SVNException sVNException2) {
            sVNException = sVNException2;
            try {
                this.myConnection.write("(w())", new Object[]{"abort-edit"});
            }
            catch (SVNException sVNException3) {
                // empty catch block
            }
            throw sVNException2;
        }
        finally {
            this.myCloseCallback.run(sVNException);
            this.myCloseCallback = null;
        }
    }

    @Override
    public void abortEdit() {
        if (this.myIsAborted || this.myCloseCallback == null) {
            return;
        }
        this.myIsAborted = true;
        SVNException sVNException = null;
        try {
            this.myConnection.write("(w())", new Object[]{"abort-edit"});
            this.myConnection.read("", null, true);
        }
        catch (SVNException sVNException2) {
            sVNException = sVNException2;
            throw sVNException2;
        }
        finally {
            this.myCloseCallback.run(sVNException);
            this.myCloseCallback = null;
        }
    }

    private static Long getRevisionObject(long l2) {
        return l2 >= 0L ? Long.valueOf(l2) : null;
    }
}

