/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.internal.io.svn.SVNConnection;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryImpl;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;

public abstract class SVNAuthenticator {
    protected static final String SUCCESS = "success";
    protected static final String FAILURE = "failure";
    protected static final String STEP = "step";
    private SVNConnection myConnection;
    private OutputStream myConnectionOutputStream;
    private InputStream myConnectionInputStream;
    private SVNErrorMessage myLastError;
    private InputStream myPlainInputStream;
    private OutputStream myPlainOutputStream;

    protected SVNAuthenticator(SVNConnection sVNConnection) {
        this.myConnection = sVNConnection;
        this.myConnectionInputStream = sVNConnection.getInputStream();
        this.myConnectionOutputStream = sVNConnection.getOutputStream();
        try {
            this.myPlainInputStream = sVNConnection.getConnector().getInputStream();
            this.myPlainOutputStream = sVNConnection.getConnector().getOutputStream();
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getMessage());
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
        }
    }

    protected void setOutputStream(OutputStream outputStream) {
        this.myConnection.setOutputStream(outputStream);
    }

    protected void setInputStream(InputStream inputStream) {
        this.myConnection.setInputStream(inputStream);
    }

    protected InputStream getConnectionInputStream() {
        return this.myConnectionInputStream;
    }

    protected OutputStream getConnectionOutputStream() {
        return this.myConnectionOutputStream;
    }

    protected InputStream getPlainInputStream() {
        return this.myPlainInputStream;
    }

    protected OutputStream getPlainOutputStream() {
        return this.myPlainOutputStream;
    }

    protected SVNConnection getConnection() {
        return this.myConnection;
    }

    protected SVNErrorMessage getLastError() {
        return this.myLastError;
    }

    public void dispose() {
    }

    protected void setLastError(SVNErrorMessage sVNErrorMessage) {
        this.myLastError = sVNErrorMessage;
    }

    public abstract SVNAuthentication authenticate(List var1, String var2, SVNRepositoryImpl var3);
}

