/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.svn.ISVNConnector;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryImpl;
import org.tmatesoft.svn.core.internal.io.svn.StreamLogger;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNLogType;

public abstract class SVNAbstractTunnelConnector
implements ISVNConnector {
    private OutputStream myOutputStream;
    private InputStream myInputStream;
    private Process myProcess;
    private StreamLogger stderrConsumer;

    public void open(SVNRepositoryImpl sVNRepositoryImpl, String string) {
        try {
            this.myProcess = Runtime.getRuntime().exec(string);
            this.myInputStream = new BufferedInputStream(this.myProcess.getInputStream());
            this.myOutputStream = new BufferedOutputStream(this.myProcess.getOutputStream());
            this.stderrConsumer = StreamLogger.consume(this.myProcess.getErrorStream());
        }
        catch (IOException iOException) {
            try {
                this.close(sVNRepositoryImpl);
            }
            catch (SVNException sVNException) {
                // empty catch block
            }
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.EXTERNAL_PROGRAM, "Cannot create tunnel: ''{0}''", (Object)iOException.getMessage());
            SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.NETWORK);
        }
    }

    public void open(SVNRepositoryImpl sVNRepositoryImpl, String[] stringArray) {
        try {
            this.myProcess = Runtime.getRuntime().exec(stringArray);
            this.myInputStream = new BufferedInputStream(this.myProcess.getInputStream());
            this.myOutputStream = new BufferedOutputStream(this.myProcess.getOutputStream());
            this.stderrConsumer = StreamLogger.consume(this.myProcess.getErrorStream());
        }
        catch (IOException iOException) {
            try {
                this.close(sVNRepositoryImpl);
            }
            catch (SVNException sVNException) {
                // empty catch block
            }
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.EXTERNAL_PROGRAM, "Cannot create tunnel: ''{0}''", (Object)iOException.getMessage());
            SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.NETWORK);
        }
    }

    @Override
    public InputStream getInputStream() {
        return this.myInputStream;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.myOutputStream;
    }

    @Override
    public boolean isConnected(SVNRepositoryImpl sVNRepositoryImpl) {
        return this.myInputStream != null;
    }

    @Override
    public boolean isStale() {
        return false;
    }

    @Override
    public void close(SVNRepositoryImpl sVNRepositoryImpl) {
        if (this.stderrConsumer != null) {
            this.stderrConsumer.close();
            this.stderrConsumer = null;
        }
        if (this.myProcess != null) {
            if (this.myInputStream != null) {
                sVNRepositoryImpl.getDebugLog().flushStream(this.myInputStream);
                SVNFileUtil.closeFile(this.myInputStream);
            }
            if (this.myOutputStream != null) {
                sVNRepositoryImpl.getDebugLog().flushStream(this.myOutputStream);
                SVNFileUtil.closeFile(this.myOutputStream);
            }
            this.myProcess.destroy();
            this.myInputStream = null;
            this.myOutputStream = null;
            this.myProcess = null;
        }
    }

    public void free() {
    }

    public boolean occupy() {
        return true;
    }
}

