/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs.revprop;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.internal.io.fs.FSFile;
import org.tmatesoft.svn.core.internal.io.fs.revprop.SVNFSFSPackedRevProps$1;
import org.tmatesoft.svn.core.internal.io.fs.revprop.SVNFSFSPackedRevProps$Entry;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNWCProperties;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNFSFSPackedRevProps {
    public static final int INT64_BUFFER_SIZE = 21;
    private final long firstRevision;
    private final List entries;
    private byte[] cachedUncompressedByteArray;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SVNFSFSPackedRevProps fromPackFile(File file) {
        byte[] byArray = new byte[(int)file.length()];
        InputStream inputStream = null;
        try {
            Object object;
            inputStream = SVNFileUtil.openFileForReading(file);
            int n2 = SVNFileUtil.readIntoBuffer(inputStream, byArray, 0, byArray.length);
            if (n2 != byArray.length) {
                object = SVNErrorMessage.create(SVNErrorCode.STREAM_UNEXPECTED_EOF);
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
            }
            object = SVNFSFSPackedRevProps.fromCompressedByteArray(byArray);
            return object;
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR);
            SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.FSFS);
        }
        finally {
            SVNFileUtil.closeFile(inputStream);
        }
        return null;
    }

    public static SVNFSFSPackedRevProps fromCompressedByteArray(byte[] byArray) {
        byte[] byArray2 = SVNFSFSPackedRevProps.decompress(byArray);
        return SVNFSFSPackedRevProps.fromUncompressedByteArray(byArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SVNFSFSPackedRevProps fromUncompressedByteArray(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            Object object;
            long l2 = SVNFSFSPackedRevProps.readNumber(byteArrayInputStream);
            long l3 = SVNFSFSPackedRevProps.readNumber(byteArrayInputStream);
            int n2 = 0;
            ArrayList<SVNFSFSPackedRevProps$Entry> arrayList = new ArrayList<SVNFSFSPackedRevProps$Entry>((int)l3);
            int n3 = 0;
            while ((long)n3 < l3) {
                object = new SVNFSFSPackedRevProps$Entry(byArray, n2, (int)SVNFSFSPackedRevProps.readNumber(byteArrayInputStream));
                arrayList.add((SVNFSFSPackedRevProps$Entry)object);
                n2 += SVNFSFSPackedRevProps$Entry.access$100((SVNFSFSPackedRevProps$Entry)object);
                ++n3;
            }
            if (byteArrayInputStream.read() != 10) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Header end not found");
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
            n3 = byArray.length - byteArrayInputStream.available();
            object = arrayList.iterator();
            while (object.hasNext()) {
                SVNFSFSPackedRevProps$Entry sVNFSFSPackedRevProps$Entry;
                SVNFSFSPackedRevProps$Entry sVNFSFSPackedRevProps$Entry2 = sVNFSFSPackedRevProps$Entry = (SVNFSFSPackedRevProps$Entry)object.next();
                SVNFSFSPackedRevProps$Entry.access$202(sVNFSFSPackedRevProps$Entry2, SVNFSFSPackedRevProps$Entry.access$200(sVNFSFSPackedRevProps$Entry2) + n3);
            }
            object = new SVNFSFSPackedRevProps(l2, arrayList, byArray);
            return object;
        }
        finally {
            SVNFileUtil.closeFile(byteArrayInputStream);
        }
    }

    private SVNFSFSPackedRevProps(long l2, List list, byte[] byArray) {
        this.firstRevision = l2;
        this.entries = list;
        this.cachedUncompressedByteArray = byArray;
    }

    public long getFirstRevision() {
        return this.firstRevision;
    }

    public long getRevisionsCount() {
        return this.entries.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] asCompressedLevelNoneByteArray() {
        ByteArrayOutputStream byteArrayOutputStream;
        OutputStream outputStream = byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            outputStream = this.writeCompressedLevelNone(byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        finally {
            SVNFileUtil.closeFile(outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToFile(File file, boolean bl2) {
        OutputStream outputStream = SVNFileUtil.openFileForWriting(file);
        try {
            outputStream = bl2 ? this.writeCompressedLevelDefault(outputStream) : this.writeCompressedLevelNone(outputStream);
        }
        finally {
            SVNFileUtil.closeFile(outputStream);
        }
    }

    private OutputStream writeCompressedLevelDefault(OutputStream outputStream) {
        return this.compressLevelDefault(this.asUncompressedByteArray(), outputStream);
    }

    private OutputStream writeCompressedLevelNone(OutputStream outputStream) {
        return SVNFSFSPackedRevProps.compressLevelNone(this.asUncompressedByteArray(), outputStream);
    }

    public SVNProperties parseProperties(long l2) {
        int n2 = (int)(l2 - this.getFirstRevision());
        if ((long)n2 >= this.getRevisionsCount()) {
            return null;
        }
        SVNFSFSPackedRevProps$Entry sVNFSFSPackedRevProps$Entry = (SVNFSFSPackedRevProps$Entry)this.entries.get(n2);
        return this.parseProperties(SVNFSFSPackedRevProps$Entry.access$300(sVNFSFSPackedRevProps$Entry), SVNFSFSPackedRevProps$Entry.access$200(sVNFSFSPackedRevProps$Entry), SVNFSFSPackedRevProps$Entry.access$100(sVNFSFSPackedRevProps$Entry));
    }

    private long getTotalSize() {
        long l2 = 0L;
        for (SVNFSFSPackedRevProps$Entry sVNFSFSPackedRevProps$Entry : this.entries) {
            l2 += sVNFSFSPackedRevProps$Entry.getSize();
        }
        return l2;
    }

    private long getSerializedSize() {
        return this.asUncompressedByteArray().length;
    }

    public List setProperties(long l2, SVNProperties sVNProperties, long l3) {
        byte[] byArray = SVNFSFSPackedRevProps.composePropertiesByteArray(sVNProperties);
        long l4 = l2 - this.getFirstRevision();
        long l5 = this.getTotalSize() - this.getSerializedSize() + (long)byArray.length + (this.getRevisionsCount() + 2L) * 21L;
        this.setEntry(l2, byArray);
        if (l5 < l3 || this.entries.size() == 1) {
            return Collections.singletonList(this);
        }
        ArrayList<SVNFSFSPackedRevProps> arrayList = new ArrayList<SVNFSFSPackedRevProps>();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = (int)this.getRevisionsCount() - 1;
        long l6 = 42L;
        long l7 = 42L;
        while (n4 <= n5) {
            SVNFSFSPackedRevProps$Entry sVNFSFSPackedRevProps$Entry = (SVNFSFSPackedRevProps$Entry)this.entries.get(n4);
            SVNFSFSPackedRevProps$Entry sVNFSFSPackedRevProps$Entry2 = (SVNFSFSPackedRevProps$Entry)this.entries.get(n5);
            if (l6 + sVNFSFSPackedRevProps$Entry.getSize() < l7 + sVNFSFSPackedRevProps$Entry2.getSize()) {
                l6 += sVNFSFSPackedRevProps$Entry.getSize();
                ++n4;
                continue;
            }
            l7 += sVNFSFSPackedRevProps$Entry2.getSize();
            --n5;
        }
        n2 = n4;
        n3 = (int)(this.getRevisionsCount() - (long)n4);
        if (l6 > l3 || l7 > l3) {
            n2 = (int)l4;
            n3 = (int)(this.getRevisionsCount() - (long)n2 - 1L);
        }
        if (n2 != 0) {
            long l8 = this.getFirstRevision();
            arrayList.add(new SVNFSFSPackedRevProps(l8, this.entries.subList(0, n2), null));
        }
        if ((long)(n2 + n3) < this.getRevisionsCount()) {
            long l9 = l2;
            arrayList.add(new SVNFSFSPackedRevProps(l9, Collections.singletonList(this.entries.get((int)l4)), null));
        }
        if (n3 != 0) {
            long l10 = this.getRevisionsCount() - (long)n3 + this.getFirstRevision();
            arrayList.add(new SVNFSFSPackedRevProps(l10, this.entries.subList((int)(this.getRevisionsCount() - (long)n3), (int)this.getRevisionsCount()), null));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] decompress(byte[] byArray) {
        byte[] byArray2;
        InputStream inputStream;
        ByteArrayOutputStream byteArrayOutputStream;
        block10: {
            byte[] byArray3;
            block9: {
                byteArrayOutputStream = null;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                inputStream = byteArrayInputStream;
                try {
                    long l2 = SVNFSFSPackedRevProps.readEncodedUncompressedSize(byteArrayInputStream, 10);
                    if (l2 == (long)byteArrayInputStream.available()) {
                        byArray3 = SVNFSFSPackedRevProps.arrayCopyOfRange(byArray, (int)((long)byArray.length - l2), (int)l2);
                        SVNFileUtil.closeFile(inputStream);
                        break block9;
                    }
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    inputStream = new InflaterInputStream(inputStream);
                    byte[] byArray4 = new byte[2048];
                    while (true) {
                        int n2;
                        if ((n2 = inputStream.read(byArray4)) < 0) {
                            byArray2 = byteArrayOutputStream.toByteArray();
                            SVNFileUtil.closeFile(inputStream);
                            break block10;
                        }
                        byteArrayOutputStream.write(byArray4, 0, n2);
                    }
                }
                catch (IOException iOException) {
                    SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR);
                    SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.FSFS);
                    return null;
                }
            }
            SVNFileUtil.closeFile(byteArrayOutputStream);
            return byArray3;
        }
        SVNFileUtil.closeFile(byteArrayOutputStream);
        return byArray2;
        finally {
            SVNFileUtil.closeFile(inputStream);
            SVNFileUtil.closeFile(byteArrayOutputStream);
        }
    }

    private static byte[] arrayCopyOfRange(byte[] byArray, int n2, int n3) {
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        return byArray2;
    }

    protected static OutputStream compressLevelNone(byte[] byArray, OutputStream outputStream) {
        SVNFSFSPackedRevProps.writeEncodedUnCompressedSize(byArray.length, outputStream);
        SVNFSFSPackedRevProps.writeBody(byArray, outputStream);
        return outputStream;
    }

    private OutputStream compressLevelDefault(byte[] byArray, OutputStream outputStream) {
        SVNFSFSPackedRevProps.writeEncodedUnCompressedSize(byArray.length, outputStream);
        outputStream = new DeflaterOutputStream(outputStream);
        SVNFSFSPackedRevProps.writeBody(byArray, outputStream);
        return outputStream;
    }

    private static void writeBody(byte[] byArray, OutputStream outputStream) {
        try {
            outputStream.write(byArray);
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR);
            SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.FSFS);
        }
    }

    private static void writeEncodedUnCompressedSize(int n2, OutputStream outputStream) {
        long l2 = n2 >> 7;
        int n3 = 1;
        while (l2 > 0L) {
            l2 >>= 7;
            ++n3;
        }
        while (--n3 >= 0) {
            byte by = (byte)((n3 > 0 ? 1 : 0) << 7);
            byte by2 = (byte)(n2 >> n3 * 7 & 0x7F | by);
            try {
                outputStream.write(by2);
            }
            catch (IOException iOException) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR);
                SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.FSFS);
            }
        }
    }

    private static long readEncodedUncompressedSize(InputStream inputStream, int n2) {
        int n3;
        int n4 = 0;
        int n5 = 0;
        do {
            if (n2 == n5) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.SVNDIFF_INVALID_HEADER, "Decompression of svndiff data failed: size too large");
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
            n3 = 0;
            try {
                n3 = inputStream.read();
            }
            catch (IOException iOException) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR);
                SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.FSFS);
            }
            if (n3 < 0) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.SVNDIFF_UNEXPECTED_END, "Decompression of svndiff data failed: no size");
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
            ++n5;
            n4 = n4 << 7 | n3 & 0x7F;
        } while (n3 >= 128);
        return n4;
    }

    private byte[] asUncompressedByteArray() {
        if (this.cachedUncompressedByteArray == null) {
            this.cachedUncompressedByteArray = this.toUncompressedByteArray();
        }
        return this.cachedUncompressedByteArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SVNProperties parseProperties(byte[] byArray, int n2, int n3) {
        try (FSFile fSFile = new FSFile(byArray, n2, n3);){
            SVNProperties sVNProperties = fSFile.readProperties(false, true);
            return sVNProperties;
        }
    }

    private static byte[] composePropertiesByteArray(SVNProperties sVNProperties) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            SVNWCProperties.setProperties(sVNProperties, byteArrayOutputStream, "END");
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        finally {
            SVNFileUtil.closeFile(byteArrayOutputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] toUncompressedByteArray() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.writeNumber(byteArrayOutputStream, this.getFirstRevision());
            this.writeNumber(byteArrayOutputStream, this.getRevisionsCount());
            for (SVNFSFSPackedRevProps$Entry sVNFSFSPackedRevProps$Entry : this.entries) {
                this.writeNumber(byteArrayOutputStream, sVNFSFSPackedRevProps$Entry.getSize());
            }
            byteArrayOutputStream.write(10);
            for (SVNFSFSPackedRevProps$Entry sVNFSFSPackedRevProps$Entry : this.entries) {
                byteArrayOutputStream.write(SVNFSFSPackedRevProps$Entry.access$300(sVNFSFSPackedRevProps$Entry), SVNFSFSPackedRevProps$Entry.access$200(sVNFSFSPackedRevProps$Entry), SVNFSFSPackedRevProps$Entry.access$100(sVNFSFSPackedRevProps$Entry));
            }
            Object object = byteArrayOutputStream.toByteArray();
            return object;
        }
        finally {
            SVNFileUtil.closeFile(byteArrayOutputStream);
        }
    }

    private void writeNumber(OutputStream outputStream, long l2) {
        try {
            outputStream.write(String.valueOf(l2).getBytes());
            outputStream.write(10);
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR);
            SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.FSFS);
        }
    }

    private static long readNumber(InputStream inputStream) {
        char[] cArray = new char[20];
        int n2 = 0;
        while (true) {
            SVNErrorMessage sVNErrorMessage;
            int n3 = 0;
            try {
                n3 = inputStream.read();
            }
            catch (IOException iOException) {
                SVNErrorMessage sVNErrorMessage2 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR);
                SVNErrorManager.error(sVNErrorMessage2, iOException, SVNLogType.FSFS);
            }
            if (n3 < 0) {
                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
            if (n3 != 10 && (n3 < 48 || n3 > 57)) {
                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
            if (n3 == 10) {
                return Long.parseLong(new String(cArray, 0, n2));
            }
            cArray[n2] = (char)n3;
            ++n2;
        }
    }

    private void setEntry(long l2, byte[] byArray) {
        this.invalidateCaches();
        this.entries.set((int)(l2 - this.getFirstRevision()), new SVNFSFSPackedRevProps$Entry(byArray, 0, byArray.length));
    }

    private void invalidateCaches() {
        this.cachedUncompressedByteArray = null;
    }

    /* synthetic */ SVNFSFSPackedRevProps(long l2, List list, byte[] byArray, SVNFSFSPackedRevProps$1 sVNFSFSPackedRevProps$1) {
        this(l2, list, byArray);
    }

    static /* synthetic */ byte[] access$500(SVNProperties sVNProperties) {
        return SVNFSFSPackedRevProps.composePropertiesByteArray(sVNProperties);
    }
}

