/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs.repcache;

import java.io.File;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.SqlJetSafetyLevel;
import org.tmatesoft.sqljet.core.table.ISqlJetCursor;
import org.tmatesoft.sqljet.core.table.ISqlJetTable;
import org.tmatesoft.sqljet.core.table.SqlJetDb;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSRepresentation;
import org.tmatesoft.svn.core.internal.io.fs.IFSRepresentationCacheManager;
import org.tmatesoft.svn.core.internal.io.fs.IFSSqlJetTransaction;
import org.tmatesoft.svn.core.internal.io.fs.repcache.FSEmptyRepresentationCacheManager;
import org.tmatesoft.svn.core.internal.io.fs.repcache.FSRepresentationCacheManager$1;
import org.tmatesoft.svn.core.internal.io.fs.repcache.FSRepresentationCacheManager$2;
import org.tmatesoft.svn.core.internal.io.fs.repcache.FSRepresentationCacheManager$3;
import org.tmatesoft.svn.core.internal.io.fs.repcache.FSRepresentationCacheRecord;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class FSRepresentationCacheManager
implements IFSRepresentationCacheManager {
    public static final String REP_CACHE_TABLE = "rep_cache";
    private static final String REP_CACHE_DB_SQL = "create table rep_cache (hash text not null primary key,                         revision integer not null,                         offset integer not null,                         size integer not null,                         expanded_size integer not null) without rowid;";
    private SqlJetDb myRepCacheDB;
    private ISqlJetTable myTable;
    private FSFS myFSFS;

    public static IFSRepresentationCacheManager openRepresentationCache(FSFS fSFS) {
        FSRepresentationCacheManager fSRepresentationCacheManager = new FSRepresentationCacheManager();
        try {
            fSRepresentationCacheManager.myRepCacheDB = SqlJetDb.open(fSFS.getRepositoryCacheFile(), true);
            fSRepresentationCacheManager.myRepCacheDB.setSafetyLevel(SqlJetSafetyLevel.OFF);
            FSRepresentationCacheManager.checkFormat(fSFS.getDBFormat(), fSRepresentationCacheManager.myRepCacheDB);
            fSRepresentationCacheManager.myTable = fSRepresentationCacheManager.myRepCacheDB.getTable(REP_CACHE_TABLE);
        }
        catch (SqlJetException sqlJetException) {
            SVNDebugLog.getDefaultLog().logError(SVNLogType.FSFS, sqlJetException);
            return new FSEmptyRepresentationCacheManager();
        }
        return fSRepresentationCacheManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createRepresentationCache(int n2, File file) {
        SqlJetDb sqlJetDb = null;
        try {
            sqlJetDb = SqlJetDb.open(file, true);
            FSRepresentationCacheManager.checkFormat(n2, sqlJetDb);
        }
        catch (SqlJetException sqlJetException) {
            SVNDebugLog.getDefaultLog().logError(SVNLogType.FSFS, sqlJetException);
        }
        finally {
            if (sqlJetDb != null) {
                try {
                    sqlJetDb.close();
                }
                catch (SqlJetException sqlJetException) {
                    SVNDebugLog.getDefaultLog().logFine(SVNLogType.FSFS, sqlJetException);
                }
            }
        }
    }

    private static void checkFormat(int n2, SqlJetDb sqlJetDb) {
        int n3 = FSFS.getRepCacheSchemaFormat(n2);
        sqlJetDb.runWithLock(new FSRepresentationCacheManager$1(n3));
    }

    @Override
    public void insert(FSRepresentation fSRepresentation, boolean bl2) {
        Object object;
        if (fSRepresentation.getSHA1HexDigest() == null) {
            object = SVNErrorMessage.create(SVNErrorCode.BAD_CHECKSUM_KIND, "Only SHA1 checksums can be used as keys in the rep_cache table.\n");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        if ((object = this.getRepresentationByHash(fSRepresentation.getSHA1HexDigest())) != null) {
            if (bl2 && (((FSRepresentation)object).getRevision() != fSRepresentation.getRevision() || ((FSRepresentation)object).getItemIndex() != fSRepresentation.getItemIndex() || ((FSRepresentation)object).getSize() != fSRepresentation.getSize() || ((FSRepresentation)object).getExpandedSize() != fSRepresentation.getExpandedSize())) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Representation key for checksum ''{0}'' exists in filesystem ''{1}'' with a different value ({2},{3},{4},{5}) than what we were about to store ({6},{7},{8},{9})", fSRepresentation.getSHA1HexDigest(), this.myFSFS.getRepositoryRoot(), String.valueOf(((FSRepresentation)object).getRevision()), String.valueOf(((FSRepresentation)object).getItemIndex()), String.valueOf(((FSRepresentation)object).getSize()), String.valueOf(((FSRepresentation)object).getExpandedSize()), String.valueOf(fSRepresentation.getRevision()), String.valueOf(fSRepresentation.getItemIndex()), String.valueOf(fSRepresentation.getSize()), String.valueOf(fSRepresentation.getExpandedSize()));
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
            return;
        }
        try {
            this.myTable.insert(fSRepresentation.getSHA1HexDigest(), fSRepresentation.getRevision(), fSRepresentation.getItemIndex(), fSRepresentation.getSize(), fSRepresentation.getExpandedSize());
        }
        catch (SqlJetException sqlJetException) {
            SVNErrorManager.error(FSRepresentationCacheManager.convertError(sqlJetException), SVNLogType.FSFS);
        }
    }

    @Override
    public void close() {
        if (this.myRepCacheDB != null) {
            try {
                this.myRepCacheDB.close();
            }
            catch (SqlJetException sqlJetException) {
                SVNErrorManager.error(FSRepresentationCacheManager.convertError(sqlJetException), SVNLogType.FSFS);
            }
            finally {
                this.myTable = null;
                this.myRepCacheDB = null;
                this.myFSFS = null;
            }
        }
    }

    @Override
    public FSRepresentation getRepresentationByHash(String string) {
        FSRepresentationCacheRecord fSRepresentationCacheRecord = this.getByHash(string);
        if (fSRepresentationCacheRecord != null) {
            FSRepresentation fSRepresentation = new FSRepresentation();
            fSRepresentation.setExpandedSize(fSRepresentationCacheRecord.getExpandedSize());
            fSRepresentation.setItemIndex(fSRepresentationCacheRecord.getOffset());
            fSRepresentation.setRevision(fSRepresentationCacheRecord.getRevision());
            fSRepresentation.setSize(fSRepresentationCacheRecord.getSize());
            fSRepresentation.setSHA1HexDigest(fSRepresentationCacheRecord.getHash());
            return fSRepresentation;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FSRepresentationCacheRecord getByHash(String string) {
        ISqlJetCursor iSqlJetCursor = null;
        try {
            iSqlJetCursor = this.myTable.lookup(this.myTable.getPrimaryKeyIndexName(), string);
            if (!iSqlJetCursor.eof()) {
                FSRepresentationCacheRecord fSRepresentationCacheRecord = new FSRepresentationCacheRecord(iSqlJetCursor);
                return fSRepresentationCacheRecord;
            }
        }
        catch (SqlJetException sqlJetException) {
            SVNErrorManager.error(FSRepresentationCacheManager.convertError(sqlJetException), SVNLogType.FSFS);
        }
        finally {
            if (iSqlJetCursor != null) {
                try {
                    iSqlJetCursor.close();
                }
                catch (SqlJetException sqlJetException) {
                    SVNErrorManager.error(FSRepresentationCacheManager.convertError(sqlJetException), SVNLogType.FSFS);
                }
            }
        }
        return null;
    }

    private static SVNErrorMessage convertError(SqlJetException sqlJetException) {
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(FSRepresentationCacheManager.convertErrorCode(sqlJetException), sqlJetException.getMessage());
        return sVNErrorMessage;
    }

    private static SVNErrorCode convertErrorCode(SqlJetException sqlJetException) {
        SqlJetErrorCode sqlJetErrorCode = sqlJetException.getErrorCode();
        if (sqlJetErrorCode == SqlJetErrorCode.READONLY) {
            return SVNErrorCode.SQLITE_READONLY;
        }
        return SVNErrorCode.SQLITE_ERROR;
    }

    @Override
    public void runWriteTransaction(IFSSqlJetTransaction iFSSqlJetTransaction) {
        if (this.myRepCacheDB != null) {
            try {
                this.myRepCacheDB.runWriteTransaction(new FSRepresentationCacheManager$2(this, iFSSqlJetTransaction));
            }
            catch (SqlJetException sqlJetException) {
                SVNErrorManager.error(FSRepresentationCacheManager.convertError(sqlJetException), SVNLogType.FSFS);
            }
        }
    }

    @Override
    public void runReadTransaction(IFSSqlJetTransaction iFSSqlJetTransaction) {
        if (this.myRepCacheDB != null) {
            try {
                this.myRepCacheDB.runReadTransaction(new FSRepresentationCacheManager$3(this, iFSSqlJetTransaction));
            }
            catch (SqlJetException sqlJetException) {
                SVNErrorManager.error(FSRepresentationCacheManager.convertError(sqlJetException), SVNLogType.FSFS);
            }
        }
    }
}

