/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs.index;

import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.logging.Level;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class FSTransactionItemIndex
implements Closeable {
    private static final String FILENAME = "itemidx";
    private final RandomAccessFile file;

    public static FSTransactionItemIndex open(FSFS fSFS, String string) {
        try {
            return new FSTransactionItemIndex(new RandomAccessFile(FSTransactionItemIndex.getIndexPath(fSFS, string), "rw"));
        }
        catch (FileNotFoundException fileNotFoundException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, fileNotFoundException);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            return null;
        }
    }

    public static File getIndexPath(FSFS fSFS, String string) {
        File file = fSFS.getTransactionDir(string);
        return SVNFileUtil.createFilePath(file, FILENAME);
    }

    private FSTransactionItemIndex(RandomAccessFile randomAccessFile) {
        this.file = randomAccessFile;
    }

    @Override
    public void close() {
        try {
            this.file.close();
        }
        catch (IOException iOException) {
            SVNDebugLog.getDefaultLog().log(SVNLogType.FSFS, iOException, Level.INFO);
        }
    }

    public long allocateItemIndex(long l2) {
        byte[] byArray = new byte[21];
        long l3 = 0L;
        try {
            int n2 = this.file.read(byArray);
            if (n2 < 0) {
                l3 = 3L;
            } else {
                int n3 = FSTransactionItemIndex.arrayIndexOf(byArray, (byte)0);
                String string = n3 >= 0 ? new String(byArray, 0, n3) : new String(byArray);
                try {
                    l3 = Long.parseLong(string);
                }
                catch (NumberFormatException numberFormatException) {
                    l3 = 3L;
                }
            }
        }
        catch (EOFException eOFException) {
            l3 = 3L;
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        try {
            this.file.seek(0L);
            String string = String.valueOf(l3 + 1L);
            byte[] byArray2 = string.getBytes();
            this.file.write(byArray2);
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        return l3;
    }

    private static int arrayIndexOf(byte[] byArray, byte by) {
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (byArray[i2] != by) continue;
            return i2;
        }
        return -1;
    }
}

