/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs.index;

import java.io.IOException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.internal.io.fs.FSFile;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;

public class FSPackedNumbersStream {
    private static final int MAX_BYTES_PER_NUMER = 4;
    private static final int NUMBERS_BUFFER_SIZE = 1024;
    private static final int BYTES_BUFFER_SIZE = 4096;
    private final byte[] bytes;
    private final long[] numbers;
    private final int[] numbersLengths;
    private final FSFile input;
    private int bytesStart;
    private int bytesLength;
    private int numbersStart;
    private int numbersLength;
    private boolean eof;
    private long inputStartPosition;
    private long prefetchedBytesCount;

    public FSPackedNumbersStream(FSFile fSFile) {
        this.input = fSFile;
        this.bytes = new byte[4096];
        this.numbers = new long[1024];
        this.numbersLengths = new int[1024];
        this.bytesStart = 0;
        this.bytesLength = 0;
        this.numbersStart = 0;
        this.numbersLength = 0;
        this.eof = false;
        this.inputStartPosition = fSFile.position();
        this.prefetchedBytesCount = 0L;
    }

    public boolean isEof() {
        return this.eof;
    }

    public long readSigned() {
        return this.decodeSigned(this.read());
    }

    private long decodeSigned(long l2) {
        return l2 % 2L != 0L ? -1L - l2 / 2L : l2 / 2L;
    }

    public long read() {
        try {
            if (this.numbersLength == 0) {
                this.numbersStart = 0;
                if (!this.eof) {
                    this.eof = this.readNextNumbersBlock();
                }
            }
            int n2 = this.numbersLengths[this.numbersStart];
            long l2 = this.numbers[this.numbersStart];
            ++this.numbersStart;
            --this.numbersLength;
            if (this.numbersLength == 0 || this.numbersStart == this.numbers.length) {
                this.numbersStart = 0;
            }
            this.prefetchedBytesCount -= (long)n2;
            return l2;
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            return -1L;
        }
    }

    private boolean readNextNumbersBlock() {
        int n2;
        int n3;
        int n4;
        boolean bl2 = false;
        do {
            int n5;
            if ((n5 = this.input.read(this.bytes, this.bytesStart + this.bytesLength, n3 = Math.min((n2 = this.numbers.length - (this.numbersStart + this.numbersLength)) * 4, this.bytes.length - (this.bytesStart + this.bytesLength)))) < 0) {
                n5 = 0;
                bl2 = true;
            }
            this.prefetchedBytesCount += (long)n5;
            this.bytesLength += n5;
            for (n4 = this.bytesLength; n4 > 0 && (this.bytes[n4 - 1] & 0x80) != 0; --n4) {
            }
        } while (!bl2 && n4 == 0);
        n2 = 0;
        while (n2 < n4 && this.numbers.length != this.numbersLength) {
            int n6;
            n3 = this.bytes[n2];
            long l2 = 0L;
            int n7 = 0;
            if ((n3 & 0x80) == 0) {
                ++this.bytesStart;
                --this.bytesLength;
                ++n2;
                l2 = n3;
                n7 = 1;
            } else {
                n6 = n2;
                while (this.bytes[n6] < 0) {
                    ++n6;
                }
                int n8 = n6 - n2 + 1;
                if (n8 > 9) {
                    throw new RuntimeException("Packed number exceeds capacity of signed long");
                }
                l2 = this.bytes[n6];
                while (n6 > n2) {
                    l2 <<= 7;
                    l2 += (long)(this.bytes[--n6] & 0x7F);
                }
                n7 = n8;
                n2 += n8;
                this.bytesStart += n8;
                this.bytesLength -= n8;
            }
            n6 = this.numbersStart + this.numbersLength;
            if (n6 >= this.numbers.length) {
                n6 -= this.numbers.length;
            }
            this.numbers[n6] = l2;
            this.numbersLengths[n6] = n7;
            ++this.numbersLength;
        }
        for (n3 = 0; n3 < this.bytesLength; ++n3) {
            this.bytes[n3] = this.bytes[n3 + n2];
        }
        this.bytesStart = 0;
        return bl2 && this.numbersLength <= 0;
    }

    public void seek(long l2) {
        this.numbersStart = 0;
        this.numbersLength = 0;
        this.bytesStart = 0;
        this.bytesLength = 0;
        this.prefetchedBytesCount = 0L;
        this.input.seek(this.inputStartPosition + l2);
    }

    public long position() {
        return this.input.position() - this.inputStartPosition - this.prefetchedBytesCount;
    }
}

