/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs.index;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.logging.Level;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.io.fs.index.FSP2LEntry;
import org.tmatesoft.svn.core.internal.io.fs.index.FSP2LProtoIndex$ItemType;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class FSP2LProtoIndex {
    private static final long MAX_OFFSET = Integer.MAX_VALUE;
    private static final String FILENAME = "index.p2l";
    private final RandomAccessFile file;

    public static FSP2LProtoIndex open(FSFS fSFS, String string, boolean bl2) {
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(FSP2LProtoIndex.getIndexPath(fSFS, string), "rw");
            if (bl2) {
                randomAccessFile.seek(randomAccessFile.length());
            }
            return new FSP2LProtoIndex(randomAccessFile);
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            return null;
        }
    }

    public static File getIndexPath(FSFS fSFS, String string) {
        File file = fSFS.getTransactionDir(string);
        return SVNFileUtil.createFilePath(file, FILENAME);
    }

    public FSP2LProtoIndex(RandomAccessFile randomAccessFile) {
        this.file = randomAccessFile;
    }

    public void close() {
        try {
            this.file.close();
        }
        catch (IOException iOException) {
            SVNDebugLog.getDefaultLog().log(SVNLogType.FSFS, iOException, Level.INFO);
        }
    }

    public FSP2LEntry readEntry() {
        boolean bl2;
        long l2 = this.readOffset();
        long l3 = this.readOffset();
        int n2 = this.readInt();
        long l4 = this.readLong();
        long l5 = this.readLong();
        long l6 = this.readLong();
        boolean bl3 = bl2 = l2 < 0L || l3 < 0L || n2 < 0 || l4 < 0L || l5 < 0L || l6 < 0L;
        if (!bl2) {
            if (l5 > 0L && l5 - 1L > Long.MAX_VALUE) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_OVERFLOW, "Revision 0x{0} too large, max = 0x{1}", Long.toHexString(l5), Long.toHexString(Integer.MAX_VALUE));
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
            long l7 = l5 == 0L ? -1L : l5 - 1L;
            return new FSP2LEntry(l2, l3, FSP2LProtoIndex$ItemType.fromCode(n2), (int)l4, l7, l6);
        }
        return null;
    }

    public void writeEntry(FSP2LEntry fSP2LEntry) {
        assert (fSP2LEntry.getOffset() >= 0L);
        assert (fSP2LEntry.getSize() >= 0L);
        assert (fSP2LEntry.getRevision() >= 0L || fSP2LEntry.getRevision() == -1L);
        long l2 = fSP2LEntry.getRevision() == -1L ? 0L : fSP2LEntry.getRevision() + 1L;
        try {
            FSRepositoryUtil.writeLongLittleEndian(this.file, fSP2LEntry.getOffset());
            FSRepositoryUtil.writeLongLittleEndian(this.file, fSP2LEntry.getSize());
            FSRepositoryUtil.writeLongLittleEndian(this.file, fSP2LEntry.getType().getCode());
            FSRepositoryUtil.writeLongLittleEndian(this.file, (long)fSP2LEntry.getChecksum() & 0xFFFFFFFFL);
            FSRepositoryUtil.writeLongLittleEndian(this.file, l2);
            FSRepositoryUtil.writeLongLittleEndian(this.file, fSP2LEntry.getNumber());
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
    }

    public long readNextOffset() {
        try {
            long l2 = this.file.getFilePointer();
            if (l2 == 0L) {
                return 0L;
            }
            this.file.seek(l2 -= 48L);
            FSP2LEntry fSP2LEntry = this.readEntry();
            return fSP2LEntry.getOffset() + fSP2LEntry.getSize();
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            return -1L;
        }
    }

    private int readInt() {
        long l2 = this.readLong();
        if (l2 >= 0L && l2 > Integer.MAX_VALUE) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_OVERFLOW, "UINT32 0x{0} too large, max = 0x{1}", Long.toHexString(l2), Long.toHexString(Integer.MAX_VALUE));
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        return (int)l2;
    }

    private long readOffset() {
        long l2 = this.readLong();
        if (l2 >= 0L && l2 > Integer.MAX_VALUE) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_OVERFLOW, "File offset 0x{0} too large, max = 0x{1}", Long.toHexString(l2), Long.toHexString(Integer.MAX_VALUE));
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        return l2;
    }

    private long readLong() {
        try {
            return FSRepositoryUtil.readLongLittleEndian(this.file);
        }
        catch (EOFException eOFException) {
            return -1L;
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            return -1L;
        }
    }
}

