/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSFile;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.io.fs.index.FSLogicalAddressingIndex$L2PIndexHeader;
import org.tmatesoft.svn.core.internal.io.fs.index.FSLogicalAddressingIndex$L2PPageInfo;
import org.tmatesoft.svn.core.internal.io.fs.index.FSLogicalAddressingIndex$P2LIndexHeader;
import org.tmatesoft.svn.core.internal.io.fs.index.FSLogicalAddressingIndex$P2LPageInfo;
import org.tmatesoft.svn.core.internal.io.fs.index.FSLogicalAddressingIndex$Page;
import org.tmatesoft.svn.core.internal.io.fs.index.FSLogicalAddressingIndex$PageTableEntry;
import org.tmatesoft.svn.core.internal.io.fs.index.FSP2LEntry;
import org.tmatesoft.svn.core.internal.io.fs.index.FSP2LProtoIndex$ItemType;
import org.tmatesoft.svn.core.internal.io.fs.index.FSPackedNumbersStream;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;

public class FSLogicalAddressingIndex {
    public static final String L2P_STREAM_PREFIX = "L2P-INDEX\n";
    public static final String P2L_STREAM_PREFIX = "P2L-INDEX\n";
    private FSFile myFile;
    private long startRevision;
    private FSFS fsfs;

    public FSLogicalAddressingIndex(FSFS fSFS, FSFile fSFile) {
        this.fsfs = fSFS;
        this.myFile = fSFile;
        this.startRevision = -1L;
    }

    public long getStartRevision(long l2) {
        if (this.startRevision == -1L) {
            this.startRevision = this.fsfs.isPackedRevision(l2) ? l2 - l2 % this.fsfs.getMaxFilesPerDirectory() : l2;
        }
        return this.startRevision;
    }

    public long getOffsetByItemIndex(long l2, long l3) {
        FSLogicalAddressingIndex$L2PPageInfo fSLogicalAddressingIndex$L2PPageInfo = this.getL2PPageInfo(l2, l3);
        boolean bl2 = this.fsfs.isPackedRevision(l2);
        boolean bl3 = false;
        long l4 = fSLogicalAddressingIndex$L2PPageInfo.getFirstRevision() + (bl2 ? this.fsfs.getMaxFilesPerDirectory() : 1L);
        FSLogicalAddressingIndex$PageTableEntry pageTableEntry = fSLogicalAddressingIndex$L2PPageInfo.getEntry();
        FSLogicalAddressingIndex$Page page = this.getL2PPage(pageTableEntry);
        long l5 = this.getL2PPageEntry(page, fSLogicalAddressingIndex$L2PPageInfo.getPageOffset(), l3, l2);
        return l5;
    }

    public long getItemIndexByOffset(long l2) {
        return -1L;
    }

    public List lookupP2LEntries(long l2, long l3, long l4) {
        FSP2LEntry fSP2LEntry;
        long l5;
        FSP2LEntry fSP2LEntry2;
        boolean bl2 = false;
        ArrayList<FSP2LEntry> arrayList = new ArrayList<FSP2LEntry>();
        FSLogicalAddressingIndex$P2LPageInfo fSLogicalAddressingIndex$P2LPageInfo = this.getP2LKeys(l2, l3);
        long l6 = fSLogicalAddressingIndex$P2LPageInfo.getPageStart();
        int n2 = 4;
        FSLogicalAddressingIndex$P2LPageInfo fSLogicalAddressingIndex$P2LPageInfo2 = fSLogicalAddressingIndex$P2LPageInfo;
        long l7 = FSRepositoryUtil.align(fSLogicalAddressingIndex$P2LPageInfo.getNextOffset(), this.fsfs.getBlockSize());
        long l8 = FSRepositoryUtil.align(fSLogicalAddressingIndex$P2LPageInfo.getStartOffset(), this.fsfs.getBlockSize()) - this.fsfs.getBlockSize();
        List list = this.getP2LPage(fSLogicalAddressingIndex$P2LPageInfo.getFirstRevision(), fSLogicalAddressingIndex$P2LPageInfo.getStartOffset(), fSLogicalAddressingIndex$P2LPageInfo.getNextOffset(), fSLogicalAddressingIndex$P2LPageInfo.getPageStart(), fSLogicalAddressingIndex$P2LPageInfo.getPageSize());
        if (list.size() > 0 && (fSP2LEntry2 = (FSP2LEntry)list.get(list.size() - 1)).getOffset() + fSP2LEntry2.getSize() > fSLogicalAddressingIndex$P2LPageInfo.getPageSize() * fSLogicalAddressingIndex$P2LPageInfo.getPageCount()) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_OVERFLOW, "Last P2L index entry extends beyond the last page in revision {0}", (Object)l2);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        this.appendP2LEntries(arrayList, list, l3, l4);
        assert (arrayList.size() > 0);
        if (fSLogicalAddressingIndex$P2LPageInfo.getPageNumber() + 1L >= fSLogicalAddressingIndex$P2LPageInfo.getPageCount() && (l5 = (fSP2LEntry = (FSP2LEntry)arrayList.get(arrayList.size() - 1)).getOffset() + fSP2LEntry.getSize()) < l4) {
            if (fSP2LEntry.getType() == FSP2LProtoIndex$ItemType.UNUSED) {
                fSP2LEntry.setSize(l4 - fSP2LEntry.getOffset());
            } else {
                fSP2LEntry = new FSP2LEntry(l5, l4 - l5, FSP2LProtoIndex$ItemType.UNUSED, 0, -1L, 0L);
                arrayList.add(fSP2LEntry);
            }
        }
        return arrayList;
    }

    protected FSLogicalAddressingIndex$P2LPageInfo getP2LKeys(long l2, long l3) {
        FSLogicalAddressingIndex$P2LPageInfo fSLogicalAddressingIndex$P2LPageInfo = this.getP2LPageInfo(l2, l3);
        if (fSLogicalAddressingIndex$P2LPageInfo.getPageCount() <= fSLogicalAddressingIndex$P2LPageInfo.getPageNumber()) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_OVERFLOW, "Offset {0} too large in revision {1}", l3, l2);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        return fSLogicalAddressingIndex$P2LPageInfo;
    }

    private FSLogicalAddressingIndex$P2LPageInfo getP2LPageInfo(long l2, long l3) {
        boolean bl2 = false;
        if (bl2) {
            return null;
        }
        FSLogicalAddressingIndex$P2LIndexHeader fSLogicalAddressingIndex$P2LIndexHeader = this.getP2LHeader();
        return this.createPageInfo(fSLogicalAddressingIndex$P2LIndexHeader, l2, l3);
    }

    private FSLogicalAddressingIndex$P2LIndexHeader getP2LHeader() {
        Object object;
        long l2;
        long l3;
        long l4;
        boolean bl2 = false;
        if (bl2) {
            return null;
        }
        FSPackedNumbersStream fSPackedNumbersStream = this.autoOpenP2LIndex();
        fSPackedNumbersStream.seek(0L);
        long l5 = fSPackedNumbersStream.read();
        if (l5 != this.startRevision) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_CORRUPTION, "Index rev / pack file revision numbers do not match");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        if ((l4 = fSPackedNumbersStream.read()) != this.myFile.getL2POffset()) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_CORRUPTION, "Index offset and rev / pack file size do not match");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        if ((l3 = fSPackedNumbersStream.read()) == 0L || (l3 & l3 - 1L) != 0L) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_CORRUPTION, "P2L index page size is not a power of two");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        if ((l2 = fSPackedNumbersStream.read()) != (l4 - 1L) / l3 + 1L) {
            object = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_CORRUPTION, "P2L page count does not match rev / pack file size");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        object = new long[(int)(l2 + 1L)];
        object[0] = 0L;
        int n2 = 0;
        while ((long)n2 < l2) {
            long l6 = fSPackedNumbersStream.read();
            object[n2 + 1] = object[n2] + l6;
            ++n2;
        }
        long l7 = fSPackedNumbersStream.position();
        int n3 = 0;
        while ((long)n3 <= l2) {
            Object object2 = object;
            int n4 = n3++;
            object2[n4] = object2[n4] + l7;
        }
        FSLogicalAddressingIndex$P2LIndexHeader fSLogicalAddressingIndex$P2LIndexHeader = new FSLogicalAddressingIndex$P2LIndexHeader(l5, l3, l2, l4, (long[])object);
        return fSLogicalAddressingIndex$P2LIndexHeader;
    }

    private FSLogicalAddressingIndex$P2LPageInfo createPageInfo(FSLogicalAddressingIndex$P2LIndexHeader fSLogicalAddressingIndex$P2LIndexHeader, long l2, long l3) {
        FSLogicalAddressingIndex$P2LPageInfo fSLogicalAddressingIndex$P2LPageInfo = new FSLogicalAddressingIndex$P2LPageInfo(null);
        if (l3 / fSLogicalAddressingIndex$P2LIndexHeader.getPageSize() < fSLogicalAddressingIndex$P2LIndexHeader.getPageCount()) {
            fSLogicalAddressingIndex$P2LPageInfo.setPageNumber(l3 / fSLogicalAddressingIndex$P2LIndexHeader.getPageSize());
            fSLogicalAddressingIndex$P2LPageInfo.setStartOffset(fSLogicalAddressingIndex$P2LIndexHeader.getOffsets()[(int)fSLogicalAddressingIndex$P2LPageInfo.getPageNumber()]);
            fSLogicalAddressingIndex$P2LPageInfo.setNextOffset(fSLogicalAddressingIndex$P2LIndexHeader.getOffsets()[(int)(fSLogicalAddressingIndex$P2LPageInfo.getPageNumber() + 1L)]);
            fSLogicalAddressingIndex$P2LPageInfo.setPageSize(fSLogicalAddressingIndex$P2LIndexHeader.getPageSize());
        } else {
            fSLogicalAddressingIndex$P2LPageInfo.setPageNumber(fSLogicalAddressingIndex$P2LIndexHeader.getPageCount());
            fSLogicalAddressingIndex$P2LPageInfo.setStartOffset(fSLogicalAddressingIndex$P2LIndexHeader.getOffsets()[(int)fSLogicalAddressingIndex$P2LPageInfo.getPageNumber()]);
            fSLogicalAddressingIndex$P2LPageInfo.setNextOffset(fSLogicalAddressingIndex$P2LIndexHeader.getOffsets()[(int)fSLogicalAddressingIndex$P2LPageInfo.getPageNumber()]);
            fSLogicalAddressingIndex$P2LPageInfo.setPageSize(0L);
        }
        fSLogicalAddressingIndex$P2LPageInfo.setFirstRevision(fSLogicalAddressingIndex$P2LIndexHeader.getFirstRevision());
        fSLogicalAddressingIndex$P2LPageInfo.setPageStart(fSLogicalAddressingIndex$P2LIndexHeader.getPageSize() * fSLogicalAddressingIndex$P2LPageInfo.getPageNumber());
        fSLogicalAddressingIndex$P2LPageInfo.setPageCount(fSLogicalAddressingIndex$P2LIndexHeader.getPageCount());
        return fSLogicalAddressingIndex$P2LPageInfo;
    }

    private void appendP2LEntries(List list, List list2, long l2, long l3) {
        FSP2LEntry fSP2LEntry;
        int n2 = FSLogicalAddressingIndex.searchLowerBound(list2, l2);
        if (n2 > 0 && (fSP2LEntry = (FSP2LEntry)list2.get(n2 - 1)).getOffset() + fSP2LEntry.getSize() > l2) {
            --n2;
        }
        while (n2 < list2.size() && (fSP2LEntry = (FSP2LEntry)list2.get(n2)).getOffset() < l3) {
            list.add(fSP2LEntry);
            ++n2;
        }
    }

    public static int searchLowerBound(List list, long l2) {
        int n2 = 0;
        int n3 = list.size() - 1;
        while (n2 <= n3) {
            int n4 = n2 + (n3 - n2) / 2;
            int n5 = FSLogicalAddressingIndex.compareEntryOffset((FSP2LEntry)list.get(n4), l2);
            if (n5 < 0) {
                n2 = n4 + 1;
                continue;
            }
            n3 = n4 - 1;
        }
        assert (n2 == n3 + 1);
        return n2;
    }

    public static int compareEntryOffset(FSP2LEntry fSP2LEntry, long l2) {
        long l3 = fSP2LEntry.getOffset() - l2;
        return l3 < 0L ? -1 : (l3 == 0L ? 0 : 1);
    }

    private List getP2LPage(long l2, long l3, long l4, long l5, long l6) {
        ArrayList arrayList = new ArrayList();
        FSPackedNumbersStream fSPackedNumbersStream = this.autoOpenP2LIndex();
        fSPackedNumbersStream.seek(l3);
        long[] lArray = new long[]{fSPackedNumbersStream.read()};
        long[] lArray2 = new long[]{l2};
        long[] lArray3 = new long[]{0L};
        if (l3 == l4) {
            this.readEntryToList(fSPackedNumbersStream, lArray, lArray2, lArray3, arrayList);
        } else {
            long l7;
            do {
                this.readEntryToList(fSPackedNumbersStream, lArray, lArray2, lArray3, arrayList);
            } while ((l7 = fSPackedNumbersStream.read()) < l4);
            if (l7 == l4) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_CORRUPTION, "P2L page description overlaps with next page description");
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
            if (lArray[0] < l5 + l6) {
                lArray[0] = fSPackedNumbersStream.read();
                lArray2[0] = l2;
                lArray3[0] = 0L;
                this.readEntryToList(fSPackedNumbersStream, lArray, lArray2, lArray3, arrayList);
            }
        }
        return arrayList;
    }

    private void readEntryToList(FSPackedNumbersStream fSPackedNumbersStream, long[] lArray, long[] lArray2, long[] lArray3, List list) {
        Object object;
        SVNErrorMessage sVNErrorMessage;
        long l2 = lArray[0];
        long l3 = fSPackedNumbersStream.read();
        lArray3[0] = lArray3[0] + fSPackedNumbersStream.readSigned();
        FSP2LProtoIndex$ItemType fSP2LProtoIndex$ItemType = FSP2LProtoIndex$ItemType.fromCode((int)(lArray3[0] & 7L));
        long l4 = lArray3[0] / 8L;
        if (fSP2LProtoIndex$ItemType.getCode() > FSP2LProtoIndex$ItemType.CHANGES.getCode()) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_CORRUPTION, "Invalid item type in P2L index");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        if (fSP2LProtoIndex$ItemType == FSP2LProtoIndex$ItemType.CHANGES && l4 != 1L) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_CORRUPTION, "Changed path list must have item number 1");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        lArray2[0] = lArray2[0] + fSPackedNumbersStream.readSigned();
        long l5 = lArray2[0];
        long l6 = fSPackedNumbersStream.read();
        if (l6 > Integer.MAX_VALUE) {
            object = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_CORRUPTION, "Invalid FNV1 checksum in P2L index");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        if (fSP2LProtoIndex$ItemType == FSP2LProtoIndex$ItemType.UNUSED && (l4 != 0L || l6 != 0L)) {
            object = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_CORRUPTION, "Empty regions must have item number 0 and checksum 0");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        object = new FSP2LEntry(l2, l3, fSP2LProtoIndex$ItemType, (int)l6, l5, l4);
        list.add(object);
        lArray[0] = lArray[0] + ((FSP2LEntry)object).getSize();
    }

    private long getL2PPageEntry(FSLogicalAddressingIndex$Page fSLogicalAddressingIndex$Page, long l2, long l3, long l4) {
        Object object;
        if (fSLogicalAddressingIndex$Page.getEntryCount() <= l2) {
            object = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_OVERFLOW, "Item index {0} too large in revision {1}", l3, l4);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        object = fSLogicalAddressingIndex$Page.getOffsets();
        return object[(int)l2];
    }

    private FSLogicalAddressingIndex$Page getL2PPage(FSLogicalAddressingIndex$PageTableEntry fSLogicalAddressingIndex$PageTableEntry) {
        long l2 = FSLogicalAddressingIndex$PageTableEntry.access$100(fSLogicalAddressingIndex$PageTableEntry);
        long l3 = 0L;
        long[] lArray = new long[(int)l2];
        FSPackedNumbersStream fSPackedNumbersStream = this.autoOpenL2PIndex();
        fSPackedNumbersStream.seek(FSLogicalAddressingIndex$PageTableEntry.access$200(fSLogicalAddressingIndex$PageTableEntry));
        int n2 = 0;
        while ((long)n2 < l2) {
            long l4 = fSPackedNumbersStream.readSigned();
            lArray[n2] = (l3 += l4) - 1L;
            ++n2;
        }
        if (fSPackedNumbersStream.position() != FSLogicalAddressingIndex$PageTableEntry.access$200(fSLogicalAddressingIndex$PageTableEntry) + FSLogicalAddressingIndex$PageTableEntry.access$300(fSLogicalAddressingIndex$PageTableEntry)) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_CORRUPTION, "L2P actual page size does not match page table value");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        return new FSLogicalAddressingIndex$Page(l2, lArray);
    }

    private FSLogicalAddressingIndex$L2PPageInfo getL2PPageInfo(long l2, long l3) {
        FSLogicalAddressingIndex$L2PIndexHeader fSLogicalAddressingIndex$L2PIndexHeader = this.getL2PHeaderBody(l2);
        return this.createPageInfo(fSLogicalAddressingIndex$L2PIndexHeader, l2, l3);
    }

    private FSLogicalAddressingIndex$L2PPageInfo createPageInfo(FSLogicalAddressingIndex$L2PIndexHeader fSLogicalAddressingIndex$L2PIndexHeader, long l2, long l3) {
        Object object;
        long l4 = l2 - fSLogicalAddressingIndex$L2PIndexHeader.getFirstRevision();
        if (l4 >= fSLogicalAddressingIndex$L2PIndexHeader.getRevisionCount()) {
            object = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_REVISION, "Revision %ld not covered by item index", (Object)l2);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        object = fSLogicalAddressingIndex$L2PIndexHeader.getPageTable();
        long[] lArray = fSLogicalAddressingIndex$L2PIndexHeader.getPageTableIndex();
        FSLogicalAddressingIndex$L2PPageInfo fSLogicalAddressingIndex$L2PPageInfo = new FSLogicalAddressingIndex$L2PPageInfo(null);
        fSLogicalAddressingIndex$L2PPageInfo.setRevision(l2);
        fSLogicalAddressingIndex$L2PPageInfo.setItemIndex(l3);
        fSLogicalAddressingIndex$L2PPageInfo.setFirstRevision(fSLogicalAddressingIndex$L2PIndexHeader.getFirstRevision());
        if (l3 < fSLogicalAddressingIndex$L2PIndexHeader.getPageSize()) {
            fSLogicalAddressingIndex$L2PPageInfo.setPageOffset((int)l3);
            fSLogicalAddressingIndex$L2PPageInfo.setPageNumber(0);
            fSLogicalAddressingIndex$L2PPageInfo.setEntry(object[(int)lArray[(int)l4]]);
        } else {
            long l5 = fSLogicalAddressingIndex$L2PIndexHeader.getPageSize() * (lArray[(int)(l4 + 1L)] - lArray[(int)l4]);
            if (l3 >= l5) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_OVERFLOW, "Item index {0} exceeds l2p limit of {1} for revision {2}", l3, l5, l2);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
            fSLogicalAddressingIndex$L2PPageInfo.setPageOffset((int)(l3 % fSLogicalAddressingIndex$L2PIndexHeader.getPageSize()));
            fSLogicalAddressingIndex$L2PPageInfo.setPageNumber((int)(l3 / fSLogicalAddressingIndex$L2PIndexHeader.getPageSize()));
            fSLogicalAddressingIndex$L2PPageInfo.setEntry(object[(int)(lArray[(int)l4] + (long)fSLogicalAddressingIndex$L2PPageInfo.getPageNumber())]);
        }
        return fSLogicalAddressingIndex$L2PPageInfo;
    }

    private FSLogicalAddressingIndex$L2PIndexHeader getL2PHeaderBody(long l2) {
        SVNErrorMessage sVNErrorMessage;
        long l3;
        FSLogicalAddressingIndex$PageTableEntry[] fSLogicalAddressingIndex$PageTableEntryArray;
        SVNErrorMessage sVNErrorMessage2;
        long l4;
        long l5;
        long l6;
        FSPackedNumbersStream fSPackedNumbersStream = this.autoOpenL2PIndex();
        fSPackedNumbersStream.seek(0L);
        long l7 = fSPackedNumbersStream.read();
        if (l7 != this.getStartRevision(l2)) {
            SVNErrorMessage sVNErrorMessage3 = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_CORRUPTION, "Index rev / pack file revision numbers do not match");
            SVNErrorManager.error(sVNErrorMessage3, SVNLogType.FSFS);
        }
        if ((l6 = fSPackedNumbersStream.read()) == 0L || (l6 & l6 - 1L) != 0L) {
            SVNErrorMessage sVNErrorMessage4 = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_CORRUPTION, "L2P index page size is not a power of two");
            SVNErrorManager.error(sVNErrorMessage4, SVNLogType.FSFS);
        }
        if ((l5 = fSPackedNumbersStream.read()) != 1L && l5 != this.fsfs.getMaxFilesPerDirectory()) {
            SVNErrorMessage sVNErrorMessage5 = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_CORRUPTION, "Invalid number of revisions in L2P index");
            SVNErrorManager.error(sVNErrorMessage5, SVNLogType.FSFS);
        }
        if ((l4 = fSPackedNumbersStream.read()) < l5) {
            sVNErrorMessage2 = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_CORRUPTION, "Fewer L2P index pages than revisions");
            SVNErrorManager.error(sVNErrorMessage2, SVNLogType.FSFS);
        }
        if (l4 > (this.myFile.getP2LOffset() - this.myFile.getL2POffset()) / 2L) {
            sVNErrorMessage2 = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_CORRUPTION, "L2P index page count implausibly large");
            SVNErrorManager.error(sVNErrorMessage2, SVNLogType.FSFS);
        }
        long l8 = l7 + l5;
        if (l7 > l2 || l8 <= l2) {
            fSLogicalAddressingIndex$PageTableEntryArray = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_CORRUPTION, "Corrupt L2P index for r{0} only covers r{1}:{2}", l2, l7, l8);
            SVNErrorManager.error((SVNErrorMessage)fSLogicalAddressingIndex$PageTableEntryArray, SVNLogType.FSFS);
        }
        fSLogicalAddressingIndex$PageTableEntryArray = new FSLogicalAddressingIndex$PageTableEntry[(int)l4];
        long[] lArray = new long[(int)(l5 + 1L)];
        lArray[0] = 0L;
        long l9 = 0L;
        int n2 = 0;
        while ((long)n2 < l5) {
            l3 = fSPackedNumbersStream.read();
            if (l3 == 0L) {
                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_CORRUPTION, "Revision with no L2P index pages");
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
            if ((l9 += l3) > l4) {
                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_CORRUPTION, "L2P page table exceeded");
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
            lArray[n2 + 1] = l9;
            ++n2;
        }
        if (l9 != l4) {
            SVNErrorMessage sVNErrorMessage6 = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_CORRUPTION, "Revisions do not cover the full L2P index page table");
            SVNErrorManager.error(sVNErrorMessage6, SVNLogType.FSFS);
        }
        n2 = 0;
        while ((long)n2 < l4) {
            l3 = fSPackedNumbersStream.read();
            if (l3 == 0L) {
                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_CORRUPTION, "Empty L2P index page");
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
            fSLogicalAddressingIndex$PageTableEntryArray[n2] = new FSLogicalAddressingIndex$PageTableEntry(null);
            FSLogicalAddressingIndex$PageTableEntry.access$302(fSLogicalAddressingIndex$PageTableEntryArray[n2], l3);
            l3 = fSPackedNumbersStream.read();
            if (l3 > l6) {
                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_CORRUPTION, "Page exceeds L2P index page size");
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
            FSLogicalAddressingIndex$PageTableEntry.access$102(fSLogicalAddressingIndex$PageTableEntryArray[n2], l3);
            ++n2;
        }
        long l10 = fSPackedNumbersStream.position();
        int n3 = 0;
        while ((long)n3 < l4) {
            FSLogicalAddressingIndex$PageTableEntry.access$202(fSLogicalAddressingIndex$PageTableEntryArray[n3], l10);
            l10 += FSLogicalAddressingIndex$PageTableEntry.access$300(fSLogicalAddressingIndex$PageTableEntryArray[n3]);
            ++n3;
        }
        FSLogicalAddressingIndex$L2PIndexHeader fSLogicalAddressingIndex$L2PIndexHeader = new FSLogicalAddressingIndex$L2PIndexHeader(l7, l5, l6, lArray, fSLogicalAddressingIndex$PageTableEntryArray);
        return fSLogicalAddressingIndex$L2PIndexHeader;
    }

    private FSPackedNumbersStream autoOpenP2LIndex() {
        this.myFile.ensureFooterLoaded();
        FSPackedNumbersStream fSPackedNumbersStream = this.packedStreamOpen(P2L_STREAM_PREFIX);
        return fSPackedNumbersStream;
    }

    private FSPackedNumbersStream autoOpenL2PIndex() {
        this.myFile.ensureFooterLoaded();
        FSPackedNumbersStream fSPackedNumbersStream = this.packedStreamOpen(L2P_STREAM_PREFIX);
        return fSPackedNumbersStream;
    }

    private FSPackedNumbersStream packedStreamOpen(String string) {
        this.myFile.seek(this.myFile.getL2POffset());
        int n2 = string.length();
        byte[] byArray = new byte[n2];
        try {
            int n3 = this.myFile.read(byArray, 0, n2);
            if (n3 != n2) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_CORRUPTION);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        if (!Arrays.equals(byArray, string.getBytes())) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_CORRUPTION, "Index stream header prefix mismatch.\n  expected: {0}  found: {1}", string, new String(byArray));
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        return new FSPackedNumbersStream(this.myFile);
    }
}

