/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs.index;

import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.logging.Level;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.io.fs.index.FSL2PEntry;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class FSL2PProtoIndex
implements Closeable {
    private static final long MAX_OFFSET = Integer.MAX_VALUE;
    private static final String FILENAME = "index.l2p";
    private final RandomAccessFile file;

    public static FSL2PProtoIndex open(FSFS fSFS, String string, boolean bl2) {
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(FSL2PProtoIndex.getIndexPath(fSFS, string), "rw");
            if (bl2) {
                randomAccessFile.seek(randomAccessFile.length());
            }
            return new FSL2PProtoIndex(randomAccessFile);
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            return null;
        }
    }

    public static File getIndexPath(FSFS fSFS, String string) {
        File file = fSFS.getTransactionDir(string);
        return SVNFileUtil.createFilePath(file, FILENAME);
    }

    public FSL2PProtoIndex(RandomAccessFile randomAccessFile) {
        this.file = randomAccessFile;
    }

    @Override
    public void close() {
        try {
            this.file.close();
        }
        catch (IOException iOException) {
            SVNDebugLog.getDefaultLog().log(SVNLogType.FSFS, iOException, Level.INFO);
        }
    }

    public long getOffsetByItemIndex(long l2) {
        Object object;
        Object object2;
        try {
            if (this.file.length() % 16L != 0L) {
                object2 = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_CORRUPTION);
                SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.FSFS);
            }
        }
        catch (IOException iOException) {
            object = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        object2 = new long[1];
        object = new long[1];
        this.readEntry((long[])object2, (long[])object);
        if (object[0] == l2) {
            return (long)(object2[0] - 1L);
        }
        return -1L;
    }

    public FSL2PEntry readEntry() {
        long[] lArray = new long[1];
        long[] lArray2 = new long[1];
        this.readEntry(lArray, lArray2);
        if (lArray[0] < 0L || lArray2[0] < 0L) {
            return null;
        }
        return new FSL2PEntry(lArray[0], lArray2[0]);
    }

    private void readEntry(long[] lArray, long[] lArray2) {
        try {
            lArray[0] = FSRepositoryUtil.readLongLittleEndian(this.file);
            lArray2[0] = FSRepositoryUtil.readLongLittleEndian(this.file);
        }
        catch (EOFException eOFException) {
            lArray[0] = -1L;
            lArray2[0] = -1L;
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
    }

    public void addEntry(long l2, long l3) {
        try {
            assert (l2 >= -1L);
            FSRepositoryUtil.writeLongLittleEndian(this.file, l2 + 1L);
            FSRepositoryUtil.writeLongLittleEndian(this.file, l3);
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
    }
}

