/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs.index;

import java.io.OutputStream;
import org.tmatesoft.svn.core.internal.io.fs.index.FSFnv1aInterleavedChecksumCalculator;

public class FSFnv1aOutputStream
extends OutputStream {
    private final OutputStream delegate;
    private final FSFnv1aInterleavedChecksumCalculator checksumCalculator;

    public FSFnv1aOutputStream(OutputStream outputStream) {
        this.delegate = outputStream;
        this.checksumCalculator = new FSFnv1aInterleavedChecksumCalculator();
    }

    @Override
    public void write(int n2) {
        byte[] byArray = new byte[]{(byte)n2};
        this.write(byArray);
    }

    @Override
    public void write(byte[] byArray) {
        this.update(byArray, 0, byArray.length);
        this.delegate.write(byArray);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        this.update(byArray, n2, n3);
        this.delegate.write(byArray, n2, n3);
    }

    @Override
    public void flush() {
        this.delegate.flush();
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    public void resetChecksum() {
        this.checksumCalculator.resetChecksum();
    }

    public int finalizeChecksum() {
        return this.checksumCalculator.finalizeChecksum();
    }

    private void update(byte[] byArray, int n2, int n3) {
        this.checksumCalculator.update(byArray, n2, n3);
    }
}

