/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs.index;

public class FSFnv1aInterleavedChecksumCalculator {
    private static final int SCALING = 4;
    private static final int HASH_SIZE_IN_BYTES = 4;
    private static final long FNV1_BASE_32 = 2166136261L;
    private static final long FNV1_PRIME_32 = 16777619L;
    private final long[] hashes = new long[4];
    private final byte[] buffer = new byte[4];
    private int buffered;

    public FSFnv1aInterleavedChecksumCalculator() {
        this.resetChecksum();
    }

    public void update(byte[] byArray, int n2, int n3) {
        int n4;
        if (this.buffered != 0) {
            n4 = 4 - this.buffered;
            if (n4 > n3) {
                System.arraycopy(byArray, n2, this.buffer, this.buffered, n3);
                this.buffered += n3;
                return;
            }
            System.arraycopy(byArray, n2, this.buffer, this.buffered, n4);
            n2 += n4;
            n3 -= n4;
            this.fnv1aInterleaved(this.buffer, 0, 4);
            this.buffered = 0;
        }
        if ((n4 = this.fnv1aInterleaved(byArray, n2, n3)) != n3) {
            this.buffered = n3 - n4;
            System.arraycopy(byArray, n2 + n4, this.buffer, 0, n3 - n4);
        }
    }

    public int finalizeChecksum() {
        return this.finalizeChecksum(this.buffer, 0, this.buffered);
    }

    private int finalizeChecksum(byte[] byArray, int n2, int n3) {
        byte[] byArray2 = new byte[19];
        assert (n3 < 4);
        for (int i2 = 0; i2 < 4; ++i2) {
            long l2 = this.hashes[i2];
            for (int i3 = 0; i3 < 4; ++i3) {
                byte by;
                byArray2[i2 * 4 + (4 - i3 - 1)] = by = (byte)(l2 & 0xFFL);
                l2 >>= 8;
            }
        }
        if (n3 != 0) {
            System.arraycopy(byArray, n2, byArray2, 16, n3);
        }
        return (int)this.fnv1a(2166136261L, byArray2, 0, 16 + n3);
    }

    private int fnv1aInterleaved(byte[] byArray, int n2, int n3) {
        int n4 = 0;
        while (n4 + 4 <= n3) {
            this.hashes[0] = this.hashes[0] ^ (long)byArray[n4 + n2] & 0xFFL;
            this.hashes[0] = this.hashes[0] * 16777619L;
            this.hashes[1] = this.hashes[1] ^ (long)byArray[n4 + n2 + 1] & 0xFFL;
            this.hashes[1] = this.hashes[1] * 16777619L;
            this.hashes[2] = this.hashes[2] ^ (long)byArray[n4 + n2 + 2] & 0xFFL;
            this.hashes[2] = this.hashes[2] * 16777619L;
            this.hashes[3] = this.hashes[3] ^ (long)byArray[n4 + n2 + 3] & 0xFFL;
            this.hashes[3] = this.hashes[3] * 16777619L;
            n4 += 4;
        }
        return n4;
    }

    private long fnv1a(long l2, byte[] byArray, int n2, int n3) {
        for (int i2 = 0; i2 < n3; ++i2) {
            l2 ^= (long)byArray[i2 + n2] & 0xFFL;
            l2 *= 16777619L;
        }
        return l2;
    }

    protected void resetChecksum() {
        for (int i2 = 0; i2 < this.hashes.length; ++i2) {
            this.hashes[i2] = 2166136261L;
        }
        this.buffered = 0;
    }
}

