/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.File;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.util.SVNDoubleLock;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNLogType;

public class FSWriteLock {
    private static final Map ourThreadDBLocksCache = new SVNHashMap();
    private static final Map ourThreadRepositoryLocksCache = new SVNHashMap();
    private static final Map ourThreadLogLocksCache = new SVNHashMap();
    private static final int DB_LOCK = 1;
    private static final int LOGS_LOCK = 2;
    private static final int REPOS_LOCK = 3;
    private File myLockFile;
    private SVNDoubleLock myLock;
    private String myToken;
    private int myLockType;
    private boolean myIsShared;
    private int myReferencesCount = 0;

    private FSWriteLock(String string, File file, int n2, boolean bl2) {
        this.myToken = string;
        this.myLockFile = file;
        this.myLockType = n2;
        this.myIsShared = bl2;
    }

    public static synchronized FSWriteLock getWriteLockForDB(FSFS fSFS) {
        String string = fSFS.getUUID();
        FSWriteLock fSWriteLock = (FSWriteLock)ourThreadDBLocksCache.get(string);
        if (fSWriteLock == null) {
            fSWriteLock = new FSWriteLock(string, fSFS.getWriteLockFile(), 1, false);
            ourThreadDBLocksCache.put(string, fSWriteLock);
        }
        ++fSWriteLock.myReferencesCount;
        return fSWriteLock;
    }

    public static synchronized FSWriteLock getWriteLockForCurrentTxn(String string, FSFS fSFS) {
        String string2;
        FSWriteLock fSWriteLock;
        if (string == null || string.length() == 0) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.FS_NO_LOCK_TOKEN, "Incorrect lock token for current transaction"), SVNLogType.FSFS);
        }
        if ((fSWriteLock = (FSWriteLock)ourThreadDBLocksCache.get(string2 = fSFS.getUUID() + string)) == null) {
            fSWriteLock = new FSWriteLock(string2, fSFS.getTransactionCurrentLockFile(), 1, false);
            ourThreadDBLocksCache.put(string2, fSWriteLock);
        }
        ++fSWriteLock.myReferencesCount;
        return fSWriteLock;
    }

    public static synchronized FSWriteLock getWriteLockForTxn(String string, FSFS fSFS) {
        String string2;
        FSWriteLock fSWriteLock;
        if (string == null || string.length() == 0) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.FS_NO_LOCK_TOKEN, "Incorrect txn id while locking"), SVNLogType.FSFS);
        }
        if ((fSWriteLock = (FSWriteLock)ourThreadDBLocksCache.get(string2 = fSFS.getUUID() + string)) == null) {
            fSWriteLock = new FSWriteLock(string2, fSFS.getTransactionProtoRevLockFile(string), 1, false);
            ourThreadDBLocksCache.put(string2, fSWriteLock);
        }
        ++fSWriteLock.myReferencesCount;
        return fSWriteLock;
    }

    public static synchronized FSWriteLock getDBLogsLock(FSFS fSFS, boolean bl2) {
        String string = fSFS.getUUID();
        FSWriteLock fSWriteLock = (FSWriteLock)ourThreadLogLocksCache.get(string);
        if (fSWriteLock == null) {
            fSWriteLock = new FSWriteLock(string, fSFS.getDBLogsLockFile(), 2, !bl2);
            ourThreadLogLocksCache.put(string, fSWriteLock);
        }
        ++fSWriteLock.myReferencesCount;
        return fSWriteLock;
    }

    public synchronized void lock() {
        Object object;
        boolean bl2 = false;
        SVNException sVNException = null;
        if (this.myLock != null) {
            bl2 = true;
        }
        try {
            object = SVNFileType.getType(this.myLockFile);
            if (object == SVNFileType.UNKNOWN || object == SVNFileType.NONE) {
                SVNFileUtil.createEmptyFile(this.myLockFile);
            }
            this.myLock = SVNDoubleLock.obtain(this.myLockFile, !this.myIsShared);
        }
        catch (SVNException sVNException2) {
            this.unlock();
            bl2 = true;
            sVNException = sVNException2;
        }
        if (bl2) {
            object = sVNException == null ? "file already locked" : ((Throwable)sVNException).getMessage();
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Can''t get exclusive lock on file ''{0}'': {1}", this.myLockFile, object);
            SVNErrorManager.error(sVNErrorMessage, sVNException, SVNLogType.FSFS);
        }
    }

    public static synchronized void release(FSWriteLock fSWriteLock) {
        if (fSWriteLock == null) {
            return;
        }
        if (--fSWriteLock.myReferencesCount == 0) {
            if (fSWriteLock.myLockType == 1) {
                ourThreadDBLocksCache.remove(fSWriteLock.myToken);
            } else if (fSWriteLock.myLockType == 3) {
                ourThreadRepositoryLocksCache.remove(fSWriteLock.myToken);
            } else if (fSWriteLock.myLockType == 2) {
                ourThreadLogLocksCache.remove(fSWriteLock.myToken);
            }
        }
    }

    public synchronized void unlock() {
        if (this.myLock != null) {
            this.myLock.release();
            this.myLock = null;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{[");
        stringBuffer.append("File:");
        stringBuffer.append(this.myLockFile);
        stringBuffer.append("][");
        stringBuffer.append("RefCount:");
        stringBuffer.append(this.myReferencesCount);
        stringBuffer.append("][");
        stringBuffer.append("Token:");
        stringBuffer.append(this.myToken);
        stringBuffer.append("]}");
        return stringBuffer.toString();
    }
}

