/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaCombiner;
import org.tmatesoft.svn.core.internal.io.fs.FSClosestCopy;
import org.tmatesoft.svn.core.internal.io.fs.FSEntry;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSFile;
import org.tmatesoft.svn.core.internal.io.fs.FSPathChange;
import org.tmatesoft.svn.core.internal.io.fs.FSRepository;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionRoot;
import org.tmatesoft.svn.core.internal.io.fs.PathInfo;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNLocationEntry;
import org.tmatesoft.svn.core.io.diff.SVNDeltaGenerator;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.util.SVNLogType;

public class FSUpdateContext {
    private File myReportFile;
    private String myTarget;
    private OutputStream myReportOS;
    private FSFile myReportIS;
    private ISVNEditor myEditor;
    private long myTargetRevision;
    private SVNDepth myDepth;
    private PathInfo myCurrentPathInfo;
    private boolean ignoreAncestry;
    private boolean sendTextDeltas;
    private String myTargetPath;
    private boolean isSwitch;
    private boolean mySendCopyFromArgs;
    private FSRoot myTargetRoot;
    private LinkedList myRootsCache;
    private FSFS myFSFS;
    private FSRepository myRepository;
    private SVNDeltaGenerator myDeltaGenerator;
    private SVNDeltaCombiner myDeltaCombiner;

    public FSUpdateContext(FSRepository fSRepository, FSFS fSFS, long l2, File file, String string, String string2, boolean bl2, SVNDepth sVNDepth, boolean bl3, boolean bl4, boolean bl5, ISVNEditor iSVNEditor) {
        this.myRepository = fSRepository;
        this.myFSFS = fSFS;
        this.myTargetRevision = l2;
        this.myReportFile = file;
        this.myTarget = string;
        this.myEditor = iSVNEditor;
        this.myDepth = sVNDepth;
        this.ignoreAncestry = bl3;
        this.sendTextDeltas = bl4;
        this.myTargetPath = string2;
        this.isSwitch = bl2;
        this.mySendCopyFromArgs = bl5;
    }

    public void reset(FSRepository fSRepository, FSFS fSFS, long l2, File file, String string, String string2, boolean bl2, SVNDepth sVNDepth, boolean bl3, boolean bl4, boolean bl5, ISVNEditor iSVNEditor) {
        this.dispose();
        this.myRepository = fSRepository;
        this.myFSFS = fSFS;
        this.myTargetRevision = l2;
        this.myReportFile = file;
        this.myTarget = string;
        this.myEditor = iSVNEditor;
        this.myDepth = sVNDepth;
        this.ignoreAncestry = bl3;
        this.sendTextDeltas = bl4;
        this.myTargetPath = string2;
        this.isSwitch = bl2;
        this.mySendCopyFromArgs = bl5;
    }

    public void setTargetRoot(FSRoot fSRoot) {
        this.myTargetRoot = fSRoot;
    }

    public OutputStream getReportFileForWriting() {
        if (this.myReportOS == null) {
            this.myReportOS = SVNFileUtil.openFileForWriting(this.myReportFile);
        }
        return this.myReportOS;
    }

    private boolean isIgnoreAncestry() {
        return this.ignoreAncestry;
    }

    private boolean isSwitch() {
        return this.isSwitch;
    }

    private boolean isSendTextDeltas() {
        return this.sendTextDeltas;
    }

    private String getReportTarget() {
        return this.myTarget;
    }

    private String getReportTargetPath() {
        return this.myTargetPath;
    }

    public void dispose() {
        SVNFileUtil.closeFile(this.myReportOS);
        this.myReportOS = null;
        if (this.myReportIS != null) {
            this.myReportIS.close();
            this.myReportIS = null;
        }
        if (this.myReportFile != null) {
            SVNFileUtil.deleteFile(this.myReportFile);
            this.myReportFile = null;
        }
        if (this.myDeltaCombiner != null) {
            this.myDeltaCombiner.reset();
        }
        this.myTargetRoot = null;
        this.myRootsCache = null;
    }

    private ISVNEditor getEditor() {
        return this.myEditor;
    }

    private long getTargetRevision() {
        return this.myTargetRevision;
    }

    private PathInfo getNextPathInfo() {
        if (this.myReportIS == null) {
            this.myReportIS = new FSFile(this.myReportFile);
        }
        this.myCurrentPathInfo = this.myReportIS.readPathInfoFromReportFile();
        return this.myCurrentPathInfo;
    }

    private PathInfo getCurrentPathInfo() {
        return this.myCurrentPathInfo;
    }

    private FSRoot getTargetRoot() {
        if (this.myTargetRoot == null) {
            this.myTargetRoot = this.myFSFS.createRevisionRoot(this.myTargetRevision);
        }
        return this.myTargetRoot;
    }

    private LinkedList getRootsCache() {
        if (this.myRootsCache == null) {
            this.myRootsCache = new LinkedList();
        }
        return this.myRootsCache;
    }

    private FSRevisionRoot getSourceRoot(long l2) {
        int n2;
        LinkedList linkedList = this.getRootsCache();
        FSRevisionRoot fSRevisionRoot = null;
        for (n2 = 0; n2 < linkedList.size() && n2 < 10; ++n2) {
            fSRevisionRoot = (FSRevisionRoot)this.myRootsCache.get(n2);
            if (fSRevisionRoot.getRevision() == l2) {
                if (n2 == 0) break;
                this.myRootsCache.remove(n2);
                this.myRootsCache.addFirst(fSRevisionRoot);
                break;
            }
            fSRevisionRoot = null;
        }
        if (fSRevisionRoot == null) {
            if (n2 == 10) {
                this.myRootsCache.removeLast();
            }
            fSRevisionRoot = this.myFSFS.createRevisionRoot(l2);
            this.myRootsCache.addFirst(fSRevisionRoot);
        }
        return fSRevisionRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drive() {
        Object object;
        Object object2;
        SVNErrorMessage sVNErrorMessage;
        OutputStream outputStream = this.getReportFileForWriting();
        try {
            outputStream.write(45);
        }
        catch (IOException iOException) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage());
            SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.FSFS);
        }
        finally {
            SVNFileUtil.closeFile(outputStream);
            this.myReportOS = null;
        }
        PathInfo pathInfo = null;
        try {
            pathInfo = this.getNextPathInfo();
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage2 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage());
            SVNErrorManager.error(sVNErrorMessage2, iOException, SVNLogType.FSFS);
        }
        if (pathInfo == null || !pathInfo.getPath().equals(this.getReportTarget()) || pathInfo.getLinkPath() != null || FSRepository.isInvalidRevision(pathInfo.getRevision())) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.REPOS_BAD_REVISION_REPORT, "Invalid report for top level of working copy");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        long l2 = pathInfo.getRevision();
        PathInfo pathInfo2 = null;
        try {
            pathInfo2 = this.getNextPathInfo();
        }
        catch (IOException iOException) {
            object2 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage());
            SVNErrorManager.error((SVNErrorMessage)object2, iOException, SVNLogType.FSFS);
        }
        if (pathInfo2 != null && pathInfo2.getPath().equals(this.getReportTarget())) {
            if ("".equals(this.getReportTarget())) {
                object = SVNErrorMessage.create(SVNErrorCode.REPOS_BAD_REVISION_REPORT, "Two top-level reports with no target");
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
            }
            if (pathInfo2.getRevision() < 0L) {
                pathInfo2.myDepth = pathInfo.getDepth();
            }
            pathInfo = pathInfo2;
            try {
                this.getNextPathInfo();
            }
            catch (IOException iOException) {
                object2 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage());
                SVNErrorManager.error((SVNErrorMessage)object2, iOException, SVNLogType.FSFS);
            }
        }
        object = this.getReportTargetPath();
        object2 = this.myRepository != null ? SVNPathUtil.getAbsolutePath(SVNPathUtil.append(this.myRepository.getRepositoryPath(""), this.getReportTarget())) : SVNPathUtil.getAbsolutePath(this.getReportTarget());
        FSEntry fSEntry = this.fakeDirEntry((String)object, this.getTargetRoot());
        FSRevisionRoot fSRevisionRoot = this.getSourceRoot(l2);
        FSEntry fSEntry2 = this.fakeDirEntry((String)object2, fSRevisionRoot);
        if (FSRepository.isValidRevision(pathInfo.getRevision()) && pathInfo.getLinkPath() == null && fSEntry2 == null) {
            object2 = null;
        }
        if ("".equals(this.getReportTarget()) && fSEntry == null) {
            SVNErrorMessage sVNErrorMessage3 = SVNErrorMessage.create(SVNErrorCode.FS_PATH_SYNTAX, "Target path ''{0}'' does not exist", (Object)this.getReportTargetPath());
            SVNErrorManager.error(sVNErrorMessage3, SVNLogType.FSFS);
        } else if ("".equals(this.getReportTarget()) && (fSEntry2 == null || fSEntry2.getType() != SVNNodeKind.DIR || fSEntry.getType() != SVNNodeKind.DIR)) {
            SVNErrorMessage sVNErrorMessage4 = SVNErrorMessage.create(SVNErrorCode.FS_PATH_SYNTAX, "Cannot replace a directory from within");
            SVNErrorManager.error(sVNErrorMessage4, SVNLogType.FSFS);
        }
        if (this.myDeltaGenerator == null) {
            this.myDeltaGenerator = new SVNDeltaGenerator();
        }
        if (this.myDeltaCombiner == null) {
            this.myDeltaCombiner = new SVNDeltaCombiner();
        }
        this.getEditor().targetRevision(this.getTargetRevision());
        this.getEditor().openRoot(l2);
        if ("".equals(this.getReportTarget())) {
            this.diffDirs(l2, (String)object2, (String)object, "", pathInfo.isStartEmpty(), pathInfo.getDepth(), this.myDepth);
        } else {
            this.updateEntry(l2, (String)object2, fSEntry2, (String)object, fSEntry, this.getReportTarget(), pathInfo, pathInfo.getDepth(), this.myDepth);
        }
        this.getEditor().closeDir();
        this.getEditor().closeEdit();
    }

    private void diffDirs(long l2, String string, String string2, String string3, boolean bl2, SVNDepth sVNDepth, SVNDepth sVNDepth2) {
        this.diffProplists(l2, bl2 ? null : string, string3, string2, null, true);
        SVNHashMap sVNHashMap = null;
        if (sVNDepth2.compareTo(SVNDepth.EMPTY) > 0 || sVNDepth2 == SVNDepth.UNKNOWN) {
            Object object;
            String string4;
            Object object2;
            Object object3;
            Object object42;
            Object object5;
            Object object6;
            if (string != null && !bl2) {
                object6 = this.getSourceRoot(l2);
                object5 = ((FSRoot)object6).getRevisionNode(string);
                sVNHashMap = new SVNHashMap(((FSRevisionNode)object5).getDirEntries(this.myFSFS));
            }
            object6 = this.getTargetRoot().getRevisionNode(string2);
            object5 = new SVNHashMap(((FSRevisionNode)object6).getDirEntries(this.myFSFS));
            while ((object42 = (String)(object3 = this.fetchPathInfo(string3))[0]) != null) {
                FSEntry fSEntry;
                object2 = (PathInfo)object3[1];
                if (object2 != null && FSRepository.isInvalidRevision(((PathInfo)object2).getRevision()) && ((PathInfo)object2).getDepth() != SVNDepth.EXCLUDE) {
                    if (sVNHashMap == null) continue;
                    sVNHashMap.remove(object42);
                    continue;
                }
                string4 = SVNPathUtil.append(string3, (String)object42);
                String string5 = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(string2, (String)object42));
                object = (FSEntry)object5.get(object42);
                String string6 = string != null ? SVNPathUtil.getAbsolutePath(SVNPathUtil.append(string, (String)object42)) : null;
                FSEntry fSEntry2 = fSEntry = sVNHashMap != null ? (FSEntry)sVNHashMap.get(object42) : null;
                if (!(object2 != null && ((PathInfo)object2).getDepth() == SVNDepth.EXCLUDE || sVNDepth2 == SVNDepth.FILES && (object != null && ((FSEntry)object).getType() == SVNNodeKind.DIR || fSEntry != null && fSEntry.getType() == SVNNodeKind.DIR))) {
                    this.updateEntry(l2, string6, fSEntry, string5, (FSEntry)object, string4, (PathInfo)object2, object2 != null ? ((PathInfo)object2).getDepth() : this.getDepthBelow(sVNDepth), this.getDepthBelow(sVNDepth2));
                }
                object5.remove(object42);
                if (sVNHashMap == null || object2 != null && ((PathInfo)object2).getDepth() == SVNDepth.EXCLUDE && object == null) continue;
                sVNHashMap.remove(object42);
            }
            if (sVNHashMap != null) {
                object3 = new ArrayList(sVNHashMap.values()).toArray(new FSEntry[sVNHashMap.size()]);
                for (int i2 = 0; i2 < ((Object)object3).length; ++i2) {
                    object2 = object3[i2];
                    if (object5.get(((FSEntry)object2).getName()) != null || ((FSEntry)object2).getType() == SVNNodeKind.FILE && sVNDepth.compareTo(SVNDepth.FILES) < 0 || ((FSEntry)object2).getType() == SVNNodeKind.DIR && (sVNDepth.compareTo(SVNDepth.IMMEDIATES) < 0 || sVNDepth2 == SVNDepth.FILES)) continue;
                    string4 = SVNPathUtil.append(string3, ((FSEntry)object2).getName());
                    long l3 = this.getDeletedRevision(SVNPathUtil.append(string2, ((FSEntry)object2).getName()), l2, this.getTargetRevision());
                    this.getEditor().deleteEntry(string4, l3);
                }
            }
            for (Object object42 : object5.values()) {
                object2 = null;
                string4 = null;
                if (!this.isDepthUpgrade(sVNDepth, sVNDepth2, ((FSEntry)object42).getType())) {
                    if (((FSEntry)object42).getType() == SVNNodeKind.FILE && sVNDepth2 == SVNDepth.UNKNOWN && sVNDepth.compareTo(SVNDepth.FILES) < 0 || ((FSEntry)object42).getType() == SVNNodeKind.DIR && (sVNDepth.compareTo(SVNDepth.IMMEDIATES) < 0 || sVNDepth2 == SVNDepth.FILES)) continue;
                    object2 = sVNHashMap != null ? (FSEntry)sVNHashMap.get(((FSEntry)object42).getName()) : null;
                    string4 = object2 != null ? SVNPathUtil.getAbsolutePath(SVNPathUtil.append(string, ((FSEntry)object42).getName())) : null;
                }
                String string7 = SVNPathUtil.append(string3, ((FSEntry)object42).getName());
                object = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(string2, ((FSEntry)object42).getName()));
                this.updateEntry(l2, string4, (FSEntry)object2, (String)object, (FSEntry)object42, string7, null, this.getDepthBelow(sVNDepth), this.getDepthBelow(sVNDepth2));
            }
        }
    }

    private boolean isDepthUpgrade(SVNDepth sVNDepth, SVNDepth sVNDepth2, SVNNodeKind sVNNodeKind) {
        if (sVNDepth2 == SVNDepth.UNKNOWN || sVNDepth == SVNDepth.IMMEDIATES) {
            return false;
        }
        int n2 = sVNDepth2.compareTo(sVNDepth);
        if (n2 <= 0) {
            return false;
        }
        if (sVNNodeKind == SVNNodeKind.FILE && sVNDepth == SVNDepth.FILES) {
            return false;
        }
        return sVNNodeKind != SVNNodeKind.DIR || sVNDepth != SVNDepth.EMPTY || sVNDepth2 != SVNDepth.FILES;
    }

    private void diffFiles(long l2, String string, String string2, String string3, String string4) {
        this.diffProplists(l2, string, string3, string2, string4, false);
        String string5 = null;
        FSRevisionRoot fSRevisionRoot = null;
        if (string != null) {
            fSRevisionRoot = this.getSourceRoot(l2);
            boolean bl2 = false;
            bl2 = this.isIgnoreAncestry() ? FSRepositoryUtil.checkFilesDifferent(fSRevisionRoot, string, this.getTargetRoot(), string2, this.myDeltaCombiner) : FSRepositoryUtil.areFileContentsChanged(fSRevisionRoot, string, this.getTargetRoot(), string2);
            if (!bl2) {
                return;
            }
            FSRevisionNode fSRevisionNode = fSRevisionRoot.getRevisionNode(string);
            string5 = fSRevisionNode.getFileMD5Checksum();
        }
        FSRepositoryUtil.sendTextDelta(this.getEditor(), string3, string, string5, fSRevisionRoot, string2, this.getTargetRoot(), this.isSendTextDeltas(), this.myDeltaCombiner, this.myDeltaGenerator, this.myFSFS);
    }

    private void updateEntry(long l2, String string, FSEntry fSEntry, String string2, FSEntry fSEntry2, String string3, PathInfo pathInfo, SVNDepth sVNDepth, SVNDepth sVNDepth2) {
        Object object;
        Object object2;
        if (pathInfo != null && pathInfo.getLinkPath() != null && !this.isSwitch()) {
            string2 = pathInfo.getLinkPath();
            fSEntry2 = this.fakeDirEntry(string2, this.getTargetRoot());
        }
        if (pathInfo != null && FSRepository.isInvalidRevision(pathInfo.getRevision())) {
            string = null;
            fSEntry = null;
        } else if (pathInfo != null && string != null) {
            string = pathInfo.getLinkPath() != null ? pathInfo.getLinkPath() : string;
            l2 = pathInfo.getRevision();
            object2 = this.getSourceRoot(l2);
            fSEntry = this.fakeDirEntry(string, (FSRoot)object2);
        }
        if (string != null && fSEntry == null) {
            object2 = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "Working copy path ''{0}'' does not exist in repository", (Object)string3);
            SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.FSFS);
        }
        boolean bl2 = false;
        if (fSEntry != null && fSEntry2 != null && fSEntry.getType() == fSEntry2.getType()) {
            int n2 = fSEntry.getId().compareTo(fSEntry2.getId());
            if (!(n2 != 0 || PathInfo.isRelevant(this.getCurrentPathInfo(), string3) || sVNDepth2.compareTo(sVNDepth) > 0 && fSEntry2.getType() != SVNNodeKind.FILE)) {
                if (pathInfo == null) {
                    return;
                }
                if (!pathInfo.isStartEmpty()) {
                    if (pathInfo.getLockToken() == null) {
                        return;
                    }
                    object = this.myFSFS.getLock(string2, false, false);
                    if (object != null && ((SVNLock)object).getID().equals(pathInfo.getLockToken())) {
                        return;
                    }
                }
            }
            boolean bl3 = bl2 = n2 != -1 || this.isIgnoreAncestry();
        }
        if (fSEntry != null && !bl2) {
            SVNNodeKind sVNNodeKind;
            long l3 = this.getDeletedRevision(string2, l2, this.getTargetRevision());
            if (!SVNRevision.isValidRevisionNumber(l3) && (sVNNodeKind = this.getTargetRoot().checkNodeKind(string2)) != SVNNodeKind.NONE) {
                l3 = this.getTargetRevision() - 1L;
            }
            this.getEditor().deleteEntry(string3, l3);
            string = null;
        }
        if (fSEntry2 == null) {
            this.skipPathInfo(string3);
            return;
        }
        if (fSEntry2.getType() == SVNNodeKind.DIR) {
            if (bl2) {
                this.getEditor().openDir(string3, l2);
            } else {
                this.getEditor().addDir(string3, null, -1L);
            }
            this.diffDirs(l2, string, string2, string3, pathInfo != null ? pathInfo.isStartEmpty() : false, sVNDepth, sVNDepth2);
            this.getEditor().closeDir();
        } else {
            if (bl2) {
                this.getEditor().openFile(string3, l2);
                this.diffFiles(l2, string, string2, string3, pathInfo != null ? pathInfo.getLockToken() : null);
            } else {
                SVNLocationEntry sVNLocationEntry = this.addFileSmartly(string3, string2);
                object = sVNLocationEntry.getPath();
                long l4 = sVNLocationEntry.getRevision();
                if (object == null) {
                    this.diffFiles(l2, string, string2, string3, pathInfo != null ? pathInfo.getLockToken() : null);
                } else {
                    this.diffFiles(l4, (String)object, string2, string3, pathInfo != null ? pathInfo.getLockToken() : null);
                }
            }
            FSRevisionNode fSRevisionNode = this.getTargetRoot().getRevisionNode(string2);
            object = fSRevisionNode.getFileMD5Checksum();
            this.getEditor().closeFile(string3, (String)object);
        }
    }

    private long getDeletedRevision(String string, long l2, long l3) {
        if (this.isTransactionTarget()) {
            return this.getTargetRevision();
        }
        return this.myFSFS.getDeletedRevision(string, l2, l3);
    }

    private boolean isTransactionTarget() {
        return this.getTargetRoot() instanceof FSTransactionRoot;
    }

    private SVNLocationEntry addFileSmartly(String string, String string2) {
        String string3 = null;
        long l2 = -1L;
        if (this.mySendCopyFromArgs) {
            FSTransactionRoot fSTransactionRoot;
            FSPathChange fSPathChange;
            if (!this.isTransactionTarget()) {
                FSClosestCopy fSClosestCopy = ((FSRevisionRoot)this.getTargetRoot()).getClosestCopy(string2);
                if (fSClosestCopy != null) {
                    FSRevisionRoot fSRevisionRoot = fSClosestCopy.getRevisionRoot();
                    String string4 = fSClosestCopy.getPath();
                    if (string2.equals(string4)) {
                        FSRevisionNode fSRevisionNode = fSRevisionRoot.getRevisionNode(string4);
                        string3 = fSRevisionNode.getCopyFromPath();
                        l2 = fSRevisionNode.getCopyFromRevision();
                    }
                }
            } else if (this.isTransactionTarget() && (fSPathChange = (FSPathChange)(fSTransactionRoot = (FSTransactionRoot)this.getTargetRoot()).getChangedPaths().get(string2)) != null) {
                string3 = fSPathChange.getCopyPath();
                l2 = fSPathChange.getCopyRevision();
            }
        }
        this.myEditor.addFile(string, string3, l2);
        return new SVNLocationEntry(l2, string3);
    }

    private Map computeMetaProperties(long l2) {
        SVNHashMap sVNHashMap = new SVNHashMap();
        if (FSRepository.isValidRevision(l2)) {
            SVNProperties sVNProperties = this.myFSFS.compoundMetaProperties(l2);
            sVNHashMap.put("svn:entry:committed-rev", sVNProperties.getSVNPropertyValue("svn:entry:committed-rev"));
            sVNHashMap.put("svn:entry:committed-date", sVNProperties.getSVNPropertyValue("svn:entry:committed-date"));
            sVNHashMap.put("svn:entry:last-author", sVNProperties.getSVNPropertyValue("svn:entry:last-author"));
            sVNHashMap.put("svn:entry:uuid", sVNProperties.getSVNPropertyValue("svn:entry:uuid"));
        } else if (!FSRepository.isValidRevision(l2) && this.isTransactionTarget()) {
            FSTransactionRoot fSTransactionRoot = (FSTransactionRoot)this.getTargetRoot();
            SVNProperties sVNProperties = this.myFSFS.getTransactionProperties(fSTransactionRoot.getTxnID());
            sVNHashMap.put("svn:entry:committed-rev", SVNPropertyValue.create(Long.toString(this.getTargetRevision())));
            sVNHashMap.put("svn:entry:committed-date", sVNProperties.getSVNPropertyValue("svn:date"));
            sVNHashMap.put("svn:entry:last-author", sVNProperties.getSVNPropertyValue("svn:author"));
            sVNHashMap.put("svn:entry:uuid", SVNPropertyValue.create(this.myFSFS.getUUID()));
        } else {
            sVNHashMap = null;
        }
        return sVNHashMap;
    }

    private void diffProplists(long l2, String string, String string2, String string3, String string4, boolean bl2) {
        Object object;
        Object object2;
        Object object3;
        FSRevisionNode fSRevisionNode = this.getTargetRoot().getRevisionNode(string3);
        long l3 = fSRevisionNode.getCreatedRevision();
        Map map = this.computeMetaProperties(l3);
        if (map != null) {
            SVNPropertyValue sVNPropertyValue;
            object3 = (SVNPropertyValue)map.get("svn:entry:committed-rev");
            this.changeProperty(string2, "svn:entry:committed-rev", (SVNPropertyValue)object3, bl2);
            object2 = (SVNPropertyValue)map.get("svn:entry:committed-date");
            if (object2 != null || string != null) {
                this.changeProperty(string2, "svn:entry:committed-date", (SVNPropertyValue)object2, bl2);
            }
            if ((object = (SVNPropertyValue)map.get("svn:entry:last-author")) != null || string != null) {
                this.changeProperty(string2, "svn:entry:last-author", (SVNPropertyValue)object, bl2);
            }
            if ((sVNPropertyValue = (SVNPropertyValue)map.get("svn:entry:uuid")) != null || string != null) {
                this.changeProperty(string2, "svn:entry:uuid", sVNPropertyValue, bl2);
            }
        }
        if (!(string4 == null || (object3 = this.myFSFS.getLockHelper(string3, false)) != null && string4.equals(((SVNLock)object3).getID()))) {
            this.changeProperty(string2, "svn:entry:lock-token", null, bl2);
        }
        object3 = null;
        if (string != null) {
            boolean bl3;
            object2 = this.getSourceRoot(l2);
            object = ((FSRoot)object2).getRevisionNode(string);
            boolean bl4 = bl3 = !FSRepositoryUtil.arePropertiesEqual((FSRevisionNode)object, fSRevisionNode);
            if (!bl3) {
                return;
            }
            object3 = ((FSRevisionNode)object).getProperties(this.myFSFS);
        } else {
            object3 = new SVNProperties();
        }
        object2 = fSRevisionNode.getProperties(this.myFSFS);
        object = FSRepositoryUtil.getPropsDiffs((SVNProperties)object3, (SVNProperties)object2);
        Object[] objectArray = ((SVNProperties)object).nameSet().toArray();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            String string5 = (String)objectArray[i2];
            this.changeProperty(string2, string5, ((SVNProperties)object).getSVNPropertyValue(string5), bl2);
        }
    }

    private SVNDepth getDepthBelow(SVNDepth sVNDepth) {
        return sVNDepth == SVNDepth.IMMEDIATES ? SVNDepth.EMPTY : sVNDepth;
    }

    private Object[] fetchPathInfo(String string) {
        Object[] objectArray = new Object[2];
        PathInfo pathInfo = this.getCurrentPathInfo();
        if (!PathInfo.isRelevant(pathInfo, string)) {
            objectArray[0] = null;
            objectArray[1] = null;
        } else {
            String string2;
            String string3 = string2 = "".equals(string) ? pathInfo.getPath() : pathInfo.getPath().substring(string.length() + 1);
            if (string2.indexOf(47) != -1) {
                objectArray[0] = string2.substring(0, string2.indexOf(47));
                objectArray[1] = null;
            } else {
                objectArray[0] = string2;
                objectArray[1] = pathInfo;
                try {
                    this.getNextPathInfo();
                }
                catch (IOException iOException) {
                    SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage());
                    SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
                }
            }
        }
        return objectArray;
    }

    private void changeProperty(String string, String string2, SVNPropertyValue sVNPropertyValue, boolean bl2) {
        if (bl2) {
            this.getEditor().changeDirProperty(string2, sVNPropertyValue);
        } else {
            this.getEditor().changeFileProperty(string, string2, sVNPropertyValue);
        }
    }

    private FSEntry fakeDirEntry(String string, FSRoot fSRoot) {
        if (fSRoot.checkNodeKind(string) == SVNNodeKind.NONE) {
            return null;
        }
        FSRevisionNode fSRevisionNode = fSRoot.getRevisionNode(string);
        FSEntry fSEntry = new FSEntry(fSRevisionNode.getId(), fSRevisionNode.getType(), SVNPathUtil.tail(fSRevisionNode.getCreatedPath()));
        return fSEntry;
    }

    private void skipPathInfo(String string) {
        while (PathInfo.isRelevant(this.getCurrentPathInfo(), string)) {
            try {
                this.getNextPathInfo();
            }
            catch (IOException iOException) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage());
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
        }
    }

    private void writeSingleString(String string, OutputStream outputStream) {
        if (string != null) {
            byte[] byArray = string.getBytes("UTF-8");
            outputStream.write(43);
            outputStream.write(String.valueOf(byArray.length).getBytes("UTF-8"));
            outputStream.write(58);
            outputStream.write(byArray);
        } else {
            outputStream.write(45);
        }
    }

    public void writePathInfoToReportFile(String string, String string2, String string3, long l2, boolean bl2, SVNDepth sVNDepth) {
        Object object;
        if (sVNDepth == null || sVNDepth == SVNDepth.UNKNOWN) {
            object = SVNErrorMessage.create(SVNErrorCode.REPOS_BAD_ARGS, "Unsupported report depth ''{0}''", (Object)(sVNDepth != null ? sVNDepth.getName() : "null"));
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        object = SVNPathUtil.append(this.getReportTarget(), string);
        String string4 = FSRepository.isValidRevision(l2) ? "+" + String.valueOf(l2) + ":" : "-";
        String string5 = "-";
        if (sVNDepth == SVNDepth.EXCLUDE || sVNDepth == SVNDepth.EMPTY || sVNDepth == SVNDepth.FILES || sVNDepth == SVNDepth.IMMEDIATES) {
            string5 = "+" + this.getDepthLetter(sVNDepth);
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.writeSingleString((String)object, byteArrayOutputStream);
            this.writeSingleString(string2, byteArrayOutputStream);
            byteArrayOutputStream.write(string4.getBytes("UTF-8"));
            byteArrayOutputStream.write(string5.getBytes("UTF-8"));
            byteArrayOutputStream.write(bl2 ? 43 : 45);
            this.writeSingleString(string3, byteArrayOutputStream);
            OutputStream outputStream = this.getReportFileForWriting();
            outputStream.write(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage());
            SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.FSFS);
        }
    }

    public String getDepthLetter(SVNDepth sVNDepth) {
        if (sVNDepth == SVNDepth.EXCLUDE) {
            return "X";
        }
        if (sVNDepth == SVNDepth.EMPTY) {
            return "E";
        }
        if (sVNDepth == SVNDepth.FILES) {
            return "F";
        }
        if (sVNDepth == SVNDepth.IMMEDIATES) {
            return "M";
        }
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.REPOS_BAD_ARGS, "Unsupported report depth ''{0}''", (Object)SVNDepth.asString(sVNDepth));
        SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        return null;
    }
}

