/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.io.fs.CountingOutputStream;
import org.tmatesoft.svn.core.internal.io.fs.FSCopyInheritance;
import org.tmatesoft.svn.core.internal.io.fs.FSEntry;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSFile;
import org.tmatesoft.svn.core.internal.io.fs.FSHooks;
import org.tmatesoft.svn.core.internal.io.fs.FSID;
import org.tmatesoft.svn.core.internal.io.fs.FSParentPath;
import org.tmatesoft.svn.core.internal.io.fs.FSPathChange;
import org.tmatesoft.svn.core.internal.io.fs.FSPathChangeKind;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.io.fs.FSRepresentation;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionInfo;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionRoot$HashRepresentationStream;
import org.tmatesoft.svn.core.internal.io.fs.index.FSFnv1aOutputStream;
import org.tmatesoft.svn.core.internal.io.fs.index.FSL2PProtoIndex;
import org.tmatesoft.svn.core.internal.io.fs.index.FSP2LEntry;
import org.tmatesoft.svn.core.internal.io.fs.index.FSP2LProtoIndex;
import org.tmatesoft.svn.core.internal.io.fs.index.FSP2LProtoIndex$ItemType;
import org.tmatesoft.svn.core.internal.io.fs.index.FSTransactionItemIndex;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNWCProperties;
import org.tmatesoft.svn.util.SVNLogType;

public class FSTransactionRoot
extends FSRoot {
    public static final int SVN_FS_TXN_CHECK_OUT_OF_DATENESS = 1;
    public static final int SVN_FS_TXN_CHECK_LOCKS = 2;
    private String myTxnID;
    private int myTxnFlags;
    private File myTxnChangesFile;
    private File myTxnRevFile;
    private long myBaseRevision;

    public FSTransactionRoot(FSFS fSFS, String string, long l2, int n2) {
        super(fSFS);
        this.myTxnID = string;
        this.myTxnFlags = n2;
        this.myBaseRevision = l2;
    }

    @Override
    public long getRevision() {
        return this.myBaseRevision;
    }

    @Override
    public FSCopyInheritance getCopyInheritance(FSParentPath fSParentPath) {
        Serializable serializable;
        if (fSParentPath == null || fSParentPath.getParent() == null || this.myTxnID == null) {
            serializable = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "FATAL error: invalid txn name or child");
            SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.FSFS);
        }
        serializable = fSParentPath.getRevNode().getId();
        FSID fSID = fSParentPath.getParent().getRevNode().getId();
        String string = ((FSID)serializable).getCopyID();
        String string2 = fSID.getCopyID();
        if (((FSID)serializable).isTxn()) {
            return new FSCopyInheritance(1, null);
        }
        FSCopyInheritance fSCopyInheritance = new FSCopyInheritance(2, null);
        if (string.compareTo("0") == 0) {
            return fSCopyInheritance;
        }
        if (string.compareTo(string2) == 0) {
            return fSCopyInheritance;
        }
        long l2 = fSParentPath.getRevNode().getCopyRootRevision();
        String string3 = fSParentPath.getRevNode().getCopyRootPath();
        FSRevisionRoot fSRevisionRoot = this.getOwner().createRevisionRoot(l2);
        FSRevisionNode fSRevisionNode = fSRevisionRoot.getRevisionNode(string3);
        FSID fSID2 = fSRevisionNode.getId();
        if (fSID2.compareTo((FSID)serializable) == -1) {
            return fSCopyInheritance;
        }
        String string4 = fSParentPath.getRevNode().getCreatedPath();
        if (string4.compareTo(fSParentPath.getAbsPath()) == 0) {
            fSCopyInheritance.setStyle(1);
            return fSCopyInheritance;
        }
        fSCopyInheritance.setStyle(3);
        fSCopyInheritance.setCopySourcePath(string4);
        return fSCopyInheritance;
    }

    @Override
    public FSRevisionNode getRootRevisionNode() {
        if (this.myRootRevisionNode == null) {
            FSTransactionInfo fSTransactionInfo = this.getTxn();
            this.myRootRevisionNode = this.getOwner().getRevisionNode(fSTransactionInfo.getRootID());
        }
        return this.myRootRevisionNode;
    }

    public FSRevisionNode getTxnBaseRootNode() {
        FSTransactionInfo fSTransactionInfo = this.getTxn();
        FSRevisionNode fSRevisionNode = this.getOwner().getRevisionNode(fSTransactionInfo.getBaseID());
        return fSRevisionNode;
    }

    public FSTransactionInfo getTxn() {
        FSID fSID = FSID.createTxnId("0", "0", this.myTxnID);
        FSRevisionNode fSRevisionNode = this.getOwner().getRevisionNode(fSID);
        FSTransactionInfo fSTransactionInfo = new FSTransactionInfo(fSRevisionNode.getId(), fSRevisionNode.getPredecessorId());
        return fSTransactionInfo;
    }

    @Override
    public Map getChangedPaths() {
        try (FSFile fSFile = this.getOwner().getTransactionChangesFile(this.myTxnID);){
            Map map = this.fetchAllChanges(fSFile, false);
            return map;
        }
    }

    public int getTxnFlags() {
        return this.myTxnFlags;
    }

    public void setTxnFlags(int n2) {
        this.myTxnFlags = n2;
    }

    public String getTxnID() {
        return this.myTxnID;
    }

    public SVNProperties unparseDirEntries(Map map) {
        SVNProperties sVNProperties = new SVNProperties();
        for (String string : map.keySet()) {
            FSEntry fSEntry = (FSEntry)map.get(string);
            String string2 = fSEntry.toString();
            sVNProperties.put(string, string2);
        }
        return sVNProperties;
    }

    public static FSTransactionInfo beginTransactionForCommit(long l2, SVNProperties sVNProperties, FSFS fSFS) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("mergeinfo");
        String string = sVNProperties.getStringValue("svn:author");
        if (fSFS != null && fSFS.isHooksEnabled()) {
            FSHooks.runStartCommitHook(fSFS.getRepositoryRoot(), string, arrayList);
        }
        FSTransactionInfo fSTransactionInfo = FSTransactionRoot.beginTransaction(l2, 2, fSFS);
        fSFS.changeTransactionProperties(fSTransactionInfo.getTxnId(), sVNProperties);
        return fSTransactionInfo;
    }

    public static FSTransactionInfo beginTransaction(long l2, int n2, FSFS fSFS) {
        FSTransactionInfo fSTransactionInfo = FSTransactionRoot.createTxn(l2, fSFS);
        String string = SVNDate.formatDate(new Date(System.currentTimeMillis()));
        fSFS.setTransactionProperty(fSTransactionInfo.getTxnId(), "svn:date", SVNPropertyValue.create(string));
        if ((n2 & 1) != 0) {
            fSFS.setTransactionProperty(fSTransactionInfo.getTxnId(), "svn:check-ood", SVNPropertyValue.create(Boolean.TRUE.toString()));
        }
        if ((n2 & 2) != 0) {
            fSFS.setTransactionProperty(fSTransactionInfo.getTxnId(), "svn:check-locks", SVNPropertyValue.create(Boolean.TRUE.toString()));
        }
        return fSTransactionInfo;
    }

    private static FSTransactionInfo createTxn(long l2, FSFS fSFS) {
        String string = null;
        string = fSFS.getDBFormat() >= 3 ? FSTransactionRoot.createTxnDir(l2, fSFS) : FSTransactionRoot.createPre15TxnDir(l2, fSFS);
        FSTransactionInfo fSTransactionInfo = new FSTransactionInfo(l2, string);
        FSRevisionRoot fSRevisionRoot = fSFS.createRevisionRoot(l2);
        FSRevisionNode fSRevisionNode = fSRevisionRoot.getRootRevisionNode();
        fSFS.createNewTxnNodeRevisionFromRevision(string, fSRevisionNode);
        SVNFileUtil.createEmptyFile(fSFS.getTransactionProtoRevFile(fSTransactionInfo.getTxnId()));
        SVNFileUtil.createEmptyFile(fSFS.getTransactionProtoRevLockFile(fSTransactionInfo.getTxnId()));
        SVNFileUtil.createEmptyFile(new File(fSFS.getTransactionDir(fSTransactionInfo.getTxnId()), "changes"));
        fSFS.writeNextIDs(string, "0", "0");
        return fSTransactionInfo;
    }

    private static String createTxnDir(long l2, FSFS fSFS) {
        String string = fSFS.getAndIncrementTxnKey();
        string = String.valueOf(l2) + "-" + string;
        File file = fSFS.getTransactionsParentDir();
        File file2 = new File(file, string + ".txn");
        file2.mkdirs();
        return string;
    }

    private static String createPre15TxnDir(long l2, FSFS fSFS) {
        File file = fSFS.getTransactionsParentDir();
        File file2 = null;
        for (int i2 = 1; i2 < 99999; ++i2) {
            String string = String.valueOf(l2) + "-" + String.valueOf(i2);
            file2 = new File(file, string + ".txn");
            if (!file2.exists() && file2.mkdirs()) {
                return string;
            }
            if (!file2.exists()) break;
        }
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_UNIQUE_NAMES_EXHAUSTED, "Unable to create transaction directory in ''{0}'' for revision {1}", file, l2);
        SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        return null;
    }

    public void deleteEntry(FSRevisionNode fSRevisionNode, String string) {
        FSEntry fSEntry;
        Object object;
        if (fSRevisionNode.getType() != SVNNodeKind.DIR) {
            object = SVNErrorMessage.create(SVNErrorCode.FS_NOT_DIRECTORY, "Attempted to delete entry ''{0}'' from *non*-directory node", (Object)string);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        if (!fSRevisionNode.getId().isTxn()) {
            object = SVNErrorMessage.create(SVNErrorCode.FS_NOT_MUTABLE, "Attempted to delete entry ''{0}'' from immutable directory node", (Object)string);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        if (!SVNPathUtil.isSinglePathComponent(string)) {
            object = SVNErrorMessage.create(SVNErrorCode.FS_NOT_SINGLE_PATH_COMPONENT, "Attempted to delete a node with an illegal name ''{0}''", (Object)string);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        if ((fSEntry = (FSEntry)(object = fSRevisionNode.getDirEntries(this.getOwner())).get(string)) == null) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_NO_SUCH_ENTRY, "Delete failed--directory has no entry ''{0}''", (Object)string);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        this.getOwner().getRevisionNode(fSEntry.getId());
        this.deleteEntryIfMutable(fSEntry.getId());
        this.setEntry(fSRevisionNode, string, null, SVNNodeKind.UNKNOWN);
    }

    public void incrementMergeInfoCount(FSRevisionNode fSRevisionNode, long l2) {
        SVNErrorMessage sVNErrorMessage;
        if (!fSRevisionNode.getId().isTxn()) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_NOT_MUTABLE, "Can''t increment mergeinfo count on *immutable* node-revision {0}", (Object)fSRevisionNode.getId());
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        if (l2 == 0L) {
            return;
        }
        fSRevisionNode.setMergeInfoCount(fSRevisionNode.getMergeInfoCount() + l2);
        if (fSRevisionNode.getMergeInfoCount() < 0L) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Can''t increment mergeinfo count on node-revision {0} to negative value {1}", fSRevisionNode.getId(), fSRevisionNode.getMergeInfoCount());
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        if (fSRevisionNode.getMergeInfoCount() > 1L && fSRevisionNode.getType() == SVNNodeKind.FILE) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Can''t increment mergeinfo count on *file* node-revision {0} to {1} (> 1)", fSRevisionNode.getId(), fSRevisionNode.getMergeInfoCount());
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        this.getOwner().putTxnRevisionNode(fSRevisionNode.getId(), fSRevisionNode);
    }

    private void deleteEntryIfMutable(FSID fSID) {
        FSRevisionNode fSRevisionNode = this.getOwner().getRevisionNode(fSID);
        if (!fSRevisionNode.getId().isTxn()) {
            return;
        }
        if (fSRevisionNode.getType() == SVNNodeKind.DIR) {
            Map map = fSRevisionNode.getDirEntries(this.getOwner());
            for (String string : map.keySet()) {
                FSEntry fSEntry = (FSEntry)map.get(string);
                this.deleteEntryIfMutable(fSEntry.getId());
            }
        }
        this.removeRevisionNode(fSID);
    }

    private void removeRevisionNode(FSID fSID) {
        FSRevisionNode fSRevisionNode = this.getOwner().getRevisionNode(fSID);
        if (!fSRevisionNode.getId().isTxn()) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_NOT_MUTABLE, "Attempted removal of immutable node");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        if (fSRevisionNode.getPropsRepresentation() != null && fSRevisionNode.getPropsRepresentation().isTxn()) {
            SVNFileUtil.deleteFile(this.getTransactionRevNodePropsFile(fSID));
        }
        if (fSRevisionNode.getTextRepresentation() != null && fSRevisionNode.getTextRepresentation().isTxn() && fSRevisionNode.getType() == SVNNodeKind.DIR) {
            SVNFileUtil.deleteFile(this.getTransactionRevNodeChildrenFile(fSID));
        }
        SVNFileUtil.deleteFile(this.getOwner().getTransactionRevNodeFile(fSID));
    }

    public void setProplist(FSRevisionNode fSRevisionNode, SVNProperties sVNProperties) {
        Serializable serializable;
        if (!fSRevisionNode.getId().isTxn()) {
            serializable = SVNErrorMessage.create(SVNErrorCode.FS_NOT_MUTABLE, "Can't set proplist on *immutable* node-revision {0}", (Object)fSRevisionNode.getId());
            SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.FSFS);
        }
        serializable = this.getTransactionRevNodePropsFile(fSRevisionNode.getId());
        SVNWCProperties.setProperties(sVNProperties, (File)serializable, SVNFileUtil.createUniqueFile(((File)serializable).getParentFile(), ".props", ".tmp", false), "END");
        if (fSRevisionNode.getPropsRepresentation() == null || !fSRevisionNode.getPropsRepresentation().isTxn()) {
            FSRepresentation fSRepresentation = new FSRepresentation();
            fSRepresentation.setTxnId(fSRevisionNode.getId().getTxnID());
            fSRevisionNode.setPropsRepresentation(fSRepresentation);
            fSRevisionNode.setIsFreshTxnRoot(false);
            this.getOwner().putTxnRevisionNode(fSRevisionNode.getId(), fSRevisionNode);
        }
    }

    public FSID createSuccessor(FSID fSID, FSRevisionNode fSRevisionNode, String string) {
        if (string == null) {
            string = fSID.getCopyID();
        }
        FSID fSID2 = FSID.createTxnId(fSID.getNodeID(), string, this.myTxnID);
        fSRevisionNode.setId(fSID2);
        if (fSRevisionNode.getCopyRootPath() == null) {
            fSRevisionNode.setCopyRootPath(fSRevisionNode.getCreatedPath());
            fSRevisionNode.setCopyRootRevision(fSRevisionNode.getId().getRevision());
        }
        fSRevisionNode.setIsFreshTxnRoot(false);
        this.getOwner().putTxnRevisionNode(fSRevisionNode.getId(), fSRevisionNode);
        return fSID2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEntry(FSRevisionNode fSRevisionNode, String string, FSID fSID, SVNNodeKind sVNNodeKind) {
        Object object;
        if (fSRevisionNode.getType() != SVNNodeKind.DIR) {
            object = SVNErrorMessage.create(SVNErrorCode.FS_NOT_DIRECTORY, "Attempted to set entry in non-directory node");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        if (!fSRevisionNode.getId().isTxn()) {
            object = SVNErrorMessage.create(SVNErrorCode.FS_NOT_MUTABLE, "Attempted to set entry in immutable node");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        object = fSRevisionNode.getTextRepresentation();
        File file = this.getTransactionRevNodeChildrenFile(fSRevisionNode.getId());
        OutputStream outputStream = null;
        try {
            Map map;
            if (object == null || !((FSRepresentation)object).isTxn()) {
                map = fSRevisionNode.getDirEntries(this.getOwner());
                SVNProperties sVNProperties = this.unparseDirEntries(map);
                outputStream = SVNFileUtil.openFileForWriting(file);
                SVNWCProperties.setProperties(sVNProperties, outputStream, "END");
                object = new FSRepresentation();
                ((FSRepresentation)object).setRevision(-1L);
                ((FSRepresentation)object).setTxnId(this.myTxnID);
                String string2 = this.getNewTxnNodeId();
                String string3 = this.myTxnID + '/' + string2;
                ((FSRepresentation)object).setUniquifier(string3);
                fSRevisionNode.setTextRepresentation((FSRepresentation)object);
                fSRevisionNode.setIsFreshTxnRoot(false);
                this.getOwner().putTxnRevisionNode(fSRevisionNode.getId(), fSRevisionNode);
            } else {
                outputStream = SVNFileUtil.openFileForWriting(file, true);
            }
            map = fSRevisionNode.getDirContents();
            if (fSID != null) {
                SVNWCProperties.appendProperty(string, SVNPropertyValue.create(sVNNodeKind + " " + fSID.toString()), outputStream);
                if (map != null) {
                    map.put(string, new FSEntry(fSID, sVNNodeKind, string));
                }
            } else {
                SVNWCProperties.appendPropertyDeleted(string, outputStream);
                if (map != null) {
                    map.remove(string);
                }
            }
        }
        catch (Throwable throwable) {
            SVNFileUtil.closeFile(outputStream);
            throw throwable;
        }
        SVNFileUtil.closeFile(outputStream);
    }

    public void writeChangeEntry(OutputStream outputStream, FSPathChange fSPathChange, boolean bl2) {
        boolean bl3;
        Object object;
        FSPathChangeKind fSPathChangeKind = fSPathChange.getChangeKind();
        if (fSPathChangeKind != FSPathChangeKind.FS_PATH_CHANGE_ADD && fSPathChangeKind != FSPathChangeKind.FS_PATH_CHANGE_DELETE && fSPathChangeKind != FSPathChangeKind.FS_PATH_CHANGE_MODIFY && fSPathChangeKind != FSPathChangeKind.FS_PATH_CHANGE_REPLACE && fSPathChangeKind != FSPathChangeKind.FS_PATH_CHANGE_RESET) {
            object = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Invalid change type");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        object = fSPathChangeKind.toString();
        if (bl2) {
            object = (String)object + "-" + fSPathChange.getKind().toString();
        }
        String string = null;
        string = fSPathChange.getRevNodeId() != null ? fSPathChange.getRevNodeId().toString() : "reset";
        boolean bl4 = bl3 = this.getOwner().getDBFormat() >= 7;
        String string2 = bl3 ? SVNProperty.toString(fSPathChange.getMergeInfoModified() == Boolean.TRUE) + " " : "";
        String string3 = string + " " + (String)object + " " + SVNProperty.toString(fSPathChange.isTextModified()) + " " + SVNProperty.toString(fSPathChange.arePropertiesModified()) + " " + string2 + fSPathChange.getPath() + "\n";
        outputStream.write(string3.getBytes("UTF-8"));
        String string4 = fSPathChange.getCopyPath();
        long l2 = fSPathChange.getCopyRevision();
        if (string4 != null && l2 != -1L) {
            String string5 = l2 + " " + string4;
            outputStream.write(string5.getBytes("UTF-8"));
        }
        outputStream.write("\n".getBytes("UTF-8"));
    }

    public long writeFinalChangedPathInfo(CountingOutputStream countingOutputStream) {
        boolean bl2;
        long l2 = countingOutputStream.getPosition();
        Map map = this.getChangedPaths();
        boolean bl3 = bl2 = this.getOwner().getDBFormat() >= 4;
        if (this.getOwner().isUseLogAddressing()) {
            countingOutputStream.resetChecksum();
        }
        this.writeChanges(countingOutputStream, map, bl2, true);
        if (this.getOwner().isUseLogAddressing()) {
            long l3 = countingOutputStream.getPosition() - l2;
            FSP2LProtoIndex$ItemType fSP2LProtoIndex$ItemType = FSP2LProtoIndex$ItemType.CHANGES;
            long l4 = -1L;
            long l5 = 1L;
            int n2 = countingOutputStream.finalizeChecksum();
            FSP2LEntry fSP2LEntry = new FSP2LEntry(l2, l3, fSP2LProtoIndex$ItemType, n2, l4, l5);
            this.storeP2LIndexEntry(fSP2LEntry);
            this.storeL2PIndexEntry(fSP2LEntry.getOffset(), 1L);
        }
        return l2;
    }

    private void writeChanges(CountingOutputStream countingOutputStream, Map map, boolean bl2, boolean bl3) {
        for (String string : map.keySet()) {
            FSPathChange fSPathChange = (FSPathChange)map.get(string);
            FSID fSID = fSPathChange.getRevNodeId();
            if (fSPathChange.getChangeKind() != FSPathChangeKind.FS_PATH_CHANGE_DELETE && !fSID.isTxn()) {
                FSRevisionNode fSRevisionNode = this.getOwner().getRevisionNode(fSID);
                fSPathChange.setRevNodeId(fSRevisionNode.getId());
            }
            this.writeChangeEntry(countingOutputStream, fSPathChange, bl2);
        }
        if (bl3) {
            countingOutputStream.write(10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] readNextIDs() {
        String[] stringArray = new String[2];
        String string = null;
        try (FSFile fSFile = new FSFile(this.getOwner().getNextIDsFile(this.myTxnID));){
            string = fSFile.readLine(403);
        }
        int n2 = string.indexOf(32);
        if (n2 == -1) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "next-ids file corrupt");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        stringArray[0] = string.substring(0, n2);
        stringArray[1] = string.substring(n2 + 1);
        return stringArray;
    }

    public void writeFinalCurrentFile(long l2, String string, String string2) {
        if (this.getOwner().getDBFormat() >= 3) {
            this.getOwner().writeCurrentFile(l2, null, null);
            return;
        }
        String[] stringArray = this.readNextIDs();
        String string3 = stringArray[0];
        String string4 = stringArray[1];
        String string5 = FSTransactionRoot.addKeys(string, string3);
        String string6 = FSTransactionRoot.addKeys(string2, string4);
        this.getOwner().writeCurrentFile(l2, string5, string6);
    }

    public FSID writeFinalRevision(FSID fSID, CountingOutputStream countingOutputStream, long l2, FSID fSID2, String string, String string2, Collection collection, boolean bl2) {
        long l3;
        String string3;
        long l4;
        Object object;
        Object object2;
        Object object32;
        Object object4;
        fSID = null;
        if (!fSID2.isTxn()) {
            return fSID;
        }
        FSFS fSFS = this.getOwner();
        FSRevisionNode fSRevisionNode = fSFS.getRevisionNode(fSID2);
        if (fSRevisionNode.getType() == SVNNodeKind.DIR) {
            object4 = fSRevisionNode.getDirEntries(fSFS);
            for (Object object32 : object4.values()) {
                if ((fSID = this.writeFinalRevision(fSID, countingOutputStream, l2, ((FSEntry)object32).getId(), string, string2, collection, false)) == null || fSID.getRevision() != l2) continue;
                ((FSEntry)object32).setId(fSID);
            }
            if (fSRevisionNode.getTextRepresentation() != null && fSRevisionNode.getTextRepresentation().isTxn()) {
                object2 = this.unparseDirEntries((Map)object4);
                object32 = fSRevisionNode.getTextRepresentation();
                ((FSRepresentation)object32).setTxnId(null);
                ((FSRepresentation)object32).setRevision(l2);
                try {
                    ((FSRepresentation)object32).setItemIndex(countingOutputStream.getPosition());
                    object = MessageDigest.getInstance("MD5");
                    l4 = this.writeHashRepresentation((FSRepresentation)object32, (SVNProperties)object2, countingOutputStream, (MessageDigest)object, FSP2LProtoIndex$ItemType.DIR_REP);
                    string3 = SVNFileUtil.toHexDigest((MessageDigest)object);
                    ((FSRepresentation)object32).setSize(l4);
                    ((FSRepresentation)object32).setMD5HexDigest(string3);
                    ((FSRepresentation)object32).setExpandedSize(((FSRepresentation)object32).getSize());
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "MD5 implementation not found: {0}", (Object)noSuchAlgorithmException.getLocalizedMessage());
                    SVNErrorManager.error(sVNErrorMessage, noSuchAlgorithmException, SVNLogType.FSFS);
                }
            }
        } else if (fSRevisionNode.getTextRepresentation() != null && fSRevisionNode.getTextRepresentation().isTxn()) {
            object4 = fSRevisionNode.getTextRepresentation();
            ((FSRepresentation)object4).setTxnId(null);
            ((FSRepresentation)object4).setRevision(l2);
        }
        if (fSRevisionNode.getPropsRepresentation() != null && fSRevisionNode.getPropsRepresentation().isTxn()) {
            object4 = fSRevisionNode.getType() == SVNNodeKind.DIR ? FSP2LProtoIndex$ItemType.DIR_PROPS : FSP2LProtoIndex$ItemType.FILE_PROPS;
            object2 = fSRevisionNode.getProperties(fSFS);
            object32 = fSRevisionNode.getPropsRepresentation();
            try {
                ((FSRepresentation)object32).setItemIndex(countingOutputStream.getPosition());
                object = MessageDigest.getInstance("MD5");
                l4 = this.writeHashRepresentation((FSRepresentation)object32, (SVNProperties)object2, countingOutputStream, (MessageDigest)object, (FSP2LProtoIndex$ItemType)((Object)object4));
                string3 = SVNFileUtil.toHexDigest((MessageDigest)object);
                ((FSRepresentation)object32).setSize(l4);
                ((FSRepresentation)object32).setMD5HexDigest(string3);
                ((FSRepresentation)object32).setTxnId(null);
                ((FSRepresentation)object32).setRevision(l2);
                ((FSRepresentation)object32).setExpandedSize(l4);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "MD5 implementation not found: {0}", (Object)noSuchAlgorithmException.getLocalizedMessage());
                SVNErrorManager.error(sVNErrorMessage, noSuchAlgorithmException, SVNLogType.FSFS);
            }
        }
        long l5 = countingOutputStream.getPosition();
        object32 = null;
        object = fSRevisionNode.getId().getNodeID();
        object32 = ((String)object).startsWith("_") ? (this.getOwner().getDBFormat() >= 3 ? ((String)object).substring(1) + "-" + l2 : FSTransactionRoot.addKeys(string, ((String)object).substring(1))) : object;
        String string4 = null;
        String string5 = fSRevisionNode.getId().getCopyID();
        string4 = string5.startsWith("_") ? (this.getOwner().getDBFormat() >= 3 ? string5.substring(1) + "-" + l2 : FSTransactionRoot.addKeys(string2, string5.substring(1))) : string5;
        if (fSRevisionNode.getCopyRootRevision() == -1L) {
            fSRevisionNode.setCopyRootRevision(l2);
        }
        if (this.getOwner().isUseLogAddressing() && bl2) {
            l3 = 2L;
            this.storeL2PIndexEntry(l5, l3);
        } else {
            l3 = this.allocateItemIndex(l5);
        }
        fSID = FSID.createRevId((String)object32, string4, l2, l3);
        fSRevisionNode.setId(fSID);
        FSFnv1aOutputStream fSFnv1aOutputStream = new FSFnv1aOutputStream(countingOutputStream);
        this.getOwner().writeTxnNodeRevision(fSFnv1aOutputStream, fSRevisionNode);
        if (collection != null && fSRevisionNode.getTextRepresentation() != null && fSRevisionNode.getType() == SVNNodeKind.FILE && fSRevisionNode.getTextRepresentation().getRevision() == l2) {
            collection.add(fSRevisionNode.getTextRepresentation());
        }
        fSRevisionNode.setIsFreshTxnRoot(false);
        this.getOwner().putTxnRevisionNode(fSID2, fSRevisionNode);
        if (this.getOwner().isUseLogAddressing()) {
            int n2 = fSFnv1aOutputStream.finalizeChecksum();
            FSP2LEntry fSP2LEntry = new FSP2LEntry(l5, countingOutputStream.getPosition() - l5, FSP2LProtoIndex$ItemType.NODEREV, n2, -1L, l3);
            this.storeP2LIndexEntry(fSP2LEntry);
        }
        return fSID;
    }

    public FSRevisionNode cloneChild(FSRevisionNode fSRevisionNode, String string, String string2, String string3, boolean bl2) {
        Object object;
        if (!fSRevisionNode.getId().isTxn()) {
            object = SVNErrorMessage.create(SVNErrorCode.FS_NOT_MUTABLE, "Attempted to clone child of non-mutable node");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        if (!SVNPathUtil.isSinglePathComponent(string2)) {
            object = SVNErrorMessage.create(SVNErrorCode.FS_NOT_SINGLE_PATH_COMPONENT, "Attempted to make a child clone with an illegal name ''{0}''", (Object)string2);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        object = fSRevisionNode.getChildDirNode(string2, this.getOwner());
        FSID fSID = null;
        if (((FSRevisionNode)object).getId().isTxn()) {
            fSID = ((FSRevisionNode)object).getId();
        } else {
            if (bl2) {
                ((FSRevisionNode)object).setCopyRootPath(fSRevisionNode.getCopyRootPath());
                ((FSRevisionNode)object).setCopyRootRevision(fSRevisionNode.getCopyRootRevision());
            }
            ((FSRevisionNode)object).setCopyFromPath(null);
            ((FSRevisionNode)object).setCopyFromRevision(-1L);
            ((FSRevisionNode)object).setPredecessorId(((FSRevisionNode)object).getId());
            if (((FSRevisionNode)object).getCount() != -1L) {
                ((FSRevisionNode)object).setCount(((FSRevisionNode)object).getCount() + 1L);
            }
            ((FSRevisionNode)object).setCreatedPath(SVNPathUtil.getAbsolutePath(SVNPathUtil.append(string, string2)));
            fSID = this.createSuccessor(((FSRevisionNode)object).getId(), (FSRevisionNode)object, string3);
            this.setEntry(fSRevisionNode, string2, fSID, ((FSRevisionNode)object).getType());
        }
        return this.getOwner().getRevisionNode(fSID);
    }

    public File getTransactionRevNodePropsFile(FSID fSID) {
        return new File(this.getOwner().getTransactionDir(fSID.getTxnID()), "node." + fSID.getNodeID() + "." + fSID.getCopyID() + ".props");
    }

    public File getTransactionRevNodeChildrenFile(FSID fSID) {
        return new File(this.getOwner().getTransactionDir(fSID.getTxnID()), "node." + fSID.getNodeID() + "." + fSID.getCopyID() + ".children");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getWritableTransactionProtoRevFile() {
        block13: {
            if (this.myTxnRevFile == null) {
                FSFS fSFS = this.getOwner();
                this.myTxnRevFile = fSFS.getTransactionProtoRevFile(this.myTxnID);
                if (fSFS.isUseLogAddressing()) {
                    FSP2LProtoIndex fSP2LProtoIndex = FSP2LProtoIndex.open(fSFS, this.myTxnID, true);
                    assert (fSP2LProtoIndex != null);
                    try {
                        long l2 = this.myTxnRevFile.length();
                        long l3 = fSP2LProtoIndex.readNextOffset();
                        if (l3 < l2) {
                            RandomAccessFile randomAccessFile = null;
                            try {
                                randomAccessFile = new RandomAccessFile(this.myTxnRevFile, "rw");
                                randomAccessFile.setLength(l3);
                            }
                            catch (IOException iOException) {
                                try {
                                    SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException);
                                    SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
                                }
                                catch (Throwable throwable) {
                                    SVNFileUtil.closeFile(randomAccessFile);
                                    throw throwable;
                                }
                                SVNFileUtil.closeFile(randomAccessFile);
                                break block13;
                            }
                            SVNFileUtil.closeFile(randomAccessFile);
                            break block13;
                        }
                        if (l3 > l2) {
                            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_INCONSISTENT, "p2l proto index offset {0} beyond protorev file size {1} for TXN {2}", l3, l2, this.myTxnID);
                            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
                        }
                    }
                    finally {
                        if (fSP2LProtoIndex != null) {
                            fSP2LProtoIndex.close();
                        }
                    }
                }
            }
        }
        return this.myTxnRevFile;
    }

    public File getTransactionChangesFile() {
        if (this.myTxnChangesFile == null) {
            this.myTxnChangesFile = new File(this.getOwner().getTransactionDir(this.myTxnID), "changes");
        }
        return this.myTxnChangesFile;
    }

    public String getNewTxnNodeId() {
        String[] stringArray = this.readNextIDs();
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = FSRepositoryUtil.generateNextKey(string);
        this.getOwner().writeNextIDs(this.getTxnID(), string3, string2);
        return "_" + string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long allocateItemIndex(long l2) {
        FSFS fSFS = this.getOwner();
        String string = this.getTxnID();
        if (fSFS.isUseLogAddressing()) {
            FSTransactionItemIndex fSTransactionItemIndex = FSTransactionItemIndex.open(fSFS, string);
            assert (fSTransactionItemIndex != null);
            try {
                long l3 = fSTransactionItemIndex.allocateItemIndex(l2);
                this.storeL2PIndexEntry(l2, l3);
                long l4 = l3;
                return l4;
            }
            finally {
                if (fSTransactionItemIndex != null) {
                    fSTransactionItemIndex.close();
                }
            }
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeL2PIndexEntry(long l2, long l3) {
        FSFS fSFS = this.getOwner();
        String string = this.getTxnID();
        if (fSFS.isUseLogAddressing()) {
            FSL2PProtoIndex fSL2PProtoIndex = FSL2PProtoIndex.open(fSFS, string, true);
            assert (fSL2PProtoIndex != null);
            try {
                fSL2PProtoIndex.addEntry(l2, l3);
            }
            finally {
                if (fSL2PProtoIndex != null) {
                    fSL2PProtoIndex.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeP2LIndexEntry(FSP2LEntry fSP2LEntry) {
        FSFS fSFS = this.getOwner();
        String string = this.getTxnID();
        if (this.getOwner().isUseLogAddressing()) {
            FSP2LProtoIndex fSP2LProtoIndex = FSP2LProtoIndex.open(fSFS, string, true);
            assert (fSP2LProtoIndex != null);
            try {
                fSP2LProtoIndex.writeEntry(fSP2LEntry);
            }
            finally {
                if (fSP2LProtoIndex != null) {
                    fSP2LProtoIndex.close();
                }
            }
        }
    }

    private long writeHashRepresentation(FSRepresentation fSRepresentation, SVNProperties sVNProperties, CountingOutputStream countingOutputStream, MessageDigest messageDigest, FSP2LProtoIndex$ItemType fSP2LProtoIndex$ItemType) {
        long l2 = countingOutputStream.getPosition();
        FSTransactionRoot$HashRepresentationStream fSTransactionRoot$HashRepresentationStream = new FSTransactionRoot$HashRepresentationStream(countingOutputStream, messageDigest);
        countingOutputStream.resetChecksum();
        String string = "PLAIN\n";
        countingOutputStream.write(string.getBytes("UTF-8"));
        SVNWCProperties.setProperties(sVNProperties, fSTransactionRoot$HashRepresentationStream, "END");
        String string2 = "ENDREP\n";
        countingOutputStream.write(string2.getBytes("UTF-8"));
        if (this.getOwner().isUseLogAddressing()) {
            long l3 = this.allocateItemIndex(l2);
            long l4 = countingOutputStream.getPosition() - l2;
            long l5 = -1L;
            long l6 = l3;
            int n2 = countingOutputStream.finalizeChecksum();
            fSRepresentation.setItemIndex(l3);
            FSP2LEntry fSP2LEntry = new FSP2LEntry(l2, l4, fSP2LProtoIndex$ItemType, n2, -1L, l6);
            this.storeP2LIndexEntry(fSP2LEntry);
        }
        return fSTransactionRoot$HashRepresentationStream.mySize;
    }

    private static String addKeys(String string, String string2) {
        int n2 = string.length() - 1;
        int n3 = string2.length() - 1;
        int n4 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (n2 >= 0 || n3 >= 0 || n4 > 0) {
            int n5 = n4;
            if (n2 >= 0) {
                n5 += string.charAt(n2) <= '9' ? string.charAt(n2) - 48 : string.charAt(n2) - 97 + 10;
            }
            if (n3 >= 0) {
                n5 += string2.charAt(n3) <= '9' ? string2.charAt(n3) - 48 : string2.charAt(n3) - 97 + 10;
            }
            n4 = n5 / 36;
            char c2 = (n5 %= 36) <= 9 ? (char)(48 + n5) : (char)(n5 - 10 + 97);
            stringBuffer.append(c2);
            if (n2 >= 0) {
                --n2;
            }
            if (n3 < 0) continue;
            --n3;
        }
        return stringBuffer.reverse().toString();
    }
}

