/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaCombiner;
import org.tmatesoft.svn.core.internal.io.fs.CountingOutputStream;
import org.tmatesoft.svn.core.internal.io.fs.FSCopyInheritance;
import org.tmatesoft.svn.core.internal.io.fs.FSErrors;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSFile;
import org.tmatesoft.svn.core.internal.io.fs.FSInputStream;
import org.tmatesoft.svn.core.internal.io.fs.FSParentPath;
import org.tmatesoft.svn.core.internal.io.fs.FSPathChange;
import org.tmatesoft.svn.core.internal.io.fs.FSPathChangeKind;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSRoot$RevisionCache;
import org.tmatesoft.svn.core.internal.io.fs.index.FSL2PEntry;
import org.tmatesoft.svn.core.internal.io.fs.index.FSL2PProtoIndex;
import org.tmatesoft.svn.core.internal.io.fs.index.FSP2LEntry;
import org.tmatesoft.svn.core.internal.io.fs.index.FSP2LProtoIndex;
import org.tmatesoft.svn.core.internal.io.fs.index.FSP2LProtoIndex$ItemType;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNSpillBuffer;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNChecksumOutputStream;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.util.SVNLogType;

public abstract class FSRoot {
    private FSRoot$RevisionCache myRevNodesCache;
    private FSFS myFSFS;
    protected FSRevisionNode myRootRevisionNode;

    protected FSRoot(FSFS fSFS) {
        this.myFSFS = fSFS;
    }

    public FSFS getOwner() {
        return this.myFSFS;
    }

    public FSRevisionNode getRevisionNode(String string) {
        FSRevisionNode fSRevisionNode = this.fetchRevNodeFromCache(string = SVNPathUtil.canonicalizeAbsolutePath(string));
        if (fSRevisionNode == null) {
            FSParentPath fSParentPath = this.openPath(string, true, false);
            fSRevisionNode = fSParentPath.getRevNode();
        }
        return fSRevisionNode;
    }

    public abstract long getRevision();

    public abstract FSRevisionNode getRootRevisionNode();

    public abstract Map getChangedPaths();

    public abstract FSCopyInheritance getCopyInheritance(FSParentPath var1);

    public FSParentPath openPath(String string, boolean bl2, boolean bl3) {
        Object object;
        if (string == null) {
            object = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "null path is not supported");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        object = SVNPathUtil.canonicalizeAbsolutePath(string);
        FSRevisionNode fSRevisionNode = this.getRootRevisionNode();
        String string2 = "/";
        FSParentPath fSParentPath = new FSParentPath(fSRevisionNode, null, null);
        fSParentPath.setCopyStyle(1);
        String string3 = ((String)object).substring(1);
        while (true) {
            Object object2;
            String string4 = SVNPathUtil.head(string3);
            String string5 = SVNPathUtil.removeHead(string3);
            string2 = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(string2, string4));
            FSRevisionNode fSRevisionNode2 = null;
            if (string4 == null || "".equals(string4)) {
                fSRevisionNode2 = fSRevisionNode;
            } else {
                FSCopyInheritance fSCopyInheritance;
                object2 = this.fetchRevNodeFromCache(string2);
                if (object2 != null) {
                    fSRevisionNode2 = object2;
                } else {
                    try {
                        fSRevisionNode2 = fSRevisionNode.getChildDirNode(string4, this.getOwner());
                    }
                    catch (SVNException sVNException) {
                        if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.FS_NOT_FOUND) {
                            if (!bl2 && (string5 == null || "".equals(string5))) {
                                return new FSParentPath(null, string4, fSParentPath);
                            }
                            SVNErrorManager.error(FSErrors.errorNotFound(this, string), sVNException, SVNLogType.FSFS);
                        }
                        throw sVNException;
                    }
                }
                fSParentPath.setParentPath(fSRevisionNode2, string4, bl3 ? new FSParentPath(fSParentPath) : null);
                if (bl3 && (fSCopyInheritance = this.getCopyInheritance(fSParentPath)) != null) {
                    fSParentPath.setCopyStyle(fSCopyInheritance.getStyle());
                    fSParentPath.setCopySourcePath(fSCopyInheritance.getCopySourcePath());
                }
                if (object2 == null) {
                    this.putRevNodeToCache(string2, fSRevisionNode2);
                }
            }
            if (string5 == null || "".equals(string5)) break;
            if (fSRevisionNode2.getType() != SVNNodeKind.DIR) {
                object2 = FSErrors.errorNotDirectory(string2, this.getOwner());
                SVNErrorManager.error(((SVNErrorMessage)object2).wrap("Failure opening ''{0}''", string), SVNLogType.FSFS);
            }
            string3 = string5;
            fSRevisionNode = fSRevisionNode2;
        }
        return fSParentPath;
    }

    public SVNNodeKind checkNodeKind(String string) {
        FSRevisionNode fSRevisionNode = null;
        try {
            fSRevisionNode = this.getRevisionNode(string);
        }
        catch (SVNException sVNException) {
            if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.FS_NOT_FOUND || sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.FS_NOT_DIRECTORY) {
                return SVNNodeKind.NONE;
            }
            throw sVNException;
        }
        return fSRevisionNode.getType();
    }

    public void putRevNodeToCache(String string, FSRevisionNode fSRevisionNode) {
        if (!string.startsWith("/")) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "Invalid path ''{0}''", (Object)string);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        if (this.myRevNodesCache == null) {
            this.myRevNodesCache = new FSRoot$RevisionCache(100);
        }
        this.myRevNodesCache.put(string, fSRevisionNode);
    }

    public void removeRevNodeFromCache(String string) {
        if (!string.startsWith("/")) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "Invalid path ''{0}''", (Object)string);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        if (this.myRevNodesCache == null) {
            return;
        }
        this.myRevNodesCache.delete(string);
    }

    protected FSRevisionNode fetchRevNodeFromCache(String string) {
        if (this.myRevNodesCache == null) {
            return null;
        }
        if (!string.startsWith("/")) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "Invalid path ''{0}''", (Object)string);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        return (FSRevisionNode)this.myRevNodesCache.fetch(string);
    }

    private void foldChange(Map map, FSPathChange fSPathChange) {
        Serializable serializable;
        if (fSPathChange == null) {
            return;
        }
        map = map != null ? map : new SVNHashMap();
        FSPathChange fSPathChange2 = null;
        String string = null;
        long l2 = -1L;
        FSPathChange fSPathChange3 = (FSPathChange)map.get(fSPathChange.getPath());
        if (fSPathChange3 != null) {
            string = fSPathChange3.getCopyPath();
            l2 = fSPathChange3.getCopyRevision();
            if (fSPathChange.getRevNodeId() == null && FSPathChangeKind.FS_PATH_CHANGE_RESET != fSPathChange.getChangeKind()) {
                serializable = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Missing required node revision ID");
                SVNErrorManager.error(serializable, SVNLogType.FSFS);
            }
            if (fSPathChange.getRevNodeId() != null && !fSPathChange3.getRevNodeId().equals(fSPathChange.getRevNodeId()) && fSPathChange3.getChangeKind() != FSPathChangeKind.FS_PATH_CHANGE_DELETE) {
                serializable = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Invalid change ordering: new node revision ID without delete");
                SVNErrorManager.error(serializable, SVNLogType.FSFS);
            }
            if (FSPathChangeKind.FS_PATH_CHANGE_DELETE == fSPathChange3.getChangeKind() && FSPathChangeKind.FS_PATH_CHANGE_REPLACE != fSPathChange.getChangeKind() && FSPathChangeKind.FS_PATH_CHANGE_RESET != fSPathChange.getChangeKind() && FSPathChangeKind.FS_PATH_CHANGE_ADD != fSPathChange.getChangeKind()) {
                serializable = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Invalid change ordering: non-add change on deleted path");
                SVNErrorManager.error(serializable, SVNLogType.FSFS);
            }
            if (FSPathChangeKind.FS_PATH_CHANGE_MODIFY == fSPathChange.getChangeKind()) {
                if (fSPathChange.isTextModified()) {
                    fSPathChange3.setTextModified(true);
                }
                if (fSPathChange.arePropertiesModified()) {
                    fSPathChange3.setPropertiesModified(true);
                }
            } else if (FSPathChangeKind.FS_PATH_CHANGE_ADD == fSPathChange.getChangeKind() || FSPathChangeKind.FS_PATH_CHANGE_REPLACE == fSPathChange.getChangeKind()) {
                fSPathChange3.setChangeKind(FSPathChangeKind.FS_PATH_CHANGE_REPLACE);
                fSPathChange3.setRevNodeId(fSPathChange.getRevNodeId());
                fSPathChange3.setTextModified(fSPathChange.isTextModified());
                fSPathChange3.setPropertiesModified(fSPathChange.arePropertiesModified());
                if (fSPathChange.getCopyPath() != null) {
                    string = fSPathChange.getCopyPath();
                    l2 = fSPathChange.getCopyRevision();
                }
            } else if (FSPathChangeKind.FS_PATH_CHANGE_DELETE == fSPathChange.getChangeKind()) {
                if (FSPathChangeKind.FS_PATH_CHANGE_ADD == fSPathChange3.getChangeKind()) {
                    fSPathChange3 = null;
                    map.remove(fSPathChange.getPath());
                } else {
                    fSPathChange3.setChangeKind(FSPathChangeKind.FS_PATH_CHANGE_DELETE);
                    fSPathChange3.setPropertiesModified(fSPathChange.arePropertiesModified());
                    fSPathChange3.setTextModified(fSPathChange.isTextModified());
                }
                string = null;
                l2 = -1L;
            } else if (FSPathChangeKind.FS_PATH_CHANGE_RESET == fSPathChange.getChangeKind()) {
                fSPathChange3 = null;
                string = null;
                l2 = -1L;
                map.remove(fSPathChange.getPath());
            }
            fSPathChange2 = fSPathChange3;
        } else {
            string = fSPathChange.getCopyPath();
            l2 = fSPathChange.getCopyRevision();
            fSPathChange2 = fSPathChange;
        }
        if (fSPathChange2 != null) {
            fSPathChange2.setCopyPath(string);
            fSPathChange2.setCopyRevision(l2);
            serializable = fSPathChange.getKind();
            if (serializable != null && serializable != SVNNodeKind.UNKNOWN) {
                fSPathChange2.setNodeKind((SVNNodeKind)serializable);
            }
            map.put(fSPathChange.getPath(), fSPathChange2);
        }
    }

    protected Map fetchAllChanges(FSFile fSFile, boolean bl2) {
        SVNHashMap sVNHashMap = new SVNHashMap();
        FSPathChange fSPathChange = this.readChange(fSFile);
        while (fSPathChange != null) {
            this.foldChange(sVNHashMap, fSPathChange);
            if (!(FSPathChangeKind.FS_PATH_CHANGE_DELETE != fSPathChange.getChangeKind() && FSPathChangeKind.FS_PATH_CHANGE_REPLACE != fSPathChange.getChangeKind() || bl2)) {
                Iterator iterator = sVNHashMap.keySet().iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    if (fSPathChange.getPath().equals(string) || SVNPathUtil.getPathAsChild(fSPathChange.getPath(), string) == null) continue;
                    iterator.remove();
                }
            }
            fSPathChange = this.readChange(fSFile);
        }
        return sVNHashMap;
    }

    public Map detectChanged() {
        Map map = this.getChangedPaths();
        if (map.size() == 0) {
            return map;
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            FSPathChange fSPathChange = (FSPathChange)map.get(string);
            if (fSPathChange.getChangeKind() != FSPathChangeKind.FS_PATH_CHANGE_RESET) continue;
            iterator.remove();
        }
        return map;
    }

    private FSPathChange readChange(FSFile fSFile) {
        String string = null;
        try {
            string = fSFile.readLine(4096);
        }
        catch (SVNException sVNException) {
            if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.STREAM_UNEXPECTED_EOF) {
                return null;
            }
            throw sVNException;
        }
        if (string == null || string.length() == 0) {
            return null;
        }
        String string2 = fSFile.readLine(4096);
        return FSPathChange.fromString(string, string2);
    }

    public InputStream getFileStreamForPath(SVNDeltaCombiner sVNDeltaCombiner, String string) {
        FSRevisionNode fSRevisionNode = this.getRevisionNode(string);
        return FSInputStream.createDeltaStream(sVNDeltaCombiner, fSRevisionNode, this.getOwner());
    }

    public long getFileSize(String string) {
        FSRevisionNode fSRevisionNode = this.getRevisionNode(string);
        return fSRevisionNode.getFileLength();
    }

    public boolean isUseLogAddressing() {
        return this.getOwner().isUseLogAddressing();
    }

    public void writeIndexData(CountingOutputStream countingOutputStream, long l2, String string) {
        long l3 = countingOutputStream.getPosition();
        String string2 = this.writeL2PIndex(countingOutputStream, l2, string);
        long l4 = countingOutputStream.getPosition();
        String string3 = this.writeP2LIndex(countingOutputStream, l2, string);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(l3);
        stringBuilder.append(' ');
        stringBuilder.append(string2);
        stringBuilder.append(' ');
        stringBuilder.append(l4);
        stringBuilder.append(' ');
        stringBuilder.append(string3);
        String string4 = stringBuilder.toString();
        try {
            byte[] byArray = string4.getBytes("UTF-8");
            countingOutputStream.write(byArray);
            countingOutputStream.write(byArray.length);
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeL2PIndex(CountingOutputStream countingOutputStream, long l2, String string) {
        block25: {
            Object object;
            SVNSpillBuffer sVNSpillBuffer = null;
            ArrayList<Long> arrayList = new ArrayList<Long>(16);
            ArrayList<Long> arrayList2 = new ArrayList<Long>(16);
            ArrayList<Integer> arrayList3 = new ArrayList<Integer>(16);
            ArrayList<Long> arrayList4 = new ArrayList<Long>(16);
            byte[] byArray = new byte[10];
            long l3 = 0L;
            long l4 = this.myFSFS.getL2PPageSize();
            if (l4 > Integer.MAX_VALUE) {
                object = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_OVERFLOW, "L2P index page size  {0} exceeds current limit of 2G entries", (Object)String.valueOf(l4));
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
            }
            object = null;
            try {
                String string2;
                int n2;
                Object object2;
                object = FSL2PProtoIndex.open(this.myFSFS, string, false);
                assert (object != null);
                sVNSpillBuffer = new SVNSpillBuffer(65536, 0x1000000L);
                int n3 = 0;
                while (true) {
                    if ((object2 = ((FSL2PProtoIndex)object).readEntry()) == null || n3 > 0 && ((FSL2PEntry)object2).getOffset() == 0L) {
                        n2 = 0;
                        for (int i2 = 0; i2 < arrayList4.size(); i2 += n2) {
                            long l5 = sVNSpillBuffer.getSize();
                            n2 = this.myFSFS.getL2PPageSize() < (long)(arrayList4.size() - i2) ? (int)this.myFSFS.getL2PPageSize() : arrayList4.size() - i2;
                            this.encodeL2PPage(byArray, arrayList4, i2, i2 + n2, sVNSpillBuffer);
                            arrayList3.add(n2);
                            arrayList2.add(sVNSpillBuffer.getSize() - l5);
                        }
                        arrayList.add((long)arrayList2.size() - l3);
                        l3 = arrayList2.size();
                    } else {
                        if (((FSL2PEntry)object2).getItemIndex() > Integer.MAX_VALUE) {
                            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_OVERFLOW, "Item index %s too large in l2p proto index for revision %ld", String.valueOf(((FSL2PEntry)object2).getItemIndex()), l2 + (long)arrayList.size());
                            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
                        }
                        long l6 = ((FSL2PEntry)object2).getItemIndex();
                        while (l6 >= (long)arrayList4.size()) {
                            arrayList4.add(0L);
                        }
                        arrayList4.set((int)l6, ((FSL2PEntry)object2).getOffset());
                    }
                    if (object2 == null) break;
                    ++n3;
                }
                SVNChecksumOutputStream sVNChecksumOutputStream = new SVNChecksumOutputStream(countingOutputStream, "MD5", false);
                sVNChecksumOutputStream.write("L2P-INDEX\n".getBytes("UTF-8"));
                FSRoot.writeEncoded(sVNChecksumOutputStream, byArray, l2);
                FSRoot.writeEncoded(sVNChecksumOutputStream, byArray, this.myFSFS.getL2PPageSize());
                FSRoot.writeEncoded(sVNChecksumOutputStream, byArray, arrayList.size());
                FSRoot.writeEncoded(sVNChecksumOutputStream, byArray, arrayList2.size());
                object2 = arrayList.iterator();
                while (object2.hasNext()) {
                    long l7 = (Long)object2.next();
                    FSRoot.writeEncoded(sVNChecksumOutputStream, byArray, l7);
                }
                n2 = arrayList2.size();
                for (int i3 = 0; i3 < n2; ++i3) {
                    Long l8 = (Long)arrayList2.get(i3);
                    FSRoot.writeEncoded(sVNChecksumOutputStream, byArray, l8);
                    int n4 = (Integer)arrayList3.get(i3);
                    FSRoot.writeEncoded(sVNChecksumOutputStream, byArray, n4);
                }
                object2 = sVNSpillBuffer.createInputStream();
                try {
                    SVNTranslator.copy((InputStream)object2, sVNChecksumOutputStream);
                    sVNChecksumOutputStream.flush();
                    sVNChecksumOutputStream.close();
                    string2 = sVNChecksumOutputStream.getDigest();
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            SVNFileUtil.closeFile((InputStream)object2);
                            throw throwable;
                        }
                        catch (IOException iOException) {
                            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException);
                            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
                            if (sVNSpillBuffer != null) {
                                sVNSpillBuffer.close();
                            }
                            break block25;
                        }
                    }
                    catch (Throwable throwable2) {
                        if (sVNSpillBuffer != null) {
                            sVNSpillBuffer.close();
                        }
                        throw throwable2;
                    }
                }
                SVNFileUtil.closeFile((InputStream)object2);
                if (sVNSpillBuffer != null) {
                    sVNSpillBuffer.close();
                }
                return string2;
            }
            finally {
                if (object != null) {
                    ((FSL2PProtoIndex)object).close();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeP2LIndex(CountingOutputStream countingOutputStream, long l2, String string) {
        block23: {
            SVNSpillBuffer sVNSpillBuffer = null;
            sVNSpillBuffer = new SVNSpillBuffer(65536, 0x1000000L);
            byte[] byArray = new byte[10];
            try (FSP2LProtoIndex fSP2LProtoIndex = null;){
                String string2;
                Object object;
                fSP2LProtoIndex = FSP2LProtoIndex.open(this.myFSFS, string, false);
                assert (fSP2LProtoIndex != null);
                long l3 = 0L;
                long l4 = 0L;
                long l5 = this.myFSFS.getP2LPageSize();
                long l6 = l2;
                long l7 = 0L;
                long l8 = 0L;
                long l9 = 0L;
                boolean bl2 = false;
                ArrayList<Long> arrayList = new ArrayList<Long>();
                do {
                    long l10;
                    boolean bl3 = sVNSpillBuffer.getSize() == 0L;
                    object = fSP2LProtoIndex.readEntry();
                    if (object == null) {
                        l3 = l4;
                        l10 = l4;
                        long l11 = FSRepositoryUtil.align(l10, l5) - l10;
                        FSP2LProtoIndex$ItemType fSP2LProtoIndex$ItemType = FSP2LProtoIndex$ItemType.UNUSED;
                        boolean bl4 = false;
                        long l12 = l6;
                        long l13 = 0L;
                        object = new FSP2LEntry(l10, l11, fSP2LProtoIndex$ItemType, 0, l12, 0L);
                        bl2 = true;
                    } else if (((FSP2LEntry)object).getRevision() == -1L) {
                        ((FSP2LEntry)object).setRevision(l2);
                    }
                    long l14 = ((FSP2LEntry)object).getOffset() + ((FSP2LEntry)object).getSize();
                    while (l14 - l8 > l5) {
                        l10 = sVNSpillBuffer.getSize();
                        arrayList.add(l10 - l9);
                        l9 = l10;
                        l8 += l5;
                        bl3 = true;
                    }
                    if (bl3) {
                        sVNSpillBuffer.write(byArray, 0, FSRepositoryUtil.encodeUnsignedInt(byArray, ((FSP2LEntry)object).getOffset()));
                        l6 = l2;
                        l7 = 0L;
                    }
                    sVNSpillBuffer.write(byArray, 0, FSRepositoryUtil.encodeUnsignedInt(byArray, ((FSP2LEntry)object).getSize()));
                    long l15 = ((FSP2LEntry)object).getRevision() - l6;
                    l6 = ((FSP2LEntry)object).getRevision();
                    long l16 = ((FSP2LEntry)object).getNumber() * 8L + (long)((FSP2LEntry)object).getType().getCode();
                    long l17 = l16 - l7;
                    l7 = l16;
                    sVNSpillBuffer.write(byArray, 0, FSRepositoryUtil.encodeInt(byArray, l17));
                    sVNSpillBuffer.write(byArray, 0, FSRepositoryUtil.encodeInt(byArray, l15));
                    sVNSpillBuffer.write(byArray, 0, FSRepositoryUtil.encodeUnsignedInt(byArray, ((FSP2LEntry)object).getChecksum()));
                    l4 = l14;
                } while (!bl2);
                arrayList.add(sVNSpillBuffer.getSize() - l9);
                SVNChecksumOutputStream sVNChecksumOutputStream = new SVNChecksumOutputStream(countingOutputStream, "MD5", false);
                sVNChecksumOutputStream.write("P2L-INDEX\n".getBytes("UTF-8"));
                FSRoot.writeEncoded(sVNChecksumOutputStream, byArray, l2);
                FSRoot.writeEncoded(sVNChecksumOutputStream, byArray, l3);
                FSRoot.writeEncoded(sVNChecksumOutputStream, byArray, l5);
                FSRoot.writeEncoded(sVNChecksumOutputStream, byArray, arrayList.size());
                for (Long l18 : arrayList) {
                    FSRoot.writeEncoded(sVNChecksumOutputStream, byArray, l18);
                }
                object = sVNSpillBuffer.createInputStream();
                try {
                    SVNTranslator.copy((InputStream)object, sVNChecksumOutputStream);
                    sVNChecksumOutputStream.flush();
                    sVNChecksumOutputStream.close();
                    string2 = sVNChecksumOutputStream.getDigest();
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            SVNFileUtil.closeFile((InputStream)object);
                            throw throwable;
                        }
                        catch (IOException iOException) {
                            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException);
                            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
                            if (sVNSpillBuffer != null) {
                                sVNSpillBuffer.close();
                            }
                            break block23;
                        }
                    }
                    catch (Throwable throwable2) {
                        if (sVNSpillBuffer != null) {
                            sVNSpillBuffer.close();
                        }
                        throw throwable2;
                    }
                }
                SVNFileUtil.closeFile((InputStream)object);
                if (sVNSpillBuffer != null) {
                    sVNSpillBuffer.close();
                }
                return string2;
            }
        }
        return null;
    }

    private void encodeL2PPage(byte[] byArray, List list, int n2, int n3, SVNSpillBuffer sVNSpillBuffer) {
        long l2 = 0L;
        for (int i2 = n2; i2 < n3; ++i2) {
            long l3 = (Long)list.get(i2) - l2;
            l2 = (Long)list.get(i2);
            int n4 = FSRepositoryUtil.encodeInt(byArray, l3);
            sVNSpillBuffer.write(byArray, 0, n4);
        }
    }

    private static void writeEncoded(OutputStream outputStream, byte[] byArray, long l2) {
        int n2 = FSRepositoryUtil.encodeUnsignedInt(byArray, l2);
        outputStream.write(byArray, 0, n2);
    }
}

