/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.io.fs.FSClosestCopy;
import org.tmatesoft.svn.core.internal.io.fs.FSCopyInheritance;
import org.tmatesoft.svn.core.internal.io.fs.FSErrors;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSFile;
import org.tmatesoft.svn.core.internal.io.fs.FSID;
import org.tmatesoft.svn.core.internal.io.fs.FSNodeHistory;
import org.tmatesoft.svn.core.internal.io.fs.FSParentPath;
import org.tmatesoft.svn.core.internal.io.fs.FSRepository;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSRoot;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.SVNLocationEntry;
import org.tmatesoft.svn.util.SVNLogType;

public class FSRevisionRoot
extends FSRoot {
    private long myRevision;
    private long myRootOffset;
    private long myChangesOffset;

    public FSRevisionRoot(FSFS fSFS, long l2) {
        super(fSFS);
        this.myRevision = l2;
        this.myRootOffset = -1L;
        this.myChangesOffset = -1L;
    }

    @Override
    public long getRevision() {
        return this.myRevision;
    }

    @Override
    public Map getChangedPaths() {
        try (FSFile fSFile = this.getOwner().getPackOrRevisionFSFile(this.getRevision());){
            this.loadOffsets(fSFile, 1L);
            fSFile.seek(this.myChangesOffset);
            Map map = this.fetchAllChanges(fSFile, true);
            return map;
        }
    }

    @Override
    public FSCopyInheritance getCopyInheritance(FSParentPath fSParentPath) {
        return null;
    }

    public FSNodeHistory getNodeHistory(String string) {
        SVNNodeKind sVNNodeKind = this.checkNodeKind(string);
        if (sVNNodeKind == SVNNodeKind.NONE) {
            SVNErrorManager.error(FSErrors.errorNotFound(this, string), SVNLogType.FSFS);
        }
        return new FSNodeHistory(new SVNLocationEntry(this.getRevision(), SVNPathUtil.canonicalizeAbsolutePath(string)), false, new SVNLocationEntry(-1L, null), this.getOwner());
    }

    public FSClosestCopy getClosestCopy(String string) {
        FSParentPath fSParentPath = this.openPath(string, true, true);
        SVNLocationEntry sVNLocationEntry = FSNodeHistory.findYoungestCopyroot(this.getOwner().getRepositoryRoot(), fSParentPath);
        if (sVNLocationEntry == null || sVNLocationEntry.getRevision() == 0L) {
            return null;
        }
        FSRevisionRoot fSRevisionRoot = this.getOwner().createRevisionRoot(sVNLocationEntry.getRevision());
        if (fSRevisionRoot.checkNodeKind(string) == SVNNodeKind.NONE) {
            return null;
        }
        FSParentPath fSParentPath2 = fSRevisionRoot.openPath(string, true, true);
        FSRevisionNode fSRevisionNode = fSParentPath2.getRevNode();
        if (!fSRevisionNode.getId().isRelated(fSParentPath.getRevNode().getId())) {
            return null;
        }
        long l2 = fSRevisionNode.getCreatedRevision();
        if (l2 == sVNLocationEntry.getRevision() && fSRevisionNode.getPredecessorId() == null) {
            return null;
        }
        return new FSClosestCopy(fSRevisionRoot, sVNLocationEntry.getPath());
    }

    @Override
    public FSRevisionNode getRootRevisionNode() {
        if (this.myRootRevisionNode == null) {
            try (FSFile fSFile = this.getOwner().getPackOrRevisionFSFile(this.getRevision());){
                this.loadOffsets(fSFile, 2L);
                fSFile.seek(this.myRootOffset);
                Map map = fSFile.readHeader();
                this.myRootRevisionNode = FSRevisionNode.fromMap(map);
            }
        }
        return this.myRootRevisionNode;
    }

    public SVNLocationEntry getPreviousLocation(String string, long[] lArray) {
        FSClosestCopy fSClosestCopy;
        if (lArray != null && lArray.length > 0) {
            lArray[0] = -1L;
        }
        if ((fSClosestCopy = this.getClosestCopy(string)) == null) {
            return null;
        }
        FSRevisionRoot fSRevisionRoot = fSClosestCopy.getRevisionRoot();
        String string2 = fSClosestCopy.getPath();
        FSRevisionNode fSRevisionNode = fSRevisionRoot.getRevisionNode(string2);
        String string3 = fSRevisionNode.getCopyFromPath();
        long l2 = fSRevisionNode.getCopyFromRevision();
        String string4 = "";
        if (!string.equals(string2) && (string4 = string.substring(string2.length())).startsWith("/")) {
            string4 = string4.substring(1);
        }
        String string5 = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(string3, string4));
        if (lArray != null && lArray.length > 0) {
            lArray[0] = fSRevisionRoot.getRevision();
        }
        return new SVNLocationEntry(l2, string5);
    }

    public long getNodeOriginRevision(String string) {
        Object object;
        String string2;
        string = SVNPathUtil.canonicalizeAbsolutePath(string);
        FSRevisionNode fSRevisionNode = this.getRevisionNode(string);
        String string3 = fSRevisionNode.getId().getNodeID();
        FSFS fSFS = this.getOwner();
        if (string3.startsWith("_")) {
            return -1L;
        }
        int n2 = string3.indexOf(45);
        if (n2 != -1 && n2 != string3.length() - 1) {
            try {
                return Long.parseLong(string3.substring(n2 + 1));
            }
            catch (NumberFormatException numberFormatException) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, numberFormatException), SVNLogType.FSFS);
            }
        }
        if ((string2 = fSFS.getNodeOrigin(string3)) != null) {
            FSID fSID = FSID.fromString(string2);
            return fSID.getRevision();
        }
        long l2 = -1L;
        String string4 = string;
        FSRevisionRoot fSRevisionRoot = this;
        while (true) {
            if (FSRepository.isValidRevision(l2)) {
                fSRevisionRoot = fSFS.createRevisionRoot(l2);
            }
            if ((object = fSRevisionRoot.getPreviousLocation(string4, null)) == null) break;
            string4 = ((SVNLocationEntry)object).getPath();
            l2 = ((SVNLocationEntry)object).getRevision();
        }
        fSRevisionNode = fSRevisionRoot.getRevisionNode(string4);
        object = fSRevisionNode.getId();
        while (object != null) {
            fSRevisionNode = fSFS.getRevisionNode((FSID)object);
            object = fSRevisionNode.getPredecessorId();
        }
        if (!string3.startsWith("_")) {
            fSFS.setNodeOrigin(string3, fSRevisionNode.getId());
        }
        return fSRevisionNode.getCreatedRevision();
    }

    private void loadOffsets(FSFile fSFile, long l2) {
        if (this.myRootOffset >= 0L && l2 == 2L) {
            return;
        }
        if (this.myChangesOffset >= 0L && l2 == 1L) {
            return;
        }
        long[] lArray = new long[]{-1L};
        long[] lArray2 = new long[]{-1L};
        if (this.isUseLogAddressing()) {
            FSRepositoryUtil.loadRootChangesOffsetLogicalAddressing(this.getOwner(), this.getRevision(), fSFile, l2, lArray, lArray2);
            if (l2 == 2L) {
                this.myRootOffset = lArray[0];
            }
            if (l2 == 1L) {
                this.myChangesOffset = lArray2[0];
            }
        } else {
            FSRepositoryUtil.loadRootChangesOffset(this.getOwner(), this.getRevision(), fSFile, lArray, lArray2);
            this.myRootOffset = lArray[0];
            this.myChangesOffset = lArray2[0];
        }
    }
}

