/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.internal.io.fs.FSEntry;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSID;
import org.tmatesoft.svn.core.internal.io.fs.FSRepository;
import org.tmatesoft.svn.core.internal.io.fs.FSRepresentation;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNLogType;

public class FSRevisionNode {
    public static final String HEADER_ID = "id";
    public static final String HEADER_TYPE = "type";
    public static final String HEADER_COUNT = "count";
    public static final String HEADER_PROPS = "props";
    public static final String HEADER_TEXT = "text";
    public static final String HEADER_CPATH = "cpath";
    public static final String HEADER_PRED = "pred";
    public static final String HEADER_COPYFROM = "copyfrom";
    public static final String HEADER_COPYROOT = "copyroot";
    public static final String HEADER_IS_FRESH_TXN_ROOT = "is-fresh-txn-root";
    public static final String HEADER_MERGE_INFO_COUNT = "minfo-cnt";
    public static final String HEADER_MERGE_INFO_HERE = "minfo-here";
    private FSID myId;
    private SVNNodeKind myType;
    private long myCount;
    private FSID myPredecessorId;
    private FSRepresentation myTextRepresentation;
    private FSRepresentation myPropsRepresentation;
    private String myCreatedPath;
    private long myCopyFromRevision;
    private String myCopyFromPath;
    private long myCopyRootRevision;
    private String myCopyRootPath;
    private Map myDirContents;
    private boolean myIsFreshTxnRoot;
    private FSID myFreshRootPredecessorId;
    private long myMergeInfoCount;
    private boolean myHasMergeInfo;

    public void setId(FSID fSID) {
        this.myId = fSID;
    }

    public void setType(SVNNodeKind sVNNodeKind) {
        this.myType = sVNNodeKind;
    }

    public void setCount(long l2) {
        this.myCount = l2;
    }

    public void setPredecessorId(FSID fSID) {
        this.myPredecessorId = fSID;
    }

    public void setTextRepresentation(FSRepresentation fSRepresentation) {
        this.myTextRepresentation = fSRepresentation;
    }

    public void setPropsRepresentation(FSRepresentation fSRepresentation) {
        this.myPropsRepresentation = fSRepresentation;
    }

    public void setCreatedPath(String string) {
        this.myCreatedPath = string;
    }

    public void setCopyFromRevision(long l2) {
        this.myCopyFromRevision = l2;
    }

    public void setCopyFromPath(String string) {
        this.myCopyFromPath = string;
    }

    public void setCopyRootRevision(long l2) {
        this.myCopyRootRevision = l2;
    }

    public void setCopyRootPath(String string) {
        this.myCopyRootPath = string;
    }

    public void setMergeInfoCount(long l2) {
        this.myMergeInfoCount = l2;
    }

    public void setHasMergeInfo(boolean bl2) {
        this.myHasMergeInfo = bl2;
    }

    public FSID getId() {
        return this.myId;
    }

    public SVNNodeKind getType() {
        return this.myType;
    }

    public long getCount() {
        return this.myCount;
    }

    public FSID getPredecessorId() {
        return this.myPredecessorId;
    }

    public FSRepresentation getTextRepresentation() {
        return this.myTextRepresentation;
    }

    public FSRepresentation getPropsRepresentation() {
        return this.myPropsRepresentation;
    }

    public String getCreatedPath() {
        return this.myCreatedPath;
    }

    public long getCreatedRevision() {
        if (this.myFreshRootPredecessorId != null) {
            return this.myFreshRootPredecessorId.getRevision();
        }
        return this.myId.getRevision();
    }

    public long getCopyFromRevision() {
        return this.myCopyFromRevision;
    }

    public String getCopyFromPath() {
        return this.myCopyFromPath;
    }

    public long getCopyRootRevision() {
        return this.myCopyRootRevision;
    }

    public String getCopyRootPath() {
        return this.myCopyRootPath;
    }

    public static FSRevisionNode dumpRevisionNode(FSRevisionNode fSRevisionNode) {
        FSRevisionNode fSRevisionNode2 = new FSRevisionNode();
        fSRevisionNode2.setId(fSRevisionNode.getId());
        if (fSRevisionNode.getPredecessorId() != null) {
            fSRevisionNode2.setPredecessorId(fSRevisionNode.getPredecessorId());
        }
        fSRevisionNode2.setType(fSRevisionNode.getType());
        fSRevisionNode2.setCopyFromPath(fSRevisionNode.getCopyFromPath());
        fSRevisionNode2.setCopyFromRevision(fSRevisionNode.getCopyFromRevision());
        fSRevisionNode2.setCopyRootPath(fSRevisionNode.getCopyRootPath());
        fSRevisionNode2.setCopyRootRevision(fSRevisionNode.getCopyRootRevision());
        fSRevisionNode2.setCount(fSRevisionNode.getCount());
        fSRevisionNode2.setCreatedPath(fSRevisionNode.getCreatedPath());
        if (fSRevisionNode.getPropsRepresentation() != null) {
            fSRevisionNode2.setPropsRepresentation(new FSRepresentation(fSRevisionNode.getPropsRepresentation()));
        }
        if (fSRevisionNode.getTextRepresentation() != null) {
            fSRevisionNode2.setTextRepresentation(new FSRepresentation(fSRevisionNode.getTextRepresentation()));
        }
        fSRevisionNode2.setMergeInfoCount(fSRevisionNode.getMergeInfoCount());
        fSRevisionNode2.setHasMergeInfo(fSRevisionNode.hasMergeInfo());
        return fSRevisionNode2;
    }

    protected Map getDirContents() {
        return this.myDirContents;
    }

    public void setDirContents(Map map) {
        this.myDirContents = map;
    }

    public boolean hasMergeInfo() {
        return this.myHasMergeInfo;
    }

    public long getMergeInfoCount() {
        return this.myMergeInfoCount;
    }

    public boolean hasDescendantsWithMergeInfo() {
        if (this.myType != SVNNodeKind.DIR) {
            return false;
        }
        if (this.myMergeInfoCount > 1L) {
            return true;
        }
        return this.myMergeInfoCount == 1L && !this.myHasMergeInfo;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{[");
        stringBuffer.append("ID:");
        stringBuffer.append(this.myId);
        stringBuffer.append("][");
        stringBuffer.append("text representation:");
        stringBuffer.append(this.myTextRepresentation);
        stringBuffer.append("][");
        stringBuffer.append("Node kind:");
        stringBuffer.append(this.myType);
        stringBuffer.append("]}");
        return stringBuffer.toString();
    }

    public static FSRevisionNode fromMap(Map map) {
        Object object;
        Object object2;
        String string;
        String string2;
        Object object3;
        Object object4;
        Serializable serializable;
        Serializable serializable2;
        FSRevisionNode fSRevisionNode = new FSRevisionNode();
        String string3 = (String)map.get(HEADER_ID);
        if (string3 == null) {
            serializable2 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Missing id field in node-rev");
            SVNErrorManager.error((SVNErrorMessage)serializable2, SVNLogType.FSFS);
        }
        if ((serializable2 = FSID.fromString(string3)) == null) {
            serializable = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Corrupted node-id in node-rev");
            SVNErrorManager.error(serializable, SVNLogType.FSFS);
        }
        fSRevisionNode.setId((FSID)serializable2);
        serializable = SVNNodeKind.parseKind((String)map.get(HEADER_TYPE));
        if (serializable == SVNNodeKind.NONE || serializable == SVNNodeKind.UNKNOWN) {
            object4 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Missing kind field in node-rev");
            SVNErrorManager.error((SVNErrorMessage)object4, SVNLogType.FSFS);
        }
        fSRevisionNode.setType((SVNNodeKind)serializable);
        object4 = (String)map.get(HEADER_COUNT);
        if (object4 == null) {
            fSRevisionNode.setCount(0L);
        } else {
            long l2 = -1L;
            try {
                l2 = Long.parseLong((String)object4);
            }
            catch (NumberFormatException numberFormatException) {
                object3 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Corrupted count field in node-rev");
                SVNErrorManager.error((SVNErrorMessage)object3, SVNLogType.FSFS);
            }
            fSRevisionNode.setCount(l2);
        }
        String string4 = (String)map.get(HEADER_PROPS);
        if (string4 != null) {
            FSRevisionNode.parseRepresentationHeader(string4, fSRevisionNode, ((FSID)serializable2).getTxnID(), false, true);
        }
        if ((string2 = (String)map.get(HEADER_TEXT)) != null) {
            FSRevisionNode.parseRepresentationHeader(string2, fSRevisionNode, ((FSID)serializable2).getTxnID(), true, serializable == SVNNodeKind.DIR);
        }
        if ((string = (String)map.get(HEADER_CPATH)) == null) {
            object3 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Missing cpath in node-rev");
            SVNErrorManager.error((SVNErrorMessage)object3, SVNLogType.FSFS);
        }
        fSRevisionNode.setCreatedPath(string);
        object3 = (String)map.get(HEADER_PRED);
        if (object3 != null) {
            object2 = FSID.fromString((String)object3);
            if (object2 == null) {
                object = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Corrupted predecessor node-id in node-rev");
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
            }
            fSRevisionNode.setPredecessorId((FSID)object2);
        }
        if ((object2 = (String)map.get(HEADER_COPYROOT)) == null) {
            fSRevisionNode.setCopyRootPath(fSRevisionNode.getCreatedPath());
            fSRevisionNode.setCopyRootRevision(fSRevisionNode.getCreatedRevision());
        } else {
            FSRevisionNode.parseCopyRoot((String)object2, fSRevisionNode);
        }
        object = (String)map.get(HEADER_COPYFROM);
        if (object == null) {
            fSRevisionNode.setCopyFromPath(null);
            fSRevisionNode.setCopyFromRevision(-1L);
        } else {
            FSRevisionNode.parseCopyFrom((String)object, fSRevisionNode);
        }
        fSRevisionNode.myIsFreshTxnRoot = map.containsKey(HEADER_IS_FRESH_TXN_ROOT);
        String string5 = (String)map.get(HEADER_MERGE_INFO_COUNT);
        if (string5 == null) {
            fSRevisionNode.myMergeInfoCount = 0L;
        } else {
            try {
                fSRevisionNode.myMergeInfoCount = Long.parseLong(string5);
            }
            catch (NumberFormatException numberFormatException) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Corrupted mergeinfo count in node-rev");
                SVNErrorManager.error(sVNErrorMessage, numberFormatException, SVNLogType.FSFS);
            }
        }
        fSRevisionNode.myHasMergeInfo = map.containsKey(HEADER_MERGE_INFO_HERE);
        return fSRevisionNode;
    }

    public static void parseRepresentationHeader(String string, FSRevisionNode fSRevisionNode, String string2, boolean bl2, boolean bl3) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        if (fSRevisionNode == null) {
            return;
        }
        FSRepresentation fSRepresentation = new FSRepresentation();
        int n2 = string.indexOf(32);
        String string3 = null;
        string3 = n2 == -1 ? string : string.substring(0, n2);
        long l2 = -1L;
        try {
            l2 = Long.parseLong(string3);
        }
        catch (NumberFormatException numberFormatException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed text rep offset line in node-rev");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        fSRepresentation.setRevision(l2);
        if (FSRepository.isInvalidRevision(fSRepresentation.getRevision())) {
            fSRepresentation.setTxnId(string2);
            if (bl2) {
                fSRevisionNode.setTextRepresentation(fSRepresentation);
            } else {
                fSRevisionNode.setPropsRepresentation(fSRepresentation);
            }
            if (bl3) {
                return;
            }
        }
        if ((n2 = (string = string.substring(n2 + 1)).indexOf(32)) == -1) {
            object6 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed text rep offset line in node-rev");
            SVNErrorManager.error((SVNErrorMessage)object6, SVNLogType.FSFS);
        }
        object6 = string.substring(0, n2);
        long l3 = -1L;
        try {
            l3 = Long.parseLong((String)object6);
            if (l3 < 0L) {
                object5 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed text rep offset line in node-rev");
                SVNErrorManager.error((SVNErrorMessage)object5, SVNLogType.FSFS);
            }
        }
        catch (NumberFormatException numberFormatException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed text rep offset line in node-rev");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        fSRepresentation.setItemIndex(l3);
        string = string.substring(n2 + 1);
        n2 = string.indexOf(32);
        if (n2 == -1) {
            object5 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed text rep offset line in node-rev");
            SVNErrorManager.error((SVNErrorMessage)object5, SVNLogType.FSFS);
        }
        object5 = string.substring(0, n2);
        long l4 = -1L;
        try {
            l4 = Long.parseLong((String)object5);
            if (l4 < 0L) {
                object4 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed text rep offset line in node-rev");
                SVNErrorManager.error((SVNErrorMessage)object4, SVNLogType.FSFS);
            }
        }
        catch (NumberFormatException numberFormatException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed text rep offset line in node-rev");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        fSRepresentation.setSize(l4);
        string = string.substring(n2 + 1);
        n2 = string.indexOf(32);
        if (n2 == -1) {
            object4 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed text rep offset line in node-rev");
            SVNErrorManager.error((SVNErrorMessage)object4, SVNLogType.FSFS);
        }
        object4 = string.substring(0, n2);
        long l5 = -1L;
        try {
            l5 = Long.parseLong((String)object4);
            if (l5 < 0L) {
                object3 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed text rep offset line in node-rev");
                SVNErrorManager.error((SVNErrorMessage)object3, SVNLogType.FSFS);
            }
        }
        catch (NumberFormatException numberFormatException) {
            object2 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed text rep offset line in node-rev");
            SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.FSFS);
        }
        fSRepresentation.setExpandedSize(l5);
        string = string.substring(n2 + 1);
        n2 = string.indexOf(32);
        object3 = null;
        object3 = n2 == -1 ? string : string.substring(0, n2);
        if (((String)object3).length() != 32 || SVNFileUtil.fromHexDigest((String)object3) == null) {
            object2 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed text rep offset line in node-rev");
            SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.FSFS);
        }
        fSRepresentation.setMD5HexDigest((String)object3);
        if (bl2) {
            fSRevisionNode.setTextRepresentation(fSRepresentation);
        } else {
            fSRevisionNode.setPropsRepresentation(fSRepresentation);
        }
        if (n2 == -1) {
            return;
        }
        string = string.substring(n2 + 1);
        n2 = string.indexOf(32);
        object2 = null;
        if (n2 == -1) {
            object = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed text rep offset line in node-rev");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        if (!"-".equals(object2 = string.substring(0, n2))) {
            if (((String)object2).length() != 40 || SVNFileUtil.fromHexDigest((String)object2) == null) {
                object = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed text rep offset line in node-rev");
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
            }
            fSRepresentation.setSHA1HexDigest((String)object2);
        }
        if (!"-".equals(object = (n2 = (string = string.substring(n2 + 1)).indexOf(32)) != -1 ? string.substring(0, n2) : string)) {
            fSRepresentation.setUniquifier((String)object);
        }
    }

    private static void parseCopyFrom(String string, FSRevisionNode fSRevisionNode) {
        Object object;
        int n2;
        if (string == null || string.length() == 0) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed copyfrom line in node-rev");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        if ((n2 = string.indexOf(32)) == -1) {
            object = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed copyfrom line in node-rev");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        object = string.substring(0, n2);
        String string2 = string.substring(n2 + 1);
        long l2 = -1L;
        try {
            l2 = Long.parseLong((String)object);
        }
        catch (NumberFormatException numberFormatException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed copyfrom line in node-rev");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        fSRevisionNode.setCopyFromRevision(l2);
        fSRevisionNode.setCopyFromPath(string2);
    }

    private static void parseCopyRoot(String string, FSRevisionNode fSRevisionNode) {
        Object object;
        int n2;
        if (string == null || string.length() == 0) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed copyroot line in node-rev");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        if ((n2 = string.indexOf(32)) == -1) {
            object = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed copyroot line in node-rev");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        object = string.substring(0, n2);
        String string2 = string.substring(n2 + 1);
        long l2 = -1L;
        try {
            l2 = Long.parseLong((String)object);
        }
        catch (NumberFormatException numberFormatException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed copyroot line in node-rev");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        fSRevisionNode.setCopyRootRevision(l2);
        fSRevisionNode.setCopyRootPath(string2);
    }

    public FSRevisionNode getChildDirNode(String string, FSFS fSFS) {
        FSEntry fSEntry;
        Object object;
        if (!SVNPathUtil.isSinglePathComponent(string)) {
            object = SVNErrorMessage.create(SVNErrorCode.FS_NOT_SINGLE_PATH_COMPONENT, "Attempted to open node with an illegal name ''{0}''", (Object)string);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        FSEntry fSEntry2 = fSEntry = (object = this.getDirEntries(fSFS)) != null ? (FSEntry)object.get(string) : null;
        if (fSEntry == null) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "Attempted to open non-existent child node ''{0}''", (Object)string);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        return fSFS.getRevisionNode(fSEntry.getId());
    }

    public Map getDirEntries(FSFS fSFS) {
        Object object;
        if (this.getType() != SVNNodeKind.DIR) {
            object = SVNErrorMessage.create(SVNErrorCode.FS_NOT_DIRECTORY, "Can't get entries of non-directory");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        if ((object = this.getDirContents()) == null) {
            object = fSFS.getDirContents(this);
            this.setDirContents((Map)object);
        }
        return Collections.unmodifiableMap(object);
    }

    public SVNProperties getProperties(FSFS fSFS) {
        return fSFS.getProperties(this);
    }

    public FSRepresentation chooseDeltaBase(FSFS fSFS) {
        if (this.getCount() == 0L) {
            return null;
        }
        long l2 = this.getCount();
        l2 &= l2 - 1L;
        FSRevisionNode fSRevisionNode = this;
        while (l2++ < this.getCount()) {
            fSRevisionNode = fSFS.getRevisionNode(fSRevisionNode.getPredecessorId());
        }
        return fSRevisionNode.getTextRepresentation();
    }

    public String getFileMD5Checksum() {
        if (this.getType() != SVNNodeKind.FILE) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FILE, "Attempted to get checksum of a *non*-file node");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        return this.getTextRepresentation() != null ? this.getTextRepresentation().getMD5HexDigest() : "";
    }

    public String getFileSHA1Checksum() {
        if (this.getType() != SVNNodeKind.FILE) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FILE, "Attempted to get checksum of a *non*-file node");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        return this.getTextRepresentation() != null ? this.getTextRepresentation().getSHA1HexDigest() : "";
    }

    public long getFileLength() {
        if (this.getType() != SVNNodeKind.FILE) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FILE, "Attempted to get length of a *non*-file node");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        return this.getTextRepresentation() != null ? this.getTextRepresentation().getExpandedSize() : 0L;
    }

    public void setIsFreshTxnRoot(boolean bl2) {
        this.myIsFreshTxnRoot = bl2;
    }

    public boolean isFreshTxnRoot() {
        return this.myIsFreshTxnRoot;
    }

    public void setFreshRootPredecessorId(FSID fSID) {
        this.myFreshRootPredecessorId = fSID;
    }
}

