/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.File;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.IFSRepresentationCacheManager;
import org.tmatesoft.svn.core.internal.io.fs.repcache.IFSRepresentationCacheManagerFactory;
import org.tmatesoft.svn.core.internal.wc.SVNClassLoader;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class FSRepresentationCacheUtil {
    private static volatile boolean ourIsAvailable;
    private static final String SQLJET_DB_CLASS_NAME = "org.tmatesoft.sqljet.core.table.SqlJetDb";
    private static final String ANTLR_CLASS_NAME = "org.antlr.runtime.Token";
    private static IFSRepresentationCacheManagerFactory ourRepCacheManagerFactory;

    public static IFSRepresentationCacheManager open(FSFS fSFS) {
        if (!FSRepresentationCacheUtil.isAvailable()) {
            return null;
        }
        if (ourRepCacheManagerFactory != null) {
            return ourRepCacheManagerFactory.openRepresentationCache(fSFS);
        }
        return null;
    }

    public static void create(int n2, File file) {
        if (!FSRepresentationCacheUtil.isAvailable()) {
            return;
        }
        if (ourRepCacheManagerFactory != null) {
            ourRepCacheManagerFactory.createRepresentationCache(n2, file);
        }
    }

    private static boolean isAvailable() {
        return ourIsAvailable;
    }

    static {
        block6: {
            Boolean bl2 = Boolean.valueOf(System.getProperty("svnkit.fsfs.repcache", "true"));
            if (bl2.booleanValue()) {
                try {
                    Class<?> clazz = FSRepresentationCacheUtil.class.getClassLoader().loadClass(ANTLR_CLASS_NAME);
                    if (clazz == null) {
                        ourIsAvailable = false;
                        break block6;
                    }
                    Class<?> clazz2 = FSRepresentationCacheUtil.class.getClassLoader().loadClass(SQLJET_DB_CLASS_NAME);
                    boolean bl3 = ourIsAvailable = clazz2 != null;
                    if (!ourIsAvailable) break block6;
                    ourRepCacheManagerFactory = SVNClassLoader.getFSRepresentationCacheManagerFactory();
                    if (ourRepCacheManagerFactory != null) {
                        ourIsAvailable = true;
                        break block6;
                    }
                    ourIsAvailable = false;
                }
                catch (Throwable throwable) {
                    ourIsAvailable = false;
                }
            } else {
                ourIsAvailable = false;
            }
        }
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.FSFS, "SQLJET enabled: " + ourIsAvailable);
    }
}

