/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;

public class FSRepresentation {
    public static final String REP_DELTA = "DELTA";
    public static final String REP_PLAIN = "PLAIN";
    public static final String REP_TRAILER = "ENDREP";
    private long myRevision;
    private long myItemIndex;
    private long mySize;
    private long myExpandedSize;
    private String myMD5HexDigest;
    private String mySHA1HexDigest;
    private String myTxnId;
    private String myUniquifier;

    public static FSRepresentation parse(String string) {
        String[] stringArray = string.split(" ");
        if (stringArray.length != 5 && stringArray.length != 7) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed text representation offset line in node-rev");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        try {
            long l2 = Long.parseLong(stringArray[0]);
            long l3 = Long.parseLong(stringArray[1]);
            long l4 = Long.parseLong(stringArray[2]);
            long l5 = Long.parseLong(stringArray[3]);
            String string2 = stringArray[4];
            FSRepresentation fSRepresentation = new FSRepresentation();
            fSRepresentation.setRevision(l2);
            fSRepresentation.setItemIndex(l3);
            fSRepresentation.setSize(l4);
            fSRepresentation.setExpandedSize(l5);
            fSRepresentation.setMD5HexDigest(string2);
            if (stringArray.length == 7) {
                Object object;
                String string3 = stringArray[5];
                String[] stringArray2 = stringArray[6].split("/_");
                if (stringArray2.length != 2) {
                    object = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed text representation offset line in node-rev");
                    SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
                }
                object = stringArray2[0];
                fSRepresentation.setSHA1HexDigest(string3);
                fSRepresentation.setTxnId((String)object);
                fSRepresentation.setUniquifier(stringArray[6]);
            }
            return fSRepresentation;
        }
        catch (NumberFormatException numberFormatException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed text representation offset line in node-rev");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            return null;
        }
    }

    public FSRepresentation(FSRepresentation fSRepresentation) {
        this.myRevision = fSRepresentation.myRevision;
        this.myItemIndex = fSRepresentation.myItemIndex;
        this.mySize = fSRepresentation.mySize;
        this.myExpandedSize = fSRepresentation.myExpandedSize;
        this.myMD5HexDigest = fSRepresentation.myMD5HexDigest;
        this.mySHA1HexDigest = fSRepresentation.mySHA1HexDigest;
        this.myUniquifier = fSRepresentation.myUniquifier;
        this.myTxnId = fSRepresentation.myTxnId;
    }

    public FSRepresentation() {
        this.myRevision = -1L;
        this.myItemIndex = -1L;
        this.mySize = -1L;
        this.myExpandedSize = -1L;
    }

    public void setRevision(long l2) {
        this.myRevision = l2;
    }

    public void setItemIndex(long l2) {
        this.myItemIndex = l2;
    }

    public void setSize(long l2) {
        this.mySize = l2;
    }

    public void setExpandedSize(long l2) {
        this.myExpandedSize = l2;
    }

    public void setMD5HexDigest(String string) {
        this.myMD5HexDigest = string;
    }

    public String getSHA1HexDigest() {
        return this.mySHA1HexDigest;
    }

    public void setSHA1HexDigest(String string) {
        this.mySHA1HexDigest = string;
    }

    public String getUniquifier() {
        return this.myUniquifier;
    }

    public void setUniquifier(String string) {
        this.myUniquifier = string;
    }

    public long getRevision() {
        return this.myRevision;
    }

    public long getItemIndex() {
        return this.myItemIndex;
    }

    public long getSize() {
        return this.mySize;
    }

    public long getExpandedSize() {
        return this.myExpandedSize;
    }

    public String getMD5HexDigest() {
        return this.myMD5HexDigest;
    }

    public static boolean compareRepresentations(FSRepresentation fSRepresentation, FSRepresentation fSRepresentation2) {
        if (fSRepresentation == fSRepresentation2) {
            return true;
        }
        if (fSRepresentation == null) {
            return false;
        }
        return fSRepresentation.equals(fSRepresentation2);
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != FSRepresentation.class) {
            return false;
        }
        FSRepresentation fSRepresentation = (FSRepresentation)object;
        if (this.myRevision != fSRepresentation.myRevision) {
            return false;
        }
        if (this.myItemIndex != fSRepresentation.myItemIndex) {
            return false;
        }
        if (this.myUniquifier == fSRepresentation.myUniquifier) {
            return true;
        }
        if (this.myUniquifier == null || fSRepresentation.myUniquifier == null) {
            return false;
        }
        return this.myUniquifier.equals(fSRepresentation.myUniquifier);
    }

    public String getStringRepresentation(int n2) {
        if (n2 < 4 || this.mySHA1HexDigest == null || this.myUniquifier == null) {
            return this.myRevision + " " + this.myItemIndex + " " + this.mySize + " " + this.myExpandedSize + " " + this.myMD5HexDigest;
        }
        return this.myRevision + " " + this.myItemIndex + " " + this.mySize + " " + this.myExpandedSize + " " + this.myMD5HexDigest + " " + this.mySHA1HexDigest + " " + this.myUniquifier;
    }

    public String getTxnId() {
        return this.myTxnId;
    }

    public void setTxnId(String string) {
        this.myTxnId = string;
    }

    public boolean isTxn() {
        return this.myTxnId != null;
    }
}

