/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.LinkedList;
import java.util.Map;
import org.tmatesoft.svn.core.ISVNCanceller;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaCombiner;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSFile;
import org.tmatesoft.svn.core.internal.io.fs.FSInputStream;
import org.tmatesoft.svn.core.internal.io.fs.FSPathChange;
import org.tmatesoft.svn.core.internal.io.fs.FSReplayPathHandler;
import org.tmatesoft.svn.core.internal.io.fs.FSRepository;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil$1;
import org.tmatesoft.svn.core.internal.io.fs.FSRepresentation;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionRoot;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNUUIDGenerator;
import org.tmatesoft.svn.core.internal.wc.IOExceptionWrapper;
import org.tmatesoft.svn.core.internal.wc.SVNCommitUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDeltaGenerator;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.util.SVNLogType;

public class FSRepositoryUtil {
    public static final int MAX_KEY_SIZE = 200;
    private static final int BYTES_IN_LONG = 8;
    private static final ThreadLocal ourCopyBuffer = new FSRepositoryUtil$1();

    public static String generateLockToken() {
        String string = SVNUUIDGenerator.formatUUID(SVNUUIDGenerator.generateUUID());
        return "opaquelocktoken:" + string;
    }

    public static void replay(FSFS fSFS, FSRoot fSRoot, String string, long l2, boolean bl2, ISVNEditor iSVNEditor) {
        Map map = fSRoot.getChangedPaths();
        string = string.startsWith("/") ? string.substring(1) : string;
        LinkedList<String> linkedList = new LinkedList<String>();
        SVNHashMap sVNHashMap = new SVNHashMap();
        for (String string2 : map.keySet()) {
            FSPathChange fSPathChange = (FSPathChange)map.get(string2);
            String string3 = string2 = string2.startsWith("/") ? string2.substring(1) : string2;
            if (SVNPathUtil.isWithinBasePath(string, string2)) {
                linkedList.add(string2);
                sVNHashMap.put(string2, fSPathChange);
                continue;
            }
            if (!SVNPathUtil.isWithinBasePath(string2, string)) continue;
            linkedList.add(string2);
            sVNHashMap.put(string2, fSPathChange);
        }
        if (FSRepository.isInvalidRevision(l2)) {
            l2 = 0L;
        }
        Object object = null;
        if (bl2) {
            long l3 = -1L;
            if (fSRoot instanceof FSRevisionRoot) {
                FSRevisionRoot fSRevisionRoot = (FSRevisionRoot)fSRoot;
                l3 = fSRevisionRoot.getRevision() - 1L;
            } else if (fSRoot instanceof FSTransactionRoot) {
                FSTransactionRoot fSTransactionRoot = (FSTransactionRoot)fSRoot;
                l3 = fSTransactionRoot.getTxn().getBaseRevision();
            }
            object = fSFS.createRevisionRoot(l3);
        }
        if (fSRoot instanceof FSRevisionRoot) {
            FSRevisionRoot fSRevisionRoot = (FSRevisionRoot)fSRoot;
            iSVNEditor.targetRevision(fSRevisionRoot.getRevision());
        }
        FSReplayPathHandler fSReplayPathHandler = new FSReplayPathHandler(fSFS, fSRoot, (FSRoot)object, sVNHashMap, string, l2);
        SVNCommitUtil.driveCommitEditor(fSReplayPathHandler, linkedList, iSVNEditor, -1L);
    }

    public static void copy(InputStream inputStream, OutputStream outputStream, ISVNCanceller iSVNCanceller) {
        try {
            int n2;
            byte[] byArray = (byte[])ourCopyBuffer.get();
            do {
                if (iSVNCanceller != null) {
                    iSVNCanceller.checkCancelled();
                }
                if ((n2 = inputStream.read(byArray)) <= 0) continue;
                outputStream.write(byArray, 0, n2);
            } while (n2 >= 0);
        }
        catch (IOExceptionWrapper iOExceptionWrapper) {
            throw iOExceptionWrapper.getOriginalException();
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage());
            SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.FSFS);
        }
    }

    public static boolean arePropertiesEqual(FSRevisionNode fSRevisionNode, FSRevisionNode fSRevisionNode2) {
        return FSRepositoryUtil.areRepresentationsEqual(fSRevisionNode, fSRevisionNode2, true);
    }

    public static boolean arePropertiesChanged(FSRoot fSRoot, String string, FSRoot fSRoot2, String string2) {
        FSRevisionNode fSRevisionNode;
        FSRevisionNode fSRevisionNode2 = fSRoot.getRevisionNode(string);
        return !FSRepositoryUtil.areRepresentationsEqual(fSRevisionNode2, fSRevisionNode = fSRoot2.getRevisionNode(string2), true);
    }

    public static boolean areFileContentsChanged(FSRoot fSRoot, String string, FSRoot fSRoot2, String string2) {
        FSRevisionNode fSRevisionNode;
        Object object;
        if (fSRoot.checkNodeKind(string) != SVNNodeKind.FILE) {
            object = SVNErrorMessage.create(SVNErrorCode.FS_GENERAL, "''{0}'' is not a file", (Object)string);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        if (fSRoot2.checkNodeKind(string2) != SVNNodeKind.FILE) {
            object = SVNErrorMessage.create(SVNErrorCode.FS_GENERAL, "''{0}'' is not a file", (Object)string2);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        return !FSRepositoryUtil.areRepresentationsEqual((FSRevisionNode)(object = fSRoot.getRevisionNode(string)), fSRevisionNode = fSRoot2.getRevisionNode(string2), false);
    }

    public static SVNProperties getPropsDiffs(SVNProperties sVNProperties, SVNProperties sVNProperties2) {
        SVNPropertyValue sVNPropertyValue;
        SVNPropertyValue sVNPropertyValue2;
        SVNProperties sVNProperties3 = new SVNProperties();
        if (sVNProperties == null) {
            sVNProperties = new SVNProperties();
        }
        if (sVNProperties2 == null) {
            sVNProperties2 = new SVNProperties();
        }
        for (String string : sVNProperties.nameSet()) {
            sVNPropertyValue2 = sVNProperties.getSVNPropertyValue(string);
            sVNPropertyValue = sVNProperties2.getSVNPropertyValue(string);
            if (sVNPropertyValue == null) {
                sVNProperties3.put(string, sVNPropertyValue);
                continue;
            }
            if (sVNPropertyValue.equals(sVNPropertyValue2)) continue;
            sVNProperties3.put(string, sVNPropertyValue);
        }
        for (String string : sVNProperties2.nameSet()) {
            sVNPropertyValue2 = sVNProperties2.getSVNPropertyValue(string);
            sVNPropertyValue = sVNProperties.getSVNPropertyValue(string);
            if (sVNPropertyValue != null) continue;
            sVNProperties3.put(string, sVNPropertyValue2);
        }
        return sVNProperties3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkFilesDifferent(FSRoot var0, String var1_1, FSRoot var2_2, String var3_3, SVNDeltaCombiner var4_4) {
        var5_5 = FSRepositoryUtil.areFileContentsChanged(var0, var1_1, var2_2, var3_3);
        if (!var5_5) {
            return false;
        }
        var6_6 = var0.getRevisionNode(var1_1);
        var7_7 = var2_2.getRevisionNode(var3_3);
        if (var6_6.getFileLength() != var7_7.getFileLength()) {
            return true;
        }
        if (!var6_6.getFileMD5Checksum().equals(var7_7.getFileMD5Checksum())) {
            return true;
        }
        var8_8 = null;
        var9_9 = null;
        try {
            var8_8 = var0.getFileStreamForPath(var4_4, var1_1);
            var9_9 = var2_2.getFileStreamForPath(var4_4, var3_3);
            var10_10 = -1;
            var11_12 = -1;
            while (true) {
                var10_10 = var8_8.read();
                if (var10_10 == (var11_12 = var9_9.read())) continue;
                var12_14 = true;
                ** GOTO lbl31
                break;
            }
        }
        catch (IOException var10_11) {
            try {
                var11_13 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, var10_11.getLocalizedMessage());
                SVNErrorManager.error(var11_13, var10_11, SVNLogType.FSFS);
            }
            catch (Throwable var13_15) {
                SVNFileUtil.closeFile(var8_8);
                SVNFileUtil.closeFile(var9_9);
                throw var13_15;
            }
lbl31:
            // 1 sources

            SVNFileUtil.closeFile(var8_8);
            SVNFileUtil.closeFile(var9_9);
            return var12_14;
            {
                if (var10_10 != -1) ** continue;
            }
            SVNFileUtil.closeFile(var8_8);
            SVNFileUtil.closeFile(var9_9);
            return false;
            SVNFileUtil.closeFile(var8_8);
            SVNFileUtil.closeFile(var9_9);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendTextDelta(ISVNEditor iSVNEditor, String string, String string2, String string3, FSRevisionRoot fSRevisionRoot, String string4, FSRoot fSRoot, boolean bl2, SVNDeltaCombiner sVNDeltaCombiner, SVNDeltaGenerator sVNDeltaGenerator, FSFS fSFS) {
        block3: {
            block2: {
                iSVNEditor.applyTextDelta(string, string3);
                if (!bl2) break block2;
                InputStream inputStream = null;
                InputStream inputStream2 = null;
                try {
                    inputStream = fSRevisionRoot != null && string2 != null ? fSRevisionRoot.getFileStreamForPath(sVNDeltaCombiner, string2) : FSInputStream.createDeltaStream(sVNDeltaCombiner, (FSRevisionNode)null, fSFS);
                    inputStream2 = fSRoot.getFileStreamForPath(sVNDeltaCombiner, string4);
                    sVNDeltaGenerator.sendDelta(string, inputStream, 0L, inputStream2, iSVNEditor, false);
                }
                catch (Throwable throwable) {
                    SVNFileUtil.closeFile(inputStream);
                    SVNFileUtil.closeFile(inputStream2);
                    throw throwable;
                }
                SVNFileUtil.closeFile(inputStream);
                SVNFileUtil.closeFile(inputStream2);
                break block3;
            }
            iSVNEditor.textDeltaChunk(string, SVNDiffWindow.EMPTY);
            iSVNEditor.textDeltaEnd(string);
        }
    }

    public static void loadRootChangesOffsetLogicalAddressing(FSFS fSFS, long l2, FSFile fSFile, long l3, long[] lArray, long[] lArray2) {
        long l4 = fSFS.lookupOffsetInIndex(fSFile, l2, l3);
        if (lArray != null) {
            lArray[0] = l4;
        }
        if (lArray2 != null) {
            lArray2[0] = l4;
        }
    }

    public static void loadRootChangesOffset(FSFS fSFS, long l2, FSFile fSFile, long[] lArray, long[] lArray2) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(64);
        long l3 = 0L;
        l3 = fSFS.isPackedRevision(l2) && (l2 + 1L) % fSFS.getMaxFilesPerDirectory() != 0L ? fSFS.getPackedOffset(l2 + 1L) : fSFile.size();
        long l4 = 0L;
        if (fSFS.isPackedRevision(l2)) {
            l4 = fSFS.getPackedOffset(l2);
        }
        fSFile.seek(l3 - 64L);
        try {
            fSFile.read(byteBuffer);
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getMessage());
            SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.FSFS);
        }
        byteBuffer.flip();
        if (byteBuffer.get(byteBuffer.limit() - 1) != 10) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Revision file lacks trailing newline");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        int n2 = -1;
        int n3 = -1;
        for (int i2 = byteBuffer.limit() - 2; i2 >= 0; --i2) {
            byte by = byteBuffer.get(i2);
            if (by == 32 && n2 < 0) {
                n2 = i2;
                continue;
            }
            if (by != 10 || n3 >= 0) continue;
            n3 = i2;
            break;
        }
        if (n3 < 0) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Final line in revision file longer than 64 characters");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        if (n2 < 0) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Final line in revision file missing space");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        CharsetDecoder charsetDecoder = Charset.forName("UTF-8").newDecoder();
        try {
            byteBuffer.limit(byteBuffer.limit() - 1);
            byteBuffer.position(n2 + 1);
            String string = charsetDecoder.decode(byteBuffer).toString();
            if (lArray2 != null && lArray2.length > 0) {
                lArray2[0] = l4 + Long.parseLong(string);
            }
            byteBuffer.limit(n2);
            byteBuffer.position(n3 + 1);
            string = charsetDecoder.decode(byteBuffer).toString();
            if (lArray != null && lArray.length > 0) {
                lArray[0] = l4 + Long.parseLong(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Final line in revision file missing changes and root offsets");
            SVNErrorManager.error(sVNErrorMessage, numberFormatException, SVNLogType.FSFS);
        }
        catch (CharacterCodingException characterCodingException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Final line in revision file missing changes and root offsets");
            SVNErrorManager.error(sVNErrorMessage, characterCodingException, SVNLogType.FSFS);
        }
    }

    public static String generateNextKey(String string) {
        int n2;
        char[] cArray = new char[string.length() + 1];
        boolean bl2 = true;
        if (string.length() > 1 && string.charAt(0) == '0') {
            return null;
        }
        for (n2 = string.length() - 1; n2 >= 0; --n2) {
            char c2 = string.charAt(n2);
            if (!(c2 >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'z')) {
                return null;
            }
            if (bl2) {
                if (c2 == 'z') {
                    cArray[n2] = 48;
                    continue;
                }
                bl2 = false;
                if (c2 == '9') {
                    cArray[n2] = 97;
                    continue;
                }
                cArray[n2] = (char)(c2 + '\u0001');
                continue;
            }
            cArray[n2] = c2;
        }
        n2 = string.length() + (bl2 ? 1 : 0);
        if (n2 >= 200) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "FATAL error: new key length is greater than the threshold {0}", new Object[]{200});
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        if (bl2) {
            System.arraycopy(cArray, 0, cArray, 1, string.length());
            cArray[0] = 49;
        }
        return new String(cArray, 0, n2);
    }

    public static void checkReposDBFormat(int n2) {
        SVNErrorMessage sVNErrorMessage;
        if (n2 == 5) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_UNSUPPORTED_FORMAT, "Found format '%s', only created by unreleased dev builds; see http://subversion.apache.org/docs/release-notes/1.7#revprop-packing", new Object[]{5});
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        if (n2 < 1 || n2 > 8) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_UNSUPPORTED_FORMAT, "Expected FS format between ''{0}'' and ''{1}''; found format ''{2}''", 1, 8, n2);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
    }

    public static void validateProperty(String string, SVNPropertyValue sVNPropertyValue) {
        if (!SVNProperty.isRegularProperty(string)) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.REPOS_BAD_ARGS, "Storage of non-regular property ''{0}'' is disallowed through the repository interface, and could indicate a bug in your client", (Object)string);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        if (SVNProperty.isSVNProperty(string) && sVNPropertyValue != null && "svn:date".equals(string)) {
            try {
                SVNDate.parseDateString(sVNPropertyValue.getString());
            }
            catch (SVNException sVNException) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.BAD_PROPERTY_VALUE);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
        }
    }

    public static long align(long l2, long l3) {
        return l2 + l3 - 1L & (l3 - 1L ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static long readLongLittleEndian(RandomAccessFile randomAccessFile) {
        byte[] byArray = new byte[8];
        int n2 = randomAccessFile.read(byArray, 0, 8);
        if (n2 < 0) {
            return n2;
        }
        long l2 = 0L;
        for (int i2 = 7; i2 >= 0; --i2) {
            l2 = (l2 << 8) + ((long)byArray[i2] & 0xFFL);
        }
        return l2;
    }

    public static void writeLongLittleEndian(RandomAccessFile randomAccessFile, long l2) {
        byte[] byArray = new byte[8];
        for (int i2 = 0; i2 < 8; ++i2) {
            byArray[i2] = (byte)l2;
            l2 >>= 8;
        }
        randomAccessFile.write(byArray, 0, 8);
    }

    public static int encodeInt(byte[] byArray, long l2) {
        return FSRepositoryUtil.encodeUnsignedInt(byArray, l2 < 0L ? -1L - 2L * l2 : 2L * l2);
    }

    public static int encodeUnsignedInt(byte[] byArray, long l2) {
        l2 &= 0xFFFFFFFFL;
        int n2 = 0;
        while (l2 >= 128L) {
            byArray[n2] = (byte)(l2 % 128L + 128L);
            l2 /= 128L;
            ++n2;
        }
        byArray[n2] = (byte)(l2 % 128L);
        return n2 + 1;
    }

    private static boolean areRepresentationsEqual(FSRevisionNode fSRevisionNode, FSRevisionNode fSRevisionNode2, boolean bl2) {
        if (fSRevisionNode == fSRevisionNode2) {
            return true;
        }
        if (fSRevisionNode == null || fSRevisionNode2 == null) {
            return false;
        }
        return FSRepresentation.compareRepresentations(bl2 ? fSRevisionNode.getPropsRepresentation() : fSRevisionNode.getTextRepresentation(), bl2 ? fSRevisionNode2.getPropsRepresentation() : fSRevisionNode2.getTextRepresentation());
    }
}

