/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNMergeInfoInheritance;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.BasicAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNUserNameAuthentication;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaCombiner;
import org.tmatesoft.svn.core.internal.io.fs.FSCommitEditor;
import org.tmatesoft.svn.core.internal.io.fs.FSEntry;
import org.tmatesoft.svn.core.internal.io.fs.FSErrors;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSFileRevisionsFinder;
import org.tmatesoft.svn.core.internal.io.fs.FSHooks;
import org.tmatesoft.svn.core.internal.io.fs.FSLocationsFinder;
import org.tmatesoft.svn.core.internal.io.fs.FSLog;
import org.tmatesoft.svn.core.internal.io.fs.FSRepository$1;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSTranslateReporter;
import org.tmatesoft.svn.core.internal.io.fs.FSUpdateContext;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNMergeInfoManager;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNFileRevisionHandler;
import org.tmatesoft.svn.core.io.ISVNInheritedPropertiesHandler;
import org.tmatesoft.svn.core.io.ISVNLocationEntryHandler;
import org.tmatesoft.svn.core.io.ISVNLocationSegmentHandler;
import org.tmatesoft.svn.core.io.ISVNLockHandler;
import org.tmatesoft.svn.core.io.ISVNReplayHandler;
import org.tmatesoft.svn.core.io.ISVNReporter;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.ISVNSession;
import org.tmatesoft.svn.core.io.ISVNWorkspaceMediator;
import org.tmatesoft.svn.core.io.SVNCapability;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.util.SVNLogType;

public class FSRepository
extends SVNRepository
implements ISVNReporter {
    private File myReposRootDir;
    private FSUpdateContext myReporterContext;
    private FSLocationsFinder myLocationsFinder;
    private FSFS myFSFS;
    private SVNMergeInfoManager myMergeInfoManager;
    private FSLog myLogDriver;
    private boolean myIsHooksEnabled;

    protected FSRepository(SVNURL sVNURL, ISVNSession iSVNSession) {
        super(sVNURL, iSVNSession);
        this.setHooksEnabled(true);
    }

    public void setHooksEnabled(boolean bl2) {
        this.myIsHooksEnabled = bl2;
        if (this.getFSFS() != null) {
            this.getFSFS().setHooksEnabled(this.isHooksEnabled());
        }
    }

    public boolean isHooksEnabled() {
        return this.myIsHooksEnabled;
    }

    public FSFS getFSFS() {
        return this.myFSFS;
    }

    @Override
    public void testConnection() {
        try {
            this.openRepository();
        }
        finally {
            this.closeRepository();
        }
    }

    public File getRepositoryRootDir() {
        return this.myReposRootDir;
    }

    public int getReposFormat() {
        return this.myFSFS.getReposFormat();
    }

    @Override
    public long getLatestRevision() {
        try {
            this.openRepository();
            long l2 = this.myFSFS.getYoungestRevision();
            return l2;
        }
        finally {
            this.closeRepository();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getDatedRevision(Date date) {
        if (date == null) {
            return this.getLatestRevision();
        }
        try {
            this.openRepository();
            long l2 = this.myFSFS.getDatedRevision(date);
            return l2;
        }
        finally {
            this.closeRepository();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SVNProperties getRevisionProperties(long l2, SVNProperties sVNProperties) {
        FSRepository.assertValidRevision(l2);
        try {
            this.openRepository();
            sVNProperties = sVNProperties == null ? new SVNProperties() : sVNProperties;
            sVNProperties.putAll(this.myFSFS.getRevisionProperties(l2));
        }
        finally {
            this.closeRepository();
        }
        return sVNProperties;
    }

    @Override
    public void setRevisionPropertyValue(long l2, String string, SVNPropertyValue sVNPropertyValue) {
        this.setRevisionPropertyValue(l2, string, sVNPropertyValue, false);
    }

    public void setRevisionPropertyValue(long l2, String string, SVNPropertyValue sVNPropertyValue, boolean bl2) {
        this.setRevisionPropertyValue(l2, string, sVNPropertyValue, bl2, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRevisionPropertyValue(long l2, String string, SVNPropertyValue sVNPropertyValue, boolean bl2, boolean bl3) {
        FSRepository.assertValidRevision(l2);
        try {
            this.openRepository();
            FSRepositoryUtil.validateProperty(string, sVNPropertyValue);
            String string2 = this.getUserName();
            SVNProperties sVNProperties = this.myFSFS.getRevisionProperties(l2);
            SVNPropertyValue sVNPropertyValue2 = sVNProperties.getSVNPropertyValue(string);
            String string3 = null;
            string3 = sVNPropertyValue == null ? "D" : (sVNPropertyValue2 == null ? "A" : "M");
            byte[] byArray = SVNPropertyValue.getPropertyAsBytes(sVNPropertyValue);
            if (this.isHooksEnabled() && FSHooks.isHooksEnabled() && !bl2) {
                FSHooks.runPreRevPropChangeHook(this.myReposRootDir, string, byArray, string2, l2, string3);
            }
            this.myFSFS.setRevisionProperty(l2, string, sVNPropertyValue);
            if (this.isHooksEnabled() && FSHooks.isHooksEnabled() && !bl3) {
                FSHooks.runPostRevPropChangeHook(this.myReposRootDir, string, byArray, string2, l2, string3);
            }
        }
        finally {
            this.closeRepository();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SVNPropertyValue getRevisionPropertyValue(long l2, String string) {
        FSRepository.assertValidRevision(l2);
        if (string == null) {
            return null;
        }
        try {
            this.openRepository();
            SVNPropertyValue sVNPropertyValue = this.myFSFS.getRevisionProperties(l2).getSVNPropertyValue(string);
            return sVNPropertyValue;
        }
        finally {
            this.closeRepository();
        }
    }

    @Override
    public SVNNodeKind checkPath(String string, long l2) {
        try {
            this.openRepository();
            if (!SVNRepository.isValidRevision(l2)) {
                l2 = this.myFSFS.getYoungestRevision();
            }
            String string2 = this.getRepositoryPath(string);
            FSRevisionRoot fSRevisionRoot = this.myFSFS.createRevisionRoot(l2);
            SVNNodeKind sVNNodeKind = fSRevisionRoot.checkNodeKind(string2);
            return sVNNodeKind;
        }
        catch (SVNException sVNException) {
            if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.FS_NOT_DIRECTORY) {
                SVNNodeKind sVNNodeKind = SVNNodeKind.NONE;
                return sVNNodeKind;
            }
            throw sVNException;
        }
        finally {
            this.closeRepository();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFile(String string, long l2, SVNProperties sVNProperties, OutputStream outputStream) {
        try {
            Object object;
            this.openRepository();
            if (!SVNRepository.isValidRevision(l2)) {
                l2 = this.myFSFS.getYoungestRevision();
            }
            String string2 = this.getRepositoryPath(string);
            FSRevisionRoot fSRevisionRoot = this.myFSFS.createRevisionRoot(l2);
            if (outputStream != null) {
                object = null;
                try {
                    object = fSRevisionRoot.getFileStreamForPath(new SVNDeltaCombiner(), string2);
                    FSRepositoryUtil.copy((InputStream)object, outputStream, this.getCanceller());
                }
                finally {
                    SVNFileUtil.closeFile((InputStream)object);
                }
            }
            if (sVNProperties != null) {
                object = fSRevisionRoot.getRevisionNode(string2);
                if (((FSRevisionNode)object).getFileMD5Checksum() != null) {
                    sVNProperties.put("svn:entry:checksum", ((FSRevisionNode)object).getFileMD5Checksum());
                }
                if (l2 >= 0L) {
                    sVNProperties.put("svn:entry:revision", Long.toString(l2));
                }
                sVNProperties.putAll(this.collectProperties((FSRevisionNode)object));
            }
            long l3 = l2;
            return l3;
        }
        finally {
            this.closeRepository();
        }
    }

    @Override
    public long getDir(String string, long l2, SVNProperties sVNProperties, ISVNDirEntryHandler iSVNDirEntryHandler) {
        return this.getDir(string, l2, sVNProperties, -1, iSVNDirEntryHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SVNDirEntry getDir(String string, long l2, boolean bl2, Collection collection) {
        try {
            SVNDirEntry sVNDirEntry;
            this.openRepository();
            if (!SVNRepository.isValidRevision(l2)) {
                l2 = this.myFSFS.getYoungestRevision();
            }
            String string2 = this.getRepositoryPath(string);
            SVNURL sVNURL = this.getLocation().appendPath(string, false);
            FSRevisionRoot fSRevisionRoot = this.myFSFS.createRevisionRoot(l2);
            FSRevisionNode fSRevisionNode = fSRevisionRoot.getRevisionNode(string2);
            if (collection != null) {
                collection.addAll(this.getDirEntries(fSRevisionNode, sVNURL, -1));
            }
            SVNDirEntry sVNDirEntry2 = sVNDirEntry = this.buildDirEntry(new FSEntry(fSRevisionNode.getId(), fSRevisionNode.getType(), ""), sVNURL, fSRevisionNode, -1);
            return sVNDirEntry2;
        }
        finally {
            this.closeRepository();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getDir(String string, long l2, SVNProperties sVNProperties, int n2, ISVNDirEntryHandler iSVNDirEntryHandler) {
        try {
            this.openRepository();
            if (!SVNRepository.isValidRevision(l2)) {
                l2 = this.myFSFS.getYoungestRevision();
            }
            String string2 = this.getRepositoryPath(string);
            FSRevisionRoot fSRevisionRoot = this.myFSFS.createRevisionRoot(l2);
            FSRevisionNode fSRevisionNode = fSRevisionRoot.getRevisionNode(string2);
            if (iSVNDirEntryHandler != null) {
                SVNURL sVNURL = this.getLocation().appendPath(string, false);
                Collection collection = this.getDirEntries(fSRevisionNode, sVNURL, n2);
                for (SVNDirEntry sVNDirEntry : collection) {
                    iSVNDirEntryHandler.handleDirEntry(sVNDirEntry);
                }
            }
            if (sVNProperties != null) {
                sVNProperties.putAll(this.collectProperties(fSRevisionNode));
            }
            long l3 = l2;
            return l3;
        }
        finally {
            this.closeRepository();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int getFileRevisionsImpl(String string, long l2, long l3, boolean bl2, ISVNFileRevisionHandler iSVNFileRevisionHandler) {
        try {
            int n2;
            this.openRepository();
            string = this.getRepositoryPath(string);
            long l4 = -1L;
            if (FSRepository.isInvalidRevision(l2)) {
                l2 = l4 = this.myFSFS.getYoungestRevision();
            }
            if (FSRepository.isInvalidRevision(l3)) {
                if (FSRepository.isInvalidRevision(l4)) {
                    l4 = this.myFSFS.getYoungestRevision();
                }
                l3 = l4;
            }
            FSFileRevisionsFinder fSFileRevisionsFinder = new FSFileRevisionsFinder(this.myFSFS);
            int n3 = n2 = fSFileRevisionsFinder.getFileRevisions(string, l2, l3, bl2, iSVNFileRevisionHandler);
            return n3;
        }
        finally {
            this.closeRepository();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long logImpl(String[] stringArray, long l2, long l3, boolean bl2, boolean bl3, long l4, boolean bl4, String[] stringArray2, ISVNLogEntryHandler iSVNLogEntryHandler) {
        try {
            boolean bl5;
            SVNErrorMessage sVNErrorMessage;
            this.openRepository();
            if (stringArray == null || stringArray.length == 0) {
                stringArray = new String[]{""};
            }
            String[] stringArray3 = new String[stringArray.length];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                stringArray3[i2] = this.getRepositoryPath(stringArray[i2]);
            }
            long l5 = this.myFSFS.getYoungestRevision();
            if (FSRepository.isInvalidRevision(l2)) {
                l2 = l5;
            }
            if (FSRepository.isInvalidRevision(l3)) {
                l3 = l5;
            }
            long l6 = l2;
            long l7 = l3;
            if (l2 > l5) {
                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_NO_SUCH_REVISION, "No such revision {0}", (Object)String.valueOf(l2));
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
            if (l3 > l5) {
                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_NO_SUCH_REVISION, "No such revision {0}", (Object)String.valueOf(l3));
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
            boolean bl6 = bl5 = l2 >= l3;
            if (bl5) {
                l6 = l3;
                l7 = l2;
            }
            FSLog fSLog = this.getLogDriver(stringArray3, l4, l6, l7, bl5, bl2, bl3, bl4, stringArray2, iSVNLogEntryHandler);
            long l8 = fSLog.runLog();
            return l8;
        }
        finally {
            this.closeRepository();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int getLocationsImpl(String string, long l2, long[] lArray, ISVNLocationEntryHandler iSVNLocationEntryHandler) {
        FSRepository.assertValidRevision(l2);
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            FSRepository.assertValidRevision(lArray[i2]);
        }
        try {
            this.openRepository();
            string = this.getRepositoryPath(string);
            FSLocationsFinder fSLocationsFinder = this.getLocationsFinder();
            int n2 = fSLocationsFinder.traceNodeLocations(string, l2, lArray, iSVNLocationEntryHandler);
            return n2;
        }
        finally {
            this.closeRepository();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long getLocationSegmentsImpl(String string, long l2, long l3, long l4, ISVNLocationSegmentHandler iSVNLocationSegmentHandler) {
        try {
            this.openRepository();
            string = this.getRepositoryPath(string);
            FSLocationsFinder fSLocationsFinder = this.getLocationsFinder();
            long l5 = fSLocationsFinder.getNodeLocationSegments(string, l2, l3, l4, iSVNLocationSegmentHandler);
            return l5;
        }
        finally {
            this.closeRepository();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replay(long l2, long l3, boolean bl2, ISVNEditor iSVNEditor) {
        try {
            this.openRepository();
            FSRevisionRoot fSRevisionRoot = this.myFSFS.createRevisionRoot(l3);
            String string = this.getRepositoryPath("");
            FSRepositoryUtil.replay(this.myFSFS, fSRevisionRoot, string, l2, bl2, iSVNEditor);
        }
        finally {
            this.closeRepository();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SVNDirEntry info(String string, long l2) {
        try {
            SVNDirEntry sVNDirEntry;
            FSRevisionRoot fSRevisionRoot;
            this.openRepository();
            string = this.getRepositoryPath(string);
            if (FSRepository.isInvalidRevision(l2)) {
                l2 = this.myFSFS.getYoungestRevision();
            }
            if ((fSRevisionRoot = this.myFSFS.createRevisionRoot(l2)).checkNodeKind(string) == SVNNodeKind.NONE) {
                SVNDirEntry sVNDirEntry2 = null;
                return sVNDirEntry2;
            }
            FSRevisionNode fSRevisionNode = fSRevisionRoot.getRevisionNode(string);
            String string2 = this.getFullPath(string);
            String string3 = "/".equals(string) ? string2 : SVNPathUtil.removeTail(string2);
            SVNURL sVNURL = this.getLocation().setPath(string3, false);
            String string4 = "/".equals(string) ? "" : SVNPathUtil.tail(string);
            FSEntry fSEntry = new FSEntry(fSRevisionNode.getId(), fSRevisionNode.getType(), string4);
            SVNDirEntry sVNDirEntry3 = sVNDirEntry = this.buildDirEntry(fSEntry, sVNURL, fSRevisionNode, -1);
            return sVNDirEntry3;
        }
        finally {
            this.closeRepository();
        }
    }

    @Override
    public ISVNEditor getCommitEditor(String string, Map map, boolean bl2, ISVNWorkspaceMediator iSVNWorkspaceMediator) {
        try {
            this.openRepository();
        }
        catch (SVNException sVNException) {
            this.closeRepository();
            throw sVNException;
        }
        String string2 = this.getUserName();
        return new FSCommitEditor(this.getRepositoryPath(""), string, string2, map, bl2, null, this.myFSFS, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SVNLock getLock(String string) {
        try {
            SVNLock sVNLock;
            this.openRepository();
            string = this.getRepositoryPath(string);
            SVNLock sVNLock2 = sVNLock = this.myFSFS.getLockHelper(string, false);
            return sVNLock2;
        }
        finally {
            this.closeRepository();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SVNLock[] getLocks(String string) {
        try {
            this.openRepository();
            string = this.getRepositoryPath(string);
            File file = this.myFSFS.getDigestFileFromRepositoryPath(string);
            ArrayList arrayList = new ArrayList();
            FSRepository$1 fSRepository$1 = new FSRepository$1(this, arrayList);
            this.myFSFS.walkDigestFiles(file, fSRepository$1, false);
            SVNLock[] sVNLockArray = arrayList.toArray(new SVNLock[arrayList.size()]);
            return sVNLockArray;
        }
        finally {
            this.closeRepository();
        }
    }

    @Override
    public void lock(Map map, String string, boolean bl2, ISVNLockHandler iSVNLockHandler) {
        this.lock(map, string, bl2, false, iSVNLockHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Map map, String string, boolean bl2, boolean bl3, ISVNLockHandler iSVNLockHandler) {
        try {
            this.openRepository();
            for (String string2 : map.keySet()) {
                SVNErrorMessage sVNErrorMessage;
                SVNLock sVNLock;
                String string3;
                block6: {
                    Long l2 = (Long)map.get(string2);
                    string3 = this.getRepositoryPath(string2);
                    long l3 = l2 == null || FSRepository.isInvalidRevision(l2) ? this.myFSFS.getYoungestRevision() : l2.longValue();
                    sVNLock = null;
                    sVNErrorMessage = null;
                    try {
                        sVNLock = this.myFSFS.lockPath(string3, null, this.getUserName(), string, null, l3, bl2, bl3);
                    }
                    catch (SVNException sVNException) {
                        sVNErrorMessage = sVNException.getErrorMessage();
                        if (FSErrors.isLockError(sVNErrorMessage)) break block6;
                        throw sVNException;
                    }
                }
                if (iSVNLockHandler == null) continue;
                iSVNLockHandler.handleLock(string3, sVNLock, sVNErrorMessage);
            }
        }
        finally {
            this.closeRepository();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock(Map map, boolean bl2, ISVNLockHandler iSVNLockHandler) {
        try {
            this.openRepository();
            for (String string : map.keySet()) {
                SVNErrorMessage sVNErrorMessage;
                String string2;
                String string3;
                block6: {
                    string3 = (String)map.get(string);
                    string2 = this.getRepositoryPath(string);
                    sVNErrorMessage = null;
                    try {
                        this.myFSFS.unlockPath(string2, string3, this.getUserName(), bl2, true);
                    }
                    catch (SVNException sVNException) {
                        sVNErrorMessage = sVNException.getErrorMessage();
                        if (FSErrors.isUnlockError(sVNErrorMessage)) break block6;
                        throw sVNException;
                    }
                }
                if (iSVNLockHandler == null) continue;
                iSVNLockHandler.handleUnlock(string2, new SVNLock(string2, string3, null, null, null, null), sVNErrorMessage);
            }
        }
        finally {
            this.closeRepository();
        }
    }

    @Override
    public void finishReport() {
        try {
            this.myReporterContext.drive();
        }
        finally {
            this.myReporterContext.dispose();
        }
    }

    @Override
    public void abortReport() {
        if (this.myReporterContext != null) {
            this.myReporterContext.dispose();
        }
    }

    @Override
    public void closeSession() {
    }

    public static boolean isInvalidRevision(long l2) {
        return SVNRepository.isInvalidRevision(l2);
    }

    public static boolean isValidRevision(long l2) {
        return SVNRepository.isValidRevision(l2);
    }

    @Override
    public void setPath(String string, String string2, long l2, boolean bl2) {
        this.setPath(string, string2, l2, SVNDepth.INFINITY, bl2);
    }

    @Override
    public void deletePath(String string) {
        this.myReporterContext.writePathInfoToReportFile(string, null, null, -1L, false, SVNDepth.INFINITY);
    }

    @Override
    public void linkPath(SVNURL sVNURL, String string, String string2, long l2, boolean bl2) {
        this.linkPath(sVNURL, string, string2, l2, SVNDepth.INFINITY, bl2);
    }

    @Override
    public void linkPath(SVNURL sVNURL, String string, String string2, long l2, SVNDepth sVNDepth, boolean bl2) {
        Object object;
        Object object2;
        FSRepository.assertValidRevision(l2);
        if (sVNDepth == SVNDepth.EXCLUDE) {
            object2 = SVNErrorMessage.create(SVNErrorCode.REPOS_BAD_ARGS, "Depth 'exclude' not supported for link");
            SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.FSFS);
        }
        object2 = this.getRepositoryRoot(false);
        if (sVNURL.toDecodedString().indexOf(((SVNURL)object2).toDecodedString()) == -1) {
            object = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "''{0}''\nis not the same repository as\n''{1}''", sVNURL, object2);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        if ("".equals(object = sVNURL.toDecodedString().substring(((SVNURL)object2).toDecodedString().length()))) {
            object = "/";
        }
        this.myReporterContext.writePathInfoToReportFile(string, (String)object, string2, l2, bl2, sVNDepth);
    }

    @Override
    public void setPath(String string, String string2, long l2, SVNDepth sVNDepth, boolean bl2) {
        FSRepository.assertValidRevision(l2);
        this.myReporterContext.writePathInfoToReportFile(string, null, string2, l2, bl2, sVNDepth);
    }

    public FSTranslateReporter beginReport(long l2, SVNURL sVNURL, String string, boolean bl2, boolean bl3, boolean bl4, SVNDepth sVNDepth, ISVNEditor iSVNEditor) {
        this.openRepository();
        this.makeReporterContext(l2, string, sVNURL, sVNDepth, bl2, bl3, bl4, iSVNEditor);
        return new FSTranslateReporter(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(long l2, String string, SVNDepth sVNDepth, boolean bl2, ISVNReporterBaton iSVNReporterBaton, ISVNEditor iSVNEditor) {
        try {
            this.openRepository();
            this.makeReporterContext(l2, string, null, sVNDepth, false, true, bl2, iSVNEditor);
            iSVNReporterBaton.report(this);
        }
        finally {
            this.closeRepository();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(SVNURL sVNURL, long l2, String string, SVNDepth sVNDepth, ISVNReporterBaton iSVNReporterBaton, ISVNEditor iSVNEditor) {
        try {
            this.openRepository();
            this.makeReporterContext(l2, string, sVNURL, sVNDepth, true, true, false, iSVNEditor);
            iSVNReporterBaton.report(this);
        }
        finally {
            this.closeRepository();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void diff(SVNURL sVNURL, long l2, long l3, String string, boolean bl2, SVNDepth sVNDepth, boolean bl3, ISVNReporterBaton iSVNReporterBaton, ISVNEditor iSVNEditor) {
        try {
            this.openRepository();
            this.makeReporterContext(l2, string, sVNURL, sVNDepth, bl2, bl3, false, iSVNEditor);
            iSVNReporterBaton.report(this);
        }
        finally {
            this.closeRepository();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void status(long l2, String string, SVNDepth sVNDepth, ISVNReporterBaton iSVNReporterBaton, ISVNEditor iSVNEditor) {
        try {
            this.openRepository();
            this.makeReporterContext(l2, string, null, sVNDepth, false, false, false, iSVNEditor);
            iSVNReporterBaton.report(this);
        }
        finally {
            this.closeRepository();
        }
    }

    @Override
    public boolean hasCapability(SVNCapability sVNCapability) {
        if (sVNCapability == SVNCapability.DEPTH || sVNCapability == SVNCapability.LOG_REVPROPS || sVNCapability == SVNCapability.PARTIAL_REPLAY || sVNCapability == SVNCapability.COMMIT_REVPROPS) {
            return true;
        }
        if (sVNCapability == SVNCapability.ATOMIC_REVPROPS) {
            return false;
        }
        if (sVNCapability == SVNCapability.MERGE_INFO) {
            try {
                this.getMergeInfoImpl(new String[]{""}, 0L, SVNMergeInfoInheritance.EXPLICIT, false);
            }
            catch (SVNException sVNException) {
                SVNErrorCode sVNErrorCode = sVNException.getErrorMessage().getErrorCode();
                if (sVNErrorCode == SVNErrorCode.UNSUPPORTED_FEATURE) {
                    return false;
                }
                if (sVNErrorCode == SVNErrorCode.FS_NOT_FOUND) {
                    return true;
                }
                throw sVNException;
            }
            return true;
        }
        if (sVNCapability == SVNCapability.INHERITED_PROPS) {
            return true;
        }
        if (sVNCapability == SVNCapability.EPHEMERAL_PROPS) {
            return true;
        }
        if (sVNCapability == SVNCapability.GET_FILE_REVS_REVERSED) {
            return false;
        }
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNKNOWN_CAPABILITY, "Don''t know anything about capability ''{0}''", (Object)sVNCapability);
        SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void getInheritedPropertiesImpl(String string, long l2, String string2, ISVNInheritedPropertiesHandler iSVNInheritedPropertiesHandler) {
        try {
            this.openRepository();
            String string3 = string = this.getRepositoryPath(string);
            FSRevisionRoot fSRevisionRoot = this.myFSFS.createRevisionRoot(l2);
            while (!"/".equals(string3) && !"".equals(string3)) {
                FSRevisionNode fSRevisionNode;
                SVNProperties sVNProperties;
                if ("".equals(string3 = SVNPathUtil.removeTail(string3))) {
                    string3 = "/";
                }
                if ((sVNProperties = this.myFSFS.getProperties(fSRevisionNode = fSRevisionRoot.getRevisionNode(string3))) == null || iSVNInheritedPropertiesHandler == null || sVNProperties.isEmpty()) continue;
                if (string2 != null && sVNProperties.containsName(string2)) {
                    SVNProperties sVNProperties2 = new SVNProperties();
                    sVNProperties2.put(string2, sVNProperties.getSVNPropertyValue(string2));
                    iSVNInheritedPropertiesHandler.handleInheritedProperites(string3, sVNProperties2);
                    continue;
                }
                if (string2 != null) continue;
                iSVNInheritedPropertiesHandler.handleInheritedProperites(string3, sVNProperties);
            }
        }
        finally {
            this.closeRepository();
        }
    }

    void closeRepository() {
        if (this.myFSFS != null) {
            this.myFSFS.close();
        }
        this.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map getMergeInfoImpl(String[] stringArray, long l2, SVNMergeInfoInheritance sVNMergeInfoInheritance, boolean bl2) {
        try {
            this.openRepository();
            if (!FSRepository.isValidRevision(l2)) {
                l2 = this.myFSFS.getYoungestRevision();
            }
            FSRevisionRoot fSRevisionRoot = this.myFSFS.createRevisionRoot(l2);
            String[] stringArray2 = new String[stringArray.length];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                stringArray2[i2] = this.getRepositoryPath(stringArray[i2]);
            }
            SVNMergeInfoManager sVNMergeInfoManager = this.getMergeInfoManager();
            Map map = sVNMergeInfoManager.getMergeInfo(stringArray2, fSRevisionRoot, sVNMergeInfoInheritance, bl2);
            return map;
        }
        finally {
            this.closeRepository();
        }
    }

    @Override
    protected ISVNEditor getCommitEditorInternal(Map map, boolean bl2, SVNProperties sVNProperties, ISVNWorkspaceMediator iSVNWorkspaceMediator) {
        try {
            this.openRepository();
        }
        catch (SVNException sVNException) {
            this.closeRepository();
            throw sVNException;
        }
        SVNProperties sVNProperties2 = sVNProperties = sVNProperties == null ? new SVNProperties() : sVNProperties;
        if (!sVNProperties.containsName("svn:author")) {
            sVNProperties.put("svn:author", this.getUserName());
        }
        return new FSCommitEditor(this.getRepositoryPath(""), map, bl2, null, this.myFSFS, this, sVNProperties);
    }

    @Override
    protected void replayRangeImpl(long l2, long l3, long l4, boolean bl2, ISVNReplayHandler iSVNReplayHandler) {
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_NOT_IMPLEMENTED);
        SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long getDeletedRevisionImpl(String string, long l2, long l3) {
        try {
            this.openRepository();
            string = this.getRepositoryPath(string);
            long l4 = this.myFSFS.getDeletedRevision(string, l2, l3);
            return l4;
        }
        finally {
            this.closeRepository();
        }
    }

    private void openRepository() {
        try {
            this.openRepositoryRoot();
        }
        catch (SVNException sVNException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_LOCAL_REPOS_OPEN_FAILED, "Unable to connect to a repository at URL ''{0}''", (Object)this.getLocation().toString());
            sVNErrorMessage.setChildErrorMessage(sVNException.getErrorMessage());
            SVNErrorManager.error(sVNErrorMessage.wrap("Unable to open repository ''{0}''", new Object[]{this.getLocation()}), SVNLogType.FSFS);
        }
    }

    private void openRepositoryRoot() {
        Object object;
        String string;
        Object object2;
        boolean bl2;
        this.lock();
        String string2 = this.getLocation().getHost();
        boolean bl3 = bl2 = !"".equals(string2) && !"localhost".equalsIgnoreCase(string2);
        if (!SVNFileUtil.isWindows && bl2) {
            object2 = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "Local URL ''{0}'' contains unsupported hostname", (Object)this.getLocation().toString());
            SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.FSFS);
        }
        if ((string = FSFS.findRepositoryRoot(bl2 ? string2 : null, (String)(object2 = SVNEncodingUtil.uriDecode(this.getLocation().getURIEncodedPath())))) == null) {
            object = SVNErrorMessage.create(SVNErrorCode.RA_LOCAL_REPOS_OPEN_FAILED, "Unable to open repository ''{0}''", (Object)this.getLocation().toString());
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        object = string.replaceFirst("\\|", "\\:");
        this.myReposRootDir = bl2 ? new File("\\\\" + string2, (String)object).getAbsoluteFile() : new File((String)object).getAbsoluteFile();
        this.myFSFS = new FSFS(this.myReposRootDir);
        this.myFSFS.setHooksEnabled(this.isHooksEnabled());
        this.myFSFS.open();
        this.setRepositoryCredentials(this.myFSFS.getUUID(), this.getLocation().setPath(string, false));
    }

    private Collection getDirEntries(FSRevisionNode fSRevisionNode, SVNURL sVNURL, int n2) {
        Map map = fSRevisionNode.getDirEntries(this.myFSFS);
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        LinkedList<SVNDirEntry> linkedList = new LinkedList<SVNDirEntry>();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            FSEntry fSEntry = (FSEntry)map.get(string);
            if (fSEntry == null) continue;
            linkedList.add(this.buildDirEntry(fSEntry, sVNURL, null, n2));
        }
        return linkedList;
    }

    private SVNProperties collectProperties(FSRevisionNode fSRevisionNode) {
        SVNProperties sVNProperties = new SVNProperties();
        SVNProperties sVNProperties2 = fSRevisionNode.getProperties(this.myFSFS);
        if (sVNProperties2 != null && sVNProperties2.size() > 0) {
            sVNProperties.putAll(sVNProperties2);
        }
        SVNProperties sVNProperties3 = null;
        try {
            sVNProperties3 = this.myFSFS.compoundMetaProperties(fSRevisionNode.getCreatedRevision());
        }
        catch (SVNException sVNException) {
            // empty catch block
        }
        if (sVNProperties3 != null && sVNProperties3.size() > 0) {
            sVNProperties.putAll(sVNProperties3);
        }
        return sVNProperties;
    }

    private SVNDirEntry buildDirEntry(FSEntry fSEntry, SVNURL sVNURL, FSRevisionNode fSRevisionNode, int n2) {
        Object object;
        Object object2;
        Object object3;
        fSRevisionNode = fSRevisionNode == null ? this.myFSFS.getRevisionNode(fSEntry.getId()) : fSRevisionNode;
        SVNNodeKind sVNNodeKind = null;
        if ((n2 & 1) != 0) {
            sVNNodeKind = fSEntry.getType();
        }
        long l2 = 0L;
        if ((n2 & 2) != 0 && fSRevisionNode.getType() == SVNNodeKind.FILE) {
            l2 = fSRevisionNode.getFileLength();
        }
        boolean bl2 = false;
        if ((n2 & 4) != 0) {
            object3 = fSRevisionNode.getProperties(this.myFSFS);
            bl2 = object3 != null && ((SVNProperties)object3).size() > 0;
        }
        object3 = null;
        String string = null;
        Date date = null;
        long l3 = -1L;
        if ((n2 & 0x10) != 0 || (n2 & 0x20) != 0 || (n2 & 8) != 0 || (n2 & 0x40) != 0) {
            l3 = fSEntry.getId().getRevision();
            object2 = this.myFSFS.getRevisionProperties(fSEntry.getId().getRevision());
            if (object2 != null && ((SVNProperties)object2).size() > 0) {
                object3 = ((SVNProperties)object2).getStringValue("svn:author");
                string = ((SVNProperties)object2).getStringValue("svn:log");
                object = ((SVNProperties)object2).getStringValue("svn:date");
                date = object != null ? SVNDate.parseDateString((String)object) : null;
            }
        }
        object2 = sVNURL.appendPath(fSEntry.getName(), false);
        object = new SVNDirEntry((SVNURL)object2, this.getRepositoryRoot(false), fSEntry.getName(), sVNNodeKind, l2, bl2, l3, date, (String)object3, string);
        ((SVNDirEntry)object).setRelativePath(fSEntry.getName());
        return object;
    }

    private void makeReporterContext(long l2, String string, SVNURL sVNURL, SVNDepth sVNDepth, boolean bl2, boolean bl3, boolean bl4, ISVNEditor iSVNEditor) {
        SVNErrorMessage sVNErrorMessage;
        Object object;
        Object object2;
        if (sVNDepth == SVNDepth.EXCLUDE) {
            object2 = SVNErrorMessage.create(SVNErrorCode.REPOS_BAD_ARGS, "Request depth 'exclude' not supported");
            SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.FSFS);
        }
        String string2 = string = string == null ? "" : string;
        if (!FSRepository.isValidRevision(l2)) {
            l2 = this.myFSFS.getYoungestRevision();
        }
        object2 = null;
        if (sVNURL != null) {
            object = this.getRepositoryRoot(false);
            if (sVNURL.toDecodedString().indexOf(((SVNURL)object).toDecodedString()) == -1) {
                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "''{0}''\nis not the same repository as\n''{1}''", sVNURL, this.getRepositoryRoot(false));
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
            if ("".equals(object2 = sVNURL.toDecodedString().substring(((SVNURL)object).toDecodedString().length()))) {
                object2 = "/";
            }
        }
        object = this.getRepositoryPath("");
        SVNErrorMessage sVNErrorMessage2 = sVNErrorMessage = object2 != null ? object2 : SVNPathUtil.getAbsolutePath(SVNPathUtil.append((String)object, string));
        if (this.myReporterContext == null) {
            this.myReporterContext = new FSUpdateContext(this, this.myFSFS, l2, SVNFileUtil.createTempFile("report", ".tmp"), string, (String)((Object)sVNErrorMessage), sVNURL != null, sVNDepth, bl2, bl3, bl4, iSVNEditor);
        } else {
            this.myReporterContext.reset(this, this.myFSFS, l2, SVNFileUtil.createTempFile("report", ".tmp"), string, (String)((Object)sVNErrorMessage), sVNURL != null, sVNDepth, bl2, bl3, bl4, iSVNEditor);
        }
    }

    private String getUserName() {
        if (this.getLocation().getUserInfo() != null && this.getLocation().getUserInfo().trim().length() > 0) {
            return this.getLocation().getUserInfo();
        }
        if (this.getAuthenticationManager() != null) {
            try {
                String string = this.getRepositoryUUID(true);
                ISVNAuthenticationManager iSVNAuthenticationManager = this.getAuthenticationManager();
                SVNAuthentication sVNAuthentication = iSVNAuthenticationManager.getFirstAuthentication("svn.username", string, this.getLocation());
                while (sVNAuthentication != null) {
                    String string2 = sVNAuthentication.getUserName();
                    if (string2 == null) {
                        return null;
                    }
                    if ("".equals(string2.trim())) {
                        string2 = System.getProperty("user.name");
                    }
                    sVNAuthentication = new SVNUserNameAuthentication(string2, sVNAuthentication.isStorageAllowed(), this.getLocation(), false);
                    if (string2 != null && !"".equals(string2.trim())) {
                        BasicAuthenticationManager.acknowledgeAuthentication(true, "svn.username", string, null, sVNAuthentication, this.myLocation, iSVNAuthenticationManager);
                        return sVNAuthentication.getUserName();
                    }
                    SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.AUTHN_CREDS_UNAVAILABLE, "Empty user name is not allowed");
                    BasicAuthenticationManager.acknowledgeAuthentication(false, "svn.username", string, sVNErrorMessage, sVNAuthentication, this.myLocation, iSVNAuthenticationManager);
                    sVNAuthentication = iSVNAuthenticationManager.getNextAuthentication("svn.username", string, this.getLocation());
                }
                SVNErrorManager.cancel("Authentication cancelled", SVNLogType.FSFS);
            }
            catch (SVNCancelException sVNCancelException) {
                throw sVNCancelException;
            }
            catch (SVNAuthenticationException sVNAuthenticationException) {
            }
            catch (SVNException sVNException) {
                throw sVNException;
            }
        }
        return null;
    }

    private FSLocationsFinder getLocationsFinder() {
        if (this.myLocationsFinder == null) {
            this.myLocationsFinder = new FSLocationsFinder(this.getFSFS());
        } else {
            this.myLocationsFinder.reset(this.getFSFS());
        }
        return this.myLocationsFinder;
    }

    private SVNMergeInfoManager getMergeInfoManager() {
        if (this.myMergeInfoManager == null) {
            this.myMergeInfoManager = new SVNMergeInfoManager();
        }
        return this.myMergeInfoManager;
    }

    private FSLog getLogDriver(String[] stringArray, long l2, long l3, long l4, boolean bl2, boolean bl3, boolean bl4, boolean bl5, String[] stringArray2, ISVNLogEntryHandler iSVNLogEntryHandler) {
        if (this.myLogDriver == null) {
            this.myLogDriver = new FSLog(this.myFSFS, stringArray, l2, l3, l4, bl2, bl3, bl4, bl5, stringArray2, iSVNLogEntryHandler);
        } else {
            this.myLogDriver.reset(this.myFSFS, stringArray, l2, l3, l4, bl2, bl3, bl4, bl5, stringArray2, iSVNLogEntryHandler);
        }
        return this.myLogDriver;
    }
}

