/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.InputStream;
import java.util.LinkedList;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaCombiner;
import org.tmatesoft.svn.core.internal.io.fs.FSEntry;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSPathChange;
import org.tmatesoft.svn.core.internal.io.fs.FSPathChangeKind;
import org.tmatesoft.svn.core.internal.io.fs.FSReplayPathHandler$CopyInfo;
import org.tmatesoft.svn.core.internal.io.fs.FSRepository;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSRoot;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.ISVNCommitPathHandler;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDeltaGenerator;
import org.tmatesoft.svn.util.SVNLogType;

public class FSReplayPathHandler
implements ISVNCommitPathHandler {
    private FSRoot myRoot;
    private FSRoot myCompareRoot;
    private Map myChangedPaths;
    private String myBasePath;
    private long myLowRevision;
    private LinkedList myCopies;
    private FSFS myOwner;
    private SVNDeltaGenerator myDeltaGenerator;
    private SVNDeltaCombiner myDeltaCombiner;

    public FSReplayPathHandler(FSFS fSFS, FSRoot fSRoot, FSRoot fSRoot2, Map map, String string, long l2) {
        this.myRoot = fSRoot;
        this.myCompareRoot = fSRoot2;
        this.myChangedPaths = map;
        this.myBasePath = string;
        this.myLowRevision = l2;
        this.myCopies = new LinkedList();
        this.myOwner = fSFS;
        this.myDeltaGenerator = new SVNDeltaGenerator();
        this.myDeltaCombiner = new SVNDeltaCombiner();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleCommitPath(String string, ISVNEditor iSVNEditor) {
        Object object;
        boolean bl2;
        boolean bl3;
        String string2;
        block42: {
            block43: {
                Object object2;
                Object object3;
                String string3 = string2 = !string.startsWith("/") ? "/" + string : string;
                while (this.myCopies.size() > 0) {
                    FSReplayPathHandler$CopyInfo fSReplayPathHandler$CopyInfo = (FSReplayPathHandler$CopyInfo)this.myCopies.getLast();
                    if (SVNPathUtil.isAncestor(fSReplayPathHandler$CopyInfo.myPath, string)) break;
                    this.myCopies.removeLast();
                }
                boolean bl4 = false;
                boolean bl5 = false;
                FSPathChange fSPathChange = (FSPathChange)this.myChangedPaths.get(string);
                if (fSPathChange == null) {
                    return false;
                }
                if (fSPathChange.getChangeKind() == FSPathChangeKind.FS_PATH_CHANGE_ADD) {
                    bl4 = true;
                } else if (fSPathChange.getChangeKind() == FSPathChangeKind.FS_PATH_CHANGE_DELETE) {
                    bl5 = true;
                } else if (fSPathChange.getChangeKind() == FSPathChangeKind.FS_PATH_CHANGE_REPLACE) {
                    bl4 = true;
                    bl5 = true;
                }
                bl3 = false;
                if (bl5) {
                    iSVNEditor.deleteEntry(string, -1L);
                }
                SVNNodeKind sVNNodeKind = null;
                if ((!bl5 || bl4) && (sVNNodeKind = this.myRoot.checkNodeKind(string2)) != SVNNodeKind.DIR && sVNNodeKind != SVNNodeKind.FILE) {
                    object3 = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "Filesystem path ''{0}'' is neither a file nor a directory", (Object)string);
                    SVNErrorManager.error((SVNErrorMessage)object3, SVNLogType.FSFS);
                }
                object3 = null;
                Object object4 = null;
                Object object5 = this.myCompareRoot;
                Object object6 = object5 != null ? string2 : null;
                bl2 = false;
                if (bl4) {
                    Object object7;
                    object = null;
                    object2 = this.myRoot.getRevisionNode(string2);
                    object3 = ((FSRevisionNode)object2).getCopyFromPath();
                    long l2 = ((FSRevisionNode)object2).getCopyFromRevision();
                    if (object3 != null && FSRepository.isValidRevision(l2)) {
                        object = this.myOwner.createRevisionRoot(l2);
                    }
                    object4 = object3;
                    if (!(object3 == null || SVNPathUtil.isWithinBasePath(this.myBasePath, (String)(object7 = ((String)object3).substring(1))) && this.myLowRevision <= l2)) {
                        object3 = null;
                        l2 = -1L;
                    }
                    if (sVNNodeKind == SVNNodeKind.DIR) {
                        if (object4 != null && object3 == null) {
                            this.addSubdirectory((FSRoot)object, this.myRoot, iSVNEditor, (String)object4, string);
                        } else {
                            iSVNEditor.addDir(string, (String)object3, l2);
                        }
                        bl3 = true;
                    } else {
                        iSVNEditor.addFile(string, (String)object3, l2);
                        bl2 = true;
                    }
                    if (object3 != null) {
                        if (sVNNodeKind == SVNNodeKind.DIR) {
                            object7 = new FSReplayPathHandler$CopyInfo(this, string, (String)object3, l2);
                            this.myCopies.addLast(object7);
                        }
                        object5 = object;
                        object6 = object3;
                    } else {
                        if (sVNNodeKind == SVNNodeKind.DIR && this.myCopies.size() > 0) {
                            object7 = new FSReplayPathHandler$CopyInfo(this, string, null, -1L);
                            this.myCopies.addLast(object7);
                        }
                        object5 = null;
                        object6 = null;
                    }
                } else if (!bl5) {
                    if (sVNNodeKind == SVNNodeKind.DIR) {
                        if ("".equals(string)) {
                            iSVNEditor.openRoot(-1L);
                        } else {
                            iSVNEditor.openDir(string, -1L);
                        }
                        bl3 = true;
                    } else {
                        iSVNEditor.openFile(string, -1L);
                        bl2 = true;
                    }
                    if (this.myCopies.size() > 0) {
                        object = (FSReplayPathHandler$CopyInfo)this.myCopies.getLast();
                        if (((FSReplayPathHandler$CopyInfo)object).myCopyFromPath != null) {
                            object5 = this.myOwner.createRevisionRoot(((FSReplayPathHandler$CopyInfo)object).myCopyFromRevision);
                            object6 = SVNPathUtil.append(((FSReplayPathHandler$CopyInfo)object).myCopyFromPath, SVNPathUtil.getPathAsChild(((FSReplayPathHandler$CopyInfo)object).myPath, string));
                        } else {
                            object5 = null;
                            object6 = null;
                        }
                    }
                }
                if (bl5 && !bl4) break block42;
                if (fSPathChange.arePropertiesModified()) {
                    if (this.myCompareRoot != null) {
                        object = null;
                        if (object5 != null) {
                            object2 = ((FSRoot)object5).getRevisionNode((String)object6);
                            object = ((FSRevisionNode)object2).getProperties(this.myOwner);
                        }
                        object2 = this.myRoot.getRevisionNode(string2);
                        SVNProperties sVNProperties = ((FSRevisionNode)object2).getProperties(this.myOwner);
                        SVNProperties sVNProperties2 = FSRepositoryUtil.getPropsDiffs((SVNProperties)object, sVNProperties);
                        for (String string4 : sVNProperties2.nameSet()) {
                            SVNPropertyValue sVNPropertyValue = sVNProperties2.getSVNPropertyValue(string4);
                            if (sVNNodeKind == SVNNodeKind.DIR) {
                                iSVNEditor.changeDirProperty(string4, sVNPropertyValue);
                                continue;
                            }
                            if (sVNNodeKind != SVNNodeKind.FILE) continue;
                            iSVNEditor.changeFileProperty(string, string4, sVNPropertyValue);
                        }
                    } else if (sVNNodeKind == SVNNodeKind.DIR) {
                        iSVNEditor.changeDirProperty("", null);
                    } else if (sVNNodeKind == SVNNodeKind.FILE) {
                        iSVNEditor.changeFileProperty(string, "", null);
                    }
                }
                if (sVNNodeKind != SVNNodeKind.FILE || !fSPathChange.isTextModified() && (object4 == null || object3 != null)) break block42;
                object = null;
                if (this.myCompareRoot != null && object5 != null && object6 != null) {
                    object2 = ((FSRoot)object5).getRevisionNode((String)object6);
                    object = ((FSRevisionNode)object2).getFileMD5Checksum();
                }
                iSVNEditor.applyTextDelta(string, (String)object);
                if (this.myCompareRoot == null) break block43;
                object2 = null;
                InputStream inputStream = null;
                try {
                    object2 = object5 != null && object6 != null ? ((FSRoot)object5).getFileStreamForPath(this.myDeltaCombiner, (String)object6) : SVNFileUtil.DUMMY_IN;
                    inputStream = this.myRoot.getFileStreamForPath(this.myDeltaCombiner, string2);
                    this.myDeltaGenerator.sendDelta(string, (InputStream)object2, 0L, inputStream, iSVNEditor, false);
                }
                catch (Throwable throwable) {
                    SVNFileUtil.closeFile((InputStream)object2);
                    SVNFileUtil.closeFile(inputStream);
                    throw throwable;
                }
                SVNFileUtil.closeFile((InputStream)object2);
                SVNFileUtil.closeFile(inputStream);
                break block42;
            }
            iSVNEditor.textDeltaEnd(string);
        }
        if (bl2) {
            object = this.myRoot.getRevisionNode(string2);
            iSVNEditor.closeFile(string, ((FSRevisionNode)object).getFileMD5Checksum());
        }
        return bl3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSubdirectory(FSRoot fSRoot, FSRoot fSRoot2, ISVNEditor iSVNEditor, String string, String string2) {
        iSVNEditor.addDir(string2, null, -1L);
        FSRevisionNode fSRevisionNode = fSRoot.getRevisionNode(string);
        SVNProperties sVNProperties = fSRevisionNode.getProperties(this.myOwner);
        for (Object object : sVNProperties.nameSet()) {
            Object object2 = sVNProperties.getSVNPropertyValue((String)object);
            iSVNEditor.changeDirProperty((String)object, (SVNPropertyValue)object2);
        }
        Map map = fSRevisionNode.getDirEntries(this.myOwner);
        for (Object object2 : map.keySet()) {
            String string32;
            FSEntry fSEntry = (FSEntry)map.get(object2);
            String string4 = SVNPathUtil.append(string2, fSEntry.getName());
            if (fSEntry.getType() == SVNNodeKind.DIR) {
                this.addSubdirectory(fSRoot, fSRoot2, iSVNEditor, SVNPathUtil.append(string, fSEntry.getName()), string4);
                iSVNEditor.closeDir();
                continue;
            }
            if (fSEntry.getType() != SVNNodeKind.FILE) continue;
            iSVNEditor.addFile(SVNPathUtil.append(string2, fSEntry.getName()), null, -1L);
            String string5 = SVNPathUtil.append(string, fSEntry.getName());
            FSRevisionNode fSRevisionNode2 = fSRoot.getRevisionNode(string5);
            sVNProperties = fSRevisionNode2.getProperties(this.myOwner);
            for (String string32 : sVNProperties.nameSet()) {
                SVNPropertyValue sVNPropertyValue = sVNProperties.getSVNPropertyValue(string32);
                iSVNEditor.changeFileProperty(string4, string32, sVNPropertyValue);
            }
            iSVNEditor.applyTextDelta(string4, null);
            Object object = null;
            try {
                object = fSRoot.getFileStreamForPath(this.myDeltaCombiner, string5);
                this.myDeltaGenerator.sendDelta(string4, SVNFileUtil.DUMMY_IN, 0L, (InputStream)object, iSVNEditor, false);
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(object);
                throw throwable;
            }
            SVNFileUtil.closeFile((InputStream)object);
            string32 = fSRevisionNode2.getFileMD5Checksum();
            iSVNEditor.closeFile(string4, string32);
        }
    }
}

