/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.tmatesoft.svn.core.ISVNCanceller;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSFile;
import org.tmatesoft.svn.core.internal.io.fs.FSID;
import org.tmatesoft.svn.core.internal.io.fs.FSInputStream;
import org.tmatesoft.svn.core.internal.io.fs.FSInputStream$FSRepresentationState;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSWriteLock;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;

public class FSRecoverer {
    private FSFS myOwner;
    private ISVNCanceller myCanceller;

    public FSRecoverer(FSFS fSFS, ISVNCanceller iSVNCanceller) {
        this.myOwner = fSFS;
        this.myCanceller = iSVNCanceller == null ? ISVNCanceller.NULL : iSVNCanceller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runRecovery() {
        FSWriteLock fSWriteLock;
        FSWriteLock fSWriteLock2 = fSWriteLock = FSWriteLock.getWriteLockForDB(this.myOwner);
        synchronized (fSWriteLock2) {
            try {
                fSWriteLock.lock();
                this.recover();
            }
            finally {
                fSWriteLock.unlock();
                FSWriteLock.release(fSWriteLock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recover() {
        String[] stringArray;
        String[] stringArray2;
        Object object;
        String string = null;
        String string2 = null;
        long l2 = this.getLargestRevision();
        long l3 = this.myOwner.getYoungestRevision();
        if (l3 > l2) {
            object = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Expected current rev to be <= {0} but found {1}", String.valueOf(l2), String.valueOf(l3));
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        if (this.myOwner.getDBFormat() < 3) {
            object = new long[]{-1L};
            stringArray2 = new String[]{"0"};
            stringArray = new String[]{"0"};
            for (long i2 = 0L; i2 <= l2; ++i2) {
                this.myCanceller.checkCancelled();
                try (FSFile fSFile = null;){
                    fSFile = this.myOwner.getPackOrRevisionFSFile(i2);
                    FSRepositoryUtil.loadRootChangesOffset(this.myOwner, i2, fSFile, (long[])object, null);
                    this.findMaxIDs(i2, fSFile, (long)object[0], stringArray2, stringArray);
                    continue;
                }
            }
            string = FSRepositoryUtil.generateNextKey(stringArray2[0]);
            string2 = FSRepositoryUtil.generateNextKey(stringArray[0]);
        }
        object = null;
        try {
            object = this.myOwner.getRevisionPropertiesFile(l2, false);
        }
        catch (SVNException sVNException) {
            if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.FS_NO_SUCH_REVISION) {
                stringArray = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Revision {0} has a revs file but no revprops file", (Object)String.valueOf(l2));
                SVNErrorManager.error((SVNErrorMessage)stringArray, SVNLogType.FSFS);
            }
            throw sVNException;
        }
        if (!((File)object).isFile()) {
            stringArray2 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Revision {0} has a non-file where its revprops file should be", (Object)String.valueOf(l2));
            SVNErrorManager.error((SVNErrorMessage)stringArray2, SVNLogType.FSFS);
        }
        try {
            this.myOwner.writeCurrentFile(l2, string, string2);
        }
        catch (IOException iOException) {
            stringArray = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage());
            SVNErrorManager.error((SVNErrorMessage)stringArray, SVNLogType.FSFS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findMaxIDs(long l2, FSFile fSFile, long l3, String[] stringArray, String[] stringArray2) {
        Serializable serializable;
        Object object;
        fSFile.seek(l3);
        Map map = null;
        try {
            map = fSFile.readHeader();
        }
        finally {
            fSFile.close();
        }
        String string = (String)map.get("id");
        FSID fSID = FSID.fromString(string);
        SVNNodeKind sVNNodeKind = SVNNodeKind.parseKind((String)map.get("type"));
        if (sVNNodeKind != SVNNodeKind.DIR) {
            object = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Recovery encountered a non-directory node");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        if ((object = (String)map.get("text")) == null) {
            return;
        }
        FSRevisionNode fSRevisionNode = new FSRevisionNode();
        fSRevisionNode.setId(fSID);
        fSRevisionNode.setType(sVNNodeKind);
        FSRevisionNode.parseRepresentationHeader((String)object, fSRevisionNode, null, true, false);
        if (fSRevisionNode.getTextRepresentation().getRevision() != l2) {
            return;
        }
        long l4 = fSRevisionNode.getTextRepresentation().getItemIndex();
        if (this.myOwner.isUseLogAddressing()) {
            throw new UnsupportedOperationException("TODO");
        }
        long l5 = l4;
        fSFile.seek(l5);
        FSInputStream$FSRepresentationState fSInputStream$FSRepresentationState = FSInputStream.readRepresentationLine(fSFile);
        if (fSInputStream$FSRepresentationState.myIsDelta) {
            serializable = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Recovery encountered a deltified directory representation");
            SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.FSFS);
        }
        serializable = fSFile.readProperties(false, false);
        for (String string2 : ((SVNProperties)serializable).nameSet()) {
            FSID fSID2;
            Object object2;
            SVNNodeKind sVNNodeKind2;
            Object object3;
            String string3 = ((SVNProperties)serializable).getStringValue(string2);
            int n2 = string3.indexOf(32);
            if (n2 == -1 || n2 == string3.length() - 1 || n2 == 0) {
                object3 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Directory entry corrupt");
                SVNErrorManager.error((SVNErrorMessage)object3, SVNLogType.FSFS);
            }
            if ((sVNNodeKind2 = SVNNodeKind.parseKind((String)(object3 = string3.substring(0, n2)))) != SVNNodeKind.DIR && sVNNodeKind2 != SVNNodeKind.FILE) {
                object2 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Directory entry corrupt");
                SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.FSFS);
            }
            if ((fSID2 = FSID.fromString((String)(object2 = string3.substring(n2 + 1)))).getRevision() != l2) continue;
            String string4 = fSID2.getNodeID();
            String string5 = fSID2.getCopyID();
            if (string4.compareTo(stringArray[0]) > 0) {
                stringArray[0] = string4;
            }
            if (string5.compareTo(stringArray2[0]) > 0) {
                stringArray2[0] = string5;
            }
            if (sVNNodeKind2 == SVNNodeKind.FILE) continue;
            this.findMaxIDs(l2, fSFile, fSID2.getOffset(), stringArray, stringArray2);
        }
    }

    private long getLargestRevision() {
        long l2 = 1L;
        while (true) {
            try {
                this.myOwner.getPackOrRevisionFSFile(l2);
            }
            catch (SVNException sVNException) {
                if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.FS_NO_SUCH_REVISION) break;
                throw sVNException;
            }
            l2 <<= 1;
        }
        long l3 = l2 >> 1;
        while (l3 + 1L < l2) {
            long l4 = l3 + (l2 - l3) / 2L;
            try {
                this.myOwner.getPackOrRevisionFSFile(l4);
                l3 = l4;
            }
            catch (SVNException sVNException) {
                if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.FS_NO_SUCH_REVISION) {
                    l2 = l4;
                    continue;
                }
                throw sVNException;
            }
        }
        return l3;
    }
}

