/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.Serializable;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.io.fs.FSID;
import org.tmatesoft.svn.core.internal.io.fs.FSPathChangeKind;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;

public class FSPathChange
extends SVNLogEntryPath {
    private static final long serialVersionUID = 4845L;
    private static final String FLAG_TRUE = "true";
    private static final String FLAG_FALSE = "false";
    private String myPath;
    private FSID myRevNodeId;
    private FSPathChangeKind myChangeKind;
    boolean isTextModified;
    boolean arePropertiesModified;
    Boolean isMergeInfoModified;

    public FSPathChange(String string, FSID fSID, FSPathChangeKind fSPathChangeKind, boolean bl2, boolean bl3, Boolean bl4, String string2, long l2, SVNNodeKind sVNNodeKind) {
        super(string, FSPathChangeKind.getType(fSPathChangeKind), string2, l2, sVNNodeKind);
        this.myPath = string;
        this.myRevNodeId = fSID;
        this.myChangeKind = fSPathChangeKind;
        this.isTextModified = bl2;
        this.arePropertiesModified = bl3;
        this.isMergeInfoModified = bl4;
    }

    @Override
    public String getPath() {
        return this.myPath;
    }

    public boolean arePropertiesModified() {
        return this.arePropertiesModified;
    }

    public void setPropertiesModified(boolean bl2) {
        this.arePropertiesModified = bl2;
    }

    public boolean isTextModified() {
        return this.isTextModified;
    }

    public void setTextModified(boolean bl2) {
        this.isTextModified = bl2;
    }

    public Boolean getMergeInfoModified() {
        return this.isMergeInfoModified;
    }

    public void setMergeInfoModified(Boolean bl2) {
        this.isMergeInfoModified = bl2;
    }

    public FSPathChangeKind getChangeKind() {
        return this.myChangeKind;
    }

    public void setChangeKind(FSPathChangeKind fSPathChangeKind) {
        this.myChangeKind = fSPathChangeKind;
        super.setChangeType(FSPathChangeKind.getType(fSPathChangeKind));
    }

    public FSID getRevNodeId() {
        return this.myRevNodeId;
    }

    public void setRevNodeId(FSID fSID) {
        this.myRevNodeId = fSID;
    }

    @Override
    public void setCopyRevision(long l2) {
        super.setCopyRevision(l2);
    }

    @Override
    public void setCopyPath(String string) {
        super.setCopyPath(string);
    }

    @Override
    public void setNodeKind(SVNNodeKind sVNNodeKind) {
        super.setNodeKind(sVNNodeKind);
    }

    public static FSPathChange fromString(String string, String string2) {
        Object object;
        Object object2;
        Serializable serializable;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        int n2 = string.indexOf(32);
        if (n2 == -1) {
            object7 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Invalid changes line in rev-file");
            SVNErrorManager.error((SVNErrorMessage)object7, SVNLogType.FSFS);
        }
        object7 = string.substring(0, n2);
        FSID fSID = FSID.fromString((String)object7);
        if ((n2 = (string = string.substring(n2 + 1)).indexOf(32)) == -1) {
            object6 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Invalid changes line in rev-file");
            SVNErrorManager.error((SVNErrorMessage)object6, SVNLogType.FSFS);
        }
        object6 = string.substring(0, n2);
        int n3 = ((String)object6).indexOf("-");
        SVNNodeKind sVNNodeKind = SVNNodeKind.UNKNOWN;
        if (n3 >= 0) {
            object5 = ((String)object6).substring(n3 + 1);
            object6 = ((String)object6).substring(0, n3);
            if (SVNNodeKind.FILE.toString().equals(object5)) {
                sVNNodeKind = SVNNodeKind.FILE;
            } else if (SVNNodeKind.DIR.toString().equals(object5)) {
                sVNNodeKind = SVNNodeKind.DIR;
            } else {
                object4 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Invalid changes line in rev-file");
                SVNErrorManager.error((SVNErrorMessage)object4, SVNLogType.FSFS);
            }
        }
        if ((object5 = FSPathChangeKind.fromString((String)object6)) == null) {
            object4 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Invalid change kind in rev file");
            SVNErrorManager.error((SVNErrorMessage)object4, SVNLogType.FSFS);
        }
        if ((n2 = (string = string.substring(n2 + 1)).indexOf(32)) == -1) {
            object4 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Invalid changes line in rev-file");
            SVNErrorManager.error((SVNErrorMessage)object4, SVNLogType.FSFS);
        }
        object4 = string.substring(0, n2);
        boolean bl2 = false;
        if (FLAG_TRUE.equals(object4)) {
            bl2 = true;
        } else if (FLAG_FALSE.equals(object4)) {
            bl2 = false;
        } else {
            object3 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Invalid text-mod flag in rev-file");
            SVNErrorManager.error((SVNErrorMessage)object3, SVNLogType.FSFS);
        }
        string = string.substring(n2 + 1);
        n2 = string.indexOf(32);
        if (n2 == -1) {
            object3 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Invalid changes line in rev-file");
            SVNErrorManager.error((SVNErrorMessage)object3, SVNLogType.FSFS);
        }
        object3 = string.substring(0, n2);
        boolean bl3 = false;
        if (FLAG_TRUE.equals(object3)) {
            bl3 = true;
        } else if (FLAG_FALSE.equals(object3)) {
            bl3 = false;
        } else {
            serializable = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Invalid prop-mod flag in rev-file");
            SVNErrorManager.error(serializable, SVNLogType.FSFS);
        }
        string = string.substring(n2 + 1);
        serializable = null;
        if (!string.startsWith("/")) {
            n2 = string.indexOf(32);
            if (n2 == -1) {
                object2 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Invalid changes line in rev-file");
                SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.FSFS);
            }
            if (FLAG_TRUE.equals(object2 = string.substring(0, n2))) {
                serializable = Boolean.valueOf(true);
            } else if (FLAG_FALSE.equals(object2)) {
                serializable = Boolean.valueOf(false);
            } else {
                object = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Invalid prop-mod flag in rev-file");
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
            }
            string = string.substring(n2 + 1);
        }
        object2 = string;
        object = null;
        long l2 = -1L;
        if (string2 != null && string2.length() != 0) {
            n2 = string2.indexOf(32);
            if (n2 == -1) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Invalid changes line in rev-file");
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
            try {
                l2 = Long.parseLong(string2.substring(0, n2));
            }
            catch (NumberFormatException numberFormatException) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, numberFormatException), SVNLogType.FSFS);
            }
            object = string2.substring(n2 + 1);
        }
        return new FSPathChange((String)object2, fSID, (FSPathChangeKind)object5, bl2, bl3, (Boolean)serializable, (String)object, l2, sVNNodeKind);
    }
}

