/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.tmatesoft.svn.core.ISVNCanceller;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.io.fs.FSWriteLock;
import org.tmatesoft.svn.core.internal.io.fs.revprop.SVNFSFSPackedRevProps;
import org.tmatesoft.svn.core.internal.io.fs.revprop.SVNFSFSPackedRevProps$Builder;
import org.tmatesoft.svn.core.internal.io.fs.revprop.SVNFSFSPackedRevPropsManifest;
import org.tmatesoft.svn.core.internal.io.fs.revprop.SVNFSFSPackedRevPropsManifest$Builder;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.wc.admin.ISVNAdminEventHandler;
import org.tmatesoft.svn.core.wc.admin.SVNAdminEvent;
import org.tmatesoft.svn.core.wc.admin.SVNAdminEventAction;
import org.tmatesoft.svn.util.SVNLogType;

public class FSPacker {
    private ISVNCanceller myCanceller;
    private ISVNAdminEventHandler myNotifyHandler;

    public FSPacker(ISVNAdminEventHandler iSVNAdminEventHandler) {
        this.myCanceller = iSVNAdminEventHandler == null ? ISVNCanceller.NULL : iSVNAdminEventHandler;
        this.myNotifyHandler = iSVNAdminEventHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pack(FSFS fSFS) {
        FSWriteLock fSWriteLock;
        FSWriteLock fSWriteLock2 = fSWriteLock = FSWriteLock.getWriteLockForDB(fSFS);
        synchronized (fSWriteLock2) {
            try {
                fSWriteLock.lock();
                this.packImpl(fSFS);
            }
            finally {
                fSWriteLock.unlock();
                FSWriteLock.release(fSWriteLock);
            }
        }
    }

    private void packImpl(FSFS fSFS) {
        boolean bl2;
        long l2;
        int n2 = fSFS.getDBFormat();
        if (n2 < 4) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_UNSUPPORTED_FORMAT, "FS format too old to pack, please upgrade.");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        if ((l2 = fSFS.getMaxFilesPerDirectory()) <= 0L) {
            return;
        }
        long l3 = fSFS.getMinUnpackedRev();
        long l4 = fSFS.getYoungestRevision();
        long l5 = (l4 + 1L) / l2;
        long l6 = 0L;
        boolean bl3 = bl2 = fSFS.getDBFormat() >= 6;
        if (bl2) {
            l6 = fSFS.getMinUnpackedRevProp();
        }
        if (l3 == l5 * l2 && l6 == l5 * l2) {
            return;
        }
        for (long i2 = l3 / l2; i2 < l5; ++i2) {
            this.myCanceller.checkCancelled();
            this.packShard(fSFS, i2, bl2);
        }
    }

    private void packShard(FSFS fSFS, long l2, boolean bl2) {
        File file = new File(fSFS.getDBRevsDir(), String.valueOf(l2));
        File file2 = new File(fSFS.getRevisionPropertiesRoot(), String.valueOf(l2));
        this.packRevShard(fSFS, l2, file);
        if (bl2) {
            this.myCanceller.checkCancelled();
            this.packRevPropShard(fSFS, l2, file2, (long)(0.9 * (double)fSFS.getRevPropPackSize()));
        }
        File file3 = fSFS.getMinUnpackedRevFile();
        File file4 = SVNFileUtil.createUniqueFile(fSFS.getDBRoot(), "tempfile", ".tmp", false);
        String string = String.valueOf((l2 + 1L) * fSFS.getMaxFilesPerDirectory()) + '\n';
        SVNFileUtil.writeToFile(file4, string, "UTF-8");
        SVNFileUtil.rename(file4, file3);
        SVNFileUtil.deleteAll(file, true, this.myCanceller);
        if (bl2) {
            this.deleteRevPropShard(file2, l2, fSFS.getMaxFilesPerDirectory());
        }
        this.firePackEvent(l2, false);
    }

    private void deleteRevPropShard(File file, long l2, long l3) {
        if (l2 == 0L) {
            int n2 = 1;
            while ((long)n2 < l3) {
                if (this.myCanceller != null) {
                    this.myCanceller.checkCancelled();
                }
                File file2 = new File(file, String.valueOf(n2));
                SVNFileUtil.deleteFile(file2);
                ++n2;
            }
        } else {
            SVNFileUtil.deleteAll(file, true, this.myCanceller);
        }
    }

    private void packRevShard(FSFS fSFS, long l2, File file) {
        File file2 = fSFS.getPackDir(l2);
        File file3 = fSFS.getPackFile(l2);
        File file4 = fSFS.getManifestFile(l2);
        this.firePackEvent(l2, true);
        SVNFileUtil.deleteAll(file2, false, this.myCanceller);
        if (fSFS.isUseLogAddressing()) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_UNSUPPORTED_FORMAT, "Logical addressing is unsupported for FS format ''{0}''", new Object[]{fSFS.getDBFormat()});
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        } else {
            this.packPhysicallyAddressed(fSFS, l2, file, file3, file4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void packPhysicallyAddressed(FSFS fSFS, long l2, File file, File file2, File file3) {
        long l3 = l2 * fSFS.getMaxFilesPerDirectory();
        long l4 = (l2 + 1L) * fSFS.getMaxFilesPerDirectory() - 1L;
        long l5 = 0L;
        OutputStream outputStream = null;
        OutputStream outputStream2 = null;
        try {
            outputStream = SVNFileUtil.openFileForWriting(file2);
            outputStream2 = SVNFileUtil.openFileForWriting(file3);
            for (long i2 = l3; i2 <= l4; ++i2) {
                File file4 = new File(file, String.valueOf(i2));
                String string = String.valueOf(l5) + '\n';
                outputStream2.write(string.getBytes("UTF-8"));
                l5 += file4.length();
                InputStream inputStream = null;
                try {
                    inputStream = SVNFileUtil.openFileForReading(file4);
                    FSRepositoryUtil.copy(inputStream, outputStream, this.myCanceller);
                    continue;
                }
                finally {
                    SVNFileUtil.closeFile(inputStream);
                }
            }
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getMessage());
            SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.FSFS);
        }
        finally {
            SVNFileUtil.closeFile(outputStream);
            SVNFileUtil.closeFile(outputStream2);
        }
    }

    private void firePackEvent(long l2, boolean bl2) {
        if (this.myNotifyHandler != null) {
            SVNAdminEvent sVNAdminEvent = new SVNAdminEvent(bl2 ? SVNAdminEventAction.PACK_START : SVNAdminEventAction.PACK_END, l2);
            this.myNotifyHandler.handleAdminEvent(sVNAdminEvent, -1.0);
        }
    }

    private void packRevPropShard(FSFS fSFS, long l2, File file, long l3) {
        File file2 = new File(fSFS.getRevisionPropertiesRoot(), String.valueOf(l2) + ".pack");
        this.firePackEvent(l2, true);
        long l4 = l2 * fSFS.getMaxFilesPerDirectory();
        long l5 = (l2 + 1L) * fSFS.getMaxFilesPerDirectory() - 1L;
        if (l4 == 0L) {
            ++l4;
        }
        long l6 = 42L;
        boolean bl2 = true;
        String string = null;
        SVNFSFSPackedRevPropsManifest$Builder sVNFSFSPackedRevPropsManifest$Builder = new SVNFSFSPackedRevPropsManifest$Builder();
        for (long i2 = l4; i2 <= l5; ++i2) {
            File file3 = new File(file, String.valueOf(i2));
            long l7 = file3.length();
            if (!bl2 && l6 + 21L + l7 > l3) {
                this.copyRevProps(string, file2, file, l4, i2 - 1L, fSFS.isCompressPackedRevprops());
                l6 = 42L;
                l4 = i2;
                bl2 = true;
            }
            if (bl2) {
                string = i2 + ".0";
            }
            sVNFSFSPackedRevPropsManifest$Builder.addPackName(string);
            bl2 = false;
            l6 += 21L + l7;
        }
        if (!bl2) {
            this.copyRevProps(string, file2, file, l4, l5, fSFS.isCompressPackedRevprops());
        }
        SVNFSFSPackedRevPropsManifest sVNFSFSPackedRevPropsManifest = sVNFSFSPackedRevPropsManifest$Builder.build();
        SVNFileUtil.writeToFile(new File(file2, "manifest"), sVNFSFSPackedRevPropsManifest.asString(), "UTF-8");
    }

    private void copyRevProps(String string, File file, File file2, long l2, long l3, boolean bl2) {
        SVNFSFSPackedRevProps$Builder sVNFSFSPackedRevProps$Builder = new SVNFSFSPackedRevProps$Builder();
        sVNFSFSPackedRevProps$Builder.setFirstRevision(l2);
        for (long i2 = l2; i2 <= l3; ++i2) {
            File file3 = new File(file2, String.valueOf(i2));
            byte[] byArray = SVNFileUtil.readFully(file3);
            sVNFSFSPackedRevProps$Builder.addByteArrayEntry(byArray);
        }
        SVNFSFSPackedRevProps sVNFSFSPackedRevProps = sVNFSFSPackedRevProps$Builder.build();
        File file4 = new File(file, string);
        sVNFSFSPackedRevProps.writeToFile(file4, bl2);
    }
}

