/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaCombiner;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaCompression;
import org.tmatesoft.svn.core.internal.io.fs.CountingOutputStream;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSFile;
import org.tmatesoft.svn.core.internal.io.fs.FSInputStream;
import org.tmatesoft.svn.core.internal.io.fs.FSOutputStream$1;
import org.tmatesoft.svn.core.internal.io.fs.FSRepresentation;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSWriteLock;
import org.tmatesoft.svn.core.internal.io.fs.IFSRepresentationCacheManager;
import org.tmatesoft.svn.core.internal.io.fs.index.FSLogicalAddressingIndex;
import org.tmatesoft.svn.core.internal.io.fs.index.FSP2LEntry;
import org.tmatesoft.svn.core.internal.io.fs.index.FSP2LProtoIndex$ItemType;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.ISVNDeltaConsumer;
import org.tmatesoft.svn.core.io.diff.SVNDeltaGenerator;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class FSOutputStream
extends OutputStream
implements ISVNDeltaConsumer {
    public static final int SVN_DELTA_WINDOW_SIZE = 102400;
    public static final int WRITE_BUFFER_SIZE = 204800;
    private boolean isHeaderWritten;
    private CountingOutputStream myTargetFileOS;
    private File myTargetFile;
    private long myDeltaStart;
    private long myRepSize;
    private long myRepOffset;
    private InputStream mySourceStream;
    private SVNDeltaGenerator myDeltaGenerator;
    private FSRevisionNode myRevNode;
    private MessageDigest myMD5Digest;
    private MessageDigest mySHA1Digest;
    private FSTransactionRoot myTxnRoot;
    private long mySourceOffset;
    private ByteArrayOutputStream myTextBuffer;
    private boolean myIsClosed;
    private SVNDeltaCompression myDeltaCompression;
    private FSWriteLock myTxnLock;

    private FSOutputStream(FSRevisionNode fSRevisionNode, CountingOutputStream countingOutputStream, File file, InputStream inputStream, long l2, long l3, long l4, FSTransactionRoot fSTransactionRoot, SVNDeltaCompression sVNDeltaCompression, FSWriteLock fSWriteLock) {
        SVNErrorMessage sVNErrorMessage;
        this.myTxnRoot = fSTransactionRoot;
        this.myTargetFileOS = countingOutputStream;
        this.myTargetFile = file;
        this.mySourceStream = inputStream;
        this.myDeltaStart = l2;
        this.myRepSize = l3;
        this.myRepOffset = l4;
        this.isHeaderWritten = false;
        this.myRevNode = fSRevisionNode;
        this.mySourceOffset = 0L;
        this.myIsClosed = false;
        this.myTxnLock = fSWriteLock;
        this.myDeltaGenerator = new SVNDeltaGenerator(102400);
        this.myTextBuffer = new ByteArrayOutputStream();
        try {
            this.myMD5Digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "MD5 implementation not found: {0}", (Object)noSuchAlgorithmException.getLocalizedMessage());
            SVNErrorManager.error(sVNErrorMessage, noSuchAlgorithmException, SVNLogType.FSFS);
        }
        try {
            this.mySHA1Digest = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "SHA1 implementation not found: {0}", (Object)noSuchAlgorithmException.getLocalizedMessage());
            SVNErrorManager.error(sVNErrorMessage, noSuchAlgorithmException, SVNLogType.FSFS);
        }
        this.myDeltaCompression = sVNDeltaCompression;
    }

    private void reset(FSRevisionNode fSRevisionNode, CountingOutputStream countingOutputStream, File file, InputStream inputStream, long l2, long l3, long l4, FSTransactionRoot fSTransactionRoot, FSWriteLock fSWriteLock) {
        this.myTxnRoot = fSTransactionRoot;
        this.myTargetFileOS = countingOutputStream;
        this.myTargetFile = file;
        this.mySourceStream = inputStream;
        this.myDeltaStart = l2;
        this.myRepSize = l3;
        this.myRepOffset = l4;
        this.isHeaderWritten = false;
        this.myRevNode = fSRevisionNode;
        this.mySourceOffset = 0L;
        this.myIsClosed = false;
        this.myMD5Digest.reset();
        this.mySHA1Digest.reset();
        this.myTextBuffer.reset();
        this.myTxnLock = fSWriteLock;
    }

    @Deprecated
    public static OutputStream createStream(FSRevisionNode fSRevisionNode, FSTransactionRoot fSTransactionRoot, OutputStream outputStream, boolean bl2) {
        return FSOutputStream.createStream(fSRevisionNode, fSTransactionRoot, outputStream, SVNDeltaCompression.fromLegacyCompress(bl2));
    }

    public static OutputStream createStream(FSRevisionNode fSRevisionNode, FSTransactionRoot fSTransactionRoot, OutputStream outputStream, SVNDeltaCompression sVNDeltaCompression) {
        Object object;
        if (fSRevisionNode.getType() != SVNNodeKind.FILE) {
            object = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FILE, "Attempted to set textual contents of a *non*-file node");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        if (!fSRevisionNode.getId().isTxn()) {
            object = SVNErrorMessage.create(SVNErrorCode.FS_NOT_MUTABLE, "Attempted to set textual contents of an immutable node");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        object = null;
        InputStream inputStream = null;
        long l2 = -1L;
        long l3 = -1L;
        FSWriteLock fSWriteLock = null;
        try {
            fSWriteLock = FSWriteLock.getWriteLockForTxn(fSTransactionRoot.getTxnID(), fSTransactionRoot.getOwner());
            fSWriteLock.lock();
            File file = fSTransactionRoot.getWritableTransactionProtoRevFile();
            l2 = file.length();
            object = SVNFileUtil.openFileForWriting(file, true);
            CountingOutputStream countingOutputStream = new CountingOutputStream((OutputStream)object, l2);
            FSRepresentation fSRepresentation = fSRevisionNode.chooseDeltaBase(fSTransactionRoot.getOwner());
            inputStream = FSInputStream.createDeltaStream(new SVNDeltaCombiner(), fSRepresentation, fSTransactionRoot.getOwner());
            String string = fSRepresentation != null ? "DELTA " + fSRepresentation.getRevision() + " " + fSRepresentation.getItemIndex() + " " + fSRepresentation.getSize() + "\n" : "DELTA\n";
            countingOutputStream.write(string.getBytes("UTF-8"));
            l3 = countingOutputStream.getPosition();
            if (outputStream instanceof FSOutputStream) {
                FSOutputStream fSOutputStream = (FSOutputStream)outputStream;
                fSOutputStream.reset(fSRevisionNode, countingOutputStream, file, inputStream, l3, 0L, l2, fSTransactionRoot, fSWriteLock);
                return outputStream;
            }
            return new FSOutputStream(fSRevisionNode, countingOutputStream, file, inputStream, l3, 0L, l2, fSTransactionRoot, sVNDeltaCompression, fSWriteLock);
        }
        catch (IOException iOException) {
            SVNFileUtil.closeFile((OutputStream)object);
            SVNFileUtil.closeFile(inputStream);
            fSWriteLock.unlock();
            FSWriteLock.release(fSWriteLock);
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage());
            SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.FSFS);
        }
        catch (SVNException sVNException) {
            if (fSWriteLock != null) {
                fSWriteLock.unlock();
                FSWriteLock.release(fSWriteLock);
            }
            SVNFileUtil.closeFile((OutputStream)object);
            SVNFileUtil.closeFile(inputStream);
            throw sVNException;
        }
        return null;
    }

    @Override
    public void write(int n2) {
        this.write(new byte[]{(byte)(n2 & 0xFF)}, 0, 1);
    }

    @Override
    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        this.myMD5Digest.update(byArray, n2, n3);
        this.mySHA1Digest.update(byArray, n2, n3);
        this.myRepSize += (long)n3;
        int n4 = 0;
        while (n3 > 0) {
            n4 = n3;
            this.myTextBuffer.write(byArray, n2, n4);
            if (this.myTextBuffer.size() >= 204800) {
                try {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.myTextBuffer.toByteArray());
                    this.myDeltaGenerator.sendDelta(null, this.mySourceStream, this.mySourceOffset, byteArrayInputStream, this, false);
                }
                catch (SVNException sVNException) {
                    throw new IOException(sVNException.getMessage());
                }
                this.myTextBuffer.reset();
            }
            n2 += n4;
            n3 -= n4;
        }
    }

    @Override
    public void close() {
        if (this.myIsClosed) {
            return;
        }
        boolean bl2 = false;
        this.myIsClosed = true;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.myTextBuffer.toByteArray());
            this.myDeltaGenerator.sendDelta(null, this.mySourceStream, this.mySourceOffset, byteArrayInputStream, this, false);
            FSRepresentation fSRepresentation = new FSRepresentation();
            fSRepresentation.setItemIndex(this.myRepOffset);
            long l2 = this.myTargetFileOS.getPosition();
            fSRepresentation.setSize(l2 - this.myDeltaStart);
            fSRepresentation.setExpandedSize(this.myRepSize);
            fSRepresentation.setTxnId(this.myRevNode.getId().getTxnID());
            String string = this.myTxnRoot.getNewTxnNodeId();
            String string2 = fSRepresentation.getTxnId() + '/' + string;
            fSRepresentation.setUniquifier(string2);
            fSRepresentation.setRevision(-1L);
            fSRepresentation.setMD5HexDigest(SVNFileUtil.toHexDigest(this.myMD5Digest));
            fSRepresentation.setSHA1HexDigest(SVNFileUtil.toHexDigest(this.mySHA1Digest));
            FSFS fSFS = this.myTxnRoot.getOwner();
            FSRepresentation fSRepresentation2 = this.getSharedRepresentation(fSFS, fSRepresentation, null);
            if (fSRepresentation2 != null) {
                this.myRevNode.setTextRepresentation(fSRepresentation2);
                bl2 = true;
            } else {
                if (fSFS.isUseLogAddressing()) {
                    fSRepresentation.setItemIndex(this.myTxnRoot.allocateItemIndex(this.myRepOffset));
                }
                this.myTargetFileOS.write("ENDREP\n".getBytes("UTF-8"));
                this.myRevNode.setTextRepresentation(fSRepresentation);
            }
            this.myRevNode.setIsFreshTxnRoot(false);
            fSFS.putTxnRevisionNode(this.myRevNode.getId(), this.myRevNode);
            if (fSRepresentation2 == null && fSFS.isUseLogAddressing()) {
                int n2 = this.myTargetFileOS.finalizeChecksum();
                FSOutputStream.storeSha1RepMapping(fSFS, this.myRevNode.getTextRepresentation());
                FSP2LEntry fSP2LEntry = new FSP2LEntry(this.myRepOffset, this.myTargetFileOS.getPosition() - this.myRepOffset, FSP2LProtoIndex$ItemType.FILE_REP, n2, -1L, fSRepresentation.getItemIndex());
                this.myTxnRoot.storeP2LIndexEntry(fSP2LEntry);
            }
        }
        catch (SVNException sVNException) {
            throw new IOException(sVNException.getMessage());
        }
        finally {
            this.closeStreams();
            try {
                if (bl2) {
                    SVNFileUtil.truncate(this.myTargetFile, this.myRepOffset);
                }
            }
            catch (IOException iOException) {
                SVNDebugLog.getDefaultLog().logError(SVNLogType.FSFS, iOException);
            }
            try {
                this.myTxnLock.unlock();
            }
            catch (SVNException sVNException) {}
            FSWriteLock.release(this.myTxnLock);
        }
    }

    public void closeStreams() {
        SVNFileUtil.closeFile(this.myTargetFileOS);
        SVNFileUtil.closeFile(this.mySourceStream);
    }

    public FSRevisionNode getRevisionNode() {
        return this.myRevNode;
    }

    @Override
    public OutputStream textDeltaChunk(String string, SVNDiffWindow sVNDiffWindow) {
        this.mySourceOffset += (long)sVNDiffWindow.getSourceViewLength();
        try {
            sVNDiffWindow.writeTo((OutputStream)this.myTargetFileOS, !this.isHeaderWritten, this.myDeltaCompression);
            this.isHeaderWritten = true;
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage());
            SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.FSFS);
        }
        return SVNFileUtil.DUMMY_OUT;
    }

    @Override
    public void textDeltaEnd(String string) {
    }

    @Override
    public void applyTextDelta(String string, String string2) {
    }

    private FSRepresentation getSharedRepresentation(FSFS fSFS, FSRepresentation fSRepresentation, Map map) {
        SVNFileType sVNFileType;
        Object object;
        if (!fSFS.isRepSharingAllowed()) {
            return null;
        }
        FSRepresentation fSRepresentation2 = null;
        if (map != null) {
            fSRepresentation2 = (FSRepresentation)map.get(fSRepresentation.getSHA1HexDigest());
        }
        if (fSRepresentation2 == null && (object = fSFS.getRepositoryCacheManager()) != null) {
            try {
                object.runReadTransaction(new FSOutputStream$1(this, (IFSRepresentationCacheManager)object, fSRepresentation));
            }
            catch (SVNException sVNException) {
                if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.FS_CORRUPT || sVNException.getErrorMessage().getErrorCode().getCategory() == 235000) {
                    throw sVNException;
                }
                SVNDebugLog.getDefaultLog().logFiner(SVNLogType.FSFS, sVNException);
            }
            if (fSRepresentation2 != null) {
                this.checkRepresentation(this.myTxnRoot.getOwner(), fSRepresentation2, null);
            }
        }
        if (fSRepresentation2 == null && fSRepresentation.isTxn() && (sVNFileType = SVNFileType.getType((File)(object = FSOutputStream.pathTxnSha1(fSFS, fSRepresentation, fSRepresentation.getTxnId())))) == SVNFileType.FILE) {
            String string = SVNFileUtil.readFile((File)object);
            fSRepresentation2 = FSRepresentation.parse(string);
        }
        if (fSRepresentation2 == null) {
            return null;
        }
        if (fSRepresentation2.getExpandedSize() != fSRepresentation.getExpandedSize() || fSRepresentation.getExpandedSize() == 0L && fSRepresentation2.getSize() != fSRepresentation.getSize()) {
            fSRepresentation2 = null;
        } else {
            fSRepresentation2.setMD5HexDigest(fSRepresentation.getMD5HexDigest());
            fSRepresentation2.setUniquifier(fSRepresentation.getUniquifier());
        }
        return fSRepresentation2;
    }

    private void checkRepresentation(FSFS fSFS, FSRepresentation fSRepresentation, Object object) {
        if (fSFS.isUseLogAddressing()) {
            FSFile fSFile;
            long l2 = fSFS.getPackedBaseRevision(fSRepresentation.getRevision());
            if (object != null) {
                // empty if block
            }
            if ((fSFile = null) != null) {
                // empty if block
            }
            fSFile = fSFS.getPackOrRevisionFSFile(fSRepresentation.getRevision());
            object = fSFile;
            long l3 = fSFS.lookupOffsetInIndex(fSFile, fSRepresentation.getRevision(), fSRepresentation.getItemIndex());
            FSP2LEntry fSP2LEntry = this.lookupP2LEntry(fSFile, fSRepresentation.getRevision(), l3);
            if (fSP2LEntry == null || fSP2LEntry.getType().getCode() < FSP2LProtoIndex$ItemType.FILE_REP.getCode() || fSP2LEntry.getType().getCode() > FSP2LProtoIndex$ItemType.DIR_PROPS.getCode()) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "No representation found at offset {0} for item %s in revision {1}", l3, fSRepresentation.getItemIndex());
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
        }
    }

    private FSP2LEntry lookupP2LEntry(FSFile fSFile, long l2, long l3) {
        boolean bl2 = false;
        if (!bl2) {
            FSLogicalAddressingIndex fSLogicalAddressingIndex = new FSLogicalAddressingIndex(this.myTxnRoot.getOwner(), fSFile);
            List list = fSLogicalAddressingIndex.lookupP2LEntries(l2, l3, l3 + 1L);
            return this.lookupEntry(list, l3, null);
        }
        return null;
    }

    private FSP2LEntry lookupEntry(List list, long l2, Object object) {
        FSP2LEntry fSP2LEntry;
        if (object != null) {
            // empty if block
        }
        int n2 = FSLogicalAddressingIndex.searchLowerBound(list, l2);
        if (object != null) {
            // empty if block
        }
        return FSLogicalAddressingIndex.compareEntryOffset(fSP2LEntry = (FSP2LEntry)list.get(n2), l2) != 0 ? null : fSP2LEntry;
    }

    private static void storeSha1RepMapping(FSFS fSFS, FSRepresentation fSRepresentation) {
        if (fSFS.isRepSharingAllowed() && fSRepresentation != null && fSRepresentation.getSHA1HexDigest() != null) {
            File file = FSOutputStream.pathTxnSha1(fSFS, fSRepresentation, fSRepresentation.getTxnId());
            String string = fSRepresentation.getStringRepresentation(fSFS.getDBFormat());
            SVNFileUtil.writeToFile(file, string, "UTF-8");
        }
    }

    private static File pathTxnSha1(FSFS fSFS, FSRepresentation fSRepresentation, String string) {
        String string2 = fSRepresentation.getSHA1HexDigest();
        File file = fSFS.getTransactionDir(string);
        return SVNFileUtil.createFilePath(file, string2);
    }
}

