/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.File;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSID;
import org.tmatesoft.svn.core.internal.io.fs.FSParentPath;
import org.tmatesoft.svn.core.internal.io.fs.FSRepository;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.SVNLocationEntry;
import org.tmatesoft.svn.util.SVNLogType;

public class FSNodeHistory {
    private SVNLocationEntry myHistoryEntry;
    private SVNLocationEntry mySearchResumeEntry;
    private boolean myIsInteresting;
    private FSFS myFSFS;

    public FSNodeHistory(SVNLocationEntry sVNLocationEntry, boolean bl2, SVNLocationEntry sVNLocationEntry2, FSFS fSFS) {
        this.myHistoryEntry = sVNLocationEntry;
        this.mySearchResumeEntry = sVNLocationEntry2;
        this.myIsInteresting = bl2;
        this.myFSFS = fSFS;
    }

    public SVNLocationEntry getHistoryEntry() {
        return this.myHistoryEntry;
    }

    public static SVNLocationEntry findYoungestCopyroot(File file, FSParentPath fSParentPath) {
        SVNLocationEntry sVNLocationEntry = null;
        if (fSParentPath.getParent() != null) {
            sVNLocationEntry = FSNodeHistory.findYoungestCopyroot(file, fSParentPath.getParent());
        }
        SVNLocationEntry sVNLocationEntry2 = new SVNLocationEntry(fSParentPath.getRevNode().getCopyRootRevision(), fSParentPath.getRevNode().getCopyRootPath());
        if (sVNLocationEntry != null) {
            if (sVNLocationEntry2.getRevision() >= sVNLocationEntry.getRevision()) {
                return sVNLocationEntry2;
            }
            return sVNLocationEntry;
        }
        return sVNLocationEntry2;
    }

    public static boolean checkAncestryOfPegPath(String string, long l2, long l3, FSFS fSFS) {
        FSRevisionRoot fSRevisionRoot = fSFS.createRevisionRoot(l3);
        FSNodeHistory fSNodeHistory = fSRevisionRoot.getNodeHistory(string);
        string = null;
        SVNLocationEntry sVNLocationEntry = null;
        while ((fSNodeHistory = fSNodeHistory.getPreviousHistory(true)) != null) {
            sVNLocationEntry = new SVNLocationEntry(fSNodeHistory.getHistoryEntry().getRevision(), fSNodeHistory.getHistoryEntry().getPath());
            if (string == null) {
                string = sVNLocationEntry.getPath();
            }
            if (sVNLocationEntry.getRevision() > l2) continue;
        }
        if (string == null) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "FATAL error occurred while checking ancestry of peg path");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        return fSNodeHistory != null && string.equals(sVNLocationEntry.getPath());
    }

    private FSNodeHistory historyPrev(boolean bl2) {
        Object object;
        String string = this.myHistoryEntry.getPath();
        long l2 = this.myHistoryEntry.getRevision();
        boolean bl3 = this.myIsInteresting;
        if (this.mySearchResumeEntry != null && this.mySearchResumeEntry.getPath() != null && FSRepository.isValidRevision(this.mySearchResumeEntry.getRevision())) {
            bl3 = false;
            if (!bl2) {
                return null;
            }
            string = this.mySearchResumeEntry.getPath();
            l2 = this.mySearchResumeEntry.getRevision();
        }
        FSRevisionRoot fSRevisionRoot = this.myFSFS.createRevisionRoot(l2);
        FSParentPath fSParentPath = fSRevisionRoot.openPath(string, true, true);
        FSRevisionNode fSRevisionNode = fSParentPath.getRevNode();
        SVNLocationEntry sVNLocationEntry = new SVNLocationEntry(fSRevisionNode.getCreatedRevision(), fSRevisionNode.getCreatedPath());
        FSNodeHistory fSNodeHistory = null;
        if (l2 == sVNLocationEntry.getRevision()) {
            if (!bl3) {
                fSNodeHistory = new FSNodeHistory(sVNLocationEntry, true, new SVNLocationEntry(-1L, null), this.myFSFS);
                return fSNodeHistory;
            }
            object = fSRevisionNode.getPredecessorId();
            if (object == null) {
                return fSNodeHistory;
            }
            fSRevisionNode = this.myFSFS.getRevisionNode((FSID)object);
            sVNLocationEntry = new SVNLocationEntry(fSRevisionNode.getCreatedRevision(), fSRevisionNode.getCreatedPath());
        }
        object = FSNodeHistory.findYoungestCopyroot(this.myFSFS.getRepositoryRoot(), fSParentPath);
        SVNLocationEntry sVNLocationEntry2 = new SVNLocationEntry(-1L, null);
        long l3 = -1L;
        if (((SVNLocationEntry)object).getRevision() > sVNLocationEntry.getRevision()) {
            FSRevisionRoot fSRevisionRoot2 = this.myFSFS.createRevisionRoot(((SVNLocationEntry)object).getRevision());
            fSRevisionNode = fSRevisionRoot2.getRevisionNode(((SVNLocationEntry)object).getPath());
            String string2 = fSRevisionNode.getCreatedPath();
            String string3 = null;
            string3 = string.equals(string2) ? "" : SVNPathUtil.getPathAsChild(string2, string);
            if (string3 != null) {
                String string4 = fSRevisionNode.getCopyFromPath();
                sVNLocationEntry2 = new SVNLocationEntry(fSRevisionNode.getCopyFromRevision(), SVNPathUtil.getAbsolutePath(SVNPathUtil.append(string4, string3)));
                l3 = ((SVNLocationEntry)object).getRevision();
            }
        }
        if (sVNLocationEntry2.getPath() != null && FSRepository.isValidRevision(sVNLocationEntry2.getRevision())) {
            boolean bl4 = false;
            if (l3 == l2 && bl3) {
                bl4 = true;
            }
            return new FSNodeHistory(new SVNLocationEntry(l3, string), !bl4, new SVNLocationEntry(sVNLocationEntry2.getRevision(), sVNLocationEntry2.getPath()), this.myFSFS);
        }
        return new FSNodeHistory(sVNLocationEntry, true, new SVNLocationEntry(-1L, null), this.myFSFS);
    }

    public FSNodeHistory getPreviousHistory(boolean bl2) {
        if ("/".equals(this.myHistoryEntry.getPath())) {
            if (!this.myIsInteresting) {
                return new FSNodeHistory(new SVNLocationEntry(this.myHistoryEntry.getRevision(), "/"), true, new SVNLocationEntry(-1L, null), this.myFSFS);
            }
            if (this.myHistoryEntry.getRevision() > 0L) {
                return new FSNodeHistory(new SVNLocationEntry(this.myHistoryEntry.getRevision() - 1L, "/"), true, new SVNLocationEntry(-1L, null), this.myFSFS);
            }
        } else {
            FSNodeHistory fSNodeHistory = this;
            do {
                if ((fSNodeHistory = fSNodeHistory.historyPrev(bl2)) != null) continue;
                return null;
            } while (!fSNodeHistory.myIsInteresting);
            return fSNodeHistory;
        }
        return null;
    }
}

