/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNMergeInfo;
import org.tmatesoft.svn.core.SVNMergeInfoInheritance;
import org.tmatesoft.svn.core.SVNMergeRange;
import org.tmatesoft.svn.core.SVNMergeRangeList;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSLocationsFinder;
import org.tmatesoft.svn.core.internal.io.fs.FSLog$1;
import org.tmatesoft.svn.core.internal.io.fs.FSLog$2;
import org.tmatesoft.svn.core.internal.io.fs.FSLog$3;
import org.tmatesoft.svn.core.internal.io.fs.FSLog$PathInfo;
import org.tmatesoft.svn.core.internal.io.fs.FSLog$PathListRange;
import org.tmatesoft.svn.core.internal.io.fs.FSLog$RangeListPath;
import org.tmatesoft.svn.core.internal.io.fs.FSPathChange;
import org.tmatesoft.svn.core.internal.io.fs.FSPathChangeKind;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSRoot;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.util.SVNMergeInfoUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNMergeDriver;
import org.tmatesoft.svn.core.internal.wc.SVNMergeInfoManager;
import org.tmatesoft.svn.core.io.SVNLocationEntry;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class FSLog {
    private static final int MAX_OPEN_HISTORIES = 128;
    private FSFS myFSFS;
    private String[] myPaths;
    private boolean myIsDescending;
    private boolean myIsDiscoverChangedPaths;
    private boolean myIsStrictNode;
    private boolean myIsIncludeMergedRevisions;
    private long myStartRevision;
    private long myEndRevision;
    private long myLimit;
    private ISVNLogEntryHandler myHandler;
    private SVNMergeInfoManager myMergeInfoManager;
    private String[] myRevPropNames;
    private static final Comparator RLP_COMPARATOR = new FSLog$1();
    private static final Comparator PLR_COMPARATOR = new FSLog$2();

    public FSLog(FSFS fSFS, String[] stringArray, long l2, long l3, long l4, boolean bl2, boolean bl3, boolean bl4, boolean bl5, String[] stringArray2, ISVNLogEntryHandler iSVNLogEntryHandler) {
        this.myFSFS = fSFS;
        this.myPaths = stringArray;
        this.myStartRevision = l3;
        this.myEndRevision = l4;
        this.myIsDescending = bl2;
        this.myIsDiscoverChangedPaths = bl3;
        this.myIsStrictNode = bl4;
        this.myIsIncludeMergedRevisions = bl5;
        this.myRevPropNames = stringArray2;
        this.myLimit = l2;
        this.myHandler = iSVNLogEntryHandler;
    }

    public void reset(FSFS fSFS, String[] stringArray, long l2, long l3, long l4, boolean bl2, boolean bl3, boolean bl4, boolean bl5, String[] stringArray2, ISVNLogEntryHandler iSVNLogEntryHandler) {
        this.myFSFS = fSFS;
        this.myPaths = stringArray;
        this.myStartRevision = l3;
        this.myEndRevision = l4;
        this.myIsDescending = bl2;
        this.myIsDiscoverChangedPaths = bl3;
        this.myIsStrictNode = bl4;
        this.myIsIncludeMergedRevisions = bl5;
        this.myRevPropNames = stringArray2;
        this.myLimit = l2;
        this.myHandler = iSVNLogEntryHandler;
    }

    public long runLog() {
        long l2 = 0L;
        if (!this.myIsIncludeMergedRevisions && this.myPaths.length == 1 && "/".equals(this.myPaths[0])) {
            l2 = this.myEndRevision - this.myStartRevision + 1L;
            if (this.myLimit > 0L && l2 > this.myLimit) {
                l2 = this.myLimit;
            }
            int n2 = 0;
            while ((long)n2 < l2) {
                long l3 = this.myStartRevision + (long)n2;
                if (this.myIsDescending) {
                    l3 = this.myEndRevision - (long)n2;
                }
                this.sendLog(l3, null, null, false, false, false);
                ++n2;
            }
            return l2;
        }
        Map map = null;
        if (this.myIsIncludeMergedRevisions) {
            map = this.getPathsHistoryAsMergeInfo(this.myPaths, this.myStartRevision, this.myEndRevision);
        }
        return this.doLogs(this.myPaths, map, null, this.myStartRevision, this.myEndRevision, this.myIsIncludeMergedRevisions, false, false, this.myIsDescending, this.myLimit);
    }

    private long doLogs(String[] stringArray, Map map, Set set, long l2, long l3, boolean bl2, boolean bl3, boolean bl4, boolean bl5, long l4) {
        long l5 = 0L;
        FSLog$PathInfo[] fSLog$PathInfoArray = this.getPathHistories(stringArray, l2, l3, this.myIsStrictNode);
        LinkedList<Long> linkedList = null;
        TreeMap<Long, Map[]> treeMap = null;
        boolean bl6 = true;
        long l6 = l3;
        while (bl6) {
            Object object;
            boolean bl7;
            boolean bl8 = false;
            bl6 = false;
            for (bl7 = false; bl7 < fSLog$PathInfoArray.length; bl7 += 1) {
                object = fSLog$PathInfoArray[bl7];
                bl8 = ((FSLog$PathInfo)object).checkHistory(l6, this.myIsStrictNode, l2, bl8);
                if (((FSLog$PathInfo)object).myIsDone) continue;
                bl6 = true;
            }
            if (bl8) {
                bl7 = false;
                object = null;
                Map map2 = null;
                Map[] mapArray = null;
                if (bl2) {
                    LinkedList<String> linkedList2 = new LinkedList<String>();
                    for (int i2 = 0; i2 < fSLog$PathInfoArray.length; ++i2) {
                        FSLog$PathInfo fSLog$PathInfo = fSLog$PathInfoArray[i2];
                        linkedList2.add(fSLog$PathInfo.myPath);
                    }
                    mapArray = this.getCombinedMergeInfoChanges(linkedList2.toArray(new String[linkedList2.size()]), l6);
                    object = mapArray[0];
                    map2 = mapArray[1];
                    boolean bl9 = bl7 = object.size() > 0 || map2.size() > 0;
                }
                if (bl5) {
                    this.sendLog(l6, map, set, bl3, bl4, bl7);
                    ++l5;
                    if (bl7) {
                        if (set == null) {
                            set = new SVNHashSet();
                        }
                        this.handleMergedRevisions((Map)object, map2, map, set);
                    }
                    if (l4 > 0L && l5 >= l4) {
                        break;
                    }
                } else {
                    if (linkedList == null) {
                        linkedList = new LinkedList<Long>();
                    }
                    linkedList.addLast(l6);
                    if (mapArray != null) {
                        if (treeMap == null) {
                            treeMap = new TreeMap<Long, Map[]>();
                        }
                        treeMap.put(l6, mapArray);
                    }
                }
            }
            l6 = this.getNextHistoryRevision(fSLog$PathInfoArray);
        }
        set = null;
        if (linkedList != null) {
            for (int i3 = 0; i3 < linkedList.size(); ++i3) {
                boolean bl10 = false;
                Map[] mapArray = null;
                long l7 = (Long)linkedList.get(linkedList.size() - i3 - 1);
                if (treeMap != null && (mapArray = (Map[])treeMap.get(l7)) != null && mapArray.length == 2) {
                    bl10 = !mapArray[0].isEmpty() || !mapArray[1].isEmpty();
                }
                this.sendLog(l7, map, set, bl3, bl4, bl10);
                if (bl10) {
                    if (set == null) {
                        set = new SVNHashSet();
                    }
                    this.handleMergedRevisions(mapArray[0], mapArray[1], map, set);
                }
                if (l4 > 0L && ++l5 >= l4) break;
            }
        }
        return l5;
    }

    private long getNextHistoryRevision(FSLog$PathInfo[] fSLog$PathInfoArray) {
        long l2 = -1L;
        for (int i2 = 0; i2 < fSLog$PathInfoArray.length; ++i2) {
            FSLog$PathInfo fSLog$PathInfo = fSLog$PathInfoArray[i2];
            if (fSLog$PathInfo.myIsDone || fSLog$PathInfo.myHistoryRevision <= l2) continue;
            l2 = fSLog$PathInfo.myHistoryRevision;
        }
        return l2;
    }

    private void sendLog(long l2, Map map, Set set, boolean bl2, boolean bl3, boolean bl4) {
        if (this.myHandler == null) {
            return;
        }
        SVNLogEntry sVNLogEntry = this.fillLogEntry(l2, this.myIsDiscoverChangedPaths || bl3);
        sVNLogEntry.setHasChildren(bl4);
        sVNLogEntry.setSubtractiveMerge(bl2);
        boolean bl5 = true;
        if (bl3 && !sVNLogEntry.getChangedPaths().isEmpty() && map != null && !map.isEmpty()) {
            boolean bl6 = false;
            bl5 = false;
            for (String string : sVNLogEntry.getChangedPaths().keySet()) {
                for (String string2 : map.keySet()) {
                    if (!SVNPathUtil.isAncestor(string2, string)) continue;
                    SVNMergeRangeList sVNMergeRangeList = (SVNMergeRangeList)map.get(string2);
                    SVNMergeRange[] sVNMergeRangeArray = sVNMergeRangeList.getRanges();
                    for (int i2 = 0; i2 < sVNMergeRangeArray.length; ++i2) {
                        if (l2 <= sVNMergeRangeArray[i2].getStartRevision() || l2 > sVNMergeRangeArray[i2].getEndRevision()) continue;
                        bl6 = true;
                        break;
                    }
                    if (!bl6) continue;
                    break;
                }
                if (bl6) continue;
                bl5 = true;
                break;
            }
        }
        if (!this.myIsDiscoverChangedPaths) {
            sVNLogEntry.getChangedPaths().clear();
        }
        if (bl5) {
            if (bl3 && set != null) {
                if (set.contains(l2)) {
                    return;
                }
                set.add(l2);
            }
            this.myHandler.handleLogEntry(sVNLogEntry);
        }
    }

    private SVNLogEntry fillLogEntry(long l2, boolean bl2) {
        Object object;
        Object object2;
        Map map;
        block8: {
            Date date;
            boolean bl3;
            block9: {
                block10: {
                    map = null;
                    object2 = null;
                    boolean bl4 = true;
                    bl3 = false;
                    if (l2 > 0L && bl2) {
                        object = this.myFSFS.createRevisionRoot(l2);
                        map = ((FSRoot)object).detectChanged();
                    }
                    if (!bl4 || (object = this.myFSFS.getRevisionProperties(l2)) == null) break block8;
                    String string = ((SVNProperties)object).getStringValue("svn:author");
                    String string2 = ((SVNProperties)object).getStringValue("svn:date");
                    Date date2 = date = string2 != null ? SVNDate.parseDateString(string2) : null;
                    if (this.myRevPropNames != null && this.myRevPropNames.length != 0) break block9;
                    if (!bl3) break block10;
                    object2 = new SVNProperties();
                    if (string != null) {
                        ((SVNProperties)object2).put("svn:author", string);
                    }
                    if (date != null) {
                        ((SVNProperties)object2).put("svn:date", SVNDate.formatDate(date));
                    }
                    break block8;
                }
                object2 = object;
                if (date == null) break block8;
                ((SVNProperties)object2).put("svn:date", SVNDate.formatDate(date));
                break block8;
            }
            for (int i2 = 0; i2 < this.myRevPropNames.length; ++i2) {
                String string = this.myRevPropNames[i2];
                SVNPropertyValue sVNPropertyValue = ((SVNProperties)object).getSVNPropertyValue(string);
                if (bl3 && !"svn:author".equals(string) && !"svn:date".equals(string)) continue;
                if (object2 == null) {
                    object2 = new SVNProperties();
                }
                if ("svn:date".equals(string) && date != null) {
                    ((SVNProperties)object2).put(string, SVNDate.formatDate(date));
                    continue;
                }
                if (sVNPropertyValue == null) continue;
                ((SVNProperties)object2).put(string, sVNPropertyValue);
            }
        }
        if (map == null) {
            map = new SVNHashMap();
        }
        if (object2 == null) {
            object2 = new SVNProperties();
        }
        object = new SVNLogEntry(map, l2, (SVNProperties)object2, false);
        return object;
    }

    private void handleMergedRevisions(Map map, Map map2, Map map3, Set set) {
        if ((map == null || map.isEmpty()) && (map2 == null || map2.isEmpty())) {
            return;
        }
        LinkedList linkedList = new LinkedList();
        if (map != null && map.size() > 0) {
            linkedList = this.combineMergeInfoPathLists(map, false);
        }
        if (map2 != null && map2.size() > 0) {
            linkedList.addAll(this.combineMergeInfoPathLists(map2, true));
        }
        Collections.sort(linkedList, PLR_COMPARATOR);
        for (int i2 = linkedList.size() - 1; i2 >= 0; --i2) {
            FSLog$PathListRange fSLog$PathListRange = (FSLog$PathListRange)linkedList.get(i2);
            try {
                this.doLogs(fSLog$PathListRange.myPaths, map3, set, fSLog$PathListRange.myRange.getStartRevision(), fSLog$PathListRange.myRange.getEndRevision(), true, fSLog$PathListRange.reverseMerge, true, true, 0L);
                continue;
            }
            catch (SVNException sVNException) {
                SVNErrorCode sVNErrorCode = sVNException.getErrorMessage().getErrorCode();
                if (sVNErrorCode == SVNErrorCode.FS_NOT_FOUND || sVNErrorCode == SVNErrorCode.FS_NO_SUCH_REVISION) continue;
                throw sVNException;
            }
        }
        if (this.myHandler != null) {
            this.myHandler.handleLogEntry(SVNLogEntry.EMPTY_ENTRY);
        }
    }

    private Map getPathsHistoryAsMergeInfo(String[] stringArray, long l2, long l3) {
        if (l2 < l3) {
            long l4 = l2;
            l2 = l3;
            l3 = l4;
        }
        Map map = new SVNHashMap();
        FSLocationsFinder fSLocationsFinder = new FSLocationsFinder(this.myFSFS);
        ArrayList arrayList = new ArrayList();
        FSLog$3 fSLog$3 = new FSLog$3(this, arrayList);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            fSLocationsFinder.getNodeLocationSegments(stringArray[i2], l2, l2, l3, fSLog$3);
            Map map2 = SVNMergeDriver.getMergeInfoFromSegments(arrayList);
            map = SVNMergeInfoUtil.mergeMergeInfos(map, map2);
        }
        return map;
    }

    private FSLog$PathInfo[] getPathHistories(String[] stringArray, long l2, long l3, boolean bl2) {
        FSLog$PathInfo[] fSLog$PathInfoArray = new FSLog$PathInfo[stringArray.length];
        FSRevisionRoot fSRevisionRoot = this.myFSFS.createRevisionRoot(l3);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            FSLog$PathInfo fSLog$PathInfo = new FSLog$PathInfo(this, null);
            fSLog$PathInfo.myPath = string;
            fSLog$PathInfo.myHistoryRevision = l3;
            fSLog$PathInfo.myIsDone = false;
            fSLog$PathInfo.myIsFirstTime = true;
            if (i2 < 128) {
                fSLog$PathInfo.myHistory = fSRevisionRoot.getNodeHistory(string);
            }
            fSLog$PathInfoArray[i2] = fSLog$PathInfo.getHistory(bl2, l2);
        }
        return fSLog$PathInfoArray;
    }

    private Map[] getCombinedMergeInfoChanges(String[] stringArray, long l2) {
        String string;
        Object object;
        if (l2 == 0L) {
            return new Map[]{new TreeMap(), new TreeMap()};
        }
        if (stringArray == null || stringArray.length == 0) {
            return new Map[]{new TreeMap(), new TreeMap()};
        }
        Map map = new SVNHashMap();
        Map map2 = new SVNHashMap();
        SVNHashMap sVNHashMap = new SVNHashMap();
        SVNHashMap sVNHashMap2 = new SVNHashMap();
        FSRevisionRoot fSRevisionRoot = this.myFSFS.createRevisionRoot(l2);
        this.collectChangedMergeInfo(sVNHashMap, sVNHashMap2, l2);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string2 = stringArray[i2];
            if (sVNHashMap2.containsKey(string2)) continue;
            object = new long[]{-1L};
            SVNLocationEntry sVNLocationEntry = null;
            try {
                sVNLocationEntry = this.myFSFS.getPreviousLocation(string2, l2, (long[])object);
            }
            catch (SVNException sVNException) {
                if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.FS_NOT_FOUND) continue;
                throw sVNException;
            }
            string = null;
            long l3 = -1L;
            if (sVNLocationEntry == null || sVNLocationEntry.getPath() == null || sVNLocationEntry.getRevision() < 0L || object[0] != l2) {
                string = string2;
                l3 = l2 - 1L;
            } else if (sVNLocationEntry != null) {
                string = sVNLocationEntry.getPath();
                l3 = sVNLocationEntry.getRevision();
            }
            FSRevisionRoot fSRevisionRoot2 = this.myFSFS.createRevisionRoot(l3);
            String[] stringArray2 = new String[]{string};
            Map map3 = null;
            try {
                map3 = this.getMergeInfoManager().getMergeInfo(stringArray2, fSRevisionRoot2, SVNMergeInfoInheritance.INHERITED, false);
            }
            catch (SVNException sVNException) {
                if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.FS_NOT_FOUND) continue;
                throw sVNException;
            }
            SVNMergeInfo sVNMergeInfo = (SVNMergeInfo)map3.get(string);
            stringArray2 = new String[]{string2};
            map3 = this.getMergeInfoManager().getMergeInfo(stringArray2, fSRevisionRoot, SVNMergeInfoInheritance.INHERITED, false);
            SVNMergeInfo sVNMergeInfo2 = (SVNMergeInfo)map3.get(string2);
            SVNHashMap sVNHashMap3 = new SVNHashMap();
            SVNHashMap sVNHashMap4 = new SVNHashMap();
            SVNMergeInfoUtil.diffMergeInfo(sVNHashMap3, sVNHashMap4, sVNMergeInfo != null ? sVNMergeInfo.getMergeSourcesToMergeLists() : null, sVNMergeInfo2 != null ? sVNMergeInfo2.getMergeSourcesToMergeLists() : null, false);
            map = SVNMergeInfoUtil.mergeMergeInfos(map, sVNHashMap4);
            map2 = SVNMergeInfoUtil.mergeMergeInfos(map2, sVNHashMap3);
        }
        block5: for (String string2 : sVNHashMap.keySet()) {
            object = (Map)sVNHashMap.get(string2);
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                string = stringArray[i3];
                if (!SVNPathUtil.isAncestor(string, string2)) continue;
                Map map4 = (Map)sVNHashMap2.get(string2);
                map2 = SVNMergeInfoUtil.mergeMergeInfos(map2, map4);
                map = SVNMergeInfoUtil.mergeMergeInfos(map, (Map)object);
                continue block5;
            }
        }
        return new Map[]{map, map2};
    }

    private void collectChangedMergeInfo(Map map, Map map2, long l2) {
        if (l2 == 0L) {
            return;
        }
        FSRevisionRoot fSRevisionRoot = this.myFSFS.createRevisionRoot(l2);
        Map map3 = fSRevisionRoot.getChangedPaths();
        if (map3 == null || map3.isEmpty()) {
            return;
        }
        for (String string : map3.keySet()) {
            Object object;
            Map map4;
            Object object2;
            Object object3;
            Object object4;
            FSPathChange fSPathChange = (FSPathChange)map3.get(string);
            if (!fSPathChange.arePropertiesModified()) continue;
            FSPathChangeKind fSPathChangeKind = fSPathChange.getChangeKind();
            Object object5 = null;
            long l3 = -1L;
            String string2 = null;
            String string3 = null;
            if (fSPathChangeKind == FSPathChangeKind.FS_PATH_CHANGE_ADD || fSPathChangeKind == FSPathChangeKind.FS_PATH_CHANGE_REPLACE) {
                object4 = fSPathChange.getCopyPath();
                long l4 = fSPathChange.getCopyRevision();
                if (object4 != null && l4 >= 0L) {
                    object5 = object4;
                    l3 = l4;
                }
            } else {
                if (fSPathChangeKind != FSPathChangeKind.FS_PATH_CHANGE_MODIFY) continue;
                object4 = new long[]{-1L};
                object3 = this.myFSFS.getPreviousLocation(string, l2, (long[])object4);
                if (object3 == null || ((SVNLocationEntry)object3).getPath() == null || ((SVNLocationEntry)object3).getRevision() < 0L || object4[0] != ((SVNLocationEntry)object3).getRevision()) {
                    object5 = string;
                    l3 = l2 - 1L;
                } else {
                    object5 = ((SVNLocationEntry)object3).getPath();
                    l3 = ((SVNLocationEntry)object3).getRevision();
                }
            }
            object4 = null;
            if (object5 != null && l3 >= 0L) {
                object4 = this.myFSFS.createRevisionRoot(l3);
                SVNProperties sVNProperties = this.myFSFS.getProperties(((FSRoot)object4).getRevisionNode((String)object5));
                string3 = sVNProperties.getStringValue("svn:mergeinfo");
            }
            if ((object3 = this.myFSFS.getProperties(fSRevisionRoot.getRevisionNode(string))) != null) {
                string2 = ((SVNProperties)object3).getStringValue("svn:mergeinfo");
            }
            if (string2 == null && string3 == null) continue;
            if (string3 != null && string2 == null) {
                object2 = new String[]{string};
                map4 = this.getMergeInfoManager().getMergeInfo((String[])object2, fSRevisionRoot, SVNMergeInfoInheritance.INHERITED, false);
                object = (SVNMergeInfo)map4.get(string);
                if (object != null) {
                    string2 = SVNMergeInfoUtil.formatMergeInfoToString(((SVNMergeInfo)object).getMergeSourcesToMergeLists(), null);
                }
            } else if (string2 != null && string3 == null && object5 != null && SVNRevision.isValidRevisionNumber(l3)) {
                object2 = new String[]{object5};
                map4 = this.getMergeInfoManager().getMergeInfo((String[])object2, (FSRevisionRoot)object4, SVNMergeInfoInheritance.INHERITED, false);
                object = (SVNMergeInfo)map4.get(object5);
                if (object != null) {
                    string3 = SVNMergeInfoUtil.formatMergeInfoToString(((SVNMergeInfo)object).getMergeSourcesToMergeLists(), null);
                }
            }
            if (!(string3 != null && string2 == null || string3 == null && string2 != null) && (string3 == null || string2 == null || string3.equals(string2))) continue;
            object2 = null;
            map4 = null;
            if (string2 != null) {
                object2 = SVNMergeInfoUtil.parseMergeInfo(new StringBuffer(string2), null);
            }
            if (string3 != null) {
                map4 = SVNMergeInfoUtil.parseMergeInfo(new StringBuffer(string3), null);
            }
            object = new SVNHashMap();
            SVNHashMap sVNHashMap = new SVNHashMap();
            SVNMergeInfoUtil.diffMergeInfo(sVNHashMap, (Map)object, map4, (Map)object2, false);
            map.put(string, object);
            map2.put(string, sVNHashMap);
        }
    }

    private LinkedList combineMergeInfoPathLists(Map map, boolean bl2) {
        Object object;
        Object object22;
        LinkedList<FSLog$RangeListPath> linkedList = new LinkedList<FSLog$RangeListPath>();
        for (Object object22 : map.keySet()) {
            object = (SVNMergeRangeList)map.get(object22);
            FSLog$RangeListPath fSLog$RangeListPath = new FSLog$RangeListPath(this, null);
            fSLog$RangeListPath.myPath = object22;
            fSLog$RangeListPath.myRangeList = ((SVNMergeRangeList)object).dup();
            SVNMergeRange[] sVNMergeRangeArray = fSLog$RangeListPath.myRangeList.getRanges();
            for (int i2 = 0; i2 < sVNMergeRangeArray.length; ++i2) {
                SVNMergeRange sVNMergeRange = sVNMergeRangeArray[i2];
                sVNMergeRange.setStartRevision(sVNMergeRange.getStartRevision() + 1L);
            }
            linkedList.add(fSLog$RangeListPath);
        }
        LinkedList linkedList2 = new LinkedList();
        while (linkedList.size() > 1) {
            FSLog$RangeListPath fSLog$RangeListPath;
            int n2;
            long l2;
            Collections.sort(linkedList, RLP_COMPARATOR);
            object = object22 = (FSLog$RangeListPath)linkedList.get(0);
            long l3 = l2 = ((FSLog$RangeListPath)object22).myRangeList.getRanges()[0].getStartRevision();
            int n3 = 1;
            while (l3 == l2) {
                if (n3 == linkedList.size()) {
                    ++n3;
                    break;
                }
                object22 = (FSLog$RangeListPath)linkedList.get(n3);
                l3 = ((FSLog$RangeListPath)object22).myRangeList.getRanges()[0].getStartRevision();
                ++n3;
            }
            --n3;
            long l4 = ((FSLog$RangeListPath)object).myRangeList.getRanges()[0].getEndRevision();
            long l5 = l3 - 1L;
            if (l3 == l2 || l4 < l3) {
                l5 = l4;
            }
            FSLog$PathListRange fSLog$PathListRange = new FSLog$PathListRange(this, null);
            fSLog$PathListRange.reverseMerge = bl2;
            fSLog$PathListRange.myRange = new SVNMergeRange(l2, l5, false);
            LinkedList<String> linkedList3 = new LinkedList<String>();
            for (n2 = 0; n2 < n3; ++n2) {
                fSLog$RangeListPath = (FSLog$RangeListPath)linkedList.get(n2);
                linkedList3.add(fSLog$RangeListPath.myPath);
            }
            fSLog$PathListRange.myPaths = linkedList3.toArray(new String[linkedList3.size()]);
            linkedList2.add(fSLog$PathListRange);
            for (n2 = 0; n2 < n3; ++n2) {
                fSLog$RangeListPath = (FSLog$RangeListPath)linkedList.get(n2);
                SVNMergeRange sVNMergeRange = fSLog$RangeListPath.myRangeList.getRanges()[0];
                sVNMergeRange.setStartRevision(l5 + 1L);
                if (sVNMergeRange.getStartRevision() <= sVNMergeRange.getEndRevision()) continue;
                if (fSLog$RangeListPath.myRangeList.getSize() == 1) {
                    linkedList.remove(0);
                    --n2;
                    --n3;
                    continue;
                }
                SVNMergeRange[] sVNMergeRangeArray = new SVNMergeRange[fSLog$RangeListPath.myRangeList.getSize() - 1];
                System.arraycopy(fSLog$RangeListPath.myRangeList.getRanges(), 1, sVNMergeRangeArray, 0, sVNMergeRangeArray.length);
                fSLog$RangeListPath.myRangeList = new SVNMergeRangeList(sVNMergeRangeArray);
            }
        }
        if (!linkedList.isEmpty()) {
            object22 = (FSLog$RangeListPath)linkedList.get(0);
            while (!((FSLog$RangeListPath)object22).myRangeList.isEmpty()) {
                object = new FSLog$PathListRange(this, null);
                ((FSLog$PathListRange)object).reverseMerge = bl2;
                ((FSLog$PathListRange)object).myPaths = new String[]{((FSLog$RangeListPath)object22).myPath};
                ((FSLog$PathListRange)object).myRange = ((FSLog$RangeListPath)object22).myRangeList.getRanges()[0];
                SVNMergeRange[] sVNMergeRangeArray = new SVNMergeRange[((FSLog$RangeListPath)object22).myRangeList.getSize() - 1];
                System.arraycopy(((FSLog$RangeListPath)object22).myRangeList.getRanges(), 1, sVNMergeRangeArray, 0, sVNMergeRangeArray.length);
                ((FSLog$RangeListPath)object22).myRangeList = new SVNMergeRangeList(sVNMergeRangeArray);
                linkedList2.add(object);
            }
        }
        return linkedList2;
    }

    private SVNMergeInfoManager getMergeInfoManager() {
        if (this.myMergeInfoManager == null) {
            this.myMergeInfoManager = new SVNMergeInfoManager();
        }
        return this.myMergeInfoManager;
    }

    static /* synthetic */ FSFS access$300(FSLog fSLog) {
        return fSLog.myFSFS;
    }
}

