/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.util.ArrayList;
import java.util.Arrays;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSNodeHistory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepository;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.ISVNLocationEntryHandler;
import org.tmatesoft.svn.core.io.ISVNLocationSegmentHandler;
import org.tmatesoft.svn.core.io.SVNLocationEntry;
import org.tmatesoft.svn.core.io.SVNLocationSegment;
import org.tmatesoft.svn.util.SVNLogType;

public class FSLocationsFinder {
    private FSFS myFSFS;

    public FSLocationsFinder(FSFS fSFS) {
        this.myFSFS = fSFS;
    }

    public int traceNodeLocations(String string, long l2, long[] lArray, ISVNLocationEntryHandler iSVNLocationEntryHandler) {
        Object object;
        Object object2;
        int n2;
        ArrayList<SVNLocationEntry> arrayList = new ArrayList<SVNLocationEntry>(0);
        long[] lArray2 = new long[lArray.length];
        Arrays.sort(lArray);
        for (n2 = 0; n2 < lArray.length; ++n2) {
            lArray2[n2] = lArray[lArray.length - (n2 + 1)];
        }
        n2 = 0;
        boolean bl2 = false;
        for (n2 = 0; n2 < lArray2.length && lArray2[n2] > l2 && !(bl2 = FSNodeHistory.checkAncestryOfPegPath(string, l2, lArray2[n2], this.myFSFS)); ++n2) {
        }
        if (n2 >= lArray2.length) {
            return 0;
        }
        long l3 = bl2 ? lArray2[n2] : l2;
        FSRevisionRoot fSRevisionRoot = null;
        while (n2 < lArray.length) {
            object2 = new long[1];
            fSRevisionRoot = this.myFSFS.createRevisionRoot(l3);
            object = fSRevisionRoot.getPreviousLocation(string, (long[])object2);
            if (object == null) break;
            String string2 = ((SVNLocationEntry)object).getPath();
            long l4 = ((SVNLocationEntry)object).getRevision();
            while (n2 < lArray.length && lArray2[n2] >= object2[0]) {
                arrayList.add(new SVNLocationEntry(lArray2[n2], string));
                ++n2;
            }
            while (n2 < lArray.length && lArray2[n2] > l4) {
                ++n2;
            }
            string = string2;
            l3 = l4;
        }
        if (fSRevisionRoot != null && l3 != fSRevisionRoot.getRevision()) {
            fSRevisionRoot = this.myFSFS.createRevisionRoot(l3);
        }
        object2 = fSRevisionRoot.getRevisionNode(string);
        while (n2 < lArray.length && (fSRevisionRoot = this.myFSFS.createRevisionRoot(lArray2[n2])).checkNodeKind(string) != SVNNodeKind.NONE) {
            object = fSRevisionRoot.getRevisionNode(string);
            if (!((FSRevisionNode)object2).getId().isRelated(((FSRevisionNode)object).getId())) break;
            arrayList.add(new SVNLocationEntry(lArray2[n2], string));
            ++n2;
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            if (iSVNLocationEntryHandler == null) continue;
            iSVNLocationEntryHandler.handleLocationEntry((SVNLocationEntry)arrayList.get(n2));
        }
        return n2;
    }

    public long getNodeLocationSegments(String string, long l2, long l3, long l4, ISVNLocationSegmentHandler iSVNLocationSegmentHandler) {
        SVNErrorMessage sVNErrorMessage;
        long l5 = -1L;
        if (FSRepository.isInvalidRevision(l2)) {
            l2 = l5 = this.myFSFS.getYoungestRevision();
        }
        if (FSRepository.isInvalidRevision(l3)) {
            l3 = FSRepository.isValidRevision(l5) ? l5 : this.myFSFS.getYoungestRevision();
        }
        if (FSRepository.isInvalidRevision(l4)) {
            l4 = 0L;
        }
        if (l4 > l3) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "End revision {0} must be less or equal to start revision {1}", l4, l3);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        if (l2 < l3) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "Peg revision {0} must be greater or equal to start revision {1}", l2, l3);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        long l6 = 0L;
        long l7 = l2;
        String string2 = string;
        long[] lArray = new long[1];
        while (l7 >= l4) {
            long l8 = l4;
            long l9 = l7;
            String string3 = string2;
            FSRevisionRoot fSRevisionRoot = this.myFSFS.createRevisionRoot(l7);
            SVNLocationEntry sVNLocationEntry = fSRevisionRoot.getPreviousLocation(string2, lArray);
            if (sVNLocationEntry == null) {
                l8 = fSRevisionRoot.getNodeOriginRevision(string2);
                if (l8 < l4) {
                    l8 = l4;
                }
                l7 = -1L;
            } else {
                l8 = lArray[0];
                string2 = sVNLocationEntry.getPath();
                l7 = sVNLocationEntry.getRevision();
            }
            l6 += this.maybeCropAndSendSegment(l8, l9, l3, l4, string3, iSVNLocationSegmentHandler);
            if (FSRepository.isInvalidRevision(l7)) break;
            if (l8 - l7 <= 1L) continue;
            l6 += this.maybeCropAndSendSegment(l7 + 1L, l8 - 1L, l3, l4, null, iSVNLocationSegmentHandler);
        }
        return l6;
    }

    protected void reset(FSFS fSFS) {
        this.myFSFS = fSFS;
    }

    private long maybeCropAndSendSegment(long l2, long l3, long l4, long l5, String string, ISVNLocationSegmentHandler iSVNLocationSegmentHandler) {
        if (l2 <= l4 && l3 >= l5) {
            if (l2 < l5) {
                l2 = l5;
            }
            if (l3 > l4) {
                l3 = l4;
            }
            if (iSVNLocationSegmentHandler != null) {
                iSVNLocationSegmentHandler.handleLocationSegment(new SVNLocationSegment(l2, l3, string));
            }
            return l3 - l2 + 1L;
        }
        return 0L;
    }
}

