/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaCombiner;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSFile;
import org.tmatesoft.svn.core.internal.io.fs.FSInputStream$FSRepresentationState;
import org.tmatesoft.svn.core.internal.io.fs.FSRepresentation;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.util.SVNLogType;

public class FSInputStream
extends InputStream {
    private LinkedList myRepStateList = new LinkedList();
    private int myChunkIndex;
    private boolean isChecksumFinalized;
    private String myHexChecksum;
    private long myLength;
    private long myOffset;
    private MessageDigest myDigest;
    private ByteBuffer myBuffer;
    private SVNDeltaCombiner myCombiner;

    private FSInputStream(SVNDeltaCombiner sVNDeltaCombiner, FSRepresentation fSRepresentation, FSFS fSFS) {
        this.myCombiner = sVNDeltaCombiner;
        this.myChunkIndex = 0;
        this.isChecksumFinalized = false;
        this.myHexChecksum = fSRepresentation.getMD5HexDigest();
        this.myOffset = 0L;
        this.myLength = fSRepresentation.getExpandedSize();
        try {
            this.myDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "MD5 implementation not found: {0}", (Object)noSuchAlgorithmException.getLocalizedMessage());
            SVNErrorManager.error(sVNErrorMessage, noSuchAlgorithmException, SVNLogType.FSFS);
        }
        try {
            this.buildRepresentationList(fSRepresentation, this.myRepStateList, fSFS);
        }
        catch (SVNException sVNException) {
            this.close();
            throw sVNException;
        }
    }

    public static InputStream createDeltaStream(SVNDeltaCombiner sVNDeltaCombiner, FSRevisionNode fSRevisionNode, FSFS fSFS) {
        Object object;
        if (fSRevisionNode == null) {
            return SVNFileUtil.DUMMY_IN;
        }
        if (fSRevisionNode.getType() != SVNNodeKind.FILE) {
            object = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FILE, "Attempted to get textual contents of a *non*-file node");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        if ((object = fSRevisionNode.getTextRepresentation()) == null) {
            return SVNFileUtil.DUMMY_IN;
        }
        return new FSInputStream(sVNDeltaCombiner, (FSRepresentation)object, fSFS);
    }

    public static InputStream createDeltaStream(SVNDeltaCombiner sVNDeltaCombiner, FSRepresentation fSRepresentation, FSFS fSFS) {
        if (fSRepresentation == null) {
            return SVNFileUtil.DUMMY_IN;
        }
        return new FSInputStream(sVNDeltaCombiner, fSRepresentation, fSFS);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        try {
            return this.readContents(byArray, n2, n3);
        }
        catch (SVNException sVNException) {
            throw new IOException(sVNException.getMessage());
        }
    }

    @Override
    public int read() {
        byte[] byArray = new byte[1];
        int n2 = this.read(byArray, 0, 1);
        if (n2 < 0) {
            return -1;
        }
        return byArray[0] & 0xFF;
    }

    private int readContents(byte[] byArray, int n2, int n3) {
        n3 = this.getContents(byArray, n2, n3);
        if (!this.isChecksumFinalized && n3 >= 0) {
            this.myDigest.update(byArray, n2, n3);
            this.myOffset += (long)n3;
            if (this.myOffset == this.myLength) {
                this.isChecksumFinalized = true;
                String string = SVNFileUtil.toHexDigest(this.myDigest);
                if (!this.myHexChecksum.equals(string)) {
                    SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Checksum mismatch while reading representation:\n   expected:  {0}\n     actual:  {1}", this.myHexChecksum, string);
                    SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
                }
            }
        }
        return n3;
    }

    private int getContents(byte[] byArray, int n2, int n3) {
        int n4 = n3;
        int n5 = n2;
        int n6 = 0;
        block0: while (n4 > 0) {
            if (this.myBuffer != null && this.myBuffer.hasRemaining()) {
                int n7 = Math.min(this.myBuffer.remaining(), n4);
                this.myBuffer.get(byArray, n5, n7);
                n5 += n7;
                n4 -= n7;
                n6 += n7;
                continue;
            }
            FSInputStream$FSRepresentationState fSInputStream$FSRepresentationState = (FSInputStream$FSRepresentationState)this.myRepStateList.getFirst();
            if (fSInputStream$FSRepresentationState.myOffset == fSInputStream$FSRepresentationState.myEnd) {
                if (n6 != 0) break;
                n6 = -1;
                break;
            }
            this.myCombiner.reset();
            ListIterator listIterator = this.myRepStateList.listIterator();
            while (listIterator.hasNext()) {
                Object object;
                FSInputStream$FSRepresentationState fSInputStream$FSRepresentationState2 = (FSInputStream$FSRepresentationState)listIterator.next();
                while (fSInputStream$FSRepresentationState2.myChunkIndex < this.myChunkIndex) {
                    this.myCombiner.skipWindow(fSInputStream$FSRepresentationState2.myFile);
                    ++fSInputStream$FSRepresentationState2.myChunkIndex;
                    fSInputStream$FSRepresentationState2.myOffset = fSInputStream$FSRepresentationState2.myFile.position();
                    if (fSInputStream$FSRepresentationState2.myOffset < fSInputStream$FSRepresentationState2.myEnd) continue;
                    object = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Reading one svndiff window read beyond the end of the representation");
                    SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
                }
                object = this.myCombiner.readWindow(fSInputStream$FSRepresentationState2.myFile, fSInputStream$FSRepresentationState2.myVersion);
                ByteBuffer byteBuffer = this.myCombiner.addWindow((SVNDiffWindow)object);
                ++fSInputStream$FSRepresentationState2.myChunkIndex;
                fSInputStream$FSRepresentationState2.myOffset = fSInputStream$FSRepresentationState2.myFile.position();
                if (byteBuffer == null) continue;
                this.myBuffer = byteBuffer;
                ++this.myChunkIndex;
                continue block0;
            }
        }
        return n6;
    }

    @Override
    public void close() {
        Iterator iterator = this.myRepStateList.iterator();
        while (iterator.hasNext()) {
            FSInputStream$FSRepresentationState fSInputStream$FSRepresentationState = (FSInputStream$FSRepresentationState)iterator.next();
            if (fSInputStream$FSRepresentationState.myFile != null) {
                fSInputStream$FSRepresentationState.myFile.close();
            }
            iterator.remove();
        }
    }

    private FSInputStream$FSRepresentationState buildRepresentationList(FSRepresentation fSRepresentation, LinkedList linkedList, FSFS fSFS) {
        FSFile fSFile = null;
        FSRepresentation fSRepresentation2 = new FSRepresentation(fSRepresentation);
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        try {
            while (true) {
                fSFile = fSFS.openAndSeekRepresentation(fSRepresentation2);
                FSInputStream$FSRepresentationState fSInputStream$FSRepresentationState = FSInputStream.readRepresentationLine(fSFile);
                fSInputStream$FSRepresentationState.myFile = fSFile;
                fSInputStream$FSRepresentationState.myOffset = fSInputStream$FSRepresentationState.myStart = fSFile.position();
                fSInputStream$FSRepresentationState.myEnd = fSInputStream$FSRepresentationState.myStart + fSRepresentation2.getSize();
                if (!fSInputStream$FSRepresentationState.myIsDelta) {
                    return fSInputStream$FSRepresentationState;
                }
                byteBuffer.clear();
                int n2 = fSFile.read(byteBuffer);
                byte[] byArray = byteBuffer.array();
                if (byArray[0] != 83 || byArray[1] != 86 || byArray[2] != 78 || n2 != 4) {
                    SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed svndiff data in representation");
                    SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
                }
                fSInputStream$FSRepresentationState.myVersion = byArray[3];
                fSInputStream$FSRepresentationState.myChunkIndex = 0;
                fSInputStream$FSRepresentationState.myOffset += 4L;
                linkedList.addLast(fSInputStream$FSRepresentationState);
                if (fSInputStream$FSRepresentationState.myIsDeltaVsEmpty) {
                    return null;
                }
                fSRepresentation2.setRevision(fSInputStream$FSRepresentationState.myBaseRevision);
                fSRepresentation2.setItemIndex(fSInputStream$FSRepresentationState.myBaseOffset);
                fSRepresentation2.setSize(fSInputStream$FSRepresentationState.myBaseLength);
                fSRepresentation2.setTxnId(null);
            }
        }
        catch (IOException iOException) {
            fSFile.close();
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage());
            SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.FSFS);
        }
        catch (SVNException sVNException) {
            if (fSFile != null) {
                fSFile.close();
            }
            throw sVNException;
        }
        return null;
    }

    public static FSInputStream$FSRepresentationState readRepresentationLine(FSFile fSFile) {
        try {
            Object object;
            Object object2;
            String string = fSFile.readLine(160);
            FSInputStream$FSRepresentationState fSInputStream$FSRepresentationState = new FSInputStream$FSRepresentationState();
            fSInputStream$FSRepresentationState.myIsDelta = false;
            if ("PLAIN".equals(string)) {
                return fSInputStream$FSRepresentationState;
            }
            if ("DELTA".equals(string)) {
                fSInputStream$FSRepresentationState.myIsDelta = true;
                fSInputStream$FSRepresentationState.myIsDeltaVsEmpty = true;
                return fSInputStream$FSRepresentationState;
            }
            fSInputStream$FSRepresentationState.myIsDelta = true;
            fSInputStream$FSRepresentationState.myIsDeltaVsEmpty = false;
            int n2 = string.indexOf(32);
            if (n2 == -1) {
                object2 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed representation header");
                SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.FSFS);
            }
            if (!"DELTA".equals(object2 = string.substring(0, n2))) {
                object = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed representation header");
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
            }
            string = string.substring(n2 + 1);
            try {
                Object object3;
                n2 = string.indexOf(32);
                if (n2 == -1) {
                    object = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed representation header");
                    SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
                }
                object = string.substring(0, n2);
                fSInputStream$FSRepresentationState.myBaseRevision = Long.parseLong((String)object);
                if ((n2 = (string = string.substring(n2 + 1)).indexOf(32)) == -1) {
                    object3 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed representation header");
                    SVNErrorManager.error((SVNErrorMessage)object3, SVNLogType.FSFS);
                }
                object3 = string.substring(0, n2);
                fSInputStream$FSRepresentationState.myBaseOffset = Long.parseLong((String)object3);
                string = string.substring(n2 + 1);
                fSInputStream$FSRepresentationState.myBaseLength = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed representation header");
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
            return fSInputStream$FSRepresentationState;
        }
        catch (SVNException sVNException) {
            fSFile.close();
            throw sVNException;
        }
    }
}

