/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.Serializable;

public class FSID
implements Serializable {
    public static final long ITEM_INDEX_UNUSED = 0L;
    public static final long ITEM_INDEX_CHANGES = 1L;
    public static final long ITEM_INDEX_ROOT_NODE = 2L;
    public static final long ITEM_FIRST_USER = 3L;
    private static final long serialVersionUID = 4845L;
    private String myNodeID;
    private String myCopyID;
    private String myTxnID;
    private long myRevision;
    private long myOffset;

    public boolean isTxn() {
        return this.myTxnID != null;
    }

    public static FSID createTxnId(String string, String string2, String string3) {
        return new FSID(string, string3, string2, -1L, -1L);
    }

    public static FSID createRevId(String string, String string2, long l2, long l3) {
        return new FSID(string, null, string2, l2, l3);
    }

    private FSID(String string, String string2, String string3, long l2, long l3) {
        this.myNodeID = string;
        this.myCopyID = string3;
        this.myTxnID = string2;
        this.myRevision = l2;
        this.myOffset = l3;
    }

    public FSID copy() {
        return new FSID(this.getNodeID(), this.getTxnID(), this.getCopyID(), this.getRevision(), this.getOffset());
    }

    public String getNodeID() {
        return this.myNodeID;
    }

    public String getTxnID() {
        return this.myTxnID;
    }

    public String getCopyID() {
        return this.myCopyID;
    }

    public long getRevision() {
        return this.myRevision;
    }

    public long getOffset() {
        return this.myOffset;
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != FSID.class) {
            return false;
        }
        FSID fSID = (FSID)object;
        if (this == fSID) {
            return true;
        }
        if (this.myNodeID != null && !this.myNodeID.equals(fSID.getNodeID())) {
            return false;
        }
        if (this.myNodeID == null && fSID.getNodeID() != null) {
            return false;
        }
        if (this.myCopyID != null && !this.myCopyID.equals(fSID.getCopyID())) {
            return false;
        }
        if (this.myCopyID == null && fSID.getCopyID() != null) {
            return false;
        }
        if (this.myTxnID != null && !this.myTxnID.equals(fSID.getTxnID())) {
            return false;
        }
        if (this.myTxnID == null && fSID.getTxnID() != null) {
            return false;
        }
        return this.myRevision == fSID.getRevision() && this.myOffset == fSID.getOffset();
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.myNodeID == null ? 0 : this.myNodeID.hashCode());
        n3 = 31 * n3 + (this.myCopyID == null ? 0 : this.myCopyID.hashCode());
        n3 = 31 * n3 + (this.myTxnID == null ? 0 : this.myTxnID.hashCode());
        n3 = 31 * n3 + (int)(this.myRevision ^ this.myRevision >>> 32);
        n3 = 31 * n3 + (int)(this.myOffset ^ this.myOffset >>> 32);
        return n3;
    }

    public int compareTo(FSID fSID) {
        if (fSID == null) {
            return -1;
        }
        if (fSID.equals(this)) {
            return 0;
        }
        return this.isRelated(fSID) ? 1 : -1;
    }

    public boolean isRelated(FSID fSID) {
        if (fSID == null) {
            return false;
        }
        if (this == fSID) {
            return true;
        }
        if (this.myNodeID != null && this.myNodeID.startsWith("_")) {
            if (this.myTxnID != null && !this.myTxnID.equals(fSID.getTxnID())) {
                return false;
            }
            if (this.myTxnID == null && fSID.getTxnID() != null) {
                return false;
            }
        }
        return this.myNodeID.equals(fSID.getNodeID());
    }

    public String toString() {
        return this.myNodeID + "." + this.myCopyID + "." + (this.isTxn() ? "t" + this.myTxnID : "r" + this.myRevision + "/" + this.myOffset);
    }

    public static FSID fromString(String string) {
        int n2 = string.indexOf(46);
        if (n2 == -1) {
            return null;
        }
        String string2 = string.substring(0, n2);
        if ((n2 = (string = string.substring(n2 + 1)).indexOf(46)) == -1) {
            return null;
        }
        String string3 = string.substring(0, n2);
        if ((string = string.substring(n2 + 1)).charAt(0) == 'r') {
            int n3 = string.indexOf(47);
            long l2 = -1L;
            long l3 = -1L;
            try {
                l2 = Long.parseLong(string.substring(1, n3));
                l3 = Long.parseLong(string.substring(n3 + 1));
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            return FSID.createRevId(string2, string3, l2, l3);
        }
        if (string.charAt(0) == 't') {
            String string4 = string.substring(1);
            return FSID.createTxnId(string2, string3, string4);
        }
        return null;
    }
}

