/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb$Mode;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSHotCopier$1;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.io.fs.FSWriteLock;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNLogType;

public class FSHotCopier {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runHotCopy(FSFS fSFS, File file) {
        FSWriteLock fSWriteLock = FSWriteLock.getDBLogsLock(fSFS, false);
        File file2 = fSFS.getRepositoryRoot();
        FSWriteLock fSWriteLock2 = fSWriteLock;
        synchronized (fSWriteLock2) {
            try {
                Object object;
                fSWriteLock.lock();
                this.createRepositoryLayout(file2, file);
                File file3 = new File(file, "locks");
                try {
                    this.createReposDir(file3);
                }
                catch (SVNException sVNException) {
                    object = sVNException.getErrorMessage().wrap("Creating lock dir");
                    SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
                }
                this.createDBLock(file3);
                this.createDBLogsLock(file3);
                File file4 = new File(file, "db");
                file4.mkdirs();
                SVNFileUtil.setSGID(file4);
                object = new FSFS(file);
                String string = fSFS.getFSType();
                this.hotCopy(fSFS, (FSFS)object);
                this.writeFSType((FSFS)object, string);
                SVNFileUtil.writeVersionFile(new File(file, "format"), fSFS.getReposFormat());
            }
            finally {
                fSWriteLock.unlock();
                FSWriteLock.release(fSWriteLock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFSType(FSFS fSFS, String string) {
        OutputStream outputStream = null;
        try {
            outputStream = SVNFileUtil.openFileForWriting(fSFS.getFSTypeFile());
            string = string + '\n';
            outputStream.write(string.getBytes("US-ASCII"));
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage());
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        finally {
            SVNFileUtil.closeFile(outputStream);
        }
    }

    private void createRepositoryLayout(File file, File file2) {
        File[] fileArray = file.listFiles();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            File file3 = fileArray[i2];
            String string = file3.getName();
            if (string.equals("db") || string.equals("locks") || string.equals("format")) continue;
            File file4 = new File(file2, string);
            if (file3.isDirectory()) {
                this.createReposDir(file4);
                this.createRepositoryLayout(file3, file4);
                continue;
            }
            if (!file3.isFile()) continue;
            SVNFileUtil.copyFile(file3, file4, true);
        }
    }

    private void createReposDir(File file) {
        if (file.exists()) {
            File[] fileArray = file.listFiles();
            if (fileArray.length > 0) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.DIR_NOT_EMPTY, "''{0}'' exists and is non-empty", (Object)file);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
        } else {
            file.mkdirs();
        }
    }

    private void createDBLock(File file) {
        try {
            SVNFileUtil.createFile(new File(file, "db.lock"), "This file is not used by Subversion 1.3.x or later.However, its existence is required for compatibility withSubversion 1.2.x or earlier.", "US-ASCII");
        }
        catch (SVNException sVNException) {
            SVNErrorMessage sVNErrorMessage = sVNException.getErrorMessage().wrap("Creating db lock file");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
    }

    private void createDBLogsLock(File file) {
        try {
            SVNFileUtil.createFile(new File(file, "db-logs.lock"), "This file is not used by Subversion 1.3.x or later.However, its existence is required for compatibility withSubversion 1.2.x or earlier.", "US-ASCII");
        }
        catch (SVNException sVNException) {
            SVNErrorMessage sVNErrorMessage = sVNException.getErrorMessage().wrap("Creating db logs lock file");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hotCopy(FSFS fSFS, FSFS fSFS2) {
        Object object;
        File file;
        File file2;
        long l2;
        int n2 = fSFS.readDBFormat();
        FSRepositoryUtil.checkReposDBFormat(n2);
        SVNFileUtil.copyFile(fSFS.getCurrentFile(), fSFS2.getCurrentFile(), true);
        SVNFileUtil.copyFile(fSFS.getUUIDFile(), fSFS2.getUUIDFile(), true);
        long l3 = 0L;
        if (n2 >= 4) {
            SVNFileUtil.copyFile(fSFS.getMinUnpackedRevFile(), fSFS2.getMinUnpackedRevFile(), true);
            l3 = fSFS.getMinUnpackedRev();
        }
        long l4 = fSFS2.getYoungestRevision();
        File file3 = fSFS2.getDBRevsDir();
        file3.mkdirs();
        long l5 = fSFS.getMaxFilesPerDirectory();
        for (l2 = 0L; l2 < l3; l2 += fSFS.getMaxFilesPerDirectory()) {
            long l6 = l2 / l5;
            SVNFileUtil.copyDirectory(fSFS.getPackDir(l6), fSFS2.getPackDir(l6), false, null);
        }
        SVNErrorManager.assertionFailure(l2 == l3, "expected minimal unpacked revision " + String.valueOf(l3) + ", but real revision is " + String.valueOf(l2), SVNLogType.FSFS);
        while (l2 <= l4) {
            File file4 = file3;
            if (l5 > 0L) {
                String string = String.valueOf(l2 / l5);
                file4 = new File(file3, string);
            }
            SVNFileUtil.copyFile(fSFS.getRevisionFile(l2), new File(file4, String.valueOf(l2)), true);
            ++l2;
        }
        long l7 = 0L;
        if (n2 >= 6) {
            l7 = fSFS.getMinUnpackedRevProp();
            SVNFileUtil.copyFile(fSFS.getMinUnpackedRevPropPath(), fSFS2.getMinUnpackedRevPropPath(), true);
            file2 = fSFS.getRevisionPropertiesDbPath();
            file = fSFS2.getRevisionPropertiesDbPath();
            object = SVNSqlJetDb.open(fSFS.getRevisionPropertiesDbPath(), SVNSqlJetDb$Mode.ReadWrite);
            try {
                SVNException sVNException = (SVNException)((SVNSqlJetDb)object).getDb().runReadTransaction(new FSHotCopier$1(this, file2, file));
                if (sVNException != null) {
                    throw sVNException;
                }
            }
            catch (SqlJetException sqlJetException) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.SQLITE_ERROR, sqlJetException);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
            finally {
                ((SVNSqlJetDb)object).close();
            }
        }
        file2 = fSFS2.getRevisionPropertiesRoot();
        for (l2 = l7; l2 <= l4; ++l2) {
            file = file2;
            if (l5 > 0L) {
                object = String.valueOf(l2 / l5);
                file = new File(file2, (String)object);
            }
            SVNFileUtil.copyFile(fSFS.getRevisionPropertiesFile(l2, false), new File(file, String.valueOf(l2)), true);
        }
        fSFS2.getTransactionsParentDir().mkdirs();
        if (n2 >= 3) {
            fSFS2.getTransactionProtoRevsDir().mkdirs();
        }
        if ((file = fSFS.getDBLocksDir()).exists()) {
            SVNFileUtil.copyDirectory(file, fSFS2.getDBLocksDir(), false, null);
        }
        if (((File)(object = fSFS.getNodeOriginsDir())).exists()) {
            SVNFileUtil.copyDirectory((File)object, fSFS2.getNodeOriginsDir(), false, null);
        }
        if (n2 >= 3) {
            SVNFileUtil.copyFile(fSFS.getTransactionCurrentFile(), fSFS2.getTransactionCurrentFile(), true);
        }
        fSFS2.writeDBFormat(n2, l5, false);
    }
}

