/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.internal.util.SVNStreamGobbler;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNLogType;

public class FSHooks {
    public static final String SVN_REPOS_HOOK_START_COMMIT = "start-commit";
    public static final String SVN_REPOS_HOOK_PRE_COMMIT = "pre-commit";
    public static final String SVN_REPOS_HOOK_POST_COMMIT = "post-commit";
    public static final String SVN_REPOS_HOOK_PRE_REVPROP_CHANGE = "pre-revprop-change";
    public static final String SVN_REPOS_HOOK_POST_REVPROP_CHANGE = "post-revprop-change";
    public static final String SVN_REPOS_HOOK_PRE_LOCK = "pre-lock";
    public static final String SVN_REPOS_HOOK_POST_LOCK = "post-lock";
    public static final String SVN_REPOS_HOOK_PRE_UNLOCK = "pre-unlock";
    public static final String SVN_REPOS_HOOK_POST_UNLOCK = "post-unlock";
    public static final String SVN_REPOS_HOOK_READ_SENTINEL = "read-sentinels";
    public static final String SVN_REPOS_HOOK_WRITE_SENTINEL = "write-sentinels";
    public static final String SVN_REPOS_HOOK_DESC_EXT = ".tmpl";
    public static final String SVN_REPOS_HOOKS_DIR = "hooks";
    public static final String REVPROP_DELETE = "D";
    public static final String REVPROP_ADD = "A";
    public static final String REVPROP_MODIFY = "M";
    private static final String[] winExtensions = new String[]{".exe", ".bat", ".cmd"};
    private static Boolean ourIsHooksEnabled;

    public static void setHooksEnabled(boolean bl2) {
        ourIsHooksEnabled = bl2 ? Boolean.TRUE : Boolean.FALSE;
    }

    public static boolean isHooksEnabled() {
        if (ourIsHooksEnabled == null) {
            ourIsHooksEnabled = Boolean.valueOf(System.getProperty("svnkit.hooksEnabled", System.getProperty("javasvn.hooksEnabled", "true")));
        }
        return ourIsHooksEnabled;
    }

    public static String runPreLockHook(File file, String string, String string2, String string3, boolean bl2) {
        string2 = string2 == null ? "" : string2;
        string = string == null ? "" : string;
        return FSHooks.runHook(file, SVN_REPOS_HOOK_PRE_LOCK, new String[]{string, string2, string3 != null ? string3 : "", bl2 ? "1" : "0"}, null);
    }

    public static void runPostLockHook(File file, String[] stringArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringBuffer.append(stringArray[i2]);
            stringBuffer.append("\n");
        }
        FSHooks.runLockHook(file, SVN_REPOS_HOOK_POST_LOCK, null, string, stringBuffer.toString());
    }

    public static void runPreUnlockHook(File file, String string, String string2) {
        FSHooks.runLockHook(file, SVN_REPOS_HOOK_PRE_UNLOCK, string, string2, null);
    }

    public static void runPostUnlockHook(File file, String[] stringArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringBuffer.append(stringArray[i2]);
            stringBuffer.append("\n");
        }
        FSHooks.runLockHook(file, SVN_REPOS_HOOK_POST_UNLOCK, null, string, stringBuffer.toString());
    }

    private static void runLockHook(File file, String string, String string2, String string3, String string4) {
        string3 = string3 == null ? "" : string3;
        string2 = string2 == null ? "" : string2;
        byte[] byArray = null;
        try {
            byArray = string4 == null ? null : string4.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string4.getBytes();
        }
        FSHooks.runHook(file, string, new String[]{string2, string3}, byArray);
    }

    public static void runPreRevPropChangeHook(File file, String string, byte[] byArray, String string2, long l2, String string3) {
        FSHooks.runChangeRevPropHook(file, SVN_REPOS_HOOK_PRE_REVPROP_CHANGE, string, byArray, string2, l2, string3, true);
    }

    public static void runPostRevPropChangeHook(File file, String string, byte[] byArray, String string2, long l2, String string3) {
        FSHooks.runChangeRevPropHook(file, SVN_REPOS_HOOK_POST_REVPROP_CHANGE, string, byArray, string2, l2, string3, false);
    }

    private static void runChangeRevPropHook(File file, String string, String string2, byte[] byArray, String string3, long l2, String string4, boolean bl2) {
        File file2 = FSHooks.getHookFile(file, string);
        if (file2 == null) {
            if (bl2) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.REPOS_DISABLED_FEATURE, "Repository has not been enabled to accept revision propchanges;\nask the administrator to create a pre-revprop-change hook");
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
            return;
        }
        string3 = string3 == null ? "" : string3;
        FSHooks.runHook(file, string, new String[]{String.valueOf(l2), string3, string2, string4}, byArray);
    }

    public static void runStartCommitHook(File file, String string, List list) {
        String[] stringArray;
        string = string == null ? "" : string;
        String string2 = FSHooks.getCapabilitiesAsString(list);
        if (string2 == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = string;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = string;
            stringArray = stringArray3;
            stringArray3[1] = string2;
        }
        String[] stringArray4 = stringArray;
        FSHooks.runHook(file, SVN_REPOS_HOOK_START_COMMIT, stringArray4, null);
    }

    public static void runPreCommitHook(File file, String string) {
        FSHooks.runHook(file, SVN_REPOS_HOOK_PRE_COMMIT, new String[]{string}, null);
    }

    public static void runPostCommitHook(File file, long l2) {
        FSHooks.runHook(file, SVN_REPOS_HOOK_POST_COMMIT, new String[]{String.valueOf(l2)}, null);
    }

    private static String runHook(File file, String string, String[] stringArray, byte[] byArray) {
        int n2;
        String[] stringArray2;
        File file2 = FSHooks.getHookFile(file, string);
        if (file2 == null) {
            return null;
        }
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        Process process = null;
        String string2 = file.getAbsolutePath().replace(File.separatorChar, '/');
        String string3 = file2.getName().toLowerCase();
        boolean bl2 = (string3.endsWith(".bat") || string3.endsWith(".cmd")) && SVNFileUtil.isWindows;
        String[] stringArray3 = stringArray2 = bl2 ? new String[4 + stringArray.length] : new String[2 + stringArray.length];
        if (bl2) {
            stringArray2 = new String[]{"cmd", "/C", ""};
            stringArray2[2] = "\"\"" + file2.getAbsolutePath() + "\" \"" + string2 + "\"";
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                stringArray2[2] = stringArray2[2] + " \"" + stringArray[n2] + "\"";
            }
            stringArray2[2] = stringArray2[2] + "\"";
        } else {
            n2 = 0;
            if (bl2) {
                stringArray2[0] = "cmd";
                stringArray2[1] = "/C";
                n2 = 2;
            }
            stringArray2[n2] = file2.getAbsolutePath();
            stringArray2[++n2] = string2;
            ++n2;
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                stringArray2[n2 + i2] = stringArray[i2];
            }
        }
        try {
            process = Runtime.getRuntime().exec(stringArray2);
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.REPOS_HOOK_FAILURE, "Failed to start ''{0}'' hook: {1}", file2, iOException.getLocalizedMessage());
            SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.FSFS);
        }
        return FSHooks.feedHook(file2, string, process, byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String feedHook(File file, String string, Process process, byte[] byArray) {
        SVNErrorMessage sVNErrorMessage;
        String string2;
        Object object;
        Object object2;
        if (process == null) {
            object2 = SVNErrorMessage.create(SVNErrorCode.REPOS_HOOK_FAILURE, "Failed to start ''{0}'' hook", (Object)file);
            SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.FSFS);
        }
        object2 = new SVNStreamGobbler(process.getInputStream());
        SVNStreamGobbler sVNStreamGobbler = new SVNStreamGobbler(process.getErrorStream());
        ((Thread)object2).start();
        sVNStreamGobbler.start();
        if (byArray != null) {
            OutputStream outputStream = process.getOutputStream();
            try {
                for (int i2 = 0; i2 < byArray.length; i2 += 1024) {
                    outputStream.write(byArray, i2, Math.min(1024, byArray.length - i2));
                    outputStream.flush();
                }
            }
            catch (IOException iOException) {
            }
            finally {
                SVNFileUtil.closeFile(outputStream);
            }
        }
        int n2 = -1;
        try {
            ((SVNStreamGobbler)object2).waitFor();
            sVNStreamGobbler.waitFor();
            n2 = process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            object = SVNErrorMessage.create(SVNErrorCode.REPOS_HOOK_FAILURE, "Failed to start ''{0}'' hook: {1}", file, interruptedException.getLocalizedMessage());
            SVNErrorManager.error((SVNErrorMessage)object, interruptedException, SVNLogType.FSFS);
        }
        finally {
            sVNStreamGobbler.close();
            ((SVNStreamGobbler)object2).close();
            process.destroy();
        }
        if (n2 == 0) {
            if (sVNStreamGobbler.getError() != null) {
                SVNErrorMessage sVNErrorMessage2 = SVNErrorMessage.create(SVNErrorCode.REPOS_HOOK_FAILURE, "''{0}'' hook succeeded, but error output could not be read", (Object)string);
                SVNErrorManager.error(sVNErrorMessage2, sVNStreamGobbler.getError(), SVNLogType.FSFS);
            }
            return ((SVNStreamGobbler)object2).getResult();
        }
        String string3 = null;
        if (SVN_REPOS_HOOK_START_COMMIT.equals(string) || SVN_REPOS_HOOK_PRE_COMMIT.equals(string)) {
            string3 = "Commit";
        } else if (SVN_REPOS_HOOK_PRE_REVPROP_CHANGE.equals(string)) {
            string3 = "Revprop change";
        } else if (SVN_REPOS_HOOK_PRE_LOCK.equals(string)) {
            string3 = "Lock";
        } else if (SVN_REPOS_HOOK_PRE_UNLOCK.equals(string)) {
            string3 = "Unlock";
        }
        object = sVNStreamGobbler.getError() != null ? "[Error output could not be read.]" : sVNStreamGobbler.getResult();
        String string4 = string2 = string3 != null ? string3 + " blocked by {0} hook (exit code {1})" : "{0} hook failed (exit code {1})";
        if (object != null && ((String)object).length() > 0) {
            string2 = string2 + " with output:\n{2}";
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.REPOS_HOOK_FAILURE, string2, string, n2, object);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        } else {
            string2 = string2 + " with no output.";
        }
        sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.REPOS_HOOK_FAILURE, string2, new Object[]{string, n2});
        SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        return null;
    }

    private static File getHookFile(File file, String string) {
        if (!FSHooks.isHooksEnabled()) {
            return null;
        }
        File file2 = null;
        if (SVNFileUtil.isWindows) {
            for (int i2 = 0; i2 < winExtensions.length; ++i2) {
                file2 = new File(FSHooks.getHooksDir(file), string + winExtensions[i2]);
                SVNFileType sVNFileType = SVNFileType.getType(file2);
                if (sVNFileType != SVNFileType.FILE) continue;
                return file2;
            }
        } else {
            file2 = new File(FSHooks.getHooksDir(file), string);
            SVNFileType sVNFileType = SVNFileType.getType(file2);
            if (sVNFileType == SVNFileType.FILE) {
                return file2;
            }
            if (sVNFileType == SVNFileType.SYMLINK) {
                File file3 = SVNFileUtil.resolveSymlinkToFile(file2);
                if (file3 == null) {
                    SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.REPOS_HOOK_FAILURE, "Failed to run ''{0}'' hook; broken symlink", (Object)file2);
                    SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
                }
                return file2;
            }
        }
        return null;
    }

    private static File getHooksDir(File file) {
        return new File(file, SVN_REPOS_HOOKS_DIR);
    }

    private static String getCapabilitiesAsString(List list) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Object e2 = list.get(i2);
            stringBuffer.append(e2);
            if (i2 >= list.size() - 1) continue;
            stringBuffer.append(":");
        }
        return stringBuffer.toString();
    }
}

