/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNMergeInfo;
import org.tmatesoft.svn.core.SVNMergeInfoInheritance;
import org.tmatesoft.svn.core.SVNMergeRange;
import org.tmatesoft.svn.core.SVNMergeRangeList;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaCombiner;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSFileRevisionsFinder$1;
import org.tmatesoft.svn.core.internal.io.fs.FSFileRevisionsFinder$SendBaton;
import org.tmatesoft.svn.core.internal.io.fs.FSInputStream;
import org.tmatesoft.svn.core.internal.io.fs.FSNodeHistory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNMergeInfoUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNMergeInfoManager;
import org.tmatesoft.svn.core.io.ISVNFileRevisionHandler;
import org.tmatesoft.svn.core.io.SVNFileRevision;
import org.tmatesoft.svn.core.io.SVNLocationEntry;
import org.tmatesoft.svn.core.io.diff.SVNDeltaGenerator;
import org.tmatesoft.svn.util.SVNLogType;

public class FSFileRevisionsFinder {
    private FSFS myFSFS;
    private SVNDeltaGenerator myDeltaGenerator;

    public FSFileRevisionsFinder(FSFS fSFS) {
        this.myFSFS = fSFS;
    }

    public int getFileRevisions(String string, long l2, long l3, boolean bl2, ISVNFileRevisionHandler iSVNFileRevisionHandler) {
        SVNLocationEntry sVNLocationEntry;
        SVNHashMap sVNHashMap = new SVNHashMap();
        LinkedList linkedList = this.findInterestingRevisions(null, string, l2, l3, bl2, false, sVNHashMap);
        LinkedList linkedList2 = null;
        linkedList2 = bl2 ? this.findMergedRevisions(linkedList, sVNHashMap) : new LinkedList();
        SVNErrorManager.assertionFailure(!linkedList.isEmpty(), "no main line path revisions found", SVNLogType.FSFS);
        FSFileRevisionsFinder$SendBaton fSFileRevisionsFinder$SendBaton = new FSFileRevisionsFinder$SendBaton(null);
        FSFileRevisionsFinder$SendBaton.access$102(fSFileRevisionsFinder$SendBaton, new SVNProperties());
        int n2 = linkedList.size() - 1;
        int n3 = linkedList2.size() - 1;
        int n4 = 0;
        while (n2 >= 0 && n3 >= 0) {
            sVNLocationEntry = (SVNLocationEntry)linkedList.get(n2);
            SVNLocationEntry sVNLocationEntry2 = (SVNLocationEntry)linkedList2.get(n3);
            if (sVNLocationEntry.getRevision() <= sVNLocationEntry2.getRevision()) {
                this.sendPathRevision(sVNLocationEntry, fSFileRevisionsFinder$SendBaton, iSVNFileRevisionHandler);
                --n2;
            } else {
                this.sendPathRevision(sVNLocationEntry2, fSFileRevisionsFinder$SendBaton, iSVNFileRevisionHandler);
                --n3;
            }
            ++n4;
        }
        while (n2 >= 0) {
            sVNLocationEntry = (SVNLocationEntry)linkedList.get(n2);
            this.sendPathRevision(sVNLocationEntry, fSFileRevisionsFinder$SendBaton, iSVNFileRevisionHandler);
            ++n4;
            --n2;
        }
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPathRevision(SVNLocationEntry sVNLocationEntry, FSFileRevisionsFinder$SendBaton fSFileRevisionsFinder$SendBaton, ISVNFileRevisionHandler iSVNFileRevisionHandler) {
        SVNProperties sVNProperties;
        FSRevisionRoot fSRevisionRoot;
        block2: {
            block3: {
                SVNProperties sVNProperties2 = this.myFSFS.getRevisionProperties(sVNLocationEntry.getRevision());
                fSRevisionRoot = this.myFSFS.createRevisionRoot(sVNLocationEntry.getRevision());
                FSRevisionNode fSRevisionNode = fSRevisionRoot.getRevisionNode(sVNLocationEntry.getPath());
                sVNProperties = fSRevisionNode.getProperties(this.myFSFS);
                SVNProperties sVNProperties3 = FSRepositoryUtil.getPropsDiffs(FSFileRevisionsFinder$SendBaton.access$100(fSFileRevisionsFinder$SendBaton), sVNProperties);
                boolean bl2 = false;
                bl2 = FSFileRevisionsFinder$SendBaton.access$200(fSFileRevisionsFinder$SendBaton) != null ? FSRepositoryUtil.areFileContentsChanged(FSFileRevisionsFinder$SendBaton.access$200(fSFileRevisionsFinder$SendBaton), FSFileRevisionsFinder$SendBaton.access$300(fSFileRevisionsFinder$SendBaton), fSRevisionRoot, sVNLocationEntry.getPath()) : true;
                if (iSVNFileRevisionHandler == null) break block2;
                iSVNFileRevisionHandler.openRevision(new SVNFileRevision(sVNLocationEntry.getPath(), sVNLocationEntry.getRevision(), sVNProperties2, sVNProperties3, sVNLocationEntry.isResultOfMerge()));
                if (!bl2) break block3;
                SVNDeltaCombiner sVNDeltaCombiner = new SVNDeltaCombiner();
                SVNDeltaCombiner sVNDeltaCombiner2 = new SVNDeltaCombiner();
                iSVNFileRevisionHandler.applyTextDelta(sVNLocationEntry.getPath(), null);
                InputStream inputStream = null;
                InputStream inputStream2 = null;
                try {
                    inputStream = FSFileRevisionsFinder$SendBaton.access$200(fSFileRevisionsFinder$SendBaton) != null && FSFileRevisionsFinder$SendBaton.access$300(fSFileRevisionsFinder$SendBaton) != null ? FSFileRevisionsFinder$SendBaton.access$200(fSFileRevisionsFinder$SendBaton).getFileStreamForPath(sVNDeltaCombiner, FSFileRevisionsFinder$SendBaton.access$300(fSFileRevisionsFinder$SendBaton)) : FSInputStream.createDeltaStream(sVNDeltaCombiner, (FSRevisionNode)null, this.myFSFS);
                    inputStream2 = fSRevisionRoot.getFileStreamForPath(sVNDeltaCombiner2, sVNLocationEntry.getPath());
                    SVNDeltaGenerator sVNDeltaGenerator = this.getDeltaGenerator();
                    sVNDeltaGenerator.sendDelta(sVNLocationEntry.getPath(), inputStream, 0L, inputStream2, iSVNFileRevisionHandler, false);
                }
                catch (Throwable throwable) {
                    SVNFileUtil.closeFile(inputStream);
                    SVNFileUtil.closeFile(inputStream2);
                    throw throwable;
                }
                SVNFileUtil.closeFile(inputStream);
                SVNFileUtil.closeFile(inputStream2);
                iSVNFileRevisionHandler.closeRevision(sVNLocationEntry.getPath());
                break block2;
            }
            iSVNFileRevisionHandler.closeRevision(sVNLocationEntry.getPath());
        }
        FSFileRevisionsFinder$SendBaton.access$202(fSFileRevisionsFinder$SendBaton, fSRevisionRoot);
        FSFileRevisionsFinder$SendBaton.access$302(fSFileRevisionsFinder$SendBaton, sVNLocationEntry.getPath());
        FSFileRevisionsFinder$SendBaton.access$102(fSFileRevisionsFinder$SendBaton, sVNProperties);
    }

    private SVNDeltaGenerator getDeltaGenerator() {
        if (this.myDeltaGenerator == null) {
            this.myDeltaGenerator = new SVNDeltaGenerator();
        }
        return this.myDeltaGenerator;
    }

    private LinkedList findMergedRevisions(LinkedList linkedList, Map map) {
        LinkedList linkedList2 = new LinkedList();
        LinkedList linkedList3 = linkedList;
        LinkedList linkedList4 = null;
        do {
            linkedList4 = new LinkedList();
            for (SVNLocationEntry sVNLocationEntry : linkedList3) {
                Map map2 = sVNLocationEntry.getMergedMergeInfo();
                if (map2 == null) continue;
                for (String string : map2.keySet()) {
                    SVNMergeRangeList sVNMergeRangeList = (SVNMergeRangeList)map2.get(string);
                    SVNMergeRange[] sVNMergeRangeArray = sVNMergeRangeList.getRanges();
                    for (int i2 = 0; i2 < sVNMergeRangeArray.length; ++i2) {
                        SVNMergeRange sVNMergeRange = sVNMergeRangeArray[i2];
                        FSRevisionRoot fSRevisionRoot = this.myFSFS.createRevisionRoot(sVNMergeRange.getEndRevision());
                        SVNNodeKind sVNNodeKind = fSRevisionRoot.checkNodeKind(string);
                        if (sVNNodeKind != SVNNodeKind.FILE) continue;
                        linkedList4 = this.findInterestingRevisions(linkedList4, string, sVNMergeRange.getStartRevision(), sVNMergeRange.getEndRevision(), true, true, map);
                    }
                }
            }
            linkedList2.addAll(linkedList4);
            linkedList3 = linkedList4;
        } while (!linkedList4.isEmpty());
        Collections.sort(linkedList2, new FSFileRevisionsFinder$1(this));
        return linkedList2;
    }

    private LinkedList findInterestingRevisions(LinkedList linkedList, String string, long l2, long l3, boolean bl2, boolean bl3, Map map) {
        Object object;
        FSRevisionRoot fSRevisionRoot = this.myFSFS.createRevisionRoot(l3);
        if (fSRevisionRoot.checkNodeKind(string) != SVNNodeKind.FILE) {
            object = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FILE, "''{0}'' is not a file in revision ''{1}''", string, l3);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        linkedList = linkedList == null ? new LinkedList() : linkedList;
        object = fSRevisionRoot.getNodeHistory(string);
        while ((object = ((FSNodeHistory)object).getPreviousHistory(true)) != null) {
            long l4 = ((FSNodeHistory)object).getHistoryEntry().getRevision();
            String string2 = ((FSNodeHistory)object).getHistoryEntry().getPath();
            if (bl2 && map.containsKey(string2 + ":" + l4)) break;
            SVNLocationEntry sVNLocationEntry = null;
            Map map2 = null;
            if (bl2) {
                map2 = this.getMergedMergeInfo(string2, l4);
                sVNLocationEntry = new SVNLocationEntry(l4, string2, bl3, map2);
                map.put(string2 + ":" + l4, sVNLocationEntry);
            } else {
                sVNLocationEntry = new SVNLocationEntry(l4, string2, bl3, null);
            }
            linkedList.addLast(sVNLocationEntry);
            if (l4 > l2) continue;
            break;
        }
        return linkedList;
    }

    private Map getMergedMergeInfo(String string, long l2) {
        Map map = this.getPathMergeInfo(string, l2);
        TreeMap treeMap = null;
        try {
            treeMap = this.getPathMergeInfo(string, l2 - 1L);
        }
        catch (SVNException sVNException) {
            if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.FS_NOT_FOUND) {
                treeMap = new TreeMap();
            }
            throw sVNException;
        }
        TreeMap treeMap2 = new TreeMap();
        Map map2 = new TreeMap();
        SVNMergeInfoUtil.diffMergeInfo(treeMap2, map2, treeMap, map, false);
        map2 = SVNMergeInfoUtil.mergeMergeInfos(map2, treeMap2);
        return map2;
    }

    public Map getPathMergeInfo(String string, long l2) {
        SVNMergeInfoManager sVNMergeInfoManager = new SVNMergeInfoManager();
        FSRevisionRoot fSRevisionRoot = this.myFSFS.createRevisionRoot(l2);
        Map map = sVNMergeInfoManager.getMergeInfo(new String[]{string}, fSRevisionRoot, SVNMergeInfoInheritance.INHERITED, false);
        SVNMergeInfo sVNMergeInfo = (SVNMergeInfo)map.get(string);
        if (sVNMergeInfo != null) {
            return sVNMergeInfo.getMergeSourcesToMergeLists();
        }
        return new TreeMap();
    }
}

