/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.MalformedInputException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.logging.Level;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.io.fs.PathInfo;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class FSFile {
    private File myFile;
    private final byte[] myData;
    private int myOffset;
    private int myLength;
    private FileChannel myChannel;
    private InputStream myInputStream;
    private long myPosition;
    private long myBufferPosition;
    private ByteBuffer myBuffer;
    private ByteBuffer myReadLineBuffer;
    private CharsetDecoder myDecoder;
    private MessageDigest myDigest;
    private long myL2POffset;
    private long myP2LOffset;
    private String myL2PChecksum;
    private String myP2LChecksum;
    private long myFooterOffset;

    public FSFile(File file) {
        this.myFile = file;
        this.myData = null;
        this.myPosition = 0L;
        this.myBufferPosition = 0L;
        this.myBuffer = ByteBuffer.allocate(1024);
        this.myReadLineBuffer = ByteBuffer.allocate(1024);
        this.myDecoder = Charset.forName("UTF-8").newDecoder();
        this.myDecoder = this.myDecoder.onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        this.myL2POffset = -1L;
        this.myP2LOffset = -1L;
    }

    public FSFile(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public FSFile(byte[] byArray, int n2, int n3) {
        this.myFile = null;
        this.myData = byArray;
        this.myOffset = n2;
        this.myLength = n3;
        this.myPosition = 0L;
        this.myBufferPosition = 0L;
        this.myBuffer = ByteBuffer.allocate(1024);
        this.myReadLineBuffer = ByteBuffer.allocate(1024);
        this.myDecoder = Charset.forName("UTF-8").newDecoder();
        this.myDecoder = this.myDecoder.onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        this.myL2POffset = -1L;
        this.myP2LOffset = -1L;
    }

    public void seek(long l2) {
        this.myPosition = l2;
    }

    public long position() {
        return this.myPosition;
    }

    public long size() {
        return this.myData == null ? this.myFile.length() : (long)this.myLength;
    }

    public void resetDigest() {
        if (this.myDigest == null) {
            try {
                this.myDigest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        this.myDigest.reset();
    }

    public String digest() {
        String string = SVNFileUtil.toHexDigest(this.myDigest);
        this.myDigest = null;
        return string;
    }

    public int readInt() {
        String string = this.readLine(80);
        if (string == null) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.BAD_VERSION_FILE_FORMAT, "First line of ''{0}'' contains non-digit", (Object)this.myFile);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
        return Integer.parseInt(string);
    }

    public long readLong() {
        String string = this.readLine(80);
        if (string == null) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.BAD_VERSION_FILE_FORMAT, "First line of ''{0}'' contains non-digit", (Object)this.myFile);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
        return Long.parseLong(string);
    }

    public String readLine(int n2) {
        long l2 = n2 < 0 ? 1024L : (long)n2;
        this.allocateReadBuffer((int)l2);
        try {
            while (this.myReadLineBuffer.hasRemaining()) {
                Object object;
                int n3 = this.read();
                if (n3 < 0) {
                    object = SVNErrorMessage.create(SVNErrorCode.STREAM_UNEXPECTED_EOF, "Can''t read length line from file {0}", (Object)this.getFile());
                    SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.DEFAULT);
                } else if (n3 == 10) break;
                this.myReadLineBuffer.put((byte)(n3 & 0xFF));
                if (n2 >= 0 || this.myReadLineBuffer.hasRemaining()) continue;
                object = this.myReadLineBuffer.array();
                int n4 = (int)l2;
                this.allocateReadBuffer((int)(l2 *= 2L));
                this.myReadLineBuffer.put((byte[])object, 0, n4);
            }
            this.myReadLineBuffer.flip();
            return this.myDecoder.decode(this.myReadLineBuffer).toString();
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Can''t read length line from file {0}: {1}", this.getFile(), iOException.getLocalizedMessage());
            SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.DEFAULT);
            return null;
        }
    }

    public String readLine(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer();
        }
        boolean bl2 = false;
        boolean bl3 = true;
        try {
            while (!bl2) {
                this.allocateReadBuffer(160);
                while (this.myReadLineBuffer.hasRemaining()) {
                    int n2 = this.read();
                    if (n2 < 0) {
                        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.STREAM_UNEXPECTED_EOF, "Can''t read length line from file {0}", (Object)this.getFile());
                        SVNErrorManager.error(sVNErrorMessage, bl3 ? Level.FINEST : Level.FINE, SVNLogType.DEFAULT);
                    } else if (n2 == 10) {
                        bl2 = true;
                        break;
                    }
                    this.myReadLineBuffer.put((byte)(n2 & 0xFF));
                    bl3 = false;
                }
                this.myReadLineBuffer.flip();
                stringBuffer.append(this.myDecoder.decode(this.myReadLineBuffer).toString());
            }
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Can''t read length line from file {0}: {1}", this.getFile(), iOException.getLocalizedMessage());
            SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.DEFAULT);
        }
        return stringBuffer.toString();
    }

    public SVNProperties readProperties(boolean bl2, boolean bl3) {
        SVNProperties sVNProperties = new SVNProperties();
        String string = null;
        block12: while (true) {
            try {
                while (true) {
                    Object object;
                    SVNErrorMessage sVNErrorMessage;
                    SVNErrorMessage sVNErrorMessage2;
                    try {
                        string = this.readLine(160);
                    }
                    catch (SVNException sVNException) {
                        if (bl2 && sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.STREAM_UNEXPECTED_EOF) break block12;
                        SVNErrorMessage sVNErrorMessage3 = SVNErrorMessage.create(SVNErrorCode.MALFORMED_FILE);
                        SVNErrorManager.error(sVNErrorMessage3, sVNException, SVNLogType.DEFAULT);
                    }
                    if (string == null || "".equals(string) || !bl2 && "END".equals(string)) break block12;
                    char c2 = string.charAt(0);
                    int n2 = -1;
                    if (c2 != 'K' && c2 != 'D' || string.length() < 3 || string.charAt(1) != ' ' || string.length() < 3) {
                        sVNErrorMessage2 = SVNErrorMessage.create(SVNErrorCode.MALFORMED_FILE);
                        SVNErrorManager.error(sVNErrorMessage2, SVNLogType.DEFAULT);
                    }
                    try {
                        n2 = Integer.parseInt(string.substring(2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        SVNErrorMessage sVNErrorMessage4 = SVNErrorMessage.create(SVNErrorCode.MALFORMED_FILE);
                        SVNErrorManager.error(sVNErrorMessage4, SVNLogType.DEFAULT);
                    }
                    if (n2 < 0) {
                        sVNErrorMessage2 = SVNErrorMessage.create(SVNErrorCode.MALFORMED_FILE);
                        SVNErrorManager.error(sVNErrorMessage2, SVNLogType.DEFAULT);
                    }
                    this.allocateReadBuffer(n2 + 1);
                    this.read(this.myReadLineBuffer);
                    this.myReadLineBuffer.flip();
                    this.myReadLineBuffer.limit(this.myReadLineBuffer.limit() - 1);
                    int n3 = this.myReadLineBuffer.position();
                    int n4 = this.myReadLineBuffer.limit();
                    String string2 = null;
                    try {
                        string2 = this.myDecoder.decode(this.myReadLineBuffer).toString();
                    }
                    catch (MalformedInputException malformedInputException) {
                        string2 = new String(this.myReadLineBuffer.array(), this.myReadLineBuffer.arrayOffset() + n3, n4 - n3);
                    }
                    if (c2 == 'D') {
                        sVNProperties.put(string2, (SVNPropertyValue)null);
                        continue;
                    }
                    string = this.readLine(160);
                    if (string == null || string.length() < 3 || string.charAt(0) != 'V' || string.charAt(1) != ' ') {
                        sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.MALFORMED_FILE);
                        SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
                    }
                    try {
                        n2 = Integer.parseInt(string.substring(2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        object = SVNErrorMessage.create(SVNErrorCode.MALFORMED_FILE);
                        SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.DEFAULT);
                    }
                    if (n2 < 0) {
                        sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.MALFORMED_FILE);
                        SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
                    }
                    this.allocateReadBuffer(n2 + 1);
                    this.read(this.myReadLineBuffer);
                    this.myReadLineBuffer.flip();
                    this.myReadLineBuffer.limit(this.myReadLineBuffer.limit() - 1);
                    n3 = this.myReadLineBuffer.position();
                    n4 = this.myReadLineBuffer.limit();
                    try {
                        sVNProperties.put(string2, this.myDecoder.decode(this.myReadLineBuffer).toString());
                        continue block12;
                    }
                    catch (CharacterCodingException characterCodingException) {
                        if (bl3) {
                            object = new byte[n4 - n3];
                            this.myReadLineBuffer.position(n3);
                            this.myReadLineBuffer.get((byte[])object);
                            sVNProperties.put(string2, (byte[])object);
                            continue;
                        }
                        object = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "File ''{0}'' contains unexpected binary property value", (Object)this.getFile());
                        SVNErrorManager.error((SVNErrorMessage)object, characterCodingException, SVNLogType.DEFAULT);
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.MALFORMED_FILE);
                SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.DEFAULT);
                break;
            }
        }
        return sVNProperties;
    }

    public Map readHeader() {
        String string;
        SVNHashMap sVNHashMap = new SVNHashMap();
        while (!"".equals(string = this.readLine(-1))) {
            Object object;
            int n2 = string.indexOf(58);
            if (n2 <= 0 || string.length() <= n2 + 2) {
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, string);
                object = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Found malformed header in revision file");
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.DEFAULT);
            } else if (string.charAt(n2 + 1) != ' ') {
                object = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Found malformed header in revision file");
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.DEFAULT);
            }
            object = string.substring(0, n2);
            String string2 = string.substring(n2 + 2);
            sVNHashMap.put(object, string2);
        }
        return sVNHashMap;
    }

    public void ensureFooterLoaded() {
        try {
            if (this.myL2POffset == -1L) {
                Object object;
                long l2 = this.size();
                this.seek(l2 - 1L);
                int n2 = this.read() & 0xFF;
                long l3 = l2 - 1L - (long)n2;
                if (l3 < 0L || l3 >= l2) {
                    object = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Invalid footer size {0}", (Object)String.valueOf(n2));
                    SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
                }
                this.seek(l3);
                object = new byte[n2];
                int n3 = this.read((byte[])object, 0, ((Object)object).length);
                assert (n3 == ((Object)object).length);
                this.parseFooter(new String((byte[])object));
                this.myFooterOffset = l3;
            }
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
    }

    public int read() {
        if (this.myData != null) {
            if (this.myPosition >= (long)this.myLength) {
                return -1;
            }
            ++this.myPosition;
            if (this.myDigest != null) {
                this.myDigest.update((byte)(this.myData[(int)((long)this.myOffset + this.myPosition - 1L)] & 0xFF));
            }
            return this.myData[(int)((long)this.myOffset + this.myPosition - 1L)] & 0xFF;
        }
        if (this.myChannel == null && this.myInputStream == null || this.myPosition < this.myBufferPosition || this.myPosition >= this.myBufferPosition + (long)this.myBuffer.limit()) {
            if (this.fill() <= 0) {
                return -1;
            }
        } else {
            this.myBuffer.position((int)(this.myPosition - this.myBufferPosition));
        }
        int n2 = this.myBuffer.get() & 0xFF;
        if (this.myDigest != null) {
            this.myDigest.update((byte)n2);
        }
        ++this.myPosition;
        return n2;
    }

    public int read(ByteBuffer byteBuffer) {
        if (this.myData != null) {
            int n2 = (int)Math.min((long)this.myLength - this.myPosition, (long)byteBuffer.remaining());
            byteBuffer.put(this.myData, (int)this.myPosition + this.myOffset, n2);
            if (this.myDigest != null) {
                this.myDigest.update(this.myData, (int)this.myPosition + this.myOffset, n2);
            }
            this.myPosition += (long)n2;
            return n2 > 0 ? n2 : -1;
        }
        int n3 = 0;
        while (byteBuffer.hasRemaining()) {
            if (this.fill() < 0) {
                return n3 > 0 ? n3 : -1;
            }
            this.myBuffer.position((int)(this.myPosition - this.myBufferPosition));
            int n4 = Math.min(this.myBuffer.remaining(), byteBuffer.remaining());
            int n5 = this.myBuffer.position() + this.myBuffer.arrayOffset();
            byteBuffer.put(this.myBuffer.array(), n5, n4);
            if (this.myDigest != null) {
                this.myDigest.update(this.myBuffer.array(), n5, n4);
            }
            this.myPosition += (long)n4;
            n3 += n4;
            this.myBuffer.position(this.myBuffer.position() + n4);
        }
        return n3;
    }

    public int read(byte[] byArray, int n2, int n3) {
        if (this.myData != null) {
            int n4 = (int)Math.min((long)this.myLength - this.myPosition, (long)n3);
            System.arraycopy(this.myData, (int)this.myPosition + this.myOffset, byArray, n2, n4);
            if (this.myDigest != null) {
                this.myDigest.update(this.myData, (int)this.myPosition + this.myOffset, n4);
            }
            this.myPosition += (long)n4;
            return n4 > 0 ? n4 : -1;
        }
        int n5 = 0;
        int n6 = n3;
        while (n6 > 0) {
            if (this.fill() < 0) {
                return n5 > 0 ? n5 : -1;
            }
            this.myBuffer.position((int)(this.myPosition - this.myBufferPosition));
            int n7 = Math.min(this.myBuffer.remaining(), n6);
            this.myBuffer.get(byArray, n2, n7);
            if (this.myDigest != null) {
                this.myDigest.update(byArray, n2, n7);
            }
            n6 -= n7;
            n2 += n7;
            this.myPosition += (long)n7;
            n5 += n7;
        }
        return n5;
    }

    public File getFile() {
        return this.myFile;
    }

    public void close() {
        if (this.myChannel != null) {
            try {
                this.myChannel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        SVNFileUtil.closeFile(this.myInputStream);
        this.myChannel = null;
        this.myInputStream = null;
        this.myPosition = 0L;
        this.myDigest = null;
    }

    private int fill() {
        if (this.myChannel == null && this.myInputStream == null || this.myPosition < this.myBufferPosition || this.myPosition >= this.myBufferPosition + (long)this.myBuffer.limit()) {
            this.myBufferPosition = this.myPosition;
            this.getChannel().position(this.myBufferPosition);
            this.myBuffer.clear();
            int n2 = this.getChannel().read(this.myBuffer);
            this.myBuffer.position(0);
            this.myBuffer.limit(n2 >= 0 ? n2 : 0);
            return n2;
        }
        return 0;
    }

    private void allocateReadBuffer(int n2) {
        if (n2 > this.myReadLineBuffer.capacity()) {
            this.myReadLineBuffer = ByteBuffer.allocate(n2 * 3 / 2);
        }
        this.myReadLineBuffer.clear();
        this.myReadLineBuffer.limit(n2);
    }

    private FileChannel getChannel() {
        if (this.myChannel == null) {
            FileInputStream fileInputStream = SVNFileUtil.createFileInputStream(this.myFile);
            this.myChannel = fileInputStream.getChannel();
            this.myInputStream = fileInputStream;
        }
        return this.myChannel;
    }

    public PathInfo readPathInfoFromReportFile() {
        Object object;
        int n2 = this.read();
        if (n2 == -1 || n2 == 45) {
            return null;
        }
        String string = this.readStringFromReportFile();
        String string2 = this.read() == 43 ? this.readStringFromReportFile() : null;
        long l2 = this.readRevisionFromReportFile();
        SVNDepth sVNDepth = SVNDepth.INFINITY;
        if (this.read() == 43) {
            int bl2 = this.read();
            switch (bl2) {
                case 88: {
                    sVNDepth = SVNDepth.EXCLUDE;
                    break;
                }
                case 69: {
                    sVNDepth = SVNDepth.EMPTY;
                    break;
                }
                case 70: {
                    sVNDepth = SVNDepth.FILES;
                    break;
                }
                case 77: {
                    sVNDepth = SVNDepth.IMMEDIATES;
                    break;
                }
                default: {
                    object = SVNErrorMessage.create(SVNErrorCode.REPOS_BAD_REVISION_REPORT, "Invalid depth ({0}) for path ''{1}''", bl2, string);
                    SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
                }
            }
        }
        boolean bl2 = this.read() == 43;
        object = this.read() == 43 ? this.readStringFromReportFile() : null;
        return new PathInfo(string, string2, (String)object, l2, sVNDepth, bl2);
    }

    private String readStringFromReportFile() {
        int n2 = this.readNumberFromReportFile();
        if (n2 == 0) {
            return "";
        }
        byte[] byArray = new byte[n2];
        this.read(byArray, 0, n2);
        return new String(byArray, "UTF-8");
    }

    private int readNumberFromReportFile() {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n2 = this.read()) != 58) {
            byteArrayOutputStream.write(n2);
        }
        return Integer.parseInt(new String(byteArrayOutputStream.toByteArray(), "UTF-8"), 10);
    }

    private long readRevisionFromReportFile() {
        if (this.read() == 43) {
            return this.readNumberFromReportFile();
        }
        return -1L;
    }

    private void parseFooter(String string) {
        String[] stringArray = string.split(" ");
        if (stringArray.length != 4) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Invalid revision footer");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        long l2 = -1L;
        try {
            l2 = Long.parseLong(stringArray[0]);
        }
        catch (NumberFormatException numberFormatException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Invalid revision footer");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        String string2 = stringArray[1];
        long l3 = -1L;
        try {
            l3 = Long.parseLong(stringArray[2]);
        }
        catch (NumberFormatException numberFormatException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Invalid revision footer");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        String string3 = stringArray[3];
        this.myL2POffset = l2;
        this.myP2LOffset = l3;
        this.myL2PChecksum = string2;
        this.myP2LChecksum = string3;
    }

    public long getL2POffset() {
        return this.myL2POffset;
    }

    public long getP2LOffset() {
        return this.myP2LOffset;
    }
}

