/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaCompression;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaReader;
import org.tmatesoft.svn.core.internal.io.fs.FSClosestCopy;
import org.tmatesoft.svn.core.internal.io.fs.FSEntry;
import org.tmatesoft.svn.core.internal.io.fs.FSErrors;
import org.tmatesoft.svn.core.internal.io.fs.FSFS$1;
import org.tmatesoft.svn.core.internal.io.fs.FSFile;
import org.tmatesoft.svn.core.internal.io.fs.FSHooks;
import org.tmatesoft.svn.core.internal.io.fs.FSID;
import org.tmatesoft.svn.core.internal.io.fs.FSLock;
import org.tmatesoft.svn.core.internal.io.fs.FSRepository;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.io.fs.FSRepresentation;
import org.tmatesoft.svn.core.internal.io.fs.FSRepresentationCacheUtil;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionInfo;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSWriteLock;
import org.tmatesoft.svn.core.internal.io.fs.IFSRepresentationCacheManager;
import org.tmatesoft.svn.core.internal.io.fs.index.FSL2PProtoIndex;
import org.tmatesoft.svn.core.internal.io.fs.index.FSLogicalAddressingIndex;
import org.tmatesoft.svn.core.internal.io.fs.revprop.SVNFSFSPackedRevProps;
import org.tmatesoft.svn.core.internal.io.fs.revprop.SVNFSFSPackedRevPropsManifest;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.SVNConfigFile;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileListUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNWCProperties;
import org.tmatesoft.svn.core.io.ISVNLockHandler;
import org.tmatesoft.svn.core.io.SVNLocationEntry;
import org.tmatesoft.svn.core.io.diff.SVNDeltaProcessor;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.util.SVNLogType;

public class FSFS {
    public static final String DB_DIR = "db";
    public static final String REVS_DIR = "revs";
    public static final String REPOS_FORMAT_FILE = "format";
    public static final String DB_FORMAT_FILE = "format";
    public static final String DB_LOGS_LOCK_FILE = "db-logs.lock";
    public static final String DB_LOCK_FILE = "db.lock";
    public static final String CURRENT_FILE = "current";
    public static final String UUID_FILE = "uuid";
    public static final String FS_TYPE_FILE = "fs-type";
    public static final String TXN_CURRENT_FILE = "txn-current";
    public static final String MIN_UNPACKED_REV_FILE = "min-unpacked-rev";
    public static final String TXN_CURRENT_LOCK_FILE = "txn-current-lock";
    public static final String REVISION_PROPERTIES_DIR = "revprops";
    public static final String WRITE_LOCK_FILE = "write-lock";
    public static final String LOCKS_DIR = "locks";
    public static final String DAV_DIR = "dav";
    public static final String TRANSACTIONS_DIR = "transactions";
    public static final String TRANSACTION_PROTOS_DIR = "txn-protorevs";
    public static final String NODE_ORIGINS_DIR = "node-origins";
    public static final String MANIFEST_FILE = "manifest";
    public static final String REP_CACHE_DB = "rep-cache.db";
    public static final String PACK_EXT = ".pack";
    public static final String PACK_KIND_PACK = "pack";
    public static final String PACK_KIND_MANIFEST = "manifest";
    public static final String ENABLE_REP_SHARING_OPTION = "enable-rep-sharing";
    public static final String REP_SHARING_SECTION = "rep-sharing";
    public static final String PACKED_REVPROPS_SECTION = "packed-revprops";
    public static final String COMPRESS_PACKED_REVPROPS_OPTION = "compress-packed-revprops";
    public static final String REVPROP_PACK_SIZE_OPTION = "revprop-pack-size";
    public static final String DELTIFICATION_SECTION = "deltification";
    public static final String COMPRESSION_OPTION = "compression";
    public static final String IO_SECTION = "io";
    public static final String BLOCK_SIZE_OPTION = "block-size";
    public static final String L2P_PAGE_SIZE_OPTION = "l2p-page-size";
    public static final String P2L_PAGE_SIZE_OPTION = "p2l-page-size";
    public static final String PATH_CONFIG = "fsfs.conf";
    public static final String TXN_PATH_EXT = ".txn";
    public static final String TXN_MERGEINFO_PATH = "mergeinfo";
    public static final String TXN_PATH_EXT_CHILDREN = ".children";
    public static final String PATH_PREFIX_NODE = "node.";
    public static final String TXN_PATH_EXT_PROPS = ".props";
    public static final String SVN_OPAQUE_LOCK_TOKEN = "opaquelocktoken:";
    public static final String TXN_PATH_REV = "rev";
    public static final String PATH_LOCK_KEY = "path";
    public static final String CHILDREN_LOCK_KEY = "children";
    public static final String TOKEN_LOCK_KEY = "token";
    public static final String OWNER_LOCK_KEY = "owner";
    public static final String IS_DAV_COMMENT_LOCK_KEY = "is_dav_comment";
    public static final String CREATION_DATE_LOCK_KEY = "creation_date";
    public static final String EXPIRATION_DATE_LOCK_KEY = "expiration_date";
    public static final String COMMENT_LOCK_KEY = "comment";
    public static final String PRE_12_COMPAT_UNNEEDED_FILE_CONTENTS = "This file is not used by Subversion 1.3.x or later.However, its existence is required for compatibility withSubversion 1.2.x or earlier.";
    public static final int DIGEST_SUBDIR_LEN = 3;
    public static final int REPOSITORY_FORMAT = 5;
    public static final int REPOSITORY_FORMAT_LEGACY = 3;
    public static final int DB_FORMAT_PRE_17 = 4;
    public static final int DB_FORMAT_PRE_10 = 7;
    public static final int DB_FORMAT = 8;
    public static final int DB_FORMAT_LOW = 1;
    public static final int MIN_SVNDIFF1_FORMAT = 2;
    public static final int LAYOUT_FORMAT_OPTION_MINIMAL_FORMAT = 3;
    public static final int MIN_CURRENT_TXN_FORMAT = 3;
    public static final int MIN_PROTOREVS_DIR_FORMAT = 3;
    public static final int MIN_NO_GLOBAL_IDS_FORMAT = 3;
    public static final int MIN_MERGE_INFO_FORMAT = 3;
    public static final int MIN_REP_SHARING_FORMAT = 4;
    public static final int MIN_PACKED_FORMAT = 4;
    public static final int MIN_KIND_IN_CHANGED_FORMAT = 4;
    public static final int MIN_PACKED_REVPROP_SQLITE_DEV_FORMAT = 5;
    public static final int MIN_PACKED_REVPROP_FORMAT = 6;
    public static final int MIN_LOG_ADDRESSING_MINIMAL_FORMAT = 7;
    public static final int MIN_MERGEINFO_IN_CHANGED_FORMAT = 7;
    public static final int MIN_INSTANCE_UUID_FORMAT = 7;
    public static final int MIN_SVNDIFF2_FORMAT = 8;
    public static final int MIN_REP_STRING_OPTIONAL_VALUES_FORMAT = 8;
    public static final int MIN_REP_CACHE_SCHEMA_V2_FORMAT = 8;
    public static final int MIN_COMPRESSION_FORMAT = 8;
    private static long DEFAULT_MAX_FILES_PER_DIRECTORY = 1000L;
    private static final String DB_TYPE = "fsfs";
    public static final String REVISION_PROPERTIES_DB = "revprops.db";
    public static final String REVISION_PROPERTIES_TABLE = "revprop";
    public static final String MIN_UNPACKED_REV = "min-unpacked-rev";
    public static final boolean DB_FORMAT_PRE_17_USE_AS_DEFAULT = true;
    private int myDBFormat;
    private int myReposFormat;
    private String myUUID;
    private String myFSType;
    private File myRepositoryRoot;
    private File myRevisionsRoot;
    private File myRevisionPropertiesRoot;
    private File myTransactionsRoot;
    private File myLocksRoot;
    private File myDBRoot;
    private File myWriteLockFile;
    private File myCurrentFile;
    private File myTransactionCurrentFile;
    private File myTransactionCurrentLockFile;
    private File myTransactionProtoRevsRoot;
    private File myNodeOriginsDir;
    private File myRepositoryFormatFile;
    private File myDBFormatFile;
    private File myUUIDFile;
    private File myFSTypeFile;
    private File myMinUnpackedRevFile;
    private File myRepositoryCacheFile;
    private long myMaxFilesPerDirectory;
    private long myYoungestRevisionCache;
    private long myMinUnpackedRevision;
    private boolean myUseLogAddressing;
    private SVNConfigFile myConfig;
    private IFSRepresentationCacheManager myReposCacheManager;
    private long myMinUnpackedRevProp;
    private boolean myIsHooksEnabled;
    private boolean myCompressPackedRevprops;
    private boolean myIsRepSharingAllowed;
    private long myRevpropPackSize;
    private long myBlockSize;
    private long myL2PPageSize;
    private long myP2LPageSize;
    private SVNDeltaCompression myDeltaCompression;

    public static int getRepCacheSchemaFormat(int n2) {
        return n2 < 8 ? 1 : 2;
    }

    public FSFS(File file) {
        this.myRepositoryRoot = file;
        this.myMaxFilesPerDirectory = 0L;
        this.setHooksEnabled(true);
    }

    public void setHooksEnabled(boolean bl2) {
        this.myIsHooksEnabled = bl2;
    }

    public boolean isHooksEnabled() {
        return this.myIsHooksEnabled;
    }

    public int getDBFormat() {
        return this.myDBFormat;
    }

    public long getMaxFilesPerDirectory() {
        return this.myMaxFilesPerDirectory;
    }

    public int getReposFormat() {
        return this.myReposFormat;
    }

    public boolean isUseLogAddressing() {
        return this.myUseLogAddressing;
    }

    public SVNDeltaCompression getDeltaCompression() {
        return this.myDeltaCompression;
    }

    @Deprecated
    public String getDeltificationCompressionAlgorithm() {
        return this.myDeltaCompression.toString().toLowerCase(Locale.ENGLISH);
    }

    public void open() {
        this.openRoot();
        this.openDB();
    }

    public void close() {
        if (this.myReposCacheManager != null) {
            this.myReposCacheManager.close();
            this.myReposCacheManager = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openForRecovery() {
        FSWriteLock fSWriteLock;
        this.openRoot();
        FSWriteLock fSWriteLock2 = fSWriteLock = FSWriteLock.getWriteLockForDB(this);
        synchronized (fSWriteLock2) {
            try {
                fSWriteLock.lock();
                try {
                    SVNFileUtil.createFile(this.getCurrentFile(), "0 1 1\n", "US-ASCII");
                }
                catch (SVNException sVNException) {
                    // empty catch block
                }
            }
            finally {
                fSWriteLock.unlock();
                FSWriteLock.release(fSWriteLock);
            }
        }
        this.openDB();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openRoot() {
        int n2 = -1;
        try (FSFile fSFile = new FSFile(this.getRepositoryFormatFile());){
            n2 = fSFile.readInt();
        }
        if (n2 != 5 && n2 != 3) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.REPOS_UNSUPPORTED_VERSION, "Expected repository format ''{0}'' or ''{1}''; found format ''{2}''", 3, 5, n2);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        this.myReposFormat = n2;
    }

    public void openDB() {
        Object object;
        Object object2;
        int n2 = this.readDBFormat();
        FSRepositoryUtil.checkReposDBFormat(n2);
        this.myDBFormat = n2;
        this.getFSType();
        if (this.myDBFormat >= 4) {
            this.getMinUnpackedRev();
        }
        this.myDeltaCompression = this.myDBFormat >= 8 ? SVNDeltaCompression.LZ4 : (this.myDBFormat >= 2 ? SVNDeltaCompression.Zlib : SVNDeltaCompression.None);
        boolean bl2 = true;
        SVNConfigFile sVNConfigFile = this.loadConfig();
        if (sVNConfigFile != null) {
            object2 = sVNConfigFile.getPropertyValue(REP_SHARING_SECTION, ENABLE_REP_SHARING_OPTION);
            bl2 = DefaultSVNOptions.getBooleanValue((String)object2, true);
            if (this.myDBFormat >= 8) {
                object = this.myConfig.getPropertyValue(DELTIFICATION_SECTION, COMPRESSION_OPTION);
                if ("lz4".equals(object)) {
                    this.myDeltaCompression = SVNDeltaCompression.LZ4;
                } else if ("none".equals(object)) {
                    this.myDeltaCompression = SVNDeltaCompression.None;
                } else if (object != null) {
                    if (((String)object).startsWith("zlib")) {
                        this.myDeltaCompression = SVNDeltaCompression.Zlib;
                    } else {
                        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.BAD_CONFIG_VALUE, "Unsupported compression algorithm {0} in fsfs.conf setting '{1}'", object, COMPRESSION_OPTION);
                        SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
                    }
                }
            }
        }
        this.myIsRepSharingAllowed = bl2;
        if (this.myDBFormat >= 4 && bl2) {
            this.myReposCacheManager = FSRepresentationCacheUtil.open(this);
        }
        if (!((File)(object2 = this.getCurrentFile())).exists() || !((File)object2).canRead()) {
            if (this.myReposCacheManager != null) {
                this.myReposCacheManager.close();
                this.myReposCacheManager = null;
            }
            object = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Can''t open file ''{0}''", object2);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        if (this.myDBFormat >= 6) {
            long l2;
            this.updateMinUnpackedRevProp();
            this.myCompressPackedRevprops = DefaultSVNOptions.getBooleanValue(sVNConfigFile.getPropertyValue(PACKED_REVPROPS_SECTION, COMPRESS_PACKED_REVPROPS_OPTION), false);
            object = sVNConfigFile.getPropertyValue(PACKED_REVPROPS_SECTION, REVPROP_PACK_SIZE_OPTION);
            long l3 = l2 = this.myCompressPackedRevprops ? 256L : 64L;
            if (object != null) {
                try {
                    l3 = Long.parseLong((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.myRevpropPackSize = l3;
        } else {
            this.myRevpropPackSize = 65536L;
            this.myCompressPackedRevprops = false;
        }
        if (this.myDBFormat >= 7) {
            long l4 = DefaultSVNOptions.getLongValue(sVNConfigFile.getPropertyValue(IO_SECTION, BLOCK_SIZE_OPTION), 64L);
            long l5 = DefaultSVNOptions.getLongValue(sVNConfigFile.getPropertyValue(IO_SECTION, L2P_PAGE_SIZE_OPTION), 8192L);
            long l6 = DefaultSVNOptions.getLongValue(sVNConfigFile.getPropertyValue(IO_SECTION, P2L_PAGE_SIZE_OPTION), 1024L);
            this.verifyBlockSize(l4, 1024L, BLOCK_SIZE_OPTION);
            this.verifyBlockSize(l4, 1024L, P2L_PAGE_SIZE_OPTION);
            this.verifyBlockSize(l4, 8L, L2P_PAGE_SIZE_OPTION);
            this.myBlockSize = l4 * 1024L;
            this.myL2PPageSize = l5;
            this.myP2LPageSize = l6 * 1024L;
        } else {
            this.myBlockSize = 4096L;
            this.myL2PPageSize = 8192L;
            this.myP2LPageSize = 0x100000L;
        }
    }

    private void verifyBlockSize(long l2, long l3, String string) {
        SVNErrorMessage sVNErrorMessage;
        if (l2 <= 0L) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.BAD_CONFIG_VALUE, "{0} is too small for fsfs.conf setting '{1}'", String.valueOf(l2), string);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        if (l2 > Integer.MAX_VALUE / l3) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.BAD_CONFIG_VALUE, "{0} is too large for fsfs.conf setting '{1}'", String.valueOf(l2), string);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        if (0L != (l2 & l2 - 1L)) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.BAD_CONFIG_VALUE, "{0} is invalid for fsfs.conf setting '{1}' because it is not a power of 2", String.valueOf(l2), string);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
    }

    public String getFSType() {
        if (this.myFSType == null) {
            try (FSFile fSFile = new FSFile(this.getFSTypeFile());){
                this.myFSType = fSFile.readLine(128);
            }
            if (!DB_TYPE.equals(this.myFSType)) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_UNKNOWN_FS_TYPE, "Unsupported fs type ''{0}''", (Object)this.myFSType);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
        }
        return this.myFSType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readDBFormat() {
        int n2;
        block9: {
            n2 = -1;
            try (FSFile fSFile = new FSFile(this.getDBFormatFile());){
                n2 = fSFile.readInt();
                this.readOptions(fSFile, n2);
            }
        }
        return n2;
    }

    public String getUUID() {
        if (this.myUUID == null) {
            try (FSFile fSFile = new FSFile(this.getUUIDFile());){
                this.myUUID = fSFile.readLine(38);
            }
        }
        return this.myUUID;
    }

    public File getDBRoot() {
        if (this.myDBRoot == null) {
            this.myDBRoot = new File(this.myRepositoryRoot, DB_DIR);
        }
        return this.myDBRoot;
    }

    public File getWriteLockFile() {
        if (this.myWriteLockFile == null) {
            this.myWriteLockFile = new File(this.getDBRoot(), WRITE_LOCK_FILE);
        }
        return this.myWriteLockFile;
    }

    public File getUUIDFile() {
        if (this.myUUIDFile == null) {
            this.myUUIDFile = new File(this.getDBRoot(), UUID_FILE);
        }
        return this.myUUIDFile;
    }

    public File getDBRevsDir() {
        if (this.myRevisionsRoot == null) {
            this.myRevisionsRoot = new File(this.getDBRoot(), REVS_DIR);
        }
        return this.myRevisionsRoot;
    }

    public File getDBLocksDir() {
        if (this.myLocksRoot == null) {
            this.myLocksRoot = new File(this.getDBRoot(), LOCKS_DIR);
        }
        return this.myLocksRoot;
    }

    public File getFSTypeFile() {
        if (this.myFSTypeFile == null) {
            this.myFSTypeFile = new File(this.getDBRoot(), FS_TYPE_FILE);
        }
        return this.myFSTypeFile;
    }

    public File getTransactionsParentDir() {
        if (this.myTransactionsRoot == null) {
            this.myTransactionsRoot = new File(this.getDBRoot(), TRANSACTIONS_DIR);
        }
        return this.myTransactionsRoot;
    }

    public File getRepositoryRoot() {
        return this.myRepositoryRoot;
    }

    public File getRevisionPropertiesRoot() {
        if (this.myRevisionPropertiesRoot == null) {
            this.myRevisionPropertiesRoot = new File(this.getDBRoot(), REVISION_PROPERTIES_DIR);
        }
        return this.myRevisionPropertiesRoot;
    }

    public File getRepositoryFormatFile() {
        if (this.myRepositoryFormatFile == null) {
            this.myRepositoryFormatFile = new File(this.myRepositoryRoot, "format");
        }
        return this.myRepositoryFormatFile;
    }

    public File getDBFormatFile() {
        if (this.myDBFormatFile == null) {
            this.myDBFormatFile = new File(this.getDBRoot(), "format");
        }
        return this.myDBFormatFile;
    }

    public File getNodeOriginsDir() {
        if (this.myNodeOriginsDir == null) {
            this.myNodeOriginsDir = new File(this.getDBRoot(), NODE_ORIGINS_DIR);
        }
        return this.myNodeOriginsDir;
    }

    public File getCurrentFile() {
        if (this.myCurrentFile == null) {
            this.myCurrentFile = new File(this.getDBRoot(), CURRENT_FILE);
        }
        return this.myCurrentFile;
    }

    public File getRepositoryCacheFile() {
        if (this.myRepositoryCacheFile == null) {
            this.myRepositoryCacheFile = new File(this.getDBRoot(), REP_CACHE_DB);
        }
        return this.myRepositoryCacheFile;
    }

    public File getDBLogsLockFile() {
        File file = new File(this.getDBRoot(), "locks/db-logs.lock");
        if (!file.exists()) {
            try {
                SVNFileUtil.createFile(file, PRE_12_COMPAT_UNNEEDED_FILE_CONTENTS, "US-ASCII");
            }
            catch (SVNException sVNException) {
                SVNErrorMessage sVNErrorMessage = sVNException.getErrorMessage().wrap("Creating db logs lock file");
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
        }
        return file;
    }

    public long getDatedRevision(Date date) {
        long l2;
        long l3 = l2 = this.getYoungestRevision();
        long l4 = 0L;
        Date date2 = null;
        while (l4 <= l3) {
            Date date3;
            long l5 = (l3 + l4) / 2L;
            date2 = this.getRevisionTime(l5);
            if (date2.compareTo(date) > 0) {
                if (l5 - 1L < 0L) {
                    return 0L;
                }
                date3 = this.getRevisionTime(l5 - 1L);
                if (date3.compareTo(date) < 0) {
                    return l5 - 1L;
                }
                l3 = l5 - 1L;
                continue;
            }
            if (date2.compareTo(date) < 0) {
                if (l5 + 1L > l2) {
                    return l2;
                }
                date3 = this.getRevisionTime(l5 + 1L);
                if (date3.compareTo(date) > 0) {
                    return l5;
                }
                l4 = l5 + 1L;
                continue;
            }
            return l5;
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getYoungestRevision() {
        try (FSFile fSFile = new FSFile(this.getCurrentFile());){
            String string = fSFile.readLine(180);
            int n2 = string.indexOf(32);
            this.myYoungestRevisionCache = n2 > 0 ? Long.parseLong(string.substring(0, n2)) : Long.parseLong(string);
            long l2 = this.myYoungestRevisionCache;
            return l2;
        }
        return this.myYoungestRevisionCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMinUnpackedRev() {
        try (FSFile fSFile = new FSFile(this.getMinUnpackedRevFile());){
            long l2 = this.myMinUnpackedRevision = fSFile.readLong();
            return l2;
        }
        return this.myMinUnpackedRevision;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upgrade() {
        FSWriteLock fSWriteLock;
        FSWriteLock fSWriteLock2 = fSWriteLock = FSWriteLock.getWriteLockForDB(this);
        synchronized (fSWriteLock2) {
            try {
                File file;
                fSWriteLock.lock();
                if (this.myDBFormat == 8) {
                    return;
                }
                if (this.myDBFormat < 3) {
                    file = this.getTransactionCurrentFile();
                    SVNFileUtil.createFile(file, "0\n", "US-ASCII");
                    SVNFileUtil.createEmptyFile(this.getTransactionCurrentLockFile());
                }
                if (this.myDBFormat < 3) {
                    file = this.getTransactionProtoRevsDir();
                    file.mkdirs();
                }
                if (this.myDBFormat < 4) {
                    SVNFileUtil.createFile(this.getMinUnpackedRevFile(), "0\n", "US-ASCII");
                }
                if (this.myDBFormat < 4) {
                    SVNFileUtil.createFile(this.getMinUnpackedRevFile(), "0\n", "US-ASCII");
                }
                if (this.myDBFormat < 6) {
                    SVNFileUtil.createFile(this.getMinUnpackedRevPropPath(), "0\n", "US-ASCII");
                }
            }
            finally {
                fSWriteLock.unlock();
                FSWriteLock.release(fSWriteLock);
            }
            this.close();
            this.open();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDBFormat(int n2, long l2, boolean bl2) {
        File file = this.getDBFormatFile();
        SVNErrorManager.assertionFailure(n2 >= 1 && n2 <= 8, "unexpected format " + String.valueOf(n2), SVNLogType.FSFS);
        String string = null;
        string = n2 >= 3 ? (l2 > 0L ? n2 + "\nlayout sharded " + l2 + "\n" : n2 + "\nlayout linear") : n2 + "\n";
        if (!bl2) {
            SVNFileUtil.createFile(file, string, "US-ASCII");
        } else {
            File file2 = SVNFileUtil.createUniqueFile(file.getParentFile(), file.getName(), ".tmp", false);
            OutputStream outputStream = null;
            try {
                outputStream = SVNFileUtil.openFileForWriting(file2);
                outputStream.write(string.getBytes("US-ASCII"));
            }
            catch (IOException iOException) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getMessage());
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
            finally {
                SVNFileUtil.closeFile(outputStream);
            }
            if (SVNFileUtil.isWindows) {
                SVNFileUtil.setReadonly(file, false);
            }
            SVNFileUtil.rename(file2, file);
        }
        SVNFileUtil.setReadonly(file, true);
    }

    public SVNProperties getRevisionProperties(long l2) {
        try {
            if (!SVNRevision.isValidRevisionNumber(l2)) {
                l2 = this.getYoungestRevision();
            }
            return this.readRevisionProperties(l2);
        }
        catch (SVNException sVNException) {
            if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.FS_NO_SUCH_REVISION && this.myDBFormat >= 6) {
                this.updateMinUnpackedRevProp();
                return this.readRevisionProperties(l2);
            }
            throw sVNException;
        }
    }

    private SVNProperties readRevisionProperties(long l2) {
        this.ensureRevisionsExists(l2);
        SVNProperties sVNProperties = null;
        if (!this.isPackedRevisionProperties(l2)) {
            try (FSFile fSFile = new FSFile(this.getRevisionPropertiesFile(l2, false));){
                sVNProperties = fSFile.readProperties(false, true);
            }
        }
        if (this.myDBFormat >= 6 && sVNProperties == null) {
            return this.readPackedRevisionProperties(l2);
        }
        return sVNProperties == null ? new SVNProperties() : sVNProperties;
    }

    private SVNProperties readPackedRevisionProperties(long l2) {
        SVNFSFSPackedRevProps sVNFSFSPackedRevProps;
        SVNProperties sVNProperties;
        Serializable serializable;
        if (!this.isPackedRevisionProperties(l2)) {
            this.updateMinUnpackedRevProp();
        }
        if (!this.isPackedRevisionProperties(l2)) {
            serializable = SVNErrorMessage.create(SVNErrorCode.FS_NO_SUCH_REVISION, "No such packed revision {0}", (Object)l2);
            SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.FSFS);
        }
        return (sVNProperties = (sVNFSFSPackedRevProps = SVNFSFSPackedRevProps.fromPackFile(serializable = this.getPackedRevPropFile(l2))).parseProperties(l2)) == null ? new SVNProperties() : sVNProperties;
    }

    private File getPackedRevPropFile(long l2) {
        File file = this.getPackedRevPropsShardPath(l2);
        File file2 = new File(file, "manifest");
        SVNFSFSPackedRevPropsManifest sVNFSFSPackedRevPropsManifest = SVNFSFSPackedRevPropsManifest.fromFile(file2, l2, this.myMaxFilesPerDirectory);
        return new File(file, sVNFSFSPackedRevPropsManifest.getPackName(l2));
    }

    private static long decodeUncompressedSize(InputStream inputStream, int n2, int[] nArray) {
        int n3;
        int n4 = 0;
        int n5 = 0;
        do {
            if (n2 == n5) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.SVNDIFF_INVALID_HEADER, "Decompression of svndiff data failed: size too large");
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
            n3 = 0;
            try {
                n3 = inputStream.read();
            }
            catch (IOException iOException) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR);
                SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.FSFS);
            }
            if (n3 < 0) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.SVNDIFF_UNEXPECTED_END, "Decompression of svndiff data failed: no size");
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
            ++n5;
            n4 = n4 << 7 | n3 & 0x7F;
        } while (n3 >= 128);
        nArray[0] = n5;
        return n4;
    }

    private static SVNProperties readProperties(byte[] byArray) {
        try (FSFile fSFile = new FSFile(byArray);){
            SVNProperties sVNProperties = fSFile.readProperties(false, true);
            return sVNProperties;
        }
    }

    private static long readNumber(BufferedReader bufferedReader) {
        String string = bufferedReader.readLine();
        if (string == null) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Unexpected EOF");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Number ''{0}'' invalid or too large", (Object)string);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            return -1L;
        }
    }

    private static long readNumber(InputStream inputStream) {
        char[] cArray = new char[20];
        int n2 = 0;
        while (true) {
            SVNErrorMessage sVNErrorMessage;
            int n3 = 0;
            try {
                n3 = inputStream.read();
            }
            catch (IOException iOException) {
                SVNErrorMessage sVNErrorMessage2 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR);
                SVNErrorManager.error(sVNErrorMessage2, iOException, SVNLogType.FSFS);
            }
            if (n3 < 0) {
                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
            if (n3 != 10 && (n3 < 48 || n3 > 57)) {
                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
            if (n3 == 10) {
                return Long.parseLong(new String(cArray, 0, n2));
            }
            cArray[n2] = (char)n3;
            ++n2;
        }
    }

    private boolean isPackedRevisionProperties(long l2) {
        return l2 < this.myMinUnpackedRevProp && l2 != 0L && this.myDBFormat >= 6;
    }

    public FSRevisionRoot createRevisionRoot(long l2) {
        this.ensureRevisionsExists(l2);
        return new FSRevisionRoot(this, l2);
    }

    public FSTransactionRoot createTransactionRoot(FSTransactionInfo fSTransactionInfo) {
        SVNProperties sVNProperties = this.getTransactionProperties(fSTransactionInfo.getTxnId());
        int n2 = 0;
        if (sVNProperties.getStringValue("svn:check-ood") != null) {
            n2 |= 1;
        }
        if (sVNProperties.getStringValue("svn:check-locks") != null) {
            n2 |= 2;
        }
        return new FSTransactionRoot(this, fSTransactionInfo.getTxnId(), fSTransactionInfo.getBaseRevision(), n2);
    }

    public FSTransactionInfo openTxn(String string) {
        Object object;
        SVNFileType sVNFileType = SVNFileType.getType(this.getTransactionDir(string));
        if (sVNFileType != SVNFileType.DIRECTORY) {
            object = SVNErrorMessage.create(SVNErrorCode.FS_NO_SUCH_TRANSACTION, "No such transaction");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        object = new FSTransactionRoot(this, string, -1L, 0);
        FSTransactionInfo fSTransactionInfo = ((FSTransactionRoot)object).getTxn();
        return new FSTransactionInfo(fSTransactionInfo.getBaseRevision(), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSRevisionNode getRevisionNode(FSID fSID) {
        Object object;
        FSFile fSFile = null;
        if (fSID.isTxn()) {
            object = new File(this.getTransactionDir(fSID.getTxnID()), PATH_PREFIX_NODE + fSID.getNodeID() + "." + fSID.getCopyID());
            fSFile = new FSFile((File)object);
        } else {
            fSFile = this.openAndSeekRevision(fSID.getRevision(), fSID.getOffset());
        }
        object = null;
        try {
            object = fSFile.readHeader();
        }
        finally {
            fSFile.close();
        }
        FSRevisionNode fSRevisionNode = FSRevisionNode.fromMap((Map)object);
        if (fSRevisionNode.isFreshTxnRoot()) {
            fSRevisionNode.setFreshRootPredecessorId(fSRevisionNode.getPredecessorId());
        }
        return fSRevisionNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getDirContents(FSRevisionNode fSRevisionNode) {
        FSRepresentation fSRepresentation = fSRevisionNode.getTextRepresentation();
        if (fSRepresentation != null && fSRepresentation.isTxn()) {
            Map map = null;
            try (FSFile fSFile = this.getTransactionRevisionNodeChildrenFile(fSRevisionNode.getId());){
                SVNProperties sVNProperties = fSFile.readProperties(false, false);
                sVNProperties.putAll(fSFile.readProperties(true, false));
                sVNProperties.removeNullValues();
                map = this.parsePlainRepresentation(sVNProperties, true);
            }
            return map;
        }
        if (fSRepresentation != null) {
            return this.parsePlainRepresentation(this.parseProperties(fSRepresentation), false);
        }
        return new SVNHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] parseRawDeltaProperties(FSRepresentation fSRepresentation, StringBuilder stringBuilder) {
        FSFile fSFile = null;
        fSFile = this.openAndSeekRepresentation(fSRepresentation);
        String string = fSFile.readLine(160);
        byte[] byArray = null;
        String string2 = null;
        try {
            Object object;
            if ("PLAIN".equals(string)) {
                fSFile.resetDigest();
                byArray = new byte[(int)fSRepresentation.getSize()];
                fSFile.read(byArray, 0, byArray.length);
                string2 = fSFile.digest();
                if (string2 != null && stringBuilder != null) {
                    stringBuilder.append(string2);
                }
            } else if ("DELTA".equals(string)) {
                object = SVNFileUtil.DUMMY_IN;
                byArray = this.applyDeltaFromFSFile(fSFile, (int)fSRepresentation.getSize(), (InputStream)object, stringBuilder);
            } else if (string.startsWith("DELTA ")) {
                Object object2;
                String[] stringArray = string.split(" ");
                if (stringArray.length < 4) {
                    object2 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed representation header ''{0}''", (Object)string);
                    SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.FSFS);
                }
                try {
                    long l2 = Long.parseLong(stringArray[1]);
                    long l3 = Long.parseLong(stringArray[2]);
                    long l4 = Long.parseLong(stringArray[3]);
                    object2 = new FSRepresentation();
                    ((FSRepresentation)object2).setRevision(l2);
                    ((FSRepresentation)object2).setItemIndex(l3);
                    ((FSRepresentation)object2).setSize(l4);
                    byte[] byArray2 = this.parseRawDeltaProperties((FSRepresentation)object2, null);
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
                    byArray = this.applyDeltaFromFSFile(fSFile, (int)fSRepresentation.getSize(), byteArrayInputStream, stringBuilder);
                }
                catch (NumberFormatException numberFormatException) {
                    SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed representation header ''{0}''", (Object)string);
                    SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
                }
            }
            object = byArray;
            return object;
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        finally {
            if (fSFile != null) {
                fSFile.close();
            }
        }
        return null;
    }

    private byte[] applyDeltaFromFSFile(FSFile fSFile, int n2, InputStream inputStream, StringBuilder stringBuilder) {
        String string;
        SVNDeltaReader sVNDeltaReader = new SVNDeltaReader();
        byte[] byArray = new byte[2048];
        int n3 = -1;
        SVNDeltaProcessor sVNDeltaProcessor = new SVNDeltaProcessor();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        sVNDeltaProcessor.applyTextDelta(inputStream, byteArrayOutputStream, true);
        while ((n3 = fSFile.read(byArray, 0, Math.min(byArray.length, n2))) != -1) {
            if (n3 == 0) continue;
            sVNDeltaReader.nextWindow(byArray, 0, n3, "", new FSFS$1(this, sVNDeltaProcessor));
            if ((n2 -= n3) != 0) continue;
        }
        if ((string = sVNDeltaProcessor.textDeltaEnd()) != null && stringBuilder != null) {
            stringBuilder.append(string);
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SVNProperties parseProperties(FSRepresentation fSRepresentation) {
        try (FSFile fSFile = null;){
            Serializable serializable;
            fSFile = this.openAndSeekRepresentation(fSRepresentation);
            String string = fSFile.readLine(160);
            SVNProperties sVNProperties = null;
            String string2 = null;
            if ("PLAIN".equals(string)) {
                fSFile.resetDigest();
                sVNProperties = fSFile.readProperties(false, true);
                string2 = fSFile.digest();
            } else if ("DELTA".equals(string)) {
                serializable = new StringBuilder();
                sVNProperties = FSFS.readProperties(this.parseRawDeltaProperties(fSRepresentation, (StringBuilder)serializable));
                string2 = serializable.toString();
            } else if (string.startsWith("DELTA ")) {
                serializable = new StringBuilder();
                byte[] byArray = this.parseRawDeltaProperties(fSRepresentation, (StringBuilder)serializable);
                string2 = serializable.toString();
                sVNProperties = FSFS.readProperties(byArray);
            }
            SVNErrorManager.assertionFailure(string2 != null, "Checksum should be computed", SVNLogType.FSFS);
            if (!string2.equals(fSRepresentation.getMD5HexDigest())) {
                serializable = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Checksum mismatch while reading representation:\n   expected:  {0}\n     actual:  {1}", string2, fSRepresentation.getMD5HexDigest());
                SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.FSFS);
            }
            serializable = sVNProperties;
            return serializable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNProperties getProperties(FSRevisionNode fSRevisionNode) {
        if (fSRevisionNode.getPropsRepresentation() != null && fSRevisionNode.getPropsRepresentation().isTxn()) {
            try (FSFile fSFile = null;){
                fSFile = this.getTransactionRevisionNodePropertiesFile(fSRevisionNode.getId());
                SVNProperties sVNProperties = fSFile.readProperties(false, true);
                return sVNProperties;
            }
        }
        if (fSRevisionNode.getPropsRepresentation() != null) {
            FSRepresentation fSRepresentation = fSRevisionNode.getPropsRepresentation();
            SVNProperties sVNProperties = this.parseProperties(fSRepresentation);
            return sVNProperties == null ? new SVNProperties() : sVNProperties;
        }
        return new SVNProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getNextRevisionIDs() {
        Object object;
        int n2;
        String[] stringArray = new String[2];
        String string = null;
        try (FSFile fSFile = new FSFile(this.getCurrentFile());){
            string = fSFile.readLine(80);
        }
        if (string == null || string.length() == 0) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Corrupt current file");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        if ((n2 = string.indexOf(32)) == -1) {
            object = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Corrupt current file");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        if ((n2 = (string = string.substring(n2 + 1)).indexOf(32)) == -1) {
            object = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Corrupt current file");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        object = string.substring(0, n2);
        String string2 = string.substring(n2 + 1);
        stringArray[0] = object;
        stringArray[1] = string2;
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAndIncrementTxnKey() {
        FSWriteLock fSWriteLock;
        FSWriteLock fSWriteLock2 = fSWriteLock = FSWriteLock.getWriteLockForCurrentTxn("_txn-current", this);
        synchronized (fSWriteLock2) {
            String string;
            try {
                fSWriteLock.lock();
                File file = this.getTransactionCurrentFile();
                String string2 = null;
                try (FSFile fSFile = new FSFile(file);){
                    string2 = fSFile.readLine(200);
                }
                String string3 = FSRepositoryUtil.generateNextKey(string2);
                OutputStream outputStream = null;
                File file2 = null;
                try {
                    file2 = SVNFileUtil.createUniqueFile(file.getParentFile(), TXN_CURRENT_FILE, ".tmp", false);
                    outputStream = SVNFileUtil.openFileForWriting(file2);
                    string3 = string3 + "\n";
                    outputStream.write(string3.getBytes("UTF-8"));
                }
                catch (IOException iOException) {
                    try {
                        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage());
                        SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.FSFS);
                    }
                    catch (Throwable throwable) {
                        SVNFileUtil.closeFile(outputStream);
                        throw throwable;
                    }
                    SVNFileUtil.closeFile(outputStream);
                }
                SVNFileUtil.closeFile(outputStream);
                SVNFileUtil.rename(file2, file);
                string = string2;
                fSWriteLock.unlock();
            }
            catch (Throwable throwable) {
                fSWriteLock.unlock();
                FSWriteLock.release(fSWriteLock);
                throw throwable;
            }
            FSWriteLock.release(fSWriteLock);
            return string;
        }
    }

    public Map listTransactions() {
        SVNHashMap sVNHashMap = new SVNHashMap();
        File file = this.getTransactionsParentDir();
        File[] fileArray = SVNFileListUtil.listFiles(file);
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            File file2 = fileArray[i2];
            if (file2.getName().length() <= TXN_PATH_EXT.length() || !file2.getName().endsWith(TXN_PATH_EXT)) continue;
            String string = file2.getName().substring(0, file2.getName().lastIndexOf(TXN_PATH_EXT));
            sVNHashMap.put(string, file2);
        }
        return sVNHashMap;
    }

    public File getNewRevisionFile(long l2) {
        File file;
        if (this.myMaxFilesPerDirectory > 0L && l2 % this.myMaxFilesPerDirectory == 0L) {
            file = new File(this.getDBRevsDir(), String.valueOf(l2 / this.myMaxFilesPerDirectory));
            file.mkdirs();
        }
        file = null;
        if (this.myMaxFilesPerDirectory > 0L) {
            File file2 = new File(this.getDBRevsDir(), String.valueOf(l2 / this.myMaxFilesPerDirectory));
            file = new File(file2, String.valueOf(l2));
        } else {
            file = new File(this.getDBRevsDir(), String.valueOf(l2));
        }
        return file;
    }

    public File getNewRevisionPropertiesFile(long l2) {
        File file;
        if (this.myMaxFilesPerDirectory > 0L && l2 % this.myMaxFilesPerDirectory == 0L) {
            file = new File(this.getRevisionPropertiesRoot(), String.valueOf(l2 / this.myMaxFilesPerDirectory));
            file.mkdirs();
        }
        file = null;
        if (this.myMaxFilesPerDirectory > 0L) {
            File file2 = new File(this.getRevisionPropertiesRoot(), String.valueOf(l2 / this.myMaxFilesPerDirectory));
            file = new File(file2, String.valueOf(l2));
        } else {
            file = new File(this.getRevisionPropertiesRoot(), String.valueOf(l2));
        }
        return file;
    }

    public File getTransactionDir(String string) {
        return new File(this.getTransactionsParentDir(), string + TXN_PATH_EXT);
    }

    public void setYoungestRevisionCache(long l2) {
        this.myYoungestRevisionCache = l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUUID(String string) {
        File file = SVNFileUtil.createUniqueFile(this.getDBRoot(), UUID_FILE, ".tmp", false);
        string = string + '\n';
        OutputStream outputStream = null;
        try {
            outputStream = SVNFileUtil.openFileForWriting(file);
            outputStream.write(string.getBytes("US-ASCII"));
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Error writing repository UUID to ''{0}''", (Object)this.getUUIDFile());
            sVNErrorMessage.setChildErrorMessage(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage()));
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        finally {
            SVNFileUtil.closeFile(outputStream);
        }
        SVNFileUtil.rename(file, this.getUUIDFile());
    }

    public File getRevisionPropertiesFile(long l2, boolean bl2) {
        Serializable serializable;
        File file = null;
        if (this.myMaxFilesPerDirectory > 0L) {
            serializable = new File(this.getRevisionPropertiesRoot(), String.valueOf(l2 / this.myMaxFilesPerDirectory));
            file = new File((File)serializable, String.valueOf(l2));
        } else {
            file = new File(this.getRevisionPropertiesRoot(), String.valueOf(l2));
        }
        if (!file.exists() && !bl2) {
            serializable = SVNErrorMessage.create(SVNErrorCode.FS_NO_SUCH_REVISION, "No such revision {0}", (Object)String.valueOf(l2));
            SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.FSFS);
        }
        return file;
    }

    public FSFile openAndSeekRepresentation(FSRepresentation fSRepresentation) {
        if (!fSRepresentation.isTxn()) {
            return this.openAndSeekRevision(fSRepresentation.getRevision(), fSRepresentation.getItemIndex());
        }
        return this.openAndSeekTransaction(fSRepresentation);
    }

    public File getNextIDsFile(String string) {
        return new File(this.getTransactionDir(string), "next-ids");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeNextIDs(String string, String string2, String string3) {
        OutputStream outputStream = null;
        try {
            outputStream = SVNFileUtil.openFileForWriting(this.getNextIDsFile(string));
            String string4 = string2 + " " + string3 + "\n";
            outputStream.write(string4.getBytes("UTF-8"));
        }
        catch (IOException iOException) {
            try {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage());
                SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.FSFS);
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(outputStream);
                throw throwable;
            }
            SVNFileUtil.closeFile(outputStream);
        }
        SVNFileUtil.closeFile(outputStream);
    }

    public void changeTransactionProperties(String string, SVNProperties sVNProperties) {
        for (String string2 : sVNProperties.nameSet()) {
            SVNPropertyValue sVNPropertyValue = sVNProperties.getSVNPropertyValue(string2);
            this.setTransactionProperty(string, string2, sVNPropertyValue);
        }
    }

    public void setTransactionProperty(String string, String string2, SVNPropertyValue sVNPropertyValue) {
        FSRepositoryUtil.validateProperty(string2, sVNPropertyValue);
        SVNWCProperties sVNWCProperties = new SVNWCProperties(this.getTransactionPropertiesFile(string), null);
        sVNWCProperties.setPropertyValue(string2, sVNPropertyValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRevisionProperty(long l2, String string, SVNPropertyValue sVNPropertyValue) {
        FSWriteLock fSWriteLock;
        this.ensureRevisionsExists(l2);
        FSWriteLock fSWriteLock2 = fSWriteLock = FSWriteLock.getWriteLockForDB(this);
        synchronized (fSWriteLock2) {
            try {
                fSWriteLock.lock();
                if (!this.isPackedRevisionProperties(l2)) {
                    SVNWCProperties sVNWCProperties = new SVNWCProperties(this.getRevisionPropertiesFile(l2, false), null);
                    sVNWCProperties.setPropertyValue(string, sVNPropertyValue);
                } else {
                    File file = this.getPackedRevPropsShardPath(l2);
                    File file2 = new File(file, "manifest");
                    SVNFSFSPackedRevPropsManifest sVNFSFSPackedRevPropsManifest = SVNFSFSPackedRevPropsManifest.fromFile(file2, l2, this.myMaxFilesPerDirectory);
                    File file3 = new File(file, sVNFSFSPackedRevPropsManifest.getPackName(l2));
                    SVNFSFSPackedRevProps sVNFSFSPackedRevProps = SVNFSFSPackedRevProps.fromPackFile(file3);
                    SVNProperties sVNProperties = sVNFSFSPackedRevProps.parseProperties(l2);
                    sVNProperties.put(string, sVNPropertyValue);
                    List list = sVNFSFSPackedRevProps.setProperties(l2, sVNProperties, this.getRevPropPackSize());
                    File file4 = SVNFileUtil.createUniqueFile(file, "svn", ".tmp", false);
                    if (list.size() == 1) {
                        SVNFSFSPackedRevProps sVNFSFSPackedRevProps2 = (SVNFSFSPackedRevProps)list.get(0);
                        sVNFSFSPackedRevProps2.writeToFile(file4, this.isCompressPackedRevprops());
                        SVNFileUtil.rename(file4, file3);
                    } else {
                        Object object;
                        HashSet<String> hashSet = new HashSet<String>(3);
                        for (SVNFSFSPackedRevProps object2 : list) {
                            object = sVNFSFSPackedRevPropsManifest.getPackName(object2.getFirstRevision());
                            hashSet.add((String)object);
                            String string2 = sVNFSFSPackedRevPropsManifest.updatePackName(object2.getFirstRevision(), (int)object2.getRevisionsCount());
                            File file5 = new File(file, string2);
                            object2.writeToFile(file5, this.isCompressPackedRevprops());
                        }
                        SVNFileUtil.writeToFile(file4, sVNFSFSPackedRevPropsManifest.asString(), "UTF-8");
                        SVNFileUtil.rename(file4, file2);
                        for (String string3 : hashSet) {
                            object = new File(file, string3);
                            SVNFileUtil.deleteFile((File)object);
                        }
                    }
                }
            }
            finally {
                fSWriteLock.unlock();
                FSWriteLock.release(fSWriteLock);
            }
        }
    }

    protected long getRevPropPackSize() {
        return this.myRevpropPackSize;
    }

    public boolean isRepSharingAllowed() {
        return this.myIsRepSharingAllowed;
    }

    public long getBlockSize() {
        return this.myBlockSize;
    }

    public long getL2PPageSize() {
        return this.myL2PPageSize;
    }

    public long getP2LPageSize() {
        return this.myP2LPageSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNProperties getTransactionProperties(String string) {
        try (FSFile fSFile = new FSFile(this.getTransactionPropertiesFile(string));){
            SVNProperties sVNProperties = fSFile.readProperties(false, true);
            return sVNProperties;
        }
    }

    public File getTransactionPropertiesFile(String string) {
        return new File(this.getTransactionDir(string), "props");
    }

    public File getTransactionProtoRevsDir() {
        if (this.myTransactionProtoRevsRoot == null) {
            this.myTransactionProtoRevsRoot = new File(this.getDBRoot(), TRANSACTION_PROTOS_DIR);
        }
        return this.myTransactionProtoRevsRoot;
    }

    public File getTransactionProtoRevFile(String string) {
        if (this.myDBFormat >= 3) {
            return new File(this.getTransactionProtoRevsDir(), string + ".rev");
        }
        return new File(this.getTransactionDir(string), TXN_PATH_REV);
    }

    public File getTransactionProtoRevLockFile(String string) {
        if (this.myDBFormat >= 3) {
            return new File(this.getTransactionProtoRevsDir(), string + ".rev-lock");
        }
        return new File(this.getTransactionDir(string), "rev-lock");
    }

    public void purgeTxn(String string) {
        SVNFileUtil.deleteAll(this.getTransactionDir(string), true);
        if (this.getDBFormat() >= 3) {
            SVNFileUtil.deleteFile(this.getTransactionProtoRevFile(string));
            SVNFileUtil.deleteFile(this.getTransactionProtoRevLockFile(string));
        }
    }

    public void createNewTxnNodeRevisionFromRevision(String string, FSRevisionNode fSRevisionNode) {
        Object object;
        if (fSRevisionNode.getId().isTxn()) {
            object = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Copying from transactions not allowed");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        object = FSRevisionNode.dumpRevisionNode(fSRevisionNode);
        ((FSRevisionNode)object).setPredecessorId(fSRevisionNode.getId());
        ((FSRevisionNode)object).setCount(((FSRevisionNode)object).getCount() + 1L);
        ((FSRevisionNode)object).setCopyFromPath(null);
        ((FSRevisionNode)object).setIsFreshTxnRoot(true);
        ((FSRevisionNode)object).setCopyFromRevision(-1L);
        ((FSRevisionNode)object).setId(FSID.createTxnId(fSRevisionNode.getId().getNodeID(), fSRevisionNode.getId().getCopyID(), string));
        this.putTxnRevisionNode(((FSRevisionNode)object).getId(), (FSRevisionNode)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putTxnRevisionNode(FSID fSID, FSRevisionNode fSRevisionNode) {
        Object object;
        if (!fSID.isTxn()) {
            object = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Attempted to write to non-transaction");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        object = null;
        try {
            object = SVNFileUtil.openFileForWriting(this.getTransactionRevNodeFile(fSID));
            this.writeTxnNodeRevision((OutputStream)object, fSRevisionNode);
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage());
            SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.FSFS);
        }
        finally {
            SVNFileUtil.closeFile((OutputStream)object);
        }
    }

    public File getTransactionRevNodeFile(FSID fSID) {
        return new File(this.getTransactionDir(fSID.getTxnID()), PATH_PREFIX_NODE + fSID.getNodeID() + "." + fSID.getCopyID());
    }

    public void writeTxnNodeRevision(OutputStream outputStream, FSRevisionNode fSRevisionNode) {
        String string;
        Object object;
        String string2;
        String string3 = "id: " + fSRevisionNode.getId() + "\n";
        outputStream.write(string3.getBytes("UTF-8"));
        String string4 = "type: " + fSRevisionNode.getType() + "\n";
        outputStream.write(string4.getBytes("UTF-8"));
        if (fSRevisionNode.getPredecessorId() != null) {
            string2 = "pred: " + fSRevisionNode.getPredecessorId() + "\n";
            outputStream.write(string2.getBytes("UTF-8"));
        }
        string2 = "count: " + fSRevisionNode.getCount() + "\n";
        outputStream.write(string2.getBytes("UTF-8"));
        if (fSRevisionNode.getTextRepresentation() != null) {
            object = fSRevisionNode.getTextRepresentation();
            string = "text: " + (((FSRepresentation)object).getTxnId() != null && fSRevisionNode.getType() == SVNNodeKind.DIR ? "-1" : ((FSRepresentation)object).getStringRepresentation(this.myDBFormat)) + "\n";
            outputStream.write(string.getBytes("UTF-8"));
        }
        if (fSRevisionNode.getPropsRepresentation() != null) {
            object = fSRevisionNode.getPropsRepresentation();
            string = "props: " + (((FSRepresentation)object).getTxnId() != null ? "-1" : ((FSRepresentation)object).getStringRepresentation(this.myDBFormat)) + "\n";
            outputStream.write(string.getBytes("UTF-8"));
        }
        object = "cpath: " + fSRevisionNode.getCreatedPath() + "\n";
        outputStream.write(((String)object).getBytes("UTF-8"));
        if (fSRevisionNode.getCopyFromPath() != null) {
            string = "copyfrom: " + fSRevisionNode.getCopyFromRevision() + " " + fSRevisionNode.getCopyFromPath() + "\n";
            outputStream.write(string.getBytes("UTF-8"));
        }
        if (fSRevisionNode.getCopyRootRevision() != fSRevisionNode.getId().getRevision() || !fSRevisionNode.getCopyRootPath().equals(fSRevisionNode.getCreatedPath())) {
            string = "copyroot: " + fSRevisionNode.getCopyRootRevision() + " " + fSRevisionNode.getCopyRootPath() + "\n";
            outputStream.write(string.getBytes("UTF-8"));
        }
        if (fSRevisionNode.isFreshTxnRoot()) {
            string = "is-fresh-txn-root: y\n";
            outputStream.write(string.getBytes("UTF-8"));
        }
        if (this.supportsMergeInfo()) {
            if (fSRevisionNode.getMergeInfoCount() > 0L) {
                string = "minfo-cnt: " + fSRevisionNode.getMergeInfoCount() + "\n";
                outputStream.write(string.getBytes("UTF-8"));
            }
            if (fSRevisionNode.hasMergeInfo()) {
                string = "minfo-here: y\n";
                outputStream.write(string.getBytes("UTF-8"));
            }
        }
        outputStream.write("\n".getBytes("UTF-8"));
    }

    public SVNLock getLock(String string, boolean bl2, boolean bl3) {
        SVNLock sVNLock = this.fetchLockFromDigestFile(null, string = SVNPathUtil.canonicalizeAbsolutePath(string), null);
        if (sVNLock == null) {
            if (!bl3) {
                return null;
            }
            SVNErrorManager.error(FSErrors.errorNoSuchLock(string, this), SVNLogType.FSFS);
        }
        Date date = new Date(System.currentTimeMillis());
        if (sVNLock.getExpirationDate() != null && date.compareTo(sVNLock.getExpirationDate()) > 0) {
            if (bl2) {
                this.deleteLock(sVNLock);
            }
            if (!bl3) {
                return null;
            }
            SVNErrorManager.error(FSErrors.errorLockExpired(sVNLock.getID(), this), SVNLogType.FSFS);
        }
        return sVNLock;
    }

    public void deleteLock(SVNLock sVNLock) {
        String string = sVNLock.getPath();
        String string2 = null;
        ArrayList arrayList = new ArrayList();
        while (true) {
            this.fetchLockFromDigestFile(null, string, arrayList);
            if (string2 != null) {
                arrayList.remove(string2);
            }
            if (arrayList.size() == 0) {
                string2 = this.getDigestFromRepositoryPath(string);
                File file = this.getDigestFileFromRepositoryPath(string);
                SVNFileUtil.deleteFile(file);
            } else {
                this.writeDigestLockFile(null, arrayList, string, false);
                string2 = null;
            }
            if ("/".equals(string)) break;
            if ("".equals(string = SVNPathUtil.removeTail(string))) {
                string = "/";
            }
            arrayList.clear();
        }
    }

    public void walkDigestFiles(File file, ISVNLockHandler iSVNLockHandler, boolean bl2) {
        LinkedList linkedList = new LinkedList();
        SVNLock sVNLock = this.fetchLockFromDigestFile(file, null, linkedList);
        if (sVNLock != null) {
            Date date = new Date(System.currentTimeMillis());
            if (sVNLock.getExpirationDate() == null || date.compareTo(sVNLock.getExpirationDate()) < 0) {
                iSVNLockHandler.handleLock(sVNLock.getPath(), sVNLock, null);
            } else if (bl2) {
                this.deleteLock(sVNLock);
            }
        }
        if (linkedList.isEmpty()) {
            return;
        }
        for (String string : linkedList) {
            File file2 = new File(this.getDBLocksDir(), string.substring(0, 3));
            File file3 = new File(file2, string);
            this.walkDigestFiles(file3, iSVNLockHandler, bl2);
        }
    }

    public SVNLock getLockHelper(String string, boolean bl2) {
        SVNLock sVNLock = null;
        try {
            sVNLock = this.getLock(string, bl2, false);
        }
        catch (SVNException sVNException) {
            if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.FS_NO_SUCH_LOCK || sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.FS_LOCK_EXPIRED) {
                return null;
            }
            throw sVNException;
        }
        return sVNLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNLock fetchLockFromDigestFile(File file, String string, Collection collection) {
        String[] stringArray;
        Object object;
        Object object2;
        File file2 = file == null ? this.getDigestFileFromRepositoryPath(string) : file;
        SVNProperties sVNProperties = null;
        if (file2.exists()) {
            object2 = new FSFile(file2);
            try {
                sVNProperties = ((FSFile)object2).readProperties(false, true);
            }
            catch (SVNException sVNException) {
                object = sVNException.getErrorMessage().wrap("Can't parse lock/entries hashfile ''{0}''", file2);
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
            }
            finally {
                ((FSFile)object2).close();
            }
        } else {
            sVNProperties = new SVNProperties();
        }
        object2 = null;
        String string2 = SVNPropertyValue.getPropertyAsString(sVNProperties.getSVNPropertyValue(PATH_LOCK_KEY));
        if (string2 != null) {
            String string3;
            String string4;
            object = SVNPropertyValue.getPropertyAsString(sVNProperties.getSVNPropertyValue(TOKEN_LOCK_KEY));
            if (object == null) {
                SVNErrorManager.error(FSErrors.errorCorruptLockFile(string2, this), SVNLogType.FSFS);
            }
            if ((stringArray = SVNPropertyValue.getPropertyAsString(sVNProperties.getSVNPropertyValue(OWNER_LOCK_KEY))) == null) {
                SVNErrorManager.error(FSErrors.errorCorruptLockFile(string2, this), SVNLogType.FSFS);
            }
            if ((string4 = SVNPropertyValue.getPropertyAsString(sVNProperties.getSVNPropertyValue(IS_DAV_COMMENT_LOCK_KEY))) == null) {
                SVNErrorManager.error(FSErrors.errorCorruptLockFile(string2, this), SVNLogType.FSFS);
            }
            if ((string3 = SVNPropertyValue.getPropertyAsString(sVNProperties.getSVNPropertyValue(CREATION_DATE_LOCK_KEY))) == null) {
                SVNErrorManager.error(FSErrors.errorCorruptLockFile(string2, this), SVNLogType.FSFS);
            }
            Date date = SVNDate.parseDateString(string3);
            String string5 = SVNPropertyValue.getPropertyAsString(sVNProperties.getSVNPropertyValue(EXPIRATION_DATE_LOCK_KEY));
            Date date2 = null;
            if (string5 != null) {
                date2 = SVNDate.parseDateString(string5);
            }
            String string6 = SVNPropertyValue.getPropertyAsString(sVNProperties.getSVNPropertyValue(COMMENT_LOCK_KEY));
            object2 = new FSLock(string2, (String)object, (String)stringArray, string6, date, date2, "1".equals(string4));
        }
        object = SVNPropertyValue.getPropertyAsString(sVNProperties.getSVNPropertyValue(CHILDREN_LOCK_KEY));
        if (collection != null && object != null) {
            stringArray = ((String)object).split("\n");
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                collection.add(stringArray[i2]);
            }
        }
        return object2;
    }

    public File getDigestFileFromRepositoryPath(String string) {
        String string2 = this.getDigestFromRepositoryPath(string);
        File file = new File(this.getDBLocksDir(), string2.substring(0, 3));
        return new File(file, string2);
    }

    public String getDigestFromRepositoryPath(String string) {
        string = SVNPathUtil.canonicalizeAbsolutePath(string);
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(string.getBytes("UTF-8"));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "MD5 implementation not found: {0}", (Object)noSuchAlgorithmException.getLocalizedMessage());
            SVNErrorManager.error(sVNErrorMessage, noSuchAlgorithmException, SVNLogType.FSFS);
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage());
            SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.FSFS);
        }
        return SVNFileUtil.toHexDigest(messageDigest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockPath(String string, String string2, String string3, boolean bl2, boolean bl3) {
        Object object;
        string = SVNPathUtil.canonicalizeAbsolutePath(string);
        String[] stringArray = new String[]{string};
        if (!bl2 && string3 == null) {
            object = SVNErrorMessage.create(SVNErrorCode.FS_NO_USER, "Cannot unlock path ''{0}'', no authenticated username available", (Object)string);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        if (bl3 && this.isHooksEnabled()) {
            FSHooks.runPreUnlockHook(this.myRepositoryRoot, string, string3);
        }
        object = FSWriteLock.getWriteLockForDB(this);
        FSWriteLock fSWriteLock = object;
        synchronized (fSWriteLock) {
            try {
                ((FSWriteLock)object).lock();
                this.unlock(string, string2, string3, bl2);
            }
            finally {
                ((FSWriteLock)object).unlock();
                FSWriteLock.release((FSWriteLock)object);
            }
        }
        if (bl3 && this.isHooksEnabled()) {
            try {
                FSHooks.runPostUnlockHook(this.myRepositoryRoot, stringArray, string3);
            }
            catch (SVNException sVNException) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.REPOS_POST_UNLOCK_HOOK_FAILED, "Unlock succeeded, but post-unlock hook failed");
                sVNErrorMessage.setChildErrorMessage(sVNException.getErrorMessage());
                SVNErrorManager.error(sVNErrorMessage, sVNException, SVNLogType.FSFS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNLock lockPath(String string, String object, String string2, String string3, Date date, long l2, boolean bl2, boolean bl3) {
        FSWriteLock fSWriteLock;
        Object object2;
        string = SVNPathUtil.canonicalizeAbsolutePath(string);
        String[] stringArray = new String[]{string};
        if (string2 == null) {
            object2 = SVNErrorMessage.create(SVNErrorCode.FS_NO_USER, "Cannot lock path ''{0}'', no authenticated username available.", (Object)string);
            SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.FSFS);
        }
        object2 = null;
        if (this.isHooksEnabled() && (object2 = FSHooks.runPreLockHook(this.myRepositoryRoot, string, string2, string3, bl2)) != null) {
            object = object2;
        }
        SVNLock sVNLock = null;
        FSWriteLock fSWriteLock2 = fSWriteLock = FSWriteLock.getWriteLockForDB(this);
        synchronized (fSWriteLock2) {
            try {
                fSWriteLock.lock();
                sVNLock = this.lock(string, (String)object, string2, string3, date, l2, bl2, bl3);
            }
            finally {
                fSWriteLock.unlock();
                FSWriteLock.release(fSWriteLock);
            }
        }
        if (this.isHooksEnabled()) {
            try {
                FSHooks.runPostLockHook(this.myRepositoryRoot, stringArray, string2);
            }
            catch (SVNException sVNException) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.REPOS_POST_LOCK_HOOK_FAILED, "Lock succeeded, but post-lock hook failed");
                sVNErrorMessage.setChildErrorMessage(sVNException.getErrorMessage());
                SVNErrorManager.error(sVNErrorMessage, sVNException, SVNLogType.FSFS);
            }
        }
        return sVNLock;
    }

    public SVNProperties compoundMetaProperties(long l2) {
        SVNProperties sVNProperties = new SVNProperties();
        SVNProperties sVNProperties2 = this.getRevisionProperties(l2);
        String string = this.getUUID();
        String string2 = String.valueOf(l2);
        sVNProperties.put("svn:entry:last-author", sVNProperties2.getStringValue("svn:author"));
        sVNProperties.put("svn:entry:committed-date", sVNProperties2.getStringValue("svn:date"));
        sVNProperties.put("svn:entry:committed-rev", string2);
        sVNProperties.put("svn:entry:uuid", string);
        return sVNProperties;
    }

    public long getDeletedRevision(String string, long l2, long l3) {
        FSClosestCopy fSClosestCopy;
        FSID fSID;
        FSRevisionNode fSRevisionNode;
        FSRevisionRoot fSRevisionRoot;
        FSID fSID2;
        block15: {
            SVNErrorMessage sVNErrorMessage;
            if (FSRepository.isInvalidRevision(l2)) {
                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_NO_SUCH_REVISION, "Invalid start revision {0}", (Object)l2);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
            if (FSRepository.isInvalidRevision(l3)) {
                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_NO_SUCH_REVISION, "Invalid end revision {0}", (Object)l3);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
            if (l2 > l3) {
                long l4 = l3;
                l3 = l2;
                l2 = l4;
            }
            FSRevisionRoot fSRevisionRoot2 = this.createRevisionRoot(l2);
            FSRevisionNode fSRevisionNode2 = null;
            try {
                fSRevisionNode2 = fSRevisionRoot2.getRevisionNode(string);
            }
            catch (SVNException sVNException) {
                if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.FS_NOT_FOUND) {
                    return -1L;
                }
                throw sVNException;
            }
            fSID2 = fSRevisionNode2.getId();
            fSRevisionRoot = this.createRevisionRoot(l3);
            fSRevisionNode = null;
            try {
                fSRevisionNode = fSRevisionRoot.getRevisionNode(string);
            }
            catch (SVNException sVNException) {
                if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.FS_NOT_FOUND) break block15;
                throw sVNException;
            }
        }
        if (fSRevisionNode != null && fSID2.compareTo(fSID = fSRevisionNode.getId()) != -1 && ((fSClosestCopy = fSRevisionRoot.getClosestCopy(string)) == null || fSClosestCopy.getRevisionRoot() == null || fSClosestCopy.getRevisionRoot().getRevision() <= l2)) {
            return -1L;
        }
        long l5 = (l2 + l3) / 2L;
        while (true) {
            FSRevisionRoot fSRevisionRoot3 = this.createRevisionRoot(l5);
            FSRevisionNode fSRevisionNode3 = null;
            try {
                fSRevisionNode3 = fSRevisionRoot3.getRevisionNode(string);
            }
            catch (SVNException sVNException) {
                if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.FS_NOT_FOUND) {
                    l3 = l5;
                    l5 = (l2 + l3) / 2L;
                }
                throw sVNException;
            }
            if (fSRevisionNode3 == null) continue;
            FSID fSID3 = fSRevisionNode3.getId();
            int n2 = fSID2.compareTo(fSID3);
            FSClosestCopy fSClosestCopy2 = fSRevisionRoot3.getClosestCopy(string);
            if (n2 == -1 || fSClosestCopy2 != null && fSClosestCopy2.getRevisionRoot() != null && fSClosestCopy2.getRevisionRoot().getRevision() > l2) {
                l3 = l5;
                l5 = (l2 + l3) / 2L;
                continue;
            }
            if (l3 - l5 == 1L) {
                return l3;
            }
            l2 = l5;
            l5 = (l2 + l3) / 2L;
        }
    }

    public SVNLocationEntry getPreviousLocation(String string, long l2, long[] lArray) {
        FSRevisionRoot fSRevisionRoot;
        FSClosestCopy fSClosestCopy;
        if (lArray != null && lArray.length > 0) {
            lArray[0] = -1L;
        }
        if ((fSClosestCopy = (fSRevisionRoot = this.createRevisionRoot(l2)).getClosestCopy(string)) == null) {
            return null;
        }
        FSRevisionRoot fSRevisionRoot2 = fSClosestCopy.getRevisionRoot();
        if (fSRevisionRoot2 == null) {
            return null;
        }
        String string2 = fSClosestCopy.getPath();
        FSRevisionNode fSRevisionNode = fSRevisionRoot2.getRevisionNode(string2);
        String string3 = fSRevisionNode.getCopyFromPath();
        long l3 = fSRevisionNode.getCopyFromRevision();
        String string4 = "";
        if (!string.equals(string2) && (string4 = string.substring(string2.length())).startsWith("/")) {
            string4 = string4.substring(1);
        }
        String string5 = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(string3, string4));
        if (lArray != null && lArray.length > 0) {
            lArray[0] = fSRevisionRoot2.getRevision();
        }
        return new SVNLocationEntry(l3, string5);
    }

    public String getNodeOrigin(String string) {
        SVNProperties sVNProperties = this.getNodeOriginsFromFile(string);
        if (sVNProperties != null) {
            return sVNProperties.getStringValue(string);
        }
        return null;
    }

    public void setNodeOrigin(String string, FSID fSID) {
        Serializable serializable;
        File file = this.getNodeOriginsDir();
        this.ensureDirExists(file, true);
        SVNProperties sVNProperties = this.getNodeOriginsFromFile(string);
        if (sVNProperties == null) {
            sVNProperties = new SVNProperties();
        }
        String string2 = sVNProperties.getStringValue(string);
        String string3 = fSID.toString();
        if (string2 != null && !string3.equals(string2)) {
            serializable = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Node origin for ''{0}'' exists with a different value ({1}) than what we were about to store ({2})", string, string2, string3);
            SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.FSFS);
        }
        sVNProperties.put(string, string3);
        serializable = this.getNodeOriginFile(string);
        File file2 = SVNFileUtil.createUniqueFile(serializable.getParentFile(), serializable.getName(), ".tmp", false);
        SVNWCProperties.setProperties(sVNProperties, serializable, file2, "END");
    }

    public boolean supportsMergeInfo() {
        return this.myDBFormat >= 3;
    }

    public void readOptions(FSFile fSFile, int n2) {
        this.myMaxFilesPerDirectory = 0L;
        this.myUseLogAddressing = false;
        while (true) {
            Object object;
            String string = null;
            try {
                string = fSFile.readLine(80);
            }
            catch (SVNException sVNException) {
                if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.STREAM_UNEXPECTED_EOF) break;
            }
            if (n2 >= 3 && string.startsWith("layout ")) {
                object = string.substring(7);
                if (((String)object).equals("linear")) {
                    this.myMaxFilesPerDirectory = 0L;
                    continue;
                }
                if (((String)object).startsWith("sharded ")) {
                    object = ((String)object).substring(8);
                    try {
                        this.myMaxFilesPerDirectory = Long.parseLong((String)object);
                    }
                    catch (NumberFormatException numberFormatException) {
                        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.BAD_VERSION_FILE_FORMAT, "Format file ''{0}'' contains an unexpected non-digit", (Object)fSFile.getFile());
                        SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
                    }
                    continue;
                }
            }
            if (n2 >= 7 && string.startsWith("addressing ")) {
                object = string.substring(11);
                if (((String)object).equals("physical")) {
                    this.myUseLogAddressing = false;
                    continue;
                }
                if (((String)object).equals("logical")) {
                    this.myUseLogAddressing = true;
                    continue;
                }
            }
            object = SVNErrorMessage.create(SVNErrorCode.BAD_VERSION_FILE_FORMAT, "''{0}'' contains invalid filesystem format option ''{1}''", fSFile.getFile(), string);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
    }

    public IFSRepresentationCacheManager getRepositoryCacheManager() {
        return this.myReposCacheManager;
    }

    public static File findRepositoryRoot(File file) {
        if (file == null) {
            file = new File("");
        }
        File file2 = file;
        while (!FSFS.isRepositoryRoot(file2)) {
            if ((file2 = file2.getParentFile()) != null) continue;
            return null;
        }
        return file2;
    }

    public static String findRepositoryRoot(String string, String string2) {
        if (string2 == null) {
            string2 = "";
        }
        String string3 = string != null ? SVNPathUtil.append("\\\\" + string, string2) : string2;
        string3 = string3.replaceFirst("\\|", "\\:");
        File file = new File(string3).getAbsoluteFile();
        while (!FSFS.isRepositoryRoot(file)) {
            if (file.getParentFile() == null) {
                return null;
            }
            string2 = SVNPathUtil.removeTail(string2);
            file = file.getParentFile();
        }
        while (string2.endsWith("/")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        while (string2.endsWith("\\")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    public static long getDefaultMaxFilesPerDirectory() {
        return DEFAULT_MAX_FILES_PER_DIRECTORY;
    }

    public static void setDefaultMaxFilesPerDirectory(long l2) {
        DEFAULT_MAX_FILES_PER_DIRECTORY = l2;
    }

    public boolean isPackedRevision(long l2) {
        return l2 < this.myMinUnpackedRevision;
    }

    public long getPackedBaseRevision(long l2) {
        return this.isPackedRevision(l2) ? l2 - l2 % this.getMaxFilesPerDirectory() : l2;
    }

    protected File getNodeOriginFile(String string) {
        String string2 = string.length() == 1 ? "0" : string.substring(0, string.length() - 1);
        return new File(this.getNodeOriginsDir(), string2);
    }

    protected FSFile getTransactionRevisionPrototypeFile(String string) {
        File file = this.getTransactionProtoRevFile(string);
        return new FSFile(file);
    }

    protected FSFile getTransactionChangesFile(String string) {
        File file = new File(this.getTransactionDir(string), "changes");
        return new FSFile(file);
    }

    protected FSFile getTransactionRevisionNodeChildrenFile(FSID fSID) {
        File file = new File(this.getTransactionDir(fSID.getTxnID()), PATH_PREFIX_NODE + fSID.getNodeID() + "." + fSID.getCopyID() + TXN_PATH_EXT_CHILDREN);
        return new FSFile(file);
    }

    protected FSFile getRevisionFSFile(long l2) {
        File file = this.getRevisionFile(l2);
        if (!file.exists()) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_NO_SUCH_REVISION, "No such revision {0}", (Object)String.valueOf(l2));
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        return new FSFile(file);
    }

    protected FSFile getPackOrRevisionFSFile(long l2) {
        File file = this.getAbsoluteRevisionPath(l2);
        if (!file.exists()) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_NO_SUCH_REVISION, "No such revision {0}", (Object)String.valueOf(l2));
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        return new FSFile(file);
    }

    protected File getAbsoluteRevisionPath(long l2) {
        if (!this.isPackedRevision(l2)) {
            File file = this.getRevisionFile(l2);
            if (file.exists()) {
                return file;
            }
            this.getMinUnpackedRev();
            if (!this.isPackedRevision(l2)) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_NO_SUCH_REVISION, "Revision file ''{0}'' does not exist, and r{1} is not packed", file, String.valueOf(l2));
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
        }
        return this.getPackedRevPath(l2, PACK_KIND_PACK);
    }

    protected FSFile getTransactionRevisionNodePropertiesFile(FSID fSID) {
        File file = new File(this.getTransactionDir(fSID.getTxnID()), PATH_PREFIX_NODE + fSID.getNodeID() + "." + fSID.getCopyID() + TXN_PATH_EXT_PROPS);
        return new FSFile(file);
    }

    protected File getPackedRevPath(long l2, String string) {
        SVNErrorManager.assertionFailure(this.myMaxFilesPerDirectory > 0L, "max files per directory is 0 or negative: " + String.valueOf(this.myMaxFilesPerDirectory), SVNLogType.FSFS);
        SVNErrorManager.assertionFailure(this.isPackedRevision(l2), "revision " + String.valueOf(l2) + " is not packed", SVNLogType.FSFS);
        File file = new File(this.getDBRevsDir(), l2 / this.myMaxFilesPerDirectory + PACK_EXT);
        file = new File(file, string);
        return file;
    }

    protected File getPackedRevPropsShardPath(long l2) {
        return new File(this.getRevisionPropertiesRoot(), l2 / this.myMaxFilesPerDirectory + PACK_EXT);
    }

    protected File getPackDir(long l2) {
        return new File(this.getDBRevsDir(), l2 + PACK_EXT);
    }

    protected File getPackFile(long l2) {
        return new File(this.getPackDir(l2), PACK_KIND_PACK);
    }

    protected File getManifestFile(long l2) {
        return new File(this.getPackDir(l2), "manifest");
    }

    protected File getRevisionFile(long l2) {
        SVNErrorManager.assertionFailure(!this.isPackedRevision(l2), "revision " + String.valueOf(l2) + " is not expected to be packed", SVNLogType.FSFS);
        File file = null;
        if (this.myMaxFilesPerDirectory > 0L) {
            File file2 = new File(this.getDBRevsDir(), String.valueOf(l2 / this.myMaxFilesPerDirectory));
            file = new File(file2, String.valueOf(l2));
        } else {
            file = new File(this.getDBRevsDir(), String.valueOf(l2));
        }
        return file;
    }

    protected File getMinUnpackedRevFile() {
        if (this.myMinUnpackedRevFile == null) {
            this.myMinUnpackedRevFile = new File(this.getDBRoot(), "min-unpacked-rev");
        }
        return this.myMinUnpackedRevFile;
    }

    protected File getTransactionCurrentFile() {
        if (this.myTransactionCurrentFile == null) {
            this.myTransactionCurrentFile = new File(this.getDBRoot(), TXN_CURRENT_FILE);
        }
        return this.myTransactionCurrentFile;
    }

    protected File getTransactionCurrentLockFile() {
        if (this.myTransactionCurrentLockFile == null) {
            this.myTransactionCurrentLockFile = new File(this.getDBRoot(), TXN_CURRENT_LOCK_FILE);
        }
        return this.myTransactionCurrentLockFile;
    }

    public File getConfigFile() {
        return new File(this.getDBRoot(), PATH_CONFIG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeCurrentFile(long l2, String string, String string2) {
        String string3 = null;
        string3 = this.getDBFormat() >= 3 ? l2 + "\n" : l2 + " " + string + " " + string2 + "\n";
        File file = this.getCurrentFile();
        File file2 = SVNFileUtil.createUniqueFile(file.getParentFile(), file.getName(), ".tmp", false);
        OutputStream outputStream = null;
        try {
            outputStream = SVNFileUtil.openFileForWriting(file2);
            outputStream.write(string3.getBytes("US-ASCII"));
        }
        finally {
            SVNFileUtil.closeFile(outputStream);
        }
        SVNFileUtil.rename(file2, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getPackedOffset(long l2) {
        Object object;
        File file = this.getPackedRevPath(l2, "manifest");
        BufferedReader bufferedReader = null;
        LinkedList<Long> linkedList = new LinkedList<Long>();
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(SVNFileUtil.openFileForReading(file)));
            object = null;
            while ((object = bufferedReader.readLine()) != null) {
                Long l3 = null;
                try {
                    l3 = Long.valueOf((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT);
                    SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
                }
                linkedList.add(l3);
            }
        }
        catch (IOException iOException) {
            try {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getMessage());
                SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.FSFS);
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(bufferedReader);
                throw throwable;
            }
            SVNFileUtil.closeFile(bufferedReader);
        }
        SVNFileUtil.closeFile(bufferedReader);
        object = (Long)linkedList.get((int)(l2 % this.myMaxFilesPerDirectory));
        SVNErrorManager.assertionFailure(object != null, "offset for revision " + String.valueOf(l2) + " is null", SVNLogType.FSFS);
        return (Long)object;
    }

    private SVNConfigFile loadConfig() {
        File file = this.getConfigFile();
        if (this.myDBFormat < 4 || !file.exists()) {
            return null;
        }
        this.myConfig = new SVNConfigFile(file);
        return this.myConfig;
    }

    private void ensureRevisionsExists(long l2) {
        SVNErrorMessage sVNErrorMessage;
        if (FSRepository.isInvalidRevision(l2)) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_NO_SUCH_REVISION, "Invalid revision number ''{0}''", (Object)l2);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        if (l2 <= this.myYoungestRevisionCache) {
            return;
        }
        this.getYoungestRevision();
        if (l2 <= this.myYoungestRevisionCache) {
            return;
        }
        sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_NO_SUCH_REVISION, "No such revision {0}", (Object)String.valueOf(l2));
        SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
    }

    private SVNProperties getNodeOriginsFromFile(String string) {
        File file = this.getNodeOriginFile(string);
        if (!file.exists()) {
            return null;
        }
        FSFile fSFile = new FSFile(file);
        return fSFile.readProperties(false, true);
    }

    private void unlock(String string, String string2, String string3, boolean bl2) {
        SVNLock sVNLock = this.getLock(string, true, true);
        if (!bl2) {
            if (string2 == null || !string2.equals(sVNLock.getID())) {
                SVNErrorManager.error(FSErrors.errorNoSuchLock(sVNLock.getPath(), this), SVNLogType.FSFS);
            }
            if (string3 == null || "".equals(string3)) {
                SVNErrorManager.error(FSErrors.errorNoUser(this), SVNLogType.FSFS);
            }
            if (!string3.equals(sVNLock.getOwner())) {
                SVNErrorManager.error(FSErrors.errorLockOwnerMismatch(string3, sVNLock.getOwner(), this), SVNLogType.FSFS);
            }
        }
        this.deleteLock(sVNLock);
    }

    private SVNLock lock(String string, String string2, String string3, String string4, Date date, long l2, boolean bl2, boolean bl3) {
        SVNLock sVNLock;
        long l3 = this.getYoungestRevision();
        FSRevisionRoot fSRevisionRoot = this.createRevisionRoot(l3);
        SVNNodeKind sVNNodeKind = fSRevisionRoot.checkNodeKind(string);
        if (string2 != null) {
            if (!string2.startsWith(SVN_OPAQUE_LOCK_TOKEN)) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_BAD_LOCK_TOKEN, "Lock token URI ''{0}'' has bad scheme; expected ''opaquelocktoken''", (Object)string2);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
            for (int i2 = 0; i2 < string2.length(); ++i2) {
                if (string2.charAt(i2) <= '\u00ff') continue;
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_BAD_LOCK_TOKEN, "Lock token ''{0}'' is not ASCII at byte ''{1}''", new Object[]{string2, i2});
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
            if (!SVNEncodingUtil.isXMLSafe(string2)) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_BAD_LOCK_TOKEN, "Lock token URI ''{0}'' is not XML-safe", (Object)string2);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
        }
        if (sVNNodeKind == SVNNodeKind.DIR) {
            SVNErrorManager.error(FSErrors.errorNotFile(string, this), SVNLogType.FSFS);
        } else if (sVNNodeKind == SVNNodeKind.NONE) {
            if (l2 >= 0L) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_OUT_OF_DATE, "Path ''{0}'' doesn''t exist in HEAD revision", (Object)string);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            } else {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "Path ''{0}'' doesn''t exist in HEAD revision", (Object)string);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
        }
        if (string3 == null || "".equals(string3)) {
            SVNErrorManager.error(FSErrors.errorNoUser(this), SVNLogType.FSFS);
        }
        if (FSRepository.isValidRevision(l2)) {
            SVNErrorMessage sVNErrorMessage;
            FSRevisionNode fSRevisionNode = fSRevisionRoot.getRevisionNode(string);
            long l4 = fSRevisionNode.getCreatedRevision();
            if (FSRepository.isInvalidRevision(l4)) {
                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_OUT_OF_DATE, "Path ''{0}'' doesn''t exist in HEAD revision", (Object)string);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
            if (l2 < l4) {
                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_OUT_OF_DATE, "Lock failed: newer version of ''{0}'' exists", (Object)string);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
        }
        if ((sVNLock = this.getLockHelper(string, true)) != null) {
            if (!bl2) {
                SVNErrorManager.error(FSErrors.errorPathAlreadyLocked(sVNLock.getPath(), sVNLock.getOwner(), this), SVNLogType.FSFS);
            } else {
                this.deleteLock(sVNLock);
            }
        }
        FSLock fSLock = null;
        if (string2 == null) {
            string2 = FSRepositoryUtil.generateLockToken();
            fSLock = new FSLock(string, string2, string3, string4, new Date(System.currentTimeMillis()), date, bl3);
        } else {
            fSLock = new FSLock(string, string2, string3, string4, new Date(System.currentTimeMillis()), date, bl3);
        }
        this.setLock(fSLock, bl3);
        return fSLock;
    }

    private void setLock(SVNLock sVNLock, boolean bl2) {
        Object object;
        if (sVNLock == null) {
            object = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "FATAL error: attempted to set a null lock");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        object = "";
        String string = sVNLock.getPath();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (true) {
            String string2 = this.getDigestFromRepositoryPath(string);
            SVNLock sVNLock2 = this.fetchLockFromDigestFile(null, string, arrayList);
            if (sVNLock != null) {
                sVNLock2 = sVNLock;
                sVNLock = null;
                object = string2;
            } else {
                if (!arrayList.isEmpty() && arrayList.contains(object)) break;
                arrayList.add(object);
            }
            this.writeDigestLockFile(sVNLock2, arrayList, string, bl2);
            if ("/".equals(string)) break;
            if ("".equals(string = SVNPathUtil.removeTail(string))) {
                string = "/";
            }
            arrayList.clear();
        }
    }

    private boolean ensureDirExists(File file, boolean bl2) {
        if (!file.exists() && bl2) {
            return file.mkdirs();
        }
        return file.exists();
    }

    private void writeDigestLockFile(SVNLock sVNLock, Collection collection, String string, boolean bl2) {
        Serializable serializable;
        Object object;
        Serializable serializable2;
        Serializable serializable3;
        if (!this.ensureDirExists(this.getDBLocksDir(), true)) {
            serializable3 = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "Can''t create a directory at ''{0}''", (Object)this.getDBLocksDir());
            SVNErrorManager.error((SVNErrorMessage)serializable3, SVNLogType.FSFS);
        }
        serializable3 = this.getDigestFileFromRepositoryPath(string);
        String string2 = this.getDigestFromRepositoryPath(string);
        File file = new File(this.getDBLocksDir(), string2.substring(0, 3));
        if (!this.ensureDirExists(file, true)) {
            serializable2 = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "Can't create a directory at ''{0}''", (Object)file);
            SVNErrorManager.error((SVNErrorMessage)serializable2, SVNLogType.FSFS);
        }
        serializable2 = new SVNProperties();
        if (sVNLock != null) {
            ((SVNProperties)serializable2).put(PATH_LOCK_KEY, sVNLock.getPath());
            ((SVNProperties)serializable2).put(OWNER_LOCK_KEY, sVNLock.getOwner());
            ((SVNProperties)serializable2).put(TOKEN_LOCK_KEY, sVNLock.getID());
            object = bl2 ? "1" : "0";
            ((SVNProperties)serializable2).put(IS_DAV_COMMENT_LOCK_KEY, (String)object);
            if (sVNLock.getComment() != null) {
                ((SVNProperties)serializable2).put(COMMENT_LOCK_KEY, sVNLock.getComment());
            }
            if (sVNLock.getCreationDate() != null) {
                ((SVNProperties)serializable2).put(CREATION_DATE_LOCK_KEY, SVNDate.formatDate(sVNLock.getCreationDate()));
            }
            if (sVNLock.getExpirationDate() != null) {
                ((SVNProperties)serializable2).put(EXPIRATION_DATE_LOCK_KEY, SVNDate.formatDate(sVNLock.getExpirationDate()));
            }
        }
        if (collection != null && collection.size() > 0) {
            object = collection.toArray();
            serializable = new StringBuffer();
            for (int i2 = 0; i2 < ((Object[])object).length; ++i2) {
                ((StringBuffer)serializable).append(object[i2]);
                ((StringBuffer)serializable).append('\n');
            }
            ((SVNProperties)serializable2).put(CHILDREN_LOCK_KEY, ((StringBuffer)serializable).toString());
        }
        try {
            SVNWCProperties.setProperties((SVNProperties)serializable2, (File)serializable3, SVNFileUtil.createUniqueFile(((File)serializable3).getParentFile(), ((File)serializable3).getName(), ".tmp", false), "END");
        }
        catch (SVNException sVNException) {
            serializable = sVNException.getErrorMessage().wrap("Cannot write lock/entries hashfile ''{0}''", serializable3);
            SVNErrorManager.error((SVNErrorMessage)serializable, sVNException, SVNLogType.FSFS);
        }
    }

    private FSFile openAndSeekTransaction(FSRepresentation fSRepresentation) {
        FSFile fSFile = this.getTransactionRevisionPrototypeFile(fSRepresentation.getTxnId());
        long l2 = fSRepresentation.getItemIndex();
        long l3 = this.isUseLogAddressing() ? this.lookupOffsetInProtoIndex(fSFile, fSRepresentation.getTxnId(), l2) : l2;
        fSFile.seek(l3);
        return fSFile;
    }

    private FSFile openAndSeekRevision(long l2, long l3) {
        long l4;
        this.ensureRevisionsExists(l2);
        FSFile fSFile = this.getPackOrRevisionFSFile(l2);
        if (this.isUseLogAddressing()) {
            l4 = this.lookupOffsetInIndex(fSFile, l2, l3);
        } else {
            if (this.isPackedRevision(l2)) {
                long l5 = this.getPackedOffset(l2);
                l3 += l5;
            }
            l4 = l3;
        }
        fSFile.seek(l4);
        return fSFile;
    }

    protected long lookupOffsetInIndex(FSFile fSFile, long l2, long l3) {
        FSLogicalAddressingIndex fSLogicalAddressingIndex = new FSLogicalAddressingIndex(this, fSFile);
        return fSLogicalAddressingIndex.getOffsetByItemIndex(l2, l3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long lookupOffsetInProtoIndex(FSFile fSFile, String string, long l2) {
        try (FSL2PProtoIndex fSL2PProtoIndex = null;){
            fSL2PProtoIndex = FSL2PProtoIndex.open(this, string, false);
            assert (fSL2PProtoIndex != null);
            long l3 = fSL2PProtoIndex.getOffsetByItemIndex(l2);
            return l3;
        }
    }

    private Map parsePlainRepresentation(SVNProperties sVNProperties, boolean bl2) {
        SVNHashMap sVNHashMap = new SVNHashMap();
        for (String string : sVNProperties.nameSet()) {
            String string2 = sVNProperties.getStringValue(string);
            if (string2 == null && bl2) continue;
            FSEntry fSEntry = this.parseRepEntryValue(string, string2);
            if (fSEntry == null) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Directory entry corrupt");
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
            sVNHashMap.put(string, fSEntry);
        }
        return sVNHashMap;
    }

    private FSEntry parseRepEntryValue(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        int n2 = string2.indexOf(32);
        if (n2 == -1) {
            return null;
        }
        String string3 = string2.substring(0, n2);
        String string4 = string2.substring(n2 + 1);
        SVNNodeKind sVNNodeKind = SVNNodeKind.parseKind(string3);
        FSID fSID = FSID.fromString(string4);
        if (sVNNodeKind != SVNNodeKind.DIR && sVNNodeKind != SVNNodeKind.FILE || fSID == null) {
            return null;
        }
        return new FSEntry(fSID, sVNNodeKind, string);
    }

    private Date getRevisionTime(long l2) {
        SVNProperties sVNProperties = this.getRevisionProperties(l2);
        String string = sVNProperties.getStringValue("svn:date");
        if (string == null) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_GENERAL, "Failed to find time on revision {0}", (Object)l2);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        return SVNDate.parseDateString(string);
    }

    private static boolean isRepositoryRoot(File file) {
        File file2 = new File(file, "format");
        SVNFileType sVNFileType = SVNFileType.getType(file2);
        if (sVNFileType != SVNFileType.FILE) {
            return false;
        }
        File file3 = new File(file, DB_DIR);
        sVNFileType = SVNFileType.getType(file3);
        return sVNFileType == SVNFileType.DIRECTORY || sVNFileType == SVNFileType.SYMLINK;
    }

    public File getRevisionPropertiesDbPath() {
        return SVNFileUtil.createFilePath(this.getRevisionPropertiesRoot(), REVISION_PROPERTIES_DB);
    }

    public File getMinUnpackedRevPropPath() {
        return SVNFileUtil.createFilePath(this.getDBRoot(), "min-unpacked-rev");
    }

    public void updateMinUnpackedRevProp() {
        this.myMinUnpackedRevProp = this.getMinUnpackedRevProp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMinUnpackedRevProp() {
        try (FSFile fSFile = new FSFile(this.getMinUnpackedRevPropPath());){
            long l2 = fSFile.readLong();
            return l2;
        }
    }

    public boolean isCompressPackedRevprops() {
        return this.myCompressPackedRevprops;
    }
}

