/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.File;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSID;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionRoot;

public class FSErrors {
    public static SVNErrorMessage errorDanglingId(FSID fSID, FSFS fSFS) {
        File file = fSFS.getDBRoot();
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_ID_NOT_FOUND, "Reference to non-existent node ''{0}'' in filesystem ''{1}''", fSID, file);
        return sVNErrorMessage;
    }

    public static SVNErrorMessage errorTxnNotMutable(String string, FSFS fSFS) {
        File file = fSFS.getDBRoot();
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_TRANSACTION_NOT_MUTABLE, "Cannot modify transaction named ''{0}'' in filesystem ''{1}''", string, file);
        return sVNErrorMessage;
    }

    public static SVNErrorMessage errorNotMutable(long l2, String string, FSFS fSFS) {
        File file = fSFS.getDBRoot();
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_NOT_MUTABLE, "File is not mutable: filesystem ''{0}'', revision {1}, path ''{2}''", file, l2, string);
        return sVNErrorMessage;
    }

    public static SVNErrorMessage errorNotFound(FSRoot fSRoot, String string) {
        SVNErrorMessage sVNErrorMessage;
        if (fSRoot instanceof FSTransactionRoot) {
            FSTransactionRoot fSTransactionRoot = (FSTransactionRoot)fSRoot;
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "File not found: transaction ''{0}'', path ''{1}''", fSTransactionRoot.getTxnID(), string);
        } else {
            FSRevisionRoot fSRevisionRoot = (FSRevisionRoot)fSRoot;
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "File not found: revision {0}, path ''{1}''", fSRevisionRoot.getRevision(), string);
        }
        return sVNErrorMessage;
    }

    public static SVNErrorMessage errorNotDirectory(String string, FSFS fSFS) {
        File file = fSFS.getDBRoot();
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_NOT_DIRECTORY, "''{0}'' is not a directory in filesystem ''{1}''", string, file);
        return sVNErrorMessage;
    }

    public static SVNErrorMessage errorCorruptLockFile(String string, FSFS fSFS) {
        File file = fSFS.getDBRoot();
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Corrupt lockfile for path ''{0}'' in filesystem ''{1}''", string, file);
        return sVNErrorMessage;
    }

    public static SVNErrorMessage errorOutOfDate(String string, SVNNodeKind sVNNodeKind) {
        if ("/".equals(string)) {
            string = "";
        }
        SVNErrorMessage sVNErrorMessage = null;
        sVNErrorMessage = sVNNodeKind == SVNNodeKind.DIR ? SVNErrorMessage.create(SVNErrorCode.FS_TXN_OUT_OF_DATE, "Directory ''{0}'' is out of date", (Object)string) : SVNErrorMessage.create(SVNErrorCode.FS_TXN_OUT_OF_DATE, "File ''{0}'' is out of date", (Object)string);
        return sVNErrorMessage;
    }

    public static SVNErrorMessage errorAlreadyExists(FSRoot fSRoot, String string, FSFS fSFS) {
        File file = fSFS.getDBRoot();
        SVNErrorMessage sVNErrorMessage = null;
        if (fSRoot instanceof FSTransactionRoot) {
            FSTransactionRoot fSTransactionRoot = (FSTransactionRoot)fSRoot;
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_ALREADY_EXISTS, "File already exists: filesystem ''{0}'', transaction ''{1}'', path ''{2}''", file, fSTransactionRoot.getTxnID(), string);
        } else {
            FSRevisionRoot fSRevisionRoot = (FSRevisionRoot)fSRoot;
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_ALREADY_EXISTS, "File already exists: filesystem ''{0}'', revision {1}, path ''{2}''", file, fSRevisionRoot.getRevision(), string);
        }
        return sVNErrorMessage;
    }

    public static SVNErrorMessage errorNotTxn() {
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_NOT_TXN_ROOT, "Root object must be a transaction root");
        return sVNErrorMessage;
    }

    public static SVNErrorMessage errorConflict(String string, StringBuffer stringBuffer) {
        if (stringBuffer != null) {
            stringBuffer.delete(0, stringBuffer.length());
            stringBuffer.append(string);
        }
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_CONFLICT, "Conflict at ''{0}''", (Object)string);
        return sVNErrorMessage;
    }

    public static SVNErrorMessage errorNoSuchLock(String string, FSFS fSFS) {
        File file = fSFS.getDBRoot();
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_NO_SUCH_LOCK, "No lock on path ''{0}'' in filesystem ''{1}''", string, file);
        return sVNErrorMessage;
    }

    public static SVNErrorMessage errorLockExpired(String string, FSFS fSFS) {
        File file = fSFS.getDBRoot();
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_LOCK_EXPIRED, "Lock has expired:  lock-token ''{0}'' in filesystem ''{1}''", string, file);
        return sVNErrorMessage;
    }

    public static SVNErrorMessage errorNoUser(FSFS fSFS) {
        File file = fSFS.getDBRoot();
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_NO_USER, "No username is currently associated with filesystem ''{0}''", (Object)file);
        return sVNErrorMessage;
    }

    public static SVNErrorMessage errorLockOwnerMismatch(String string, String string2, FSFS fSFS) {
        File file = fSFS.getDBRoot();
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_LOCK_OWNER_MISMATCH, "User ''{0}'' is trying to use a lock owned by ''{1}'' in filesystem ''{2}''", string, string2, file);
        return sVNErrorMessage;
    }

    public static SVNErrorMessage errorNotFile(String string, FSFS fSFS) {
        File file = fSFS.getDBRoot();
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FILE, "''{0}'' is not a file in filesystem ''{1}''", string, file);
        return sVNErrorMessage;
    }

    public static SVNErrorMessage errorPathAlreadyLocked(String string, String string2, FSFS fSFS) {
        File file = fSFS.getDBRoot();
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_PATH_ALREADY_LOCKED, "Path ''{0}'' is already locked by user ''{1}'' in filesystem ''{2}''", string, string2, file);
        return sVNErrorMessage;
    }

    public static boolean isLockError(SVNErrorMessage sVNErrorMessage) {
        if (sVNErrorMessage == null) {
            return false;
        }
        SVNErrorCode sVNErrorCode = sVNErrorMessage.getErrorCode();
        return sVNErrorCode == SVNErrorCode.FS_PATH_ALREADY_LOCKED || sVNErrorCode == SVNErrorCode.FS_NOT_FOUND || sVNErrorCode == SVNErrorCode.FS_BAD_LOCK_TOKEN || sVNErrorCode == SVNErrorCode.FS_OUT_OF_DATE;
    }

    public static boolean isUnlockError(SVNErrorMessage sVNErrorMessage) {
        if (sVNErrorMessage == null) {
            return false;
        }
        SVNErrorCode sVNErrorCode = sVNErrorMessage.getErrorCode();
        return sVNErrorCode == SVNErrorCode.FS_PATH_NOT_LOCKED || sVNErrorCode == SVNErrorCode.FS_BAD_LOCK_TOKEN || sVNErrorCode == SVNErrorCode.FS_LOCK_OWNER_MISMATCH || sVNErrorCode == SVNErrorCode.FS_NO_SUCH_LOCK || sVNErrorCode == SVNErrorCode.RA_NOT_LOCKED || sVNErrorCode == SVNErrorCode.FS_LOCK_EXPIRED;
    }
}

