/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaCombiner;
import org.tmatesoft.svn.core.internal.io.fs.FSCommitter;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSInputStream;
import org.tmatesoft.svn.core.internal.io.fs.FSOutputStream;
import org.tmatesoft.svn.core.internal.io.fs.FSParentPath;
import org.tmatesoft.svn.core.internal.io.fs.FSPathChangeKind;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionRoot;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.ISVNDeltaConsumer;
import org.tmatesoft.svn.core.io.diff.SVNDeltaProcessor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.util.SVNLogType;

public class FSDeltaConsumer
implements ISVNDeltaConsumer {
    private String myBasePath;
    private FSTransactionRoot myTxnRoot;
    private FSFS myFSFS;
    private FSCommitter myCommitter;
    private SVNDeltaProcessor myDeltaProcessor;
    private FSOutputStream myTargetStream;
    private String myAuthor;
    private Collection myLockTokens;
    private SVNDeltaCombiner myDeltaCombiner;
    private boolean myIsComputeChecksum;
    private String myComputedChecksum;

    public FSDeltaConsumer(String string, FSTransactionRoot fSTransactionRoot, FSFS fSFS, FSCommitter fSCommitter, String string2, Collection collection) {
        this.myBasePath = string;
        this.myTxnRoot = fSTransactionRoot;
        this.myFSFS = fSFS;
        this.myCommitter = fSCommitter;
        this.myAuthor = string2;
        this.myLockTokens = collection != null ? collection : Collections.EMPTY_LIST;
    }

    @Override
    public void applyTextDelta(String string, String string2) {
        Object object;
        Object object2;
        String string3 = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(this.myBasePath, string));
        FSParentPath fSParentPath = this.myTxnRoot.openPath(string3, true, true);
        if ((this.myTxnRoot.getTxnFlags() & 2) != 0) {
            this.myCommitter.allowLockedOperation(this.myFSFS, string3, this.myAuthor, this.myLockTokens, false, false);
        }
        this.myCommitter.makePathMutable(fSParentPath, string3);
        FSRevisionNode fSRevisionNode = fSParentPath.getRevNode();
        if (string2 != null && (object2 = fSRevisionNode.getFileMD5Checksum()) != null && !((String)object2).equals(string2)) {
            object = SVNErrorMessage.create(SVNErrorCode.CHECKSUM_MISMATCH, "Base checksum mismatch on ''{0}'':\n   expected:  {1}\n     actual:  {2}\n", string, string2, object2);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        object2 = null;
        object = null;
        try {
            object2 = FSInputStream.createDeltaStream(this.getCombiner(), fSRevisionNode, this.myFSFS);
            object = FSOutputStream.createStream(fSRevisionNode, this.myTxnRoot, (OutputStream)this.myTargetStream, this.myFSFS.getDeltaCompression());
            if (this.myDeltaProcessor == null) {
                this.myDeltaProcessor = new SVNDeltaProcessor();
            }
            this.myDeltaProcessor.applyTextDelta((InputStream)object2, (OutputStream)object, this.myIsComputeChecksum);
        }
        catch (SVNException sVNException) {
            SVNFileUtil.closeFile((InputStream)object2);
            throw sVNException;
        }
        finally {
            this.myTargetStream = (FSOutputStream)object;
        }
        this.myCommitter.addChange(string3, fSRevisionNode.getId(), FSPathChangeKind.FS_PATH_CHANGE_MODIFY, true, false, false, -1L, null, SVNNodeKind.FILE);
    }

    public void applyText(String string) {
        String string2 = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(this.myBasePath, string));
        FSParentPath fSParentPath = this.myTxnRoot.openPath(string2, true, true);
        if ((this.myTxnRoot.getTxnFlags() & 2) != 0) {
            this.myCommitter.allowLockedOperation(this.myFSFS, string2, this.myAuthor, this.myLockTokens, false, false);
        }
        this.myCommitter.makePathMutable(fSParentPath, string2);
        FSRevisionNode fSRevisionNode = fSParentPath.getRevNode();
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = SVNFileUtil.DUMMY_IN;
            outputStream = FSOutputStream.createStream(fSRevisionNode, this.myTxnRoot, (OutputStream)this.myTargetStream, this.myFSFS.getDeltaCompression());
            if (this.myDeltaProcessor == null) {
                this.myDeltaProcessor = new SVNDeltaProcessor();
            }
            this.myDeltaProcessor.applyTextDelta(inputStream, outputStream, false);
        }
        catch (SVNException sVNException) {
            throw sVNException;
        }
        finally {
            this.myTargetStream = (FSOutputStream)outputStream;
        }
        this.myCommitter.addChange(string2, fSRevisionNode.getId(), FSPathChangeKind.FS_PATH_CHANGE_MODIFY, true, false, false, -1L, null, SVNNodeKind.FILE);
    }

    @Override
    public OutputStream textDeltaChunk(String string, SVNDiffWindow sVNDiffWindow) {
        return this.myDeltaProcessor.textDeltaChunk(sVNDiffWindow);
    }

    @Override
    public void textDeltaEnd(String string) {
        this.myComputedChecksum = this.myDeltaProcessor.textDeltaEnd();
    }

    public String getChecksum() {
        return this.myComputedChecksum;
    }

    public void close() {
        this.abort();
    }

    public void abort() {
        if (this.myTargetStream != null) {
            try {
                this.myTargetStream.closeStreams();
            }
            catch (IOException iOException) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
        }
    }

    public void setComputeChecksum(boolean bl2) {
        this.myIsComputeChecksum = bl2;
    }

    private SVNDeltaCombiner getCombiner() {
        if (this.myDeltaCombiner == null) {
            this.myDeltaCombiner = new SVNDeltaCombiner();
        } else {
            this.myDeltaCombiner.reset();
        }
        return this.myDeltaCombiner;
    }
}

