/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.io.fs.CountingOutputStream;
import org.tmatesoft.svn.core.internal.io.fs.FSCommitter$1;
import org.tmatesoft.svn.core.internal.io.fs.FSCommitter$2;
import org.tmatesoft.svn.core.internal.io.fs.FSEntry;
import org.tmatesoft.svn.core.internal.io.fs.FSErrors;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSHooks;
import org.tmatesoft.svn.core.internal.io.fs.FSID;
import org.tmatesoft.svn.core.internal.io.fs.FSParentPath;
import org.tmatesoft.svn.core.internal.io.fs.FSPathChange;
import org.tmatesoft.svn.core.internal.io.fs.FSPathChangeKind;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.io.fs.FSRepresentation;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionInfo;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSWriteLock;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class FSCommitter {
    private static volatile boolean ourAutoUnlock;
    private FSFS myFSFS;
    private FSTransactionRoot myTxnRoot;
    private FSTransactionInfo myTxn;
    private Collection myLockTokens;
    private Map myAutoUnlockPaths;
    private String myAuthor;

    public static synchronized void setAutoUnlock(boolean bl2) {
        ourAutoUnlock = bl2;
    }

    public static synchronized boolean isAutoUnlock() {
        return ourAutoUnlock;
    }

    public FSCommitter(FSFS fSFS, FSTransactionRoot fSTransactionRoot, FSTransactionInfo fSTransactionInfo, Collection collection, String string) {
        this.myFSFS = fSFS;
        this.myTxnRoot = fSTransactionRoot;
        this.myTxn = fSTransactionInfo;
        this.myLockTokens = collection != null ? collection : new HashSet();
        this.myAutoUnlockPaths = new HashMap();
        this.myAuthor = string;
    }

    public Map getAutoUnlockPaths() {
        return this.myAutoUnlockPaths;
    }

    public void deleteNode(String string) {
        long l2;
        FSTransactionRoot fSTransactionRoot = this.getTxnRoot();
        FSParentPath fSParentPath = fSTransactionRoot.openPath(string, true, true);
        SVNNodeKind sVNNodeKind = fSParentPath.getRevNode().getType();
        if (fSParentPath.getParent() == null) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_ROOT_DIR, "The root directory cannot be deleted");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        if ((fSTransactionRoot.getTxnFlags() & 2) != 0) {
            this.allowLockedOperation(this.myFSFS, string, this.myAuthor, this.myLockTokens, true, false);
        }
        this.makePathMutable(fSParentPath.getParent(), string);
        fSTransactionRoot.deleteEntry(fSParentPath.getParent().getRevNode(), fSParentPath.getEntryName());
        fSTransactionRoot.removeRevNodeFromCache(fSParentPath.getAbsPath());
        if (this.myFSFS.supportsMergeInfo() && (l2 = fSParentPath.getRevNode().getMergeInfoCount()) > 0L) {
            this.incrementMergeInfoUpTree(fSParentPath.getParent(), -l2);
        }
        this.addChange(string, fSParentPath.getRevNode().getId(), FSPathChangeKind.FS_PATH_CHANGE_DELETE, false, false, false, -1L, null, sVNNodeKind);
    }

    public void changeNodeProperty(String string, String string2, SVNPropertyValue sVNPropertyValue) {
        FSRepositoryUtil.validateProperty(string2, sVNPropertyValue);
        FSTransactionRoot fSTransactionRoot = this.getTxnRoot();
        FSParentPath fSParentPath = fSTransactionRoot.openPath(string, true, true);
        SVNNodeKind sVNNodeKind = fSParentPath.getRevNode().getType();
        if ((fSTransactionRoot.getTxnFlags() & 2) != 0) {
            this.allowLockedOperation(this.myFSFS, string, this.myAuthor, this.myLockTokens, false, false);
        }
        this.makePathMutable(fSParentPath, string);
        SVNProperties sVNProperties = fSParentPath.getRevNode().getProperties(this.myFSFS);
        boolean bl2 = false;
        if (this.myFSFS.supportsMergeInfo() && string2.equals("svn:mergeinfo")) {
            long l2 = 0L;
            boolean bl3 = fSParentPath.getRevNode().hasMergeInfo();
            if (sVNPropertyValue != null && !bl3) {
                l2 = 1L;
            } else if (sVNPropertyValue == null && bl3) {
                l2 = -1L;
            }
            if (l2 != 0L) {
                fSParentPath.getRevNode().setHasMergeInfo(sVNPropertyValue != null);
                this.incrementMergeInfoUpTree(fSParentPath, l2);
            }
            bl2 = true;
        }
        if (sVNPropertyValue == null) {
            sVNProperties.remove(string2);
        } else {
            sVNProperties.put(string2, sVNPropertyValue);
        }
        fSTransactionRoot.setProplist(fSParentPath.getRevNode(), sVNProperties);
        this.addChange(string, fSParentPath.getRevNode().getId(), FSPathChangeKind.FS_PATH_CHANGE_MODIFY, false, true, bl2, -1L, null, sVNNodeKind);
    }

    public void makeCopy(FSRevisionRoot fSRevisionRoot, String string, String string2, boolean bl2) {
        FSPathChangeKind fSPathChangeKind;
        FSTransactionRoot fSTransactionRoot = this.getTxnRoot();
        String string3 = fSTransactionRoot.getTxnID();
        FSRevisionNode fSRevisionNode = fSRevisionRoot.getRevisionNode(string);
        FSParentPath fSParentPath = fSTransactionRoot.openPath(string2, false, true);
        if ((fSTransactionRoot.getTxnFlags() & 2) != 0) {
            this.allowLockedOperation(this.myFSFS, string2, this.myAuthor, this.myLockTokens, true, false);
        }
        if (fSParentPath.getRevNode() != null && fSParentPath.getRevNode().getId().equals(fSRevisionNode.getId())) {
            return;
        }
        long l2 = 0L;
        if (fSParentPath.getRevNode() != null) {
            fSPathChangeKind = FSPathChangeKind.FS_PATH_CHANGE_REPLACE;
            if (this.myFSFS.supportsMergeInfo()) {
                l2 = fSParentPath.getRevNode().getMergeInfoCount();
            }
        } else {
            fSPathChangeKind = FSPathChangeKind.FS_PATH_CHANGE_ADD;
        }
        this.makePathMutable(fSParentPath.getParent(), string2);
        String string4 = SVNPathUtil.canonicalizeAbsolutePath(string);
        this.copy(fSParentPath.getParent().getRevNode(), fSParentPath.getEntryName(), fSRevisionNode, bl2, fSRevisionRoot.getRevision(), string4, string3);
        if (fSPathChangeKind == FSPathChangeKind.FS_PATH_CHANGE_REPLACE) {
            fSTransactionRoot.removeRevNodeFromCache(fSParentPath.getAbsPath());
        }
        long l3 = 0L;
        if (this.myFSFS.supportsMergeInfo() && l2 != (l3 = fSRevisionNode.getMergeInfoCount())) {
            this.incrementMergeInfoUpTree(fSParentPath.getParent(), l3 - l2);
        }
        FSRevisionNode fSRevisionNode2 = fSTransactionRoot.getRevisionNode(string2);
        this.addChange(string2, fSRevisionNode2.getId(), fSPathChangeKind, false, false, false, fSRevisionRoot.getRevision(), string4, fSRevisionNode.getType());
    }

    public void makeFile(String string) {
        SVNPathUtil.checkPathIsValid(string);
        FSTransactionRoot fSTransactionRoot = this.getTxnRoot();
        String string2 = fSTransactionRoot.getTxnID();
        FSParentPath fSParentPath = fSTransactionRoot.openPath(string, false, true);
        if (fSParentPath.getRevNode() != null) {
            SVNErrorManager.error(FSErrors.errorAlreadyExists(fSTransactionRoot, string, this.myFSFS), SVNLogType.FSFS);
        }
        if ((fSTransactionRoot.getTxnFlags() & 2) != 0) {
            this.allowLockedOperation(this.myFSFS, string, this.myAuthor, this.myLockTokens, false, false);
        }
        this.makePathMutable(fSParentPath.getParent(), string);
        FSRevisionNode fSRevisionNode = this.makeEntry(fSParentPath.getParent().getRevNode(), fSParentPath.getParent().getAbsPath(), fSParentPath.getEntryName(), false, string2);
        fSTransactionRoot.putRevNodeToCache(fSParentPath.getAbsPath(), fSRevisionNode);
        this.addChange(string, fSRevisionNode.getId(), FSPathChangeKind.FS_PATH_CHANGE_ADD, true, false, false, -1L, null, SVNNodeKind.FILE);
    }

    public void makeDir(String string) {
        FSCommitter.checkFSPathIsValid(string);
        FSTransactionRoot fSTransactionRoot = this.getTxnRoot();
        String string2 = fSTransactionRoot.getTxnID();
        FSParentPath fSParentPath = fSTransactionRoot.openPath(string, false, true);
        if (fSParentPath.getRevNode() != null) {
            SVNErrorManager.error(FSErrors.errorAlreadyExists(fSTransactionRoot, string, this.myFSFS), SVNLogType.FSFS);
        }
        if ((fSTransactionRoot.getTxnFlags() & 2) != 0) {
            this.allowLockedOperation(this.myFSFS, string, this.myAuthor, this.myLockTokens, true, false);
        }
        this.makePathMutable(fSParentPath.getParent(), string);
        FSRevisionNode fSRevisionNode = this.makeEntry(fSParentPath.getParent().getRevNode(), fSParentPath.getParent().getAbsPath(), fSParentPath.getEntryName(), true, string2);
        fSTransactionRoot.putRevNodeToCache(fSParentPath.getAbsPath(), fSRevisionNode);
        this.addChange(string, fSRevisionNode.getId(), FSPathChangeKind.FS_PATH_CHANGE_ADD, false, false, false, -1L, null, SVNNodeKind.DIR);
    }

    public FSRevisionNode makeEntry(FSRevisionNode fSRevisionNode, String string, String string2, boolean bl2, String string3) {
        Object object;
        if (!SVNPathUtil.isSinglePathComponent(string2)) {
            object = SVNErrorMessage.create(SVNErrorCode.FS_NOT_SINGLE_PATH_COMPONENT, "Attempted to create a node with an illegal name ''{0}''", (Object)string2);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        if (fSRevisionNode.getType() != SVNNodeKind.DIR) {
            object = SVNErrorMessage.create(SVNErrorCode.FS_NOT_DIRECTORY, "Attempted to create entry in non-directory parent");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        if (!fSRevisionNode.getId().isTxn()) {
            object = SVNErrorMessage.create(SVNErrorCode.FS_NOT_MUTABLE, "Attempted to clone child of non-mutable node");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        object = new FSRevisionNode();
        ((FSRevisionNode)object).setType(bl2 ? SVNNodeKind.DIR : SVNNodeKind.FILE);
        String string4 = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(string, string2));
        ((FSRevisionNode)object).setCreatedPath(string4);
        ((FSRevisionNode)object).setCopyRootPath(fSRevisionNode.getCopyRootPath());
        ((FSRevisionNode)object).setCopyRootRevision(fSRevisionNode.getCopyRootRevision());
        ((FSRevisionNode)object).setCopyFromRevision(-1L);
        ((FSRevisionNode)object).setCopyFromPath(null);
        FSID fSID = this.createNode((FSRevisionNode)object, fSRevisionNode.getId().getCopyID(), string3);
        FSRevisionNode fSRevisionNode2 = this.myFSFS.getRevisionNode(fSID);
        FSTransactionRoot fSTransactionRoot = this.getTxnRoot();
        fSTransactionRoot.setEntry(fSRevisionNode, string2, fSRevisionNode2.getId(), ((FSRevisionNode)object).getType());
        return fSRevisionNode2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChange(String string, FSID fSID, FSPathChangeKind fSPathChangeKind, boolean bl2, boolean bl3, boolean bl4, long l2, String string2, SVNNodeKind sVNNodeKind) {
        string = SVNPathUtil.canonicalizeAbsolutePath(string);
        OutputStream outputStream = null;
        try {
            FSTransactionRoot fSTransactionRoot = this.getTxnRoot();
            outputStream = SVNFileUtil.openFileForWriting(fSTransactionRoot.getTransactionChangesFile(), true);
            FSPathChange fSPathChange = new FSPathChange(string, fSID, fSPathChangeKind, bl2, bl3, bl4, string2, l2, sVNNodeKind);
            fSTransactionRoot.writeChangeEntry(outputStream, fSPathChange, true);
        }
        catch (IOException iOException) {
            try {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage());
                SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.FSFS);
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(outputStream);
                throw throwable;
            }
            SVNFileUtil.closeFile(outputStream);
        }
        SVNFileUtil.closeFile(outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public long commitTxn(boolean bl2, boolean bl3, SVNErrorMessage[] sVNErrorMessageArray, StringBuffer stringBuffer) {
        ArrayList arrayList;
        Object object;
        long l2;
        block17: {
            FSWriteLock fSWriteLock;
            if (this.myFSFS.isHooksEnabled() && bl2) {
                FSHooks.runPreCommitHook(this.myFSFS.getRepositoryRoot(), this.myTxn.getTxnId());
            }
            SVNProperties sVNProperties = this.myFSFS.getTransactionProperties(this.myTxn.getTxnId());
            for (String string : new HashSet(sVNProperties.nameSet())) {
                if (!string.startsWith("svn:txn-")) continue;
                this.myFSFS.setTransactionProperty(this.myTxn.getTxnId(), string, null);
            }
            l2 = -1L;
            while (true) {
                long l3 = this.myFSFS.getYoungestRevision();
                object = this.myFSFS.createRevisionRoot(l3);
                FSRevisionNode fSRevisionNode = ((FSRoot)object).getRevisionNode("/");
                FSCommitter.mergeChanges(this.myFSFS, this.getTxnRoot(), fSRevisionNode, stringBuffer);
                this.myTxn.setBaseRevision(l3);
                fSWriteLock = FSWriteLock.getWriteLockForDB(this.myFSFS);
                arrayList = this.myFSFS.getRepositoryCacheManager() != null ? new ArrayList() : null;
                FSWriteLock fSWriteLock2 = fSWriteLock;
                // MONITORENTER : fSWriteLock2
                try {
                    fSWriteLock.lock();
                    l2 = this.commit(arrayList);
                    break block17;
                }
                catch (SVNException sVNException) {
                    long l4;
                    if (sVNException.getErrorMessage().getErrorCode() != SVNErrorCode.FS_TXN_OUT_OF_DATE) throw sVNException;
                    if (l3 != (l4 = this.myFSFS.getYoungestRevision())) continue;
                    throw sVNException;
                }
                break;
            }
            finally {
                fSWriteLock.unlock();
                FSWriteLock.release(fSWriteLock);
            }
        }
        // MONITOREXIT : fSWriteLock2
        if (arrayList != null && !arrayList.isEmpty() && this.myFSFS.getRepositoryCacheManager() != null) {
            try {
                this.myFSFS.getRepositoryCacheManager().runWriteTransaction(new FSCommitter$1(this, arrayList));
            }
            catch (SVNException sVNException) {
                SVNDebugLog.getDefaultLog().logFiner(SVNLogType.FSFS, sVNException);
            }
        }
        if (!this.myFSFS.isHooksEnabled()) return l2;
        if (!bl3) return l2;
        try {
            FSHooks.runPostCommitHook(this.myFSFS.getRepositoryRoot(), l2);
            return l2;
        }
        catch (SVNException sVNException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.REPOS_POST_COMMIT_HOOK_FAILED, "Commit succeeded, but post-commit hook failed", 1);
            object = sVNException.getErrorMessage();
            ((SVNErrorMessage)object).setDontShowErrorCode(true);
            sVNErrorMessage.setChildErrorMessage((SVNErrorMessage)object);
            if (sVNErrorMessageArray != null && sVNErrorMessageArray.length > 0) {
                sVNErrorMessageArray[0] = sVNErrorMessage;
                return l2;
            }
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        return l2;
    }

    public void makePathMutable(FSParentPath fSParentPath, String string) {
        FSTransactionRoot fSTransactionRoot = this.getTxnRoot();
        String string2 = fSTransactionRoot.getTxnID();
        if (fSParentPath.getRevNode().getId().isTxn()) {
            return;
        }
        FSRevisionNode fSRevisionNode = null;
        if (fSParentPath.getParent() != null) {
            Object object;
            this.makePathMutable(fSParentPath.getParent(), string);
            FSID fSID = null;
            String string3 = null;
            switch (fSParentPath.getCopyStyle()) {
                case 2: {
                    fSID = fSParentPath.getParent().getRevNode().getId();
                    string3 = fSID.getCopyID();
                    break;
                }
                case 3: {
                    string3 = this.reserveCopyId(string2);
                    break;
                }
                case 1: {
                    string3 = null;
                    break;
                }
                default: {
                    object = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "FATAL error: can not make path ''{0}'' mutable", (Object)string);
                    SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
                }
            }
            object = fSParentPath.getRevNode().getCopyRootPath();
            long l2 = fSParentPath.getRevNode().getCopyRootRevision();
            FSRevisionRoot fSRevisionRoot = this.myFSFS.createRevisionRoot(l2);
            FSRevisionNode fSRevisionNode2 = fSRevisionRoot.getRevisionNode((String)object);
            FSID fSID2 = fSParentPath.getRevNode().getId();
            FSID fSID3 = fSRevisionNode2.getId();
            boolean bl2 = false;
            if (!fSID2.getNodeID().equals(fSID3.getNodeID())) {
                bl2 = true;
            }
            String string4 = fSParentPath.getParent().getAbsPath();
            fSRevisionNode = fSTransactionRoot.cloneChild(fSParentPath.getParent().getRevNode(), string4, fSParentPath.getEntryName(), string3, bl2);
            fSTransactionRoot.putRevNodeToCache(fSParentPath.getAbsPath(), fSRevisionNode);
        } else {
            FSTransactionInfo fSTransactionInfo = fSTransactionRoot.getTxn();
            if (fSTransactionInfo.getRootID().equals(fSTransactionInfo.getBaseID())) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "FATAL error: txn ''{0}'' root id ''{1}'' matches base id ''{2}''", string2, fSTransactionInfo.getRootID(), fSTransactionInfo.getBaseID());
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
            fSRevisionNode = this.myFSFS.getRevisionNode(fSTransactionInfo.getRootID());
        }
        fSParentPath.setRevNode(fSRevisionNode);
    }

    public String reserveCopyId(String string) {
        FSTransactionRoot fSTransactionRoot = this.getTxnRoot();
        String[] stringArray = fSTransactionRoot.readNextIDs();
        String string2 = FSRepositoryUtil.generateNextKey(stringArray[1]);
        this.myFSFS.writeNextIDs(string, stringArray[0], string2);
        return "_" + stringArray[1];
    }

    public void incrementMergeInfoUpTree(FSParentPath fSParentPath, long l2) {
        while (fSParentPath != null) {
            FSTransactionRoot fSTransactionRoot = this.getTxnRoot();
            fSTransactionRoot.incrementMergeInfoCount(fSParentPath.getRevNode(), l2);
            fSParentPath = fSParentPath.getParent();
        }
    }

    private void copy(FSRevisionNode fSRevisionNode, String string, FSRevisionNode fSRevisionNode2, boolean bl2, long l2, String string2, String string3) {
        FSID fSID = null;
        FSTransactionRoot fSTransactionRoot = this.getTxnRoot();
        if (bl2) {
            FSID fSID2 = fSRevisionNode2.getId();
            FSRevisionNode fSRevisionNode3 = FSRevisionNode.dumpRevisionNode(fSRevisionNode2);
            String string4 = this.reserveCopyId(string3);
            fSRevisionNode3.setPredecessorId(fSID2);
            if (fSRevisionNode3.getCount() != -1L) {
                fSRevisionNode3.setCount(fSRevisionNode3.getCount() + 1L);
            }
            String string5 = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(fSRevisionNode.getCreatedPath(), string));
            fSRevisionNode3.setCreatedPath(string5);
            fSRevisionNode3.setCopyFromPath(string2);
            fSRevisionNode3.setCopyFromRevision(l2);
            fSRevisionNode3.setCopyRootPath(null);
            fSID = fSTransactionRoot.createSuccessor(fSID2, fSRevisionNode3, string4);
        } else {
            fSID = fSRevisionNode2.getId();
        }
        fSTransactionRoot.setEntry(fSRevisionNode, string, fSID, fSRevisionNode2.getType());
    }

    private FSID createNode(FSRevisionNode fSRevisionNode, String string, String string2) {
        FSTransactionRoot fSTransactionRoot = this.getTxnRoot();
        String string3 = fSTransactionRoot.getNewTxnNodeId();
        FSID fSID = FSID.createTxnId(string3, string, string2);
        fSRevisionNode.setId(fSID);
        fSRevisionNode.setIsFreshTxnRoot(false);
        this.myFSFS.putTxnRevisionNode(fSID, fSRevisionNode);
        return fSID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long commit(Collection collection) {
        Serializable serializable;
        Serializable serializable2;
        String string;
        Object object;
        long l2 = this.myFSFS.getYoungestRevision();
        if (this.myTxn.getBaseRevision() != l2) {
            object = SVNErrorMessage.create(SVNErrorCode.FS_TXN_OUT_OF_DATE, "Transaction out of date");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        this.verifyLocks();
        if (this.myFSFS.getDBFormat() < 3) {
            String[] stringArray = this.myFSFS.getNextRevisionIDs();
            object = stringArray[0];
            string = stringArray[1];
        } else {
            object = null;
            string = null;
        }
        long l3 = l2 + 1L;
        OutputStream outputStream = null;
        FSID fSID = null;
        FSTransactionRoot fSTransactionRoot = this.getTxnRoot();
        FSWriteLock fSWriteLock = FSWriteLock.getWriteLockForTxn(this.myTxn.getTxnId(), this.myFSFS);
        Object object2 = fSWriteLock;
        synchronized (object2) {
            try {
                fSWriteLock.lock();
                serializable2 = fSTransactionRoot.getWritableTransactionProtoRevFile();
                long l4 = ((File)serializable2).length();
                this.commit((String)object, string, l3, outputStream, fSID, fSTransactionRoot, (File)serializable2, l4, collection);
                serializable = this.myFSFS.getNewRevisionFile(l3);
                SVNFileUtil.rename((File)serializable2, serializable);
            }
            finally {
                fSWriteLock.unlock();
                FSWriteLock.release(fSWriteLock);
            }
        }
        object2 = SVNDate.formatDate(new Date(System.currentTimeMillis()));
        serializable2 = this.myFSFS.getTransactionProperties(this.myTxn.getTxnId());
        if (serializable2 == null || !((SVNProperties)serializable2).containsName("svn:date")) {
            this.myFSFS.setTransactionProperty(this.myTxn.getTxnId(), "svn:date", SVNPropertyValue.create((String)object2));
        }
        File file = this.myFSFS.getTransactionPropertiesFile(this.myTxn.getTxnId());
        if (this.myFSFS.getDBFormat() < 6 || l3 >= this.myFSFS.getMinUnpackedRevProp()) {
            File file2 = this.myFSFS.getNewRevisionPropertiesFile(l3);
            SVNFileUtil.rename(file, file2);
        }
        try {
            fSTransactionRoot.writeFinalCurrentFile(l3, (String)object, string);
        }
        catch (IOException iOException) {
            serializable = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage());
            SVNErrorManager.error((SVNErrorMessage)serializable, iOException, SVNLogType.FSFS);
        }
        this.myFSFS.setYoungestRevisionCache(l3);
        this.myFSFS.purgeTxn(this.myTxn.getTxnId());
        return l3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commit(String string, String string2, long l2, OutputStream outputStream, FSID fSID, FSTransactionRoot fSTransactionRoot, File file, long l3, Collection collection) {
        Serializable serializable;
        try {
            outputStream = SVNFileUtil.openFileForWriting(file, true);
            serializable = FSID.createTxnId("0", "0", this.myTxn.getTxnId());
            CountingOutputStream countingOutputStream = new CountingOutputStream(outputStream, l3);
            fSID = fSTransactionRoot.writeFinalRevision(fSID, countingOutputStream, l2, (FSID)serializable, string, string2, collection, true);
            long l4 = fSTransactionRoot.writeFinalChangedPathInfo(countingOutputStream);
            if (this.myFSFS.isUseLogAddressing()) {
                fSTransactionRoot.writeIndexData(countingOutputStream, l2, this.myTxn.getTxnId());
            } else {
                String string3 = "\n" + fSID.getOffset() + " " + l4 + "\n";
                outputStream.write(string3.getBytes("UTF-8"));
            }
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage());
            SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.FSFS);
        }
        finally {
            SVNFileUtil.closeFile(outputStream);
        }
        serializable = this.myFSFS.getTransactionProperties(this.myTxn.getTxnId());
        if (serializable != null && !((SVNProperties)serializable).isEmpty()) {
            if (((SVNProperties)serializable).getStringValue("svn:check-ood") != null) {
                this.myFSFS.setTransactionProperty(this.myTxn.getTxnId(), "svn:check-ood", null);
            }
            if (((SVNProperties)serializable).getStringValue("svn:check-locks") != null) {
                this.myFSFS.setTransactionProperty(this.myTxn.getTxnId(), "svn:check-locks", null);
            }
        }
    }

    public static void mergeChanges(FSFS fSFS, FSTransactionRoot fSTransactionRoot, FSRevisionNode fSRevisionNode, StringBuffer stringBuffer) {
        FSRevisionNode fSRevisionNode2 = fSTransactionRoot.getRootRevisionNode();
        FSRevisionNode fSRevisionNode3 = fSTransactionRoot.getTxnBaseRootNode();
        if (fSRevisionNode2.getId().equals(fSRevisionNode3.getId())) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "FATAL error: no changes in transaction to commit");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        } else {
            FSCommitter.merge(fSFS, "/", fSRevisionNode2, fSRevisionNode, fSRevisionNode3, fSTransactionRoot, stringBuffer);
        }
    }

    private static long merge(FSFS fSFS, String string, FSRevisionNode fSRevisionNode, FSRevisionNode fSRevisionNode2, FSRevisionNode fSRevisionNode3, FSTransactionRoot fSTransactionRoot, StringBuffer stringBuffer) {
        Object object;
        FSEntry fSEntry;
        FSEntry fSEntry2;
        Object object2;
        FSID fSID = fSRevisionNode2.getId();
        FSID fSID2 = fSRevisionNode.getId();
        FSID fSID3 = fSRevisionNode3.getId();
        long l2 = 0L;
        if (fSID3.equals(fSID2)) {
            object2 = SVNErrorMessage.create(SVNErrorCode.FS_GENERAL, "Bad merge; target ''{0}'' has id ''{1}'', same as ancestor", string, fSID2);
            SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.FSFS);
        }
        if (fSID3.equals(fSID) || fSID.equals(fSID2)) {
            return l2;
        }
        if (fSRevisionNode2.getType() != SVNNodeKind.DIR || fSRevisionNode.getType() != SVNNodeKind.DIR || fSRevisionNode3.getType() != SVNNodeKind.DIR) {
            SVNErrorManager.error(FSErrors.errorConflict(string, stringBuffer), SVNLogType.FSFS);
        }
        if (!FSRepresentation.compareRepresentations(fSRevisionNode.getPropsRepresentation(), fSRevisionNode3.getPropsRepresentation())) {
            SVNErrorManager.error(FSErrors.errorConflict(string, stringBuffer), SVNLogType.FSFS);
        }
        if (!FSRepresentation.compareRepresentations(fSRevisionNode2.getPropsRepresentation(), fSRevisionNode3.getPropsRepresentation())) {
            SVNErrorManager.error(FSErrors.errorConflict(string, stringBuffer), SVNLogType.FSFS);
        }
        object2 = fSRevisionNode2.getDirEntries(fSFS);
        Map map = fSRevisionNode.getDirEntries(fSFS);
        Map map2 = fSRevisionNode3.getDirEntries(fSFS);
        SVNHashSet sVNHashSet = new SVNHashSet();
        for (String string2 : map2.keySet()) {
            fSEntry2 = (FSEntry)map2.get(string2);
            fSEntry = sVNHashSet.contains(string2) ? null : (FSEntry)object2.get(string2);
            object = (FSEntry)map.get(string2);
            if (fSEntry == null || !fSEntry2.getId().equals(fSEntry.getId())) {
                FSRevisionNode fSRevisionNode4;
                if (object != null && fSEntry2.getId().equals(((FSEntry)object).getId())) {
                    long l3;
                    if (fSFS.supportsMergeInfo()) {
                        fSRevisionNode4 = fSFS.getRevisionNode(((FSEntry)object).getId());
                        l3 = fSRevisionNode4.getMergeInfoCount();
                        l2 -= l3;
                    }
                    if (fSEntry != null) {
                        if (fSFS.supportsMergeInfo()) {
                            fSRevisionNode4 = fSFS.getRevisionNode(fSEntry.getId());
                            l3 = fSRevisionNode4.getMergeInfoCount();
                            l2 += l3;
                        }
                        fSTransactionRoot.setEntry(fSRevisionNode, string2, fSEntry.getId(), fSEntry.getType());
                    } else {
                        fSTransactionRoot.deleteEntry(fSRevisionNode, string2);
                    }
                } else {
                    if (fSEntry == null || object == null) {
                        SVNErrorManager.error(FSErrors.errorConflict(SVNPathUtil.getAbsolutePath(SVNPathUtil.append(string, string2)), stringBuffer), SVNLogType.FSFS);
                    }
                    if (fSEntry.getType() == SVNNodeKind.FILE || ((FSEntry)object).getType() == SVNNodeKind.FILE || fSEntry2.getType() == SVNNodeKind.FILE) {
                        SVNErrorManager.error(FSErrors.errorConflict(SVNPathUtil.getAbsolutePath(SVNPathUtil.append(string, string2)), stringBuffer), SVNLogType.FSFS);
                    }
                    if (!(fSEntry.getId().getNodeID().equals(fSEntry2.getId().getNodeID()) && fSEntry.getId().getCopyID().equals(fSEntry2.getId().getCopyID()) && ((FSEntry)object).getId().getNodeID().equals(fSEntry2.getId().getNodeID()) && ((FSEntry)object).getId().getCopyID().equals(fSEntry2.getId().getCopyID()))) {
                        SVNErrorManager.error(FSErrors.errorConflict(SVNPathUtil.getAbsolutePath(SVNPathUtil.append(string, string2)), stringBuffer), SVNLogType.FSFS);
                    }
                    fSRevisionNode4 = fSFS.getRevisionNode(fSEntry.getId());
                    FSRevisionNode fSRevisionNode5 = fSFS.getRevisionNode(((FSEntry)object).getId());
                    FSRevisionNode fSRevisionNode6 = fSFS.getRevisionNode(fSEntry2.getId());
                    String string3 = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(string, ((FSEntry)object).getName()));
                    long l4 = FSCommitter.merge(fSFS, string3, fSRevisionNode5, fSRevisionNode4, fSRevisionNode6, fSTransactionRoot, stringBuffer);
                    if (fSFS.supportsMergeInfo()) {
                        l2 += l4;
                    }
                }
            }
            sVNHashSet.add(string2);
        }
        for (String string2 : object2.keySet()) {
            if (sVNHashSet.contains(string2)) continue;
            fSEntry2 = (FSEntry)object2.get(string2);
            fSEntry = (FSEntry)map.get(string2);
            if (fSEntry != null) {
                SVNErrorManager.error(FSErrors.errorConflict(SVNPathUtil.getAbsolutePath(SVNPathUtil.append(string, fSEntry.getName())), stringBuffer), SVNLogType.FSFS);
            }
            if (fSFS.supportsMergeInfo()) {
                object = fSFS.getRevisionNode(fSEntry2.getId());
                long l5 = ((FSRevisionNode)object).getMergeInfoCount();
                l2 += l5;
            }
            fSTransactionRoot.setEntry(fSRevisionNode, fSEntry2.getName(), fSEntry2.getId(), fSEntry2.getType());
        }
        FSCommitter.updateAncestry(fSFS, fSID, fSID2);
        if (fSFS.supportsMergeInfo()) {
            fSTransactionRoot.incrementMergeInfoCount(fSRevisionNode, l2);
        }
        return l2;
    }

    private static void updateAncestry(FSFS fSFS, FSID fSID, FSID fSID2) {
        Object object;
        if (!fSID2.isTxn()) {
            object = SVNErrorMessage.create(SVNErrorCode.FS_NOT_MUTABLE, "Attempt to update ancestry of non-mutable node");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        object = fSFS.getRevisionNode(fSID2);
        FSRevisionNode fSRevisionNode = fSFS.getRevisionNode(fSID);
        ((FSRevisionNode)object).setPredecessorId(fSRevisionNode.getId());
        long l2 = fSRevisionNode.getCount();
        ((FSRevisionNode)object).setPredecessorId(fSID);
        ((FSRevisionNode)object).setCount(l2 != -1L ? l2 + 1L : l2);
        ((FSRevisionNode)object).setIsFreshTxnRoot(false);
        fSFS.putTxnRevisionNode(fSID2, (FSRevisionNode)object);
    }

    private void verifyLocks() {
        FSTransactionRoot fSTransactionRoot = this.getTxnRoot();
        Map map = fSTransactionRoot.getChangedPaths();
        Object[] objectArray = map.keySet().toArray();
        Arrays.sort(objectArray);
        String string = null;
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            String string2 = (String)objectArray[i2];
            boolean bl2 = true;
            if (string != null && SVNPathUtil.getPathAsChild(string, string2) != null) continue;
            FSPathChange fSPathChange = (FSPathChange)map.get(string2);
            if (fSPathChange.getChangeKind() == FSPathChangeKind.FS_PATH_CHANGE_MODIFY) {
                bl2 = false;
            }
            this.allowLockedOperation(this.myFSFS, string2, this.myAuthor, this.myLockTokens, bl2, true);
            if (!bl2) continue;
            string = string2;
        }
    }

    private FSTransactionRoot getTxnRoot() {
        if (this.myTxnRoot == null && this.myTxn != null) {
            this.myTxnRoot = this.myFSFS.createTransactionRoot(this.myTxn);
        }
        return this.myTxnRoot;
    }

    public void allowLockedOperation(FSFS fSFS, String string, String string2, Collection collection, boolean bl2, boolean bl3) {
        string = SVNPathUtil.canonicalizeAbsolutePath(string);
        if (bl2) {
            FSCommitter$2 fSCommitter$2 = new FSCommitter$2(this, string2, collection);
            fSFS.walkDigestFiles(fSFS.getDigestFileFromRepositoryPath(string), fSCommitter$2, bl3);
        } else {
            SVNLock sVNLock = fSFS.getLockHelper(string, bl3);
            if (sVNLock != null) {
                if (FSCommitter.isAutoUnlock()) {
                    this.scheduleForAutoUnlock(string2, string, sVNLock);
                } else {
                    this.verifyLock(sVNLock, collection, string2);
                }
            }
        }
    }

    private void scheduleForAutoUnlock(String string, String string2, SVNLock sVNLock) {
        this.myAutoUnlockPaths.put(string2, sVNLock.getID());
    }

    private void verifyLock(SVNLock sVNLock, Collection collection, String string) {
        SVNErrorMessage sVNErrorMessage;
        if (string == null || "".equals(string)) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_NO_USER, "Cannot verify lock on path ''{0}''; no username available", (Object)sVNLock.getPath());
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        } else if (string.compareTo(sVNLock.getOwner()) != 0) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_LOCK_OWNER_MISMATCH, "User {0} does not own lock on path ''{1}'' (currently locked by {2})", string, sVNLock.getPath(), sVNLock.getOwner());
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        if (collection.contains(sVNLock.getID())) {
            return;
        }
        sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_BAD_LOCK_TOKEN, "Cannot verify lock on path ''{0}''; no matching lock-token available", (Object)sVNLock.getPath());
        SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
    }

    public static void abortTransaction(FSFS fSFS, String string) {
        File file = fSFS.getTransactionDir(string);
        SVNFileUtil.deleteAll(file, true);
        if (file.exists()) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "Transaction cleanup failed");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
    }

    private static void checkFSPathIsValid(String string) {
        SVNErrorMessage sVNErrorMessage;
        SVNPathUtil.checkPathIsValid(string);
        if (FSCommitter.containsBackPath(string) || FSCommitter.containsDotPath(string)) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_PATH_SYNTAX, "Path ''{0}'' contains '.' or '..' element", (Object)string);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
        if (string.contains("\n")) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_PATH_SYNTAX, "Invalid control character '0x0a' in path ''{0}''", (Object)string);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
    }

    private static boolean containsBackPath(String string) {
        if (string.length() == 0 || string.length() == 1) {
            return false;
        }
        if (string.charAt(0) == '.' && string.charAt(1) == '.' && (string.length() == 2 || string.charAt(2) == '/')) {
            return true;
        }
        if (string.length() == 2) {
            return false;
        }
        if (string.contains("/../")) {
            return true;
        }
        return string.endsWith("/..");
    }

    private static boolean containsDotPath(String string) {
        if (string.length() == 0) {
            return false;
        }
        if (string.charAt(0) == '.' && (string.length() == 1 || string.charAt(1) == '/')) {
            return true;
        }
        if (string.length() == 1) {
            return false;
        }
        if (string.contains("/./")) {
            return true;
        }
        return string.endsWith("/.");
    }

    static /* synthetic */ FSFS access$000(FSCommitter fSCommitter) {
        return fSCommitter.myFSFS;
    }

    static /* synthetic */ void access$100(FSCommitter fSCommitter, String string, String string2, SVNLock sVNLock) {
        fSCommitter.scheduleForAutoUnlock(string, string2, sVNLock);
    }

    static /* synthetic */ void access$200(FSCommitter fSCommitter, SVNLock sVNLock, Collection collection, String string) {
        fSCommitter.verifyLock(sVNLock, collection, string);
    }
}

