/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.OutputStream;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Stack;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.io.fs.FSCommitEditor$DirBaton;
import org.tmatesoft.svn.core.internal.io.fs.FSCommitter;
import org.tmatesoft.svn.core.internal.io.fs.FSDeltaConsumer;
import org.tmatesoft.svn.core.internal.io.fs.FSErrors;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSParentPath;
import org.tmatesoft.svn.core.internal.io.fs.FSPathChangeKind;
import org.tmatesoft.svn.core.internal.io.fs.FSRepository;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.io.fs.FSRepresentation;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionInfo;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionRoot;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.util.SVNLogType;
import org.tmatesoft.svn.util.Version;

public class FSCommitEditor
implements ISVNEditor {
    private Map myPathsToLockTokens;
    private Collection myLockTokens;
    private String myBasePath;
    private FSTransactionInfo myTxn;
    private FSTransactionRoot myTxnRoot;
    private boolean isTxnOwner;
    private FSFS myFSFS;
    private FSRepository myRepository;
    private Stack myDirsStack;
    private FSDeltaConsumer myDeltaConsumer;
    private SVNProperties myCurrentFileProps;
    private String myCurrentFilePath;
    private FSCommitter myCommitter;
    private SVNProperties myRevProps;
    private String myAuthor;

    public FSCommitEditor(String string, String string2, String string3, Map map, boolean bl2, FSTransactionInfo fSTransactionInfo, FSFS fSFS, FSRepository fSRepository) {
        this(string, map, bl2, fSTransactionInfo, fSFS, fSRepository, null);
        this.myRevProps = new SVNProperties();
        if (string3 != null) {
            this.myAuthor = string3;
            this.myRevProps.put("svn:author", string3);
        }
        if (string2 != null) {
            this.myRevProps.put("svn:log", string2);
        }
        this.myRevProps.put("svn:txn-client-compat-version", Version.getSVNVersion());
    }

    public FSCommitEditor(String string, Map map, boolean bl2, FSTransactionInfo fSTransactionInfo, FSFS fSFS, FSRepository fSRepository, SVNProperties sVNProperties) {
        this.myPathsToLockTokens = !bl2 ? map : null;
        this.myLockTokens = map != null ? map.values() : new HashSet();
        this.myBasePath = string;
        this.myTxn = fSTransactionInfo;
        this.isTxnOwner = fSTransactionInfo == null;
        this.myRepository = fSRepository;
        this.myFSFS = fSFS;
        this.myDirsStack = new Stack();
        SVNProperties sVNProperties2 = this.myRevProps = sVNProperties != null ? sVNProperties : new SVNProperties();
        if (!this.myRevProps.containsName("svn:txn-client-compat-version")) {
            this.myRevProps.put("svn:txn-client-compat-version", Version.getSVNVersion());
        }
    }

    @Override
    public void targetRevision(long l2) {
    }

    @Override
    public void openRoot(long l2) {
        long l3 = this.myFSFS.getYoungestRevision();
        if (this.isTxnOwner) {
            this.myTxn = FSTransactionRoot.beginTransactionForCommit(l3, this.myRevProps, this.myFSFS);
        } else {
            this.myFSFS.changeTransactionProperties(this.myTxn.getTxnId(), this.myRevProps);
        }
        this.myTxnRoot = this.myFSFS.createTransactionRoot(this.myTxn);
        this.myCommitter = new FSCommitter(this.myFSFS, this.myTxnRoot, this.myTxn, this.myLockTokens, this.getAuthor());
        FSCommitEditor$DirBaton fSCommitEditor$DirBaton = new FSCommitEditor$DirBaton(l2, this.myBasePath, false);
        this.myDirsStack.push(fSCommitEditor$DirBaton);
    }

    private String getAuthor() {
        if (this.myAuthor == null) {
            this.myAuthor = this.myRevProps.getStringValue("svn:author");
        }
        return this.myAuthor;
    }

    @Override
    public void openDir(String string, long l2) {
        Object object;
        FSCommitEditor$DirBaton fSCommitEditor$DirBaton = (FSCommitEditor$DirBaton)this.myDirsStack.peek();
        String string2 = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(this.myBasePath, string));
        SVNNodeKind sVNNodeKind = this.myTxnRoot.checkNodeKind(string2);
        if (sVNNodeKind == SVNNodeKind.NONE) {
            object = SVNErrorMessage.create(SVNErrorCode.FS_NOT_DIRECTORY, "Path ''{0}'' not present", (Object)string);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        object = new FSCommitEditor$DirBaton(l2, string2, fSCommitEditor$DirBaton.isCopied());
        this.myDirsStack.push(object);
    }

    @Override
    public void deleteEntry(String string, long l2) {
        String string2 = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(this.myBasePath, string));
        SVNNodeKind sVNNodeKind = this.myTxnRoot.checkNodeKind(string2);
        if (sVNNodeKind == SVNNodeKind.NONE) {
            SVNErrorManager.error(FSErrors.errorOutOfDate(string2, sVNNodeKind), SVNLogType.FSFS);
        }
        FSRevisionNode fSRevisionNode = this.myTxnRoot.getRevisionNode(string2);
        long l3 = fSRevisionNode.getCreatedRevision();
        if (FSRepository.isValidRevision(l2) && l2 < l3) {
            SVNErrorManager.error(FSErrors.errorOutOfDate(string2, sVNNodeKind), SVNLogType.FSFS);
        }
        this.myCommitter.deleteNode(string2);
    }

    @Override
    public void absentDir(String string) {
    }

    @Override
    public void absentFile(String string) {
    }

    @Override
    public void addDir(String string, String string2, long l2) {
        Object object;
        FSCommitEditor$DirBaton fSCommitEditor$DirBaton = (FSCommitEditor$DirBaton)this.myDirsStack.peek();
        String string3 = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(this.myBasePath, string));
        boolean bl2 = false;
        if (string2 != null && FSRepository.isInvalidRevision(l2)) {
            object = SVNErrorMessage.create(SVNErrorCode.FS_GENERAL, "Got source path but no source revision for ''{0}''", (Object)string3);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        } else if (string2 != null) {
            object = this.myTxnRoot.checkNodeKind(string3);
            if (object != SVNNodeKind.NONE && !fSCommitEditor$DirBaton.isCopied()) {
                SVNErrorManager.error(FSErrors.errorOutOfDate(string3, (SVNNodeKind)object), SVNLogType.FSFS);
            }
            string2 = this.myRepository.getRepositoryPath(string2);
            FSRevisionRoot fSRevisionRoot = this.myFSFS.createRevisionRoot(l2);
            this.myCommitter.makeCopy(fSRevisionRoot, string2, string3, true);
            bl2 = true;
        } else {
            this.myCommitter.makeDir(string3);
        }
        object = new FSCommitEditor$DirBaton(-1L, string3, bl2);
        this.myDirsStack.push(object);
    }

    @Override
    public void changeDirProperty(String string, SVNPropertyValue sVNPropertyValue) {
        FSCommitEditor$DirBaton fSCommitEditor$DirBaton = (FSCommitEditor$DirBaton)this.myDirsStack.peek();
        if (FSRepository.isValidRevision(fSCommitEditor$DirBaton.getBaseRevision())) {
            FSRevisionNode fSRevisionNode = this.myTxnRoot.getRevisionNode(fSCommitEditor$DirBaton.getPath());
            long l2 = fSRevisionNode.getCreatedRevision();
            if (fSCommitEditor$DirBaton.getBaseRevision() < l2) {
                SVNErrorManager.error(FSErrors.errorOutOfDate(fSCommitEditor$DirBaton.getPath(), SVNNodeKind.DIR), SVNLogType.FSFS);
            }
        }
        this.myCommitter.changeNodeProperty(fSCommitEditor$DirBaton.getPath(), string, sVNPropertyValue);
    }

    private void changeNodeProperties(String string, SVNProperties sVNProperties) {
        FSParentPath fSParentPath = null;
        SVNNodeKind sVNNodeKind = null;
        SVNProperties sVNProperties2 = null;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (String string2 : sVNProperties.nameSet()) {
            SVNPropertyValue sVNPropertyValue = sVNProperties.getSVNPropertyValue(string2);
            FSRepositoryUtil.validateProperty(string2, sVNPropertyValue);
            if (!bl2) {
                fSParentPath = this.myTxnRoot.openPath(string, true, true);
                sVNNodeKind = fSParentPath.getRevNode().getType();
                if ((this.myTxnRoot.getTxnFlags() & 2) != 0) {
                    this.myCommitter.allowLockedOperation(this.myFSFS, string, this.getAuthor(), this.myLockTokens, false, false);
                }
                this.myCommitter.makePathMutable(fSParentPath, string);
                sVNProperties2 = fSParentPath.getRevNode().getProperties(this.myFSFS);
                bl2 = true;
            }
            if (sVNProperties2.isEmpty() && sVNPropertyValue == null) continue;
            if (this.myFSFS.supportsMergeInfo() && string2.equals("svn:mergeinfo")) {
                long l2 = 0L;
                boolean bl5 = fSParentPath.getRevNode().hasMergeInfo();
                if (sVNPropertyValue != null && !bl5) {
                    l2 = 1L;
                } else if (sVNPropertyValue == null && bl5) {
                    l2 = -1L;
                }
                if (l2 != 0L) {
                    fSParentPath.getRevNode().setHasMergeInfo(sVNPropertyValue != null);
                    this.myCommitter.incrementMergeInfoUpTree(fSParentPath, l2);
                }
                bl4 = true;
            }
            if (sVNPropertyValue == null) {
                sVNProperties2.remove(string2);
            } else {
                sVNProperties2.put(string2, sVNPropertyValue);
            }
            if (bl3) continue;
            bl3 = true;
        }
        if (bl3) {
            this.myTxnRoot.setProplist(fSParentPath.getRevNode(), sVNProperties2);
            this.myCommitter.addChange(string, fSParentPath.getRevNode().getId(), FSPathChangeKind.FS_PATH_CHANGE_MODIFY, false, true, bl4, -1L, null, sVNNodeKind);
        }
    }

    @Override
    public void closeDir() {
        this.flushPendingProperties();
        this.myDirsStack.pop();
    }

    @Override
    public void addFile(String string, String string2, long l2) {
        FSCommitEditor$DirBaton fSCommitEditor$DirBaton = (FSCommitEditor$DirBaton)this.myDirsStack.peek();
        String string3 = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(this.myBasePath, string));
        if (string2 != null && FSRepository.isInvalidRevision(l2)) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_GENERAL, "Got source path but no source revision for ''{0}''", (Object)string3);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        } else if (string2 != null) {
            SVNNodeKind sVNNodeKind = this.myTxnRoot.checkNodeKind(string3);
            if (sVNNodeKind != SVNNodeKind.NONE && !fSCommitEditor$DirBaton.isCopied()) {
                SVNErrorManager.error(FSErrors.errorOutOfDate(string3, sVNNodeKind), SVNLogType.FSFS);
            }
            string2 = this.myRepository.getRepositoryPath(string2);
            FSRevisionRoot fSRevisionRoot = this.myFSFS.createRevisionRoot(l2);
            this.myCommitter.makeCopy(fSRevisionRoot, string2, string3, true);
        } else {
            this.myCommitter.makeFile(string3);
        }
    }

    @Override
    public void openFile(String string, long l2) {
        String string2 = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(this.myBasePath, string));
        FSRevisionNode fSRevisionNode = this.myTxnRoot.getRevisionNode(string2);
        if (FSRepository.isValidRevision(l2) && l2 < fSRevisionNode.getCreatedRevision()) {
            SVNErrorManager.error(FSErrors.errorOutOfDate(string2, SVNNodeKind.FILE), SVNLogType.FSFS);
        }
    }

    @Override
    public void applyTextDelta(String string, String string2) {
        this.flushPendingProperties();
        FSDeltaConsumer fSDeltaConsumer = this.getDeltaConsumer();
        fSDeltaConsumer.applyTextDelta(string, string2);
    }

    @Override
    public OutputStream textDeltaChunk(String string, SVNDiffWindow sVNDiffWindow) {
        FSDeltaConsumer fSDeltaConsumer = this.getDeltaConsumer();
        return fSDeltaConsumer.textDeltaChunk(string, sVNDiffWindow);
    }

    @Override
    public void textDeltaEnd(String string) {
        FSDeltaConsumer fSDeltaConsumer = this.getDeltaConsumer();
        fSDeltaConsumer.textDeltaEnd(string);
    }

    private FSDeltaConsumer getDeltaConsumer() {
        if (this.myDeltaConsumer == null) {
            this.myDeltaConsumer = new FSDeltaConsumer(this.myBasePath, this.myTxnRoot, this.myFSFS, this.myCommitter, this.getAuthor(), this.myLockTokens);
        }
        return this.myDeltaConsumer;
    }

    @Override
    public void changeFileProperty(String string, String string2, SVNPropertyValue sVNPropertyValue) {
        String string3 = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(this.myBasePath, string));
        SVNProperties sVNProperties = this.getFilePropertiesStorage();
        if (!string3.equals(this.myCurrentFilePath)) {
            if (this.myCurrentFilePath != null) {
                this.changeNodeProperties(this.myCurrentFilePath, sVNProperties);
                sVNProperties.clear();
            }
            this.myCurrentFilePath = string3;
        }
        sVNProperties.put(string2, sVNPropertyValue);
    }

    private SVNProperties getFilePropertiesStorage() {
        if (this.myCurrentFileProps == null) {
            this.myCurrentFileProps = new SVNProperties();
        }
        return this.myCurrentFileProps;
    }

    private void flushPendingProperties() {
        if (this.myCurrentFilePath != null) {
            SVNProperties sVNProperties = this.getFilePropertiesStorage();
            this.changeNodeProperties(this.myCurrentFilePath, sVNProperties);
            sVNProperties.clear();
            this.myCurrentFilePath = null;
        }
    }

    @Override
    public void closeFile(String string, String string2) {
        String string3;
        FSRevisionNode fSRevisionNode;
        FSRepresentation fSRepresentation;
        this.flushPendingProperties();
        if (string2 != null && (fSRepresentation = (fSRevisionNode = this.myTxnRoot.getRevisionNode(string3 = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(this.myBasePath, string)))).getTextRepresentation()) != null && !string2.equals(fSRepresentation.getMD5HexDigest())) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CHECKSUM_MISMATCH, "Checksum mismatch for resulting fulltext\n({0}):\n   expected checksum:  {1}\n   actual checksum:    {2}\n", string3, string2, fSRepresentation.getMD5HexDigest());
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SVNCommitInfo closeEdit() {
        try {
            Object object;
            SVNErrorMessage[] sVNErrorMessageArray;
            SVNProperties sVNProperties;
            String string;
            if (this.myTxn == null) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.REPOS_BAD_ARGS, "No valid transaction supplied to closeEdit()");
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
            long l2 = -1L;
            if (this.myDeltaConsumer != null) {
                this.myDeltaConsumer.close();
            }
            Date date = (string = (sVNProperties = this.myFSFS.getRevisionProperties(l2 = this.myCommitter.commitTxn(true, true, sVNErrorMessageArray = new SVNErrorMessage[1], null))).getStringValue("svn:date")) != null ? SVNDate.parseDateString(string) : null;
            SVNErrorMessage sVNErrorMessage = sVNErrorMessageArray[0];
            if (sVNErrorMessage != null && sVNErrorMessage.getErrorCode() == SVNErrorCode.REPOS_POST_COMMIT_HOOK_FAILED) {
                object = sVNErrorMessage.getChildErrorMessage() != null ? sVNErrorMessage.getChildErrorMessage().getFullMessage() : sVNErrorMessage.getFullMessage();
                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.REPOS_POST_COMMIT_HOOK_FAILED, (String)object, 1);
            }
            object = new SVNCommitInfo(l2, this.getAuthor(), date, sVNErrorMessage);
            this.releaseLocks();
            Object object2 = object;
            return object2;
        }
        finally {
            this.myRepository.closeRepository();
        }
    }

    private void releaseLocks() {
        this.releaseLocks(this.myPathsToLockTokens, false, true);
        Map map = this.myCommitter.getAutoUnlockPaths();
        this.releaseLocks(map, true, false);
    }

    private void releaseLocks(Map map, boolean bl2, boolean bl3) {
        if (map == null) {
            return;
        }
        for (String string : map.keySet()) {
            String string2 = (String)map.get(string);
            String string3 = !string.startsWith("/") ? SVNPathUtil.getAbsolutePath(SVNPathUtil.append(this.myBasePath, string)) : string;
            try {
                this.myFSFS.unlockPath(string3, string2, this.getAuthor(), bl2, bl3);
            }
            catch (SVNException sVNException) {}
        }
    }

    @Override
    public void abortEdit() {
        if (this.myDeltaConsumer != null) {
            this.myDeltaConsumer.abort();
        }
        try {
            if (this.myTxn == null || !this.isTxnOwner) {
                return;
            }
            FSCommitter.abortTransaction(this.myFSFS, this.myTxn.getTxnId());
        }
        finally {
            this.myRepository.closeRepository();
            this.myTxn = null;
            this.myTxnRoot = null;
        }
    }
}

